/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-01 at 04:21:57 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Machine image resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MachineImage extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The URL for this machine image. The server defines this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The source instance used to create the template. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  -
   * projects/project/zones/zone/instances/instance
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceInstance;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SourceInstanceProperties sourceInstanceProperties;

  /**
   * [Output Only] The status of disk creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * GCS bucket storage location of the snapshot (regional or multi-regional).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> storageLocations;

  /**
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] The creation timestamp for this machine image in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public MachineImage setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public MachineImage setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this machine image. The server defines this identifier.
   * @param id id or {@code null} for none
   */
  public MachineImage setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#machineImage for machine image.
   * @param kind kind or {@code null} for none
   */
  public MachineImage setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public MachineImage setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The URL for this machine image. The server defines this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this machine image. The server defines this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public MachineImage setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The source instance used to create the template. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  -
   * projects/project/zones/zone/instances/instance
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceInstance() {
    return sourceInstance;
  }

  /**
   * The source instance used to create the template. You can provide this as a partial or full URL
   * to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance  -
   * projects/project/zones/zone/instances/instance
   * @param sourceInstance sourceInstance or {@code null} for none
   */
  public MachineImage setSourceInstance(java.lang.String sourceInstance) {
    this.sourceInstance = sourceInstance;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public SourceInstanceProperties getSourceInstanceProperties() {
    return sourceInstanceProperties;
  }

  /**
   * @param sourceInstanceProperties sourceInstanceProperties or {@code null} for none
   */
  public MachineImage setSourceInstanceProperties(SourceInstanceProperties sourceInstanceProperties) {
    this.sourceInstanceProperties = sourceInstanceProperties;
    return this;
  }

  /**
   * [Output Only] The status of disk creation.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of disk creation.
   * @param status status or {@code null} for none
   */
  public MachineImage setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * GCS bucket storage location of the snapshot (regional or multi-regional).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getStorageLocations() {
    return storageLocations;
  }

  /**
   * GCS bucket storage location of the snapshot (regional or multi-regional).
   * @param storageLocations storageLocations or {@code null} for none
   */
  public MachineImage setStorageLocations(java.util.List<java.lang.String> storageLocations) {
    this.storageLocations = storageLocations;
    return this;
  }

  @Override
  public MachineImage set(String fieldName, Object value) {
    return (MachineImage) super.set(fieldName, value);
  }

  @Override
  public MachineImage clone() {
    return (MachineImage) super.clone();
  }

}
