/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-02-18 22:11:37 UTC)
 * on 2016-03-10 at 06:19:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * [Input Only] Specifies the parameters for a new disk that will be created alongside the new
 * instance. Use initialization parameters to create boot disks or local SSDs attached to the new
 * instance.
 *
 * This property is mutually exclusive with the source property; you can only define one or the
 * other, but not both.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AttachedDiskInitializeParams extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the disk name. If not specified, the default is to use the name of the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskName;

  /**
   * Specifies the size of the disk in base-2 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskSizeGb;

  /**
   * [Deprecated] Storage type of the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskStorageType;

  /**
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-
   * standard, specified using the full URL. For example:
   *
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
   *
   * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the
   * full or partial URL. For example, the following are valid values:   -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType  -
   * projects/project/zones/zone/diskTypes/diskType  - zones/zone/diskTypes/diskType
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskType;

  /**
   * A source image used to create the disk. You can provide a private (custom) image, and Compute
   * Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceImage;

  /**
   * The customer-supplied encryption key of the source image. This key is required if the source
   * image is protected by a customer-supplied encryption key.
   *
   * If the incorrect key is provided, the operation will fail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomerEncryptionKey sourceImageEncryptionKey;

  /**
   * Specifies the disk name. If not specified, the default is to use the name of the instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskName() {
    return diskName;
  }

  /**
   * Specifies the disk name. If not specified, the default is to use the name of the instance.
   * @param diskName diskName or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskName(java.lang.String diskName) {
    this.diskName = diskName;
    return this;
  }

  /**
   * Specifies the size of the disk in base-2 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Specifies the size of the disk in base-2 GB.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskSizeGb(java.lang.Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * [Deprecated] Storage type of the disk.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskStorageType() {
    return diskStorageType;
  }

  /**
   * [Deprecated] Storage type of the disk.
   * @param diskStorageType diskStorageType or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskStorageType(java.lang.String diskStorageType) {
    this.diskStorageType = diskStorageType;
    return this;
  }

  /**
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-
   * standard, specified using the full URL. For example:
   *
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
   *
   * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the
   * full or partial URL. For example, the following are valid values:   -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType  -
   * projects/project/zones/zone/diskTypes/diskType  - zones/zone/diskTypes/diskType
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskType() {
    return diskType;
  }

  /**
   * Specifies the disk type to use to create the instance. If not specified, the default is pd-
   * standard, specified using the full URL. For example:
   *
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/pd-standard
   *
   * Other values include pd-ssd and local-ssd. If you define this field, you can provide either the
   * full or partial URL. For example, the following are valid values:   -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/diskTypes/diskType  -
   * projects/project/zones/zone/diskTypes/diskType  - zones/zone/diskTypes/diskType
   * @param diskType diskType or {@code null} for none
   */
  public AttachedDiskInitializeParams setDiskType(java.lang.String diskType) {
    this.diskType = diskType;
    return this;
  }

  /**
   * A source image used to create the disk. You can provide a private (custom) image, and Compute
   * Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceImage() {
    return sourceImage;
  }

  /**
   * A source image used to create the disk. You can provide a private (custom) image, and Compute
   * Engine will use the corresponding image from your project. For example:
   *
   * global/images/my-private-image
   *
   * Or you can provide an image from a publicly-available project. For example, to use a Debian
   * image from the debian-cloud project, make sure to include the project in the URL:
   *
   * projects/debian-cloud/global/images/debian-7-wheezy-vYYYYMMDD
   *
   * where vYYYYMMDD is the image version. The fully-qualified URL will also work in both cases.
   * @param sourceImage sourceImage or {@code null} for none
   */
  public AttachedDiskInitializeParams setSourceImage(java.lang.String sourceImage) {
    this.sourceImage = sourceImage;
    return this;
  }

  /**
   * The customer-supplied encryption key of the source image. This key is required if the source
   * image is protected by a customer-supplied encryption key.
   *
   * If the incorrect key is provided, the operation will fail.
   * @return value or {@code null} for none
   */
  public CustomerEncryptionKey getSourceImageEncryptionKey() {
    return sourceImageEncryptionKey;
  }

  /**
   * The customer-supplied encryption key of the source image. This key is required if the source
   * image is protected by a customer-supplied encryption key.
   *
   * If the incorrect key is provided, the operation will fail.
   * @param sourceImageEncryptionKey sourceImageEncryptionKey or {@code null} for none
   */
  public AttachedDiskInitializeParams setSourceImageEncryptionKey(CustomerEncryptionKey sourceImageEncryptionKey) {
    this.sourceImageEncryptionKey = sourceImageEncryptionKey;
    return this;
  }

  @Override
  public AttachedDiskInitializeParams set(String fieldName, Object value) {
    return (AttachedDiskInitializeParams) super.set(fieldName, value);
  }

  @Override
  public AttachedDiskInitializeParams clone() {
    return (AttachedDiskInitializeParams) super.clone();
  }

}
