/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-02-18 22:11:37 UTC)
 * on 2016-03-25 at 00:03:05 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A network interface resource attached to an instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkInterface extends com.google.api.client.json.GenericJson {

  /**
   * An array of configurations for this interface. Currently, ONE_TO_ONE_NAT is the only access
   * config supported. If there are no accessConfigs specified, then this instance will have no
   * external internet access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AccessConfig> accessConfigs;

  static {
    // hack to force ProGuard to consider AccessConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AccessConfig.class);
  }

  /**
   * [Output Only] The name of the network interface, generated by the server. For network devices,
   * these are eth0, eth1, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the network resource for this instance. This is required for creating an instance but
   * optional when creating a firewall rule. If not specified when creating a firewall rule, the
   * default network is used:
   *
   * global/networks/default
   *
   * If you specify this property, you can specify the network as a full or partial URL. For
   * example, the following are all valid URLs:   -
   * https://www.googleapis.com/compute/v1/projects/project/global/networks/network  -
   * projects/project/global/networks/network  - global/networks/default
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * [Output Only] An optional IPV4 internal network address assigned to the instance for this
   * network interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String networkIP;

  /**
   * The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   * mode, do not provide this property. If the network is in auto subnet mode, providing the
   * subnetwork is optional. If the network is in custom subnet mode, then this field should be
   * specified. If you specify this property, you can specify the subnetwork as a full or partial
   * URL. For example, the following are all valid URLs: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/subnetworks/subnetwork  -
   * zones/zone/subnetworks/subnetwork
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * An array of configurations for this interface. Currently, ONE_TO_ONE_NAT is the only access
   * config supported. If there are no accessConfigs specified, then this instance will have no
   * external internet access.
   * @return value or {@code null} for none
   */
  public java.util.List<AccessConfig> getAccessConfigs() {
    return accessConfigs;
  }

  /**
   * An array of configurations for this interface. Currently, ONE_TO_ONE_NAT is the only access
   * config supported. If there are no accessConfigs specified, then this instance will have no
   * external internet access.
   * @param accessConfigs accessConfigs or {@code null} for none
   */
  public NetworkInterface setAccessConfigs(java.util.List<AccessConfig> accessConfigs) {
    this.accessConfigs = accessConfigs;
    return this;
  }

  /**
   * [Output Only] The name of the network interface, generated by the server. For network devices,
   * these are eth0, eth1, etc.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] The name of the network interface, generated by the server. For network devices,
   * these are eth0, eth1, etc.
   * @param name name or {@code null} for none
   */
  public NetworkInterface setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the network resource for this instance. This is required for creating an instance but
   * optional when creating a firewall rule. If not specified when creating a firewall rule, the
   * default network is used:
   *
   * global/networks/default
   *
   * If you specify this property, you can specify the network as a full or partial URL. For
   * example, the following are all valid URLs:   -
   * https://www.googleapis.com/compute/v1/projects/project/global/networks/network  -
   * projects/project/global/networks/network  - global/networks/default
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * URL of the network resource for this instance. This is required for creating an instance but
   * optional when creating a firewall rule. If not specified when creating a firewall rule, the
   * default network is used:
   *
   * global/networks/default
   *
   * If you specify this property, you can specify the network as a full or partial URL. For
   * example, the following are all valid URLs:   -
   * https://www.googleapis.com/compute/v1/projects/project/global/networks/network  -
   * projects/project/global/networks/network  - global/networks/default
   * @param network network or {@code null} for none
   */
  public NetworkInterface setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * [Output Only] An optional IPV4 internal network address assigned to the instance for this
   * network interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetworkIP() {
    return networkIP;
  }

  /**
   * [Output Only] An optional IPV4 internal network address assigned to the instance for this
   * network interface.
   * @param networkIP networkIP or {@code null} for none
   */
  public NetworkInterface setNetworkIP(java.lang.String networkIP) {
    this.networkIP = networkIP;
    return this;
  }

  /**
   * The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   * mode, do not provide this property. If the network is in auto subnet mode, providing the
   * subnetwork is optional. If the network is in custom subnet mode, then this field should be
   * specified. If you specify this property, you can specify the subnetwork as a full or partial
   * URL. For example, the following are all valid URLs: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/subnetworks/subnetwork  -
   * zones/zone/subnetworks/subnetwork
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * The URL of the Subnetwork resource for this instance. If the network resource is in legacy
   * mode, do not provide this property. If the network is in auto subnet mode, providing the
   * subnetwork is optional. If the network is in custom subnet mode, then this field should be
   * specified. If you specify this property, you can specify the subnetwork as a full or partial
   * URL. For example, the following are all valid URLs: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone/subnetworks/subnetwork  -
   * zones/zone/subnetworks/subnetwork
   * @param subnetwork subnetwork or {@code null} for none
   */
  public NetworkInterface setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  @Override
  public NetworkInterface set(String fieldName, Object value) {
    return (NetworkInterface) super.set(fieldName, value);
  }

  @Override
  public NetworkInterface clone() {
    return (NetworkInterface) super.clone();
  }

}
