/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:31:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A BackendService resource. This resource defines a group of backend virtual machines and their
 * serving capacity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendService extends com.google.api.client.json.GenericJson {

  /**
   * The list of backends that serve this BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Backend> backends;

  static {
    // hack to force ProGuard to consider Backend used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Backend.class);
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * If true, enable Cloud CDN for this BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableCDN;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The list of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this
   * BackendService. Currently at most one health check can be specified, and a health check is
   * required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> healthChecks;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Name of backend port. The same name should appear in the instance groups referenced by this
   * service. Required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portName;

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP and SSL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String protocol;

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * How many seconds to wait for the backend before considering it a failed request. Default is 30
   * seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutSec;

  /**
   * The list of backends that serve this BackendService.
   * @return value or {@code null} for none
   */
  public java.util.List<Backend> getBackends() {
    return backends;
  }

  /**
   * The list of backends that serve this BackendService.
   * @param backends backends or {@code null} for none
   */
  public BackendService setBackends(java.util.List<Backend> backends) {
    this.backends = backends;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public BackendService setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public BackendService setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * If true, enable Cloud CDN for this BackendService.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableCDN() {
    return enableCDN;
  }

  /**
   * If true, enable Cloud CDN for this BackendService.
   * @param enableCDN enableCDN or {@code null} for none
   */
  public BackendService setEnableCDN(java.lang.Boolean enableCDN) {
    this.enableCDN = enableCDN;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public BackendService setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-
   * date fingerprint must be provided in order to update the BackendService.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public BackendService encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The list of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this
   * BackendService. Currently at most one health check can be specified, and a health check is
   * required.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHealthChecks() {
    return healthChecks;
  }

  /**
   * The list of URLs to the HttpHealthCheck or HttpsHealthCheck resource for health checking this
   * BackendService. Currently at most one health check can be specified, and a health check is
   * required.
   * @param healthChecks healthChecks or {@code null} for none
   */
  public BackendService setHealthChecks(java.util.List<java.lang.String> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public BackendService setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * @param kind kind or {@code null} for none
   */
  public BackendService setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public BackendService setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is
   * 80.
   * @param port port or {@code null} for none
   */
  public BackendService setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Name of backend port. The same name should appear in the instance groups referenced by this
   * service. Required.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortName() {
    return portName;
  }

  /**
   * Name of backend port. The same name should appear in the instance groups referenced by this
   * service. Required.
   * @param portName portName or {@code null} for none
   */
  public BackendService setPortName(java.lang.String portName) {
    this.portName = portName;
    return this;
  }

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP and SSL.
   * @return value or {@code null} for none
   */
  public java.lang.String getProtocol() {
    return protocol;
  }

  /**
   * The protocol this BackendService uses to communicate with backends.
   *
   * Possible values are HTTP, HTTPS, HTTP2, TCP and SSL.
   * @param protocol protocol or {@code null} for none
   */
  public BackendService setProtocol(java.lang.String protocol) {
    this.protocol = protocol;
    return this;
  }

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the regional backend service resides. This field is not
   * applicable to global backend services.
   * @param region region or {@code null} for none
   */
  public BackendService setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public BackendService setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * How many seconds to wait for the backend before considering it a failed request. Default is 30
   * seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutSec() {
    return timeoutSec;
  }

  /**
   * How many seconds to wait for the backend before considering it a failed request. Default is 30
   * seconds.
   * @param timeoutSec timeoutSec or {@code null} for none
   */
  public BackendService setTimeoutSec(java.lang.Integer timeoutSec) {
    this.timeoutSec = timeoutSec;
    return this;
  }

  @Override
  public BackendService set(String fieldName, Object value) {
    return (BackendService) super.set(fieldName, value);
  }

  @Override
  public BackendService clone() {
    return (BackendService) super.clone();
  }

}
