/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-04-08 17:16:44 UTC)
 * on 2016-04-27 at 00:31:39 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a customer-supplied encryption key
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CustomerEncryptionKey extends com.google.api.client.json.GenericJson {

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in base64 to either encrypt or
   * decrypt this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rawKey;

  /**
   * Specifies a base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either
   * encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in base64 encoding.  Get the RSA public key certificate
   * provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String rsaEncryptedKey;

  /**
   * [Output only] The base64 encoded SHA-256 hash of the customer-supplied encryption key that
   * protects this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sha256;

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in base64 to either encrypt or
   * decrypt this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getRawKey() {
    return rawKey;
  }

  /**
   * Specifies a 256-bit customer-supplied encryption key, encoded in base64 to either encrypt or
   * decrypt this resource.
   * @param rawKey rawKey or {@code null} for none
   */
  public CustomerEncryptionKey setRawKey(java.lang.String rawKey) {
    this.rawKey = rawKey;
    return this;
  }

  /**
   * Specifies a base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either
   * encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in base64 encoding.  Get the RSA public key certificate
   * provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * @return value or {@code null} for none
   */
  public java.lang.String getRsaEncryptedKey() {
    return rsaEncryptedKey;
  }

  /**
   * Specifies a base64 encoded, RSA-wrapped 2048-bit customer-supplied encryption key to either
   * encrypt or decrypt this resource.
   *
   * The key must meet the following requirements before you can provide it to Compute Engine:   -
   * The key is wrapped using a RSA public key certificate provided by Google.  - After being
   * wrapped, the key must be encoded in base64 encoding.  Get the RSA public key certificate
   * provided by Google at: https://cloud-certs.storage.googleapis.com/google-cloud-csek-ingress.pem
   * @param rsaEncryptedKey rsaEncryptedKey or {@code null} for none
   */
  public CustomerEncryptionKey setRsaEncryptedKey(java.lang.String rsaEncryptedKey) {
    this.rsaEncryptedKey = rsaEncryptedKey;
    return this;
  }

  /**
   * [Output only] The base64 encoded SHA-256 hash of the customer-supplied encryption key that
   * protects this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSha256() {
    return sha256;
  }

  /**
   * [Output only] The base64 encoded SHA-256 hash of the customer-supplied encryption key that
   * protects this resource.
   * @param sha256 sha256 or {@code null} for none
   */
  public CustomerEncryptionKey setSha256(java.lang.String sha256) {
    this.sha256 = sha256;
    return this;
  }

  @Override
  public CustomerEncryptionKey set(String fieldName, Object value) {
    return (CustomerEncryptionKey) super.set(fieldName, value);
  }

  @Override
  public CustomerEncryptionKey clone() {
    return (CustomerEncryptionKey) super.clone();
  }

}
