/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A shielded VM identity entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ShieldedVmIdentity extends com.google.api.client.json.GenericJson {

  /**
   * An Endorsement Key (EK) issued to the Shielded VM's vTPM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedVmIdentityEntry encryptionKey;

  /**
   * [Output Only] Type of the resource. Always compute#shieldedVmIdentity for shielded VM identity
   * entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * An Attestation Key (AK) issued to the Shielded VM's vTPM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ShieldedVmIdentityEntry signingKey;

  /**
   * An Endorsement Key (EK) issued to the Shielded VM's vTPM.
   * @return value or {@code null} for none
   */
  public ShieldedVmIdentityEntry getEncryptionKey() {
    return encryptionKey;
  }

  /**
   * An Endorsement Key (EK) issued to the Shielded VM's vTPM.
   * @param encryptionKey encryptionKey or {@code null} for none
   */
  public ShieldedVmIdentity setEncryptionKey(ShieldedVmIdentityEntry encryptionKey) {
    this.encryptionKey = encryptionKey;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#shieldedVmIdentity for shielded VM identity
   * entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#shieldedVmIdentity for shielded VM identity
   * entry.
   * @param kind kind or {@code null} for none
   */
  public ShieldedVmIdentity setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * An Attestation Key (AK) issued to the Shielded VM's vTPM.
   * @return value or {@code null} for none
   */
  public ShieldedVmIdentityEntry getSigningKey() {
    return signingKey;
  }

  /**
   * An Attestation Key (AK) issued to the Shielded VM's vTPM.
   * @param signingKey signingKey or {@code null} for none
   */
  public ShieldedVmIdentity setSigningKey(ShieldedVmIdentityEntry signingKey) {
    this.signingKey = signingKey;
    return this;
  }

  @Override
  public ShieldedVmIdentity set(String fieldName, Object value) {
    return (ShieldedVmIdentity) super.set(fieldName, value);
  }

  @Override
  public ShieldedVmIdentity clone() {
    return (ShieldedVmIdentity) super.clone();
  }

}
