/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SourceInstanceProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SourceInstanceProperties extends com.google.api.client.json.GenericJson {

  /**
   * Enables instances created based on this machine image to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * Whether the instance created from this machine image should be protected against deletion.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deletionProtection;

  /**
   * An optional text description for the instances that are created from this machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * An array of disks that are associated with the instances that are created from this machine
   * image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SavedAttachedDisk> disks;

  static {
    // hack to force ProGuard to consider SavedAttachedDisk used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SavedAttachedDisk.class);
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from this
   * machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AcceleratorConfig> guestAccelerators;

  static {
    // hack to force ProGuard to consider AcceleratorConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AcceleratorConfig.class);
  }

  /**
   * Labels to apply to instances that are created from this machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * The machine type to use for instances that are created from this machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * The metadata key/value pairs to assign to instances that are created from this machine image.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may
   * be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names
   * of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
   * Bridge". For more information, read Specifying a Minimum CPU Platform.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String minCpuPlatform;

  /**
   * An array of network access configurations for this interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  static {
    // hack to force ProGuard to consider NetworkInterface used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(NetworkInterface.class);
  }

  /**
   * PostKeyRevocationActionType of the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postKeyRevocationActionType;

  /**
   * Specifies the scheduling options for the instances that are created from this machine image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this machine image. Use metadata queries to
   * obtain the access tokens for these instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  static {
    // hack to force ProGuard to consider ServiceAccount used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ServiceAccount.class);
  }

  /**
   * A list of tags to apply to the instances that are created from this machine image. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * Enables instances created based on this machine image to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Enables instances created based on this machine image to send packets with source IP addresses
   * other than their own and receive packets with destination IP addresses other than their own. If
   * these instances will be used as an IP gateway or it will be set as the next-hop in a Route
   * resource, specify true. If unsure, leave this set to false. See the Enable IP forwarding
   * documentation for more information.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public SourceInstanceProperties setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * Whether the instance created from this machine image should be protected against deletion.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeletionProtection() {
    return deletionProtection;
  }

  /**
   * Whether the instance created from this machine image should be protected against deletion.
   * @param deletionProtection deletionProtection or {@code null} for none
   */
  public SourceInstanceProperties setDeletionProtection(java.lang.Boolean deletionProtection) {
    this.deletionProtection = deletionProtection;
    return this;
  }

  /**
   * An optional text description for the instances that are created from this machine image.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional text description for the instances that are created from this machine image.
   * @param description description or {@code null} for none
   */
  public SourceInstanceProperties setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * An array of disks that are associated with the instances that are created from this machine
   * image.
   * @return value or {@code null} for none
   */
  public java.util.List<SavedAttachedDisk> getDisks() {
    return disks;
  }

  /**
   * An array of disks that are associated with the instances that are created from this machine
   * image.
   * @param disks disks or {@code null} for none
   */
  public SourceInstanceProperties setDisks(java.util.List<SavedAttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from this
   * machine image.
   * @return value or {@code null} for none
   */
  public java.util.List<AcceleratorConfig> getGuestAccelerators() {
    return guestAccelerators;
  }

  /**
   * A list of guest accelerator cards' type and count to use for instances created from this
   * machine image.
   * @param guestAccelerators guestAccelerators or {@code null} for none
   */
  public SourceInstanceProperties setGuestAccelerators(java.util.List<AcceleratorConfig> guestAccelerators) {
    this.guestAccelerators = guestAccelerators;
    return this;
  }

  /**
   * Labels to apply to instances that are created from this machine image.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to instances that are created from this machine image.
   * @param labels labels or {@code null} for none
   */
  public SourceInstanceProperties setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The machine type to use for instances that are created from this machine image.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * The machine type to use for instances that are created from this machine image.
   * @param machineType machineType or {@code null} for none
   */
  public SourceInstanceProperties setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from this machine image.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs to assign to instances that are created from this machine image.
   * These pairs can consist of custom metadata or predefined keys. See Project and instance
   * metadata for more information.
   * @param metadata metadata or {@code null} for none
   */
  public SourceInstanceProperties setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may
   * be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names
   * of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
   * Bridge". For more information, read Specifying a Minimum CPU Platform.
   * @return value or {@code null} for none
   */
  public java.lang.String getMinCpuPlatform() {
    return minCpuPlatform;
  }

  /**
   * Minimum cpu/platform to be used by instances created from this machine image. The instance may
   * be scheduled on the specified or newer cpu/platform. Applicable values are the friendly names
   * of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy
   * Bridge". For more information, read Specifying a Minimum CPU Platform.
   * @param minCpuPlatform minCpuPlatform or {@code null} for none
   */
  public SourceInstanceProperties setMinCpuPlatform(java.lang.String minCpuPlatform) {
    this.minCpuPlatform = minCpuPlatform;
    return this;
  }

  /**
   * An array of network access configurations for this interface.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * An array of network access configurations for this interface.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public SourceInstanceProperties setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * PostKeyRevocationActionType of the instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostKeyRevocationActionType() {
    return postKeyRevocationActionType;
  }

  /**
   * PostKeyRevocationActionType of the instance.
   * @param postKeyRevocationActionType postKeyRevocationActionType or {@code null} for none
   */
  public SourceInstanceProperties setPostKeyRevocationActionType(java.lang.String postKeyRevocationActionType) {
    this.postKeyRevocationActionType = postKeyRevocationActionType;
    return this;
  }

  /**
   * Specifies the scheduling options for the instances that are created from this machine image.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * Specifies the scheduling options for the instances that are created from this machine image.
   * @param scheduling scheduling or {@code null} for none
   */
  public SourceInstanceProperties setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this machine image. Use metadata queries to
   * obtain the access tokens for these instances.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts with specified scopes. Access tokens for these service accounts are
   * available to the instances that are created from this machine image. Use metadata queries to
   * obtain the access tokens for these instances.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public SourceInstanceProperties setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * A list of tags to apply to the instances that are created from this machine image. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to apply to the instances that are created from this machine image. The tags
   * identify valid sources or targets for network firewalls. The setTags method can modify this
   * list of tags. Each tag within the list must comply with RFC1035.
   * @param tags tags or {@code null} for none
   */
  public SourceInstanceProperties setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  @Override
  public SourceInstanceProperties set(String fieldName, Object value) {
    return (SourceInstanceProperties) super.set(fieldName, value);
  }

  @Override
  public SourceInstanceProperties clone() {
    return (SourceInstanceProperties) super.clone();
  }

}
