/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for TestFailure.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TestFailure extends com.google.api.client.json.GenericJson {

  /**
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query
   * parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actualOutputUrl;

  /**
   * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer actualRedirectResponseCode;

  /**
   * BackendService or BackendBucket returned by load balancer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String actualService;

  /**
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and
   * query parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expectedOutputUrl;

  /**
   * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer expectedRedirectResponseCode;

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expectedService;

  /**
   * HTTP headers of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UrlMapTestHeader> headers;

  /**
   * Host portion of the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String host;

  /**
   * Path portion including query parameters in the URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query
   * parameters.
   * @return value or {@code null} for none
   */
  public java.lang.String getActualOutputUrl() {
    return actualOutputUrl;
  }

  /**
   * The actual output URL evaluated by a load balancer containing the scheme, host, path and query
   * parameters.
   * @param actualOutputUrl actualOutputUrl or {@code null} for none
   */
  public TestFailure setActualOutputUrl(java.lang.String actualOutputUrl) {
    this.actualOutputUrl = actualOutputUrl;
    return this;
  }

  /**
   * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
   * @return value or {@code null} for none
   */
  public java.lang.Integer getActualRedirectResponseCode() {
    return actualRedirectResponseCode;
  }

  /**
   * Actual HTTP status code for rule with `urlRedirect` calculated by load balancer
   * @param actualRedirectResponseCode actualRedirectResponseCode or {@code null} for none
   */
  public TestFailure setActualRedirectResponseCode(java.lang.Integer actualRedirectResponseCode) {
    this.actualRedirectResponseCode = actualRedirectResponseCode;
    return this;
  }

  /**
   * BackendService or BackendBucket returned by load balancer.
   * @return value or {@code null} for none
   */
  public java.lang.String getActualService() {
    return actualService;
  }

  /**
   * BackendService or BackendBucket returned by load balancer.
   * @param actualService actualService or {@code null} for none
   */
  public TestFailure setActualService(java.lang.String actualService) {
    this.actualService = actualService;
    return this;
  }

  /**
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and
   * query parameters.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpectedOutputUrl() {
    return expectedOutputUrl;
  }

  /**
   * The expected output URL evaluated by a load balancer containing the scheme, host, path and
   * query parameters.
   * @param expectedOutputUrl expectedOutputUrl or {@code null} for none
   */
  public TestFailure setExpectedOutputUrl(java.lang.String expectedOutputUrl) {
    this.expectedOutputUrl = expectedOutputUrl;
    return this;
  }

  /**
   * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExpectedRedirectResponseCode() {
    return expectedRedirectResponseCode;
  }

  /**
   * Expected HTTP status code for rule with `urlRedirect` calculated by load balancer
   * @param expectedRedirectResponseCode expectedRedirectResponseCode or {@code null} for none
   */
  public TestFailure setExpectedRedirectResponseCode(java.lang.Integer expectedRedirectResponseCode) {
    this.expectedRedirectResponseCode = expectedRedirectResponseCode;
    return this;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpectedService() {
    return expectedService;
  }

  /**
   * Expected BackendService or BackendBucket resource the given URL should be mapped to.
   * @param expectedService expectedService or {@code null} for none
   */
  public TestFailure setExpectedService(java.lang.String expectedService) {
    this.expectedService = expectedService;
    return this;
  }

  /**
   * HTTP headers of the request.
   * @return value or {@code null} for none
   */
  public java.util.List<UrlMapTestHeader> getHeaders() {
    return headers;
  }

  /**
   * HTTP headers of the request.
   * @param headers headers or {@code null} for none
   */
  public TestFailure setHeaders(java.util.List<UrlMapTestHeader> headers) {
    this.headers = headers;
    return this;
  }

  /**
   * Host portion of the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getHost() {
    return host;
  }

  /**
   * Host portion of the URL.
   * @param host host or {@code null} for none
   */
  public TestFailure setHost(java.lang.String host) {
    this.host = host;
    return this;
  }

  /**
   * Path portion including query parameters in the URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * Path portion including query parameters in the URL.
   * @param path path or {@code null} for none
   */
  public TestFailure setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  @Override
  public TestFailure set(String fieldName, Object value) {
    return (TestFailure) super.set(fieldName, value);
  }

  @Override
  public TestFailure clone() {
    return (TestFailure) super.clone();
  }

}
