/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The available logging options for a firewall rule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FirewallLogConfig extends com.google.api.client.json.GenericJson {

  /**
   * This field denotes whether to enable logging for a particular firewall rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enable;

  /**
   * This field can only be specified for a particular firewall rule if logging is enabled for that
   * rule. This field denotes whether to include or exclude metadata for firewall logs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metadata;

  /**
   * This field denotes whether to enable logging for a particular firewall rule.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnable() {
    return enable;
  }

  /**
   * This field denotes whether to enable logging for a particular firewall rule.
   * @param enable enable or {@code null} for none
   */
  public FirewallLogConfig setEnable(java.lang.Boolean enable) {
    this.enable = enable;
    return this;
  }

  /**
   * This field can only be specified for a particular firewall rule if logging is enabled for that
   * rule. This field denotes whether to include or exclude metadata for firewall logs.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetadata() {
    return metadata;
  }

  /**
   * This field can only be specified for a particular firewall rule if logging is enabled for that
   * rule. This field denotes whether to include or exclude metadata for firewall logs.
   * @param metadata metadata or {@code null} for none
   */
  public FirewallLogConfig setMetadata(java.lang.String metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public FirewallLogConfig set(String fieldName, Object value) {
    return (FirewallLogConfig) super.set(fieldName, value);
  }

  @Override
  public FirewallLogConfig clone() {
    return (FirewallLogConfig) super.clone();
  }

}
