/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRuleRateLimitOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRuleRateLimitOptions extends com.google.api.client.json.GenericJson {

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines
   * the time (in seconds) the traffic will continue to be banned by the rate limit after the rate
   * falls below the threshold.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer banDurationSec;

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key
   * will be banned for the configured 'ban_duration_sec' when the number of requests that exceed
   * the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityPolicyRuleRateLimitOptionsThreshold banThreshold;

  /**
   * Action to take for requests that are under the configured rate limit threshold. Valid option is
   * "allow" only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String conformAction;

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single
   * rate limit threshold is applied to all the requests matching this rule. This is the default
   * value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the
   * request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the
   * HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to
   * the first 128 bytes of the header value. If no such header is present in the request, the key
   * type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address)
   * specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or
   * the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the
   * first 128 bytes of the cookie value. If no such cookie is present in the request, the key type
   * defaults to ALL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enforceOnKey;

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String enforceOnKeyName;

  /**
   * Action to take for requests that are above the configured rate limit threshold, to either deny
   * with a specified HTTP response code, or redirect to a different endpoint. Valid options are
   * "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the
   * redirect parameters come from exceed_redirect_options below.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String exceedAction;

  /**
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified
   * if the exceed action is not redirect.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityPolicyRuleRedirectOptions exceedRedirectOptions;

  /**
   * Threshold at which to begin ratelimiting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityPolicyRuleRateLimitOptionsThreshold rateLimitThreshold;

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines
   * the time (in seconds) the traffic will continue to be banned by the rate limit after the rate
   * falls below the threshold.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBanDurationSec() {
    return banDurationSec;
  }

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, determines
   * the time (in seconds) the traffic will continue to be banned by the rate limit after the rate
   * falls below the threshold.
   * @param banDurationSec banDurationSec or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setBanDurationSec(java.lang.Integer banDurationSec) {
    this.banDurationSec = banDurationSec;
    return this;
  }

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key
   * will be banned for the configured 'ban_duration_sec' when the number of requests that exceed
   * the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * @return value or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsThreshold getBanThreshold() {
    return banThreshold;
  }

  /**
   * Can only be specified if the action for the rule is "rate_based_ban". If specified, the key
   * will be banned for the configured 'ban_duration_sec' when the number of requests that exceed
   * the 'rate_limit_threshold' also exceed this 'ban_threshold'.
   * @param banThreshold banThreshold or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setBanThreshold(SecurityPolicyRuleRateLimitOptionsThreshold banThreshold) {
    this.banThreshold = banThreshold;
    return this;
  }

  /**
   * Action to take for requests that are under the configured rate limit threshold. Valid option is
   * "allow" only.
   * @return value or {@code null} for none
   */
  public java.lang.String getConformAction() {
    return conformAction;
  }

  /**
   * Action to take for requests that are under the configured rate limit threshold. Valid option is
   * "allow" only.
   * @param conformAction conformAction or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setConformAction(java.lang.String conformAction) {
    this.conformAction = conformAction;
    return this;
  }

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single
   * rate limit threshold is applied to all the requests matching this rule. This is the default
   * value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the
   * request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the
   * HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to
   * the first 128 bytes of the header value. If no such header is present in the request, the key
   * type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address)
   * specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or
   * the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the
   * first 128 bytes of the cookie value. If no such cookie is present in the request, the key type
   * defaults to ALL.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnforceOnKey() {
    return enforceOnKey;
  }

  /**
   * Determines the key to enforce the rate_limit_threshold on. Possible values are: - ALL: A single
   * rate limit threshold is applied to all the requests matching this rule. This is the default
   * value if this field 'enforce_on_key' is not configured. - IP: The source IP address of the
   * request is the key. Each IP has this limit enforced separately. - HTTP_HEADER: The value of the
   * HTTP header whose name is configured under "enforce_on_key_name". The key value is truncated to
   * the first 128 bytes of the header value. If no such header is present in the request, the key
   * type defaults to ALL. - XFF_IP: The first IP address (i.e. the originating client IP address)
   * specified in the list of IPs under X-Forwarded-For HTTP header. If no such header is present or
   * the value is not a valid IP, the key type defaults to ALL. - HTTP_COOKIE: The value of the HTTP
   * cookie whose name is configured under "enforce_on_key_name". The key value is truncated to the
   * first 128 bytes of the cookie value. If no such cookie is present in the request, the key type
   * defaults to ALL.
   * @param enforceOnKey enforceOnKey or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setEnforceOnKey(java.lang.String enforceOnKey) {
    this.enforceOnKey = enforceOnKey;
    return this;
  }

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * @return value or {@code null} for none
   */
  public java.lang.String getEnforceOnKeyName() {
    return enforceOnKeyName;
  }

  /**
   * Rate limit key name applicable only for the following key types: HTTP_HEADER -- Name of the
   * HTTP header whose value is taken as the key value. HTTP_COOKIE -- Name of the HTTP cookie whose
   * value is taken as the key value.
   * @param enforceOnKeyName enforceOnKeyName or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setEnforceOnKeyName(java.lang.String enforceOnKeyName) {
    this.enforceOnKeyName = enforceOnKeyName;
    return this;
  }

  /**
   * Action to take for requests that are above the configured rate limit threshold, to either deny
   * with a specified HTTP response code, or redirect to a different endpoint. Valid options are
   * "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the
   * redirect parameters come from exceed_redirect_options below.
   * @return value or {@code null} for none
   */
  public java.lang.String getExceedAction() {
    return exceedAction;
  }

  /**
   * Action to take for requests that are above the configured rate limit threshold, to either deny
   * with a specified HTTP response code, or redirect to a different endpoint. Valid options are
   * "deny()" where valid values for status are 403, 404, 429, and 502, and "redirect" where the
   * redirect parameters come from exceed_redirect_options below.
   * @param exceedAction exceedAction or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setExceedAction(java.lang.String exceedAction) {
    this.exceedAction = exceedAction;
    return this;
  }

  /**
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified
   * if the exceed action is not redirect.
   * @return value or {@code null} for none
   */
  public SecurityPolicyRuleRedirectOptions getExceedRedirectOptions() {
    return exceedRedirectOptions;
  }

  /**
   * Parameters defining the redirect action that is used as the exceed action. Cannot be specified
   * if the exceed action is not redirect.
   * @param exceedRedirectOptions exceedRedirectOptions or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setExceedRedirectOptions(SecurityPolicyRuleRedirectOptions exceedRedirectOptions) {
    this.exceedRedirectOptions = exceedRedirectOptions;
    return this;
  }

  /**
   * Threshold at which to begin ratelimiting.
   * @return value or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptionsThreshold getRateLimitThreshold() {
    return rateLimitThreshold;
  }

  /**
   * Threshold at which to begin ratelimiting.
   * @param rateLimitThreshold rateLimitThreshold or {@code null} for none
   */
  public SecurityPolicyRuleRateLimitOptions setRateLimitThreshold(SecurityPolicyRuleRateLimitOptionsThreshold rateLimitThreshold) {
    this.rateLimitThreshold = rateLimitThreshold;
    return this;
  }

  @Override
  public SecurityPolicyRuleRateLimitOptions set(String fieldName, Object value) {
    return (SecurityPolicyRuleRateLimitOptions) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRuleRateLimitOptions clone() {
    return (SecurityPolicyRuleRateLimitOptions) super.clone();
  }

}
