/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyRecaptchaOptionsConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyRecaptchaOptionsConfig extends com.google.api.client.json.GenericJson {

  /**
   * An optional field to supply a reCAPTCHA site key to be used for all the rules using the
   * redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site
   * key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the
   * specified site key. If not specified, a Google-managed site key is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String redirectSiteKey;

  /**
   * An optional field to supply a reCAPTCHA site key to be used for all the rules using the
   * redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site
   * key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the
   * specified site key. If not specified, a Google-managed site key is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getRedirectSiteKey() {
    return redirectSiteKey;
  }

  /**
   * An optional field to supply a reCAPTCHA site key to be used for all the rules using the
   * redirect action with the type of GOOGLE_RECAPTCHA under the security policy. The specified site
   * key needs to be created from the reCAPTCHA API. The user is responsible for the validity of the
   * specified site key. If not specified, a Google-managed site key is used.
   * @param redirectSiteKey redirectSiteKey or {@code null} for none
   */
  public SecurityPolicyRecaptchaOptionsConfig setRedirectSiteKey(java.lang.String redirectSiteKey) {
    this.redirectSiteKey = redirectSiteKey;
    return this;
  }

  @Override
  public SecurityPolicyRecaptchaOptionsConfig set(String fieldName, Object value) {
    return (SecurityPolicyRecaptchaOptionsConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyRecaptchaOptionsConfig clone() {
    return (SecurityPolicyRecaptchaOptionsConfig) super.clone();
  }

}
