/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute;

/**
 * Service definition for Compute (beta).
 *
 * <p>
 * Creates and runs virtual machines on Google Cloud Platform. 
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/compute/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link ComputeRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Compute extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Compute Engine API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://compute.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://compute.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "compute/beta/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/compute/beta";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Compute(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Compute(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the AcceleratorTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.AcceleratorTypes.List request = compute.acceleratorTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public AcceleratorTypes acceleratorTypes() {
    return new AcceleratorTypes();
  }

  /**
   * The "acceleratorTypes" collection of methods.
   */
  public class AcceleratorTypes {

    /**
     * Retrieves an aggregated list of accelerator types.
     *
     * Create a request for the method "acceleratorTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AcceleratorTypeAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/acceleratorTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of accelerator types.
       *
       * Create a request for the method "acceleratorTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified accelerator type.
     *
     * Create a request for the method "acceleratorTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param acceleratorType Name of the accelerator type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String acceleratorType) throws java.io.IOException {
      Get result = new Get(project, zone, acceleratorType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.AcceleratorType> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/acceleratorTypes/{acceleratorType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ACCELERATOR_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified accelerator type.
       *
       * Create a request for the method "acceleratorTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param acceleratorType Name of the accelerator type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String acceleratorType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.acceleratorType = com.google.api.client.util.Preconditions.checkNotNull(acceleratorType, "Required parameter acceleratorType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCELERATOR_TYPE_PATTERN.matcher(acceleratorType).matches(),
              "Parameter acceleratorType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the accelerator type to return. */
      @com.google.api.client.util.Key
      private java.lang.String acceleratorType;

      /** Name of the accelerator type to return.
       */
      public java.lang.String getAcceleratorType() {
        return acceleratorType;
      }

      /** Name of the accelerator type to return. */
      public Get setAcceleratorType(java.lang.String acceleratorType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ACCELERATOR_TYPE_PATTERN.matcher(acceleratorType).matches(),
              "Parameter acceleratorType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.acceleratorType = acceleratorType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of accelerator types that are available to the specified project.
     *
     * Create a request for the method "acceleratorTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AcceleratorTypeList> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/acceleratorTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of accelerator types that are available to the specified project.
       *
       * Create a request for the method "acceleratorTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AcceleratorTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Addresses collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Addresses.List request = compute.addresses().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Addresses addresses() {
    return new Addresses();
  }

  /**
   * The "addresses" collection of methods.
   */
  public class Addresses {

    /**
     * Retrieves an aggregated list of addresses.
     *
     * Create a request for the method "addresses.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AddressAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of addresses.
       *
       * Create a request for the method "addresses.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified address resource.
     *
     * Create a request for the method "addresses.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Delete result = new Delete(project, region, address);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified address resource.
       *
       * Create a request for the method "addresses.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to delete.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to delete. */
      public Delete setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.address = address;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified address resource.
     *
     * Create a request for the method "addresses.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param address Name of the address resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String address) throws java.io.IOException {
      Get result = new Get(project, region, address);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Address> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses/{address}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern ADDRESS_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified address resource.
       *
       * Create a request for the method "addresses.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param address Name of the address resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String address) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Address.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.address = com.google.api.client.util.Preconditions.checkNotNull(address, "Required parameter address must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the address resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String address;

      /** Name of the address resource to return.
       */
      public java.lang.String getAddress() {
        return address;
      }

      /** Name of the address resource to return. */
      public Get setAddress(java.lang.String address) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ADDRESS_PATTERN.matcher(address).matches(),
              "Parameter address must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.address = address;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an address resource in the specified project by using the data included in the request.
     *
     * Create a request for the method "addresses.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @param content the {@link com.google.api.services.compute.model.Address}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an address resource in the specified project by using the data included in the request.
       *
       * Create a request for the method "addresses.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @param content the {@link com.google.api.services.compute.model.Address}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.Address content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of addresses contained within the specified region.
     *
     * Create a request for the method "addresses.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AddressList> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of addresses contained within the specified region.
       *
       * Create a request for the method "addresses.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AddressList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region for this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the labels on an Address. To learn more about labels, read the Labeling Resources
     * documentation.
     *
     * Create a request for the method "addresses.setLabels".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The region for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.RegionSetLabelsRequest}
     * @return the request
     */
    public SetLabels setLabels(java.lang.String project, java.lang.String region, java.lang.String resource, com.google.api.services.compute.model.RegionSetLabelsRequest content) throws java.io.IOException {
      SetLabels result = new SetLabels(project, region, resource, content);
      initialize(result);
      return result;
    }

    public class SetLabels extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses/{resource}/setLabels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the labels on an Address. To learn more about labels, read the Labeling Resources
       * documentation.
       *
       * Create a request for the method "addresses.setLabels".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The region for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.RegionSetLabelsRequest}
       * @since 1.13
       */
      protected SetLabels(java.lang.String project, java.lang.String region, java.lang.String resource, com.google.api.services.compute.model.RegionSetLabelsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetLabels set$Xgafv(java.lang.String $Xgafv) {
        return (SetLabels) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetLabels setAccessToken(java.lang.String accessToken) {
        return (SetLabels) super.setAccessToken(accessToken);
      }

      @Override
      public SetLabels setAlt(java.lang.String alt) {
        return (SetLabels) super.setAlt(alt);
      }

      @Override
      public SetLabels setCallback(java.lang.String callback) {
        return (SetLabels) super.setCallback(callback);
      }

      @Override
      public SetLabels setFields(java.lang.String fields) {
        return (SetLabels) super.setFields(fields);
      }

      @Override
      public SetLabels setKey(java.lang.String key) {
        return (SetLabels) super.setKey(key);
      }

      @Override
      public SetLabels setOauthToken(java.lang.String oauthToken) {
        return (SetLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetLabels setQuotaUser(java.lang.String quotaUser) {
        return (SetLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetLabels setUploadType(java.lang.String uploadType) {
        return (SetLabels) super.setUploadType(uploadType);
      }

      @Override
      public SetLabels setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetLabels) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetLabels setUserIp(java.lang.String userIp) {
        return (SetLabels) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetLabels setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The region for this request. */
      public SetLabels setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetLabels setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public SetLabels setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetLabels set(String parameterName, Object value) {
        return (SetLabels) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "addresses.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region The name of the region for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String region, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/addresses/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "addresses.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region The name of the region for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String region, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the region for this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** The name of the region for this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** The name of the region for this request. */
      public TestIamPermissions setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Autoscalers collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Autoscalers.List request = compute.autoscalers().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Autoscalers autoscalers() {
    return new Autoscalers();
  }

  /**
   * The "autoscalers" collection of methods.
   */
  public class Autoscalers {

    /**
     * Retrieves an aggregated list of autoscalers.
     *
     * Create a request for the method "autoscalers.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.AutoscalerAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of autoscalers.
       *
       * Create a request for the method "autoscalers.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified autoscaler.
     *
     * Create a request for the method "autoscalers.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Delete result = new Delete(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified autoscaler.
       *
       * Create a request for the method "autoscalers.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to delete. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to delete.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to delete. */
      public Delete setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified autoscaler resource. Gets a list of available autoscalers by making a
     * list() request.
     *
     * Create a request for the method "autoscalers.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param autoscaler Name of the autoscaler to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) throws java.io.IOException {
      Get result = new Get(project, zone, autoscaler);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Autoscaler> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers/{autoscaler}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified autoscaler resource. Gets a list of available autoscalers by making a
       * list() request.
       *
       * Create a request for the method "autoscalers.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param autoscaler Name of the autoscaler to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String autoscaler) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Autoscaler.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.autoscaler = com.google.api.client.util.Preconditions.checkNotNull(autoscaler, "Required parameter autoscaler must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to return. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to return.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to return. */
      public Get setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of autoscalers contained within the specified zone.
     *
     * Create a request for the method "autoscalers.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.AutoscalerList> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of autoscalers contained within the specified zone.
       *
       * Create a request for the method "autoscalers.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.AutoscalerList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request. This
     * method supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "autoscalers.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Patch result = new Patch(project, zone, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates an autoscaler in the specified project using the data included in the request. This
       * method supports PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "autoscalers.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Patch setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to patch. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to patch.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to patch. */
      public Patch setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "autoscalers.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, zone, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "autoscalers.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public TestIamPermissions setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates an autoscaler in the specified project using the data included in the request.
     *
     * Create a request for the method "autoscalers.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone Name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Autoscaler}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) throws java.io.IOException {
      Update result = new Update(project, zone, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/autoscalers";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern AUTOSCALER_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates an autoscaler in the specified project using the data included in the request.
       *
       * Create a request for the method "autoscalers.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone Name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Autoscaler}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Autoscaler content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** Name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** Name of the zone for this request. */
      public Update setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the autoscaler to update. */
      @com.google.api.client.util.Key
      private java.lang.String autoscaler;

      /** Name of the autoscaler to update.
       */
      public java.lang.String getAutoscaler() {
        return autoscaler;
      }

      /** Name of the autoscaler to update. */
      public Update setAutoscaler(java.lang.String autoscaler) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(AUTOSCALER_PATTERN.matcher(autoscaler).matches(),
              "Parameter autoscaler must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.autoscaler = autoscaler;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendBuckets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendBuckets.List request = compute.backendBuckets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendBuckets backendBuckets() {
    return new BackendBuckets();
  }

  /**
   * The "backendBuckets" collection of methods.
   */
  public class BackendBuckets {

    /**
     * Adds a key for validating requests with signed URLs for this backend bucket.
     *
     * Create a request for the method "backendBuckets.addSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
     * @return the request
     */
    public AddSignedUrlKey addSignedUrlKey(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SignedUrlKey content) throws java.io.IOException {
      AddSignedUrlKey result = new AddSignedUrlKey(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class AddSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}/addSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Adds a key for validating requests with signed URLs for this backend bucket.
       *
       * Create a request for the method "backendBuckets.addSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
       * <p> {@link AddSignedUrlKey#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
       * @since 1.13
       */
      protected AddSignedUrlKey(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SignedUrlKey content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
      }

      @Override
      public AddSignedUrlKey set$Xgafv(java.lang.String $Xgafv) {
        return (AddSignedUrlKey) super.set$Xgafv($Xgafv);
      }

      @Override
      public AddSignedUrlKey setAccessToken(java.lang.String accessToken) {
        return (AddSignedUrlKey) super.setAccessToken(accessToken);
      }

      @Override
      public AddSignedUrlKey setAlt(java.lang.String alt) {
        return (AddSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public AddSignedUrlKey setCallback(java.lang.String callback) {
        return (AddSignedUrlKey) super.setCallback(callback);
      }

      @Override
      public AddSignedUrlKey setFields(java.lang.String fields) {
        return (AddSignedUrlKey) super.setFields(fields);
      }

      @Override
      public AddSignedUrlKey setKey(java.lang.String key) {
        return (AddSignedUrlKey) super.setKey(key);
      }

      @Override
      public AddSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (AddSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public AddSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (AddSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddSignedUrlKey setUploadType(java.lang.String uploadType) {
        return (AddSignedUrlKey) super.setUploadType(uploadType);
      }

      @Override
      public AddSignedUrlKey setUploadProtocol(java.lang.String uploadProtocol) {
        return (AddSignedUrlKey) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AddSignedUrlKey setUserIp(java.lang.String userIp) {
        return (AddSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public AddSignedUrlKey setBackendBucket(java.lang.String backendBucket) {
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public AddSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddSignedUrlKey set(String parameterName, Object value) {
        return (AddSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified BackendBucket resource.
     *
     * Create a request for the method "backendBuckets.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendBucket) throws java.io.IOException {
      Delete result = new Delete(project, backendBucket);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified BackendBucket resource.
       *
       * Create a request for the method "backendBuckets.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendBucket) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to delete.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to delete. */
      public Delete setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a key for validating requests with signed URLs for this backend bucket.
     *
     * Create a request for the method "backendBuckets.deleteSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param keyName The name of the Signed URL Key to delete.
     * @return the request
     */
    public DeleteSignedUrlKey deleteSignedUrlKey(java.lang.String project, java.lang.String backendBucket, java.lang.String keyName) throws java.io.IOException {
      DeleteSignedUrlKey result = new DeleteSignedUrlKey(project, backendBucket, keyName);
      initialize(result);
      return result;
    }

    public class DeleteSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}/deleteSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes a key for validating requests with signed URLs for this backend bucket.
       *
       * Create a request for the method "backendBuckets.deleteSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote
       * operation. <p> {@link DeleteSignedUrlKey#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param keyName The name of the Signed URL Key to delete.
       * @since 1.13
       */
      protected DeleteSignedUrlKey(java.lang.String project, java.lang.String backendBucket, java.lang.String keyName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        this.keyName = com.google.api.client.util.Preconditions.checkNotNull(keyName, "Required parameter keyName must be specified.");
      }

      @Override
      public DeleteSignedUrlKey set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteSignedUrlKey) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteSignedUrlKey setAccessToken(java.lang.String accessToken) {
        return (DeleteSignedUrlKey) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteSignedUrlKey setAlt(java.lang.String alt) {
        return (DeleteSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public DeleteSignedUrlKey setCallback(java.lang.String callback) {
        return (DeleteSignedUrlKey) super.setCallback(callback);
      }

      @Override
      public DeleteSignedUrlKey setFields(java.lang.String fields) {
        return (DeleteSignedUrlKey) super.setFields(fields);
      }

      @Override
      public DeleteSignedUrlKey setKey(java.lang.String key) {
        return (DeleteSignedUrlKey) super.setKey(key);
      }

      @Override
      public DeleteSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (DeleteSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (DeleteSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteSignedUrlKey setUploadType(java.lang.String uploadType) {
        return (DeleteSignedUrlKey) super.setUploadType(uploadType);
      }

      @Override
      public DeleteSignedUrlKey setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteSignedUrlKey) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public DeleteSignedUrlKey setUserIp(java.lang.String userIp) {
        return (DeleteSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /**
       * Name of the BackendBucket resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public DeleteSignedUrlKey setBackendBucket(java.lang.String backendBucket) {
        this.backendBucket = backendBucket;
        return this;
      }

      /** The name of the Signed URL Key to delete. */
      @com.google.api.client.util.Key
      private java.lang.String keyName;

      /** The name of the Signed URL Key to delete.
       */
      public java.lang.String getKeyName() {
        return keyName;
      }

      /** The name of the Signed URL Key to delete. */
      public DeleteSignedUrlKey setKeyName(java.lang.String keyName) {
        this.keyName = keyName;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public DeleteSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public DeleteSignedUrlKey set(String parameterName, Object value) {
        return (DeleteSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendBucket resource. Gets a list of available backend buckets by making
     * a list() request.
     *
     * Create a request for the method "backendBuckets.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendBucket) throws java.io.IOException {
      Get result = new Get(project, backendBucket);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendBucket> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified BackendBucket resource. Gets a list of available backend buckets by
       * making a list() request.
       *
       * Create a request for the method "backendBuckets.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendBucket) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendBucket.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to return.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to return. */
      public Get setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * Create a request for the method "backendBuckets.getIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String project, java.lang.String resource) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(project, resource);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{resource}/getIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Gets the access control policy for a resource. May be empty if no such policy or resource
       * exists.
       *
       * Create a request for the method "backendBuckets.getIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String project, java.lang.String resource) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      /** Requested IAM Policy version. */
      @com.google.api.client.util.Key
      private java.lang.Integer optionsRequestedPolicyVersion;

      /** Requested IAM Policy version.
       */
      public java.lang.Integer getOptionsRequestedPolicyVersion() {
        return optionsRequestedPolicyVersion;
      }

      /** Requested IAM Policy version. */
      public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendBucket resource in the specified project using the data included in the request.
     *
     * Create a request for the method "backendBuckets.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendBucket resource in the specified project using the data included in the
       * request.
       *
       * Create a request for the method "backendBuckets.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendBucket resources available to the specified project.
     *
     * Create a request for the method "backendBuckets.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendBucketList> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendBucket resources available to the specified project.
       *
       * Create a request for the method "backendBuckets.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendBucketList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendBucket resource with the data included in the request. This method
     * supports PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "backendBuckets.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to patch.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Patch result = new Patch(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified BackendBucket resource with the data included in the request. This method
       * supports PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "backendBuckets.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to patch.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to patch.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to patch. */
      public Patch setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the edge security policy for the specified backend bucket.
     *
     * Create a request for the method "backendBuckets.setEdgeSecurityPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetEdgeSecurityPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendService resource to which the security policy should be set. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
     * @return the request
     */
    public SetEdgeSecurityPolicy setEdgeSecurityPolicy(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SecurityPolicyReference content) throws java.io.IOException {
      SetEdgeSecurityPolicy result = new SetEdgeSecurityPolicy(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class SetEdgeSecurityPolicy extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}/setEdgeSecurityPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets the edge security policy for the specified backend bucket.
       *
       * Create a request for the method "backendBuckets.setEdgeSecurityPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetEdgeSecurityPolicy#execute()} method to invoke the remote
       * operation. <p> {@link SetEdgeSecurityPolicy#initialize(com.google.api.client.googleapis.service
       * s.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendService resource to which the security policy should be set. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
       * @since 1.13
       */
      protected SetEdgeSecurityPolicy(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.SecurityPolicyReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
      }

      @Override
      public SetEdgeSecurityPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetEdgeSecurityPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetEdgeSecurityPolicy setAccessToken(java.lang.String accessToken) {
        return (SetEdgeSecurityPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetEdgeSecurityPolicy setAlt(java.lang.String alt) {
        return (SetEdgeSecurityPolicy) super.setAlt(alt);
      }

      @Override
      public SetEdgeSecurityPolicy setCallback(java.lang.String callback) {
        return (SetEdgeSecurityPolicy) super.setCallback(callback);
      }

      @Override
      public SetEdgeSecurityPolicy setFields(java.lang.String fields) {
        return (SetEdgeSecurityPolicy) super.setFields(fields);
      }

      @Override
      public SetEdgeSecurityPolicy setKey(java.lang.String key) {
        return (SetEdgeSecurityPolicy) super.setKey(key);
      }

      @Override
      public SetEdgeSecurityPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetEdgeSecurityPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetEdgeSecurityPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetEdgeSecurityPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetEdgeSecurityPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetEdgeSecurityPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetEdgeSecurityPolicy setUploadType(java.lang.String uploadType) {
        return (SetEdgeSecurityPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetEdgeSecurityPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetEdgeSecurityPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetEdgeSecurityPolicy setUserIp(java.lang.String userIp) {
        return (SetEdgeSecurityPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetEdgeSecurityPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the security policy should be set. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendService resource to which the security policy should be set. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /**
       * Name of the BackendService resource to which the security policy should be set. The name
       * should conform to RFC1035.
       */
      public SetEdgeSecurityPolicy setBackendBucket(java.lang.String backendBucket) {
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public SetEdgeSecurityPolicy setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetEdgeSecurityPolicy set(String parameterName, Object value) {
        return (SetEdgeSecurityPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * Create a request for the method "backendBuckets.setIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.GlobalSetPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(project, resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{resource}/setIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "backendBuckets.setIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.GlobalSetPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetPolicyRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "backendBuckets.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "backendBuckets.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendBucket resource with the data included in the request.
     *
     * Create a request for the method "backendBuckets.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendBucket Name of the BackendBucket resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendBucket}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) throws java.io.IOException {
      Update result = new Update(project, backendBucket, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendBuckets/{backendBucket}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_BUCKET_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified BackendBucket resource with the data included in the request.
       *
       * Create a request for the method "backendBuckets.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendBucket Name of the BackendBucket resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendBucket}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendBucket, com.google.api.services.compute.model.BackendBucket content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendBucket = com.google.api.client.util.Preconditions.checkNotNull(backendBucket, "Required parameter backendBucket must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendBucket resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendBucket;

      /** Name of the BackendBucket resource to update.
       */
      public java.lang.String getBackendBucket() {
        return backendBucket;
      }

      /** Name of the BackendBucket resource to update. */
      public Update setBackendBucket(java.lang.String backendBucket) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_BUCKET_PATTERN.matcher(backendBucket).matches(),
              "Parameter backendBucket must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendBucket = backendBucket;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the BackendServices collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.BackendServices.List request = compute.backendServices().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public BackendServices backendServices() {
    return new BackendServices();
  }

  /**
   * The "backendServices" collection of methods.
   */
  public class BackendServices {

    /**
     * Adds a key for validating requests with signed URLs for this backend service.
     *
     * Create a request for the method "backendServices.addSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
     * @return the request
     */
    public AddSignedUrlKey addSignedUrlKey(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SignedUrlKey content) throws java.io.IOException {
      AddSignedUrlKey result = new AddSignedUrlKey(project, backendService, content);
      initialize(result);
      return result;
    }

    public class AddSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}/addSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Adds a key for validating requests with signed URLs for this backend service.
       *
       * Create a request for the method "backendServices.addSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddSignedUrlKey#execute()} method to invoke the remote operation.
       * <p> {@link AddSignedUrlKey#initialize(com.google.api.client.googleapis.services.AbstractGoogleC
       * lientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SignedUrlKey}
       * @since 1.13
       */
      protected AddSignedUrlKey(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SignedUrlKey content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
      }

      @Override
      public AddSignedUrlKey set$Xgafv(java.lang.String $Xgafv) {
        return (AddSignedUrlKey) super.set$Xgafv($Xgafv);
      }

      @Override
      public AddSignedUrlKey setAccessToken(java.lang.String accessToken) {
        return (AddSignedUrlKey) super.setAccessToken(accessToken);
      }

      @Override
      public AddSignedUrlKey setAlt(java.lang.String alt) {
        return (AddSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public AddSignedUrlKey setCallback(java.lang.String callback) {
        return (AddSignedUrlKey) super.setCallback(callback);
      }

      @Override
      public AddSignedUrlKey setFields(java.lang.String fields) {
        return (AddSignedUrlKey) super.setFields(fields);
      }

      @Override
      public AddSignedUrlKey setKey(java.lang.String key) {
        return (AddSignedUrlKey) super.setKey(key);
      }

      @Override
      public AddSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (AddSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public AddSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (AddSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddSignedUrlKey setUploadType(java.lang.String uploadType) {
        return (AddSignedUrlKey) super.setUploadType(uploadType);
      }

      @Override
      public AddSignedUrlKey setUploadProtocol(java.lang.String uploadProtocol) {
        return (AddSignedUrlKey) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AddSignedUrlKey setUserIp(java.lang.String userIp) {
        return (AddSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public AddSignedUrlKey setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public AddSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddSignedUrlKey set(String parameterName, Object value) {
        return (AddSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of all BackendService resources, regional and global, available to the
     * specified project.
     *
     * Create a request for the method "backendServices.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Name of the project scoping this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.BackendServiceAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of all BackendService resources, regional and global, available to the
       * specified project.
       *
       * Create a request for the method "backendServices.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Name of the project scoping this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Name of the project scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Name of the project scoping this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Name of the project scoping this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified BackendService resource.
     *
     * Create a request for the method "backendServices.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Delete result = new Delete(project, backendService);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified BackendService resource.
       *
       * Create a request for the method "backendServices.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to delete.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to delete. */
      public Delete setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a key for validating requests with signed URLs for this backend service.
     *
     * Create a request for the method "backendServices.deleteSignedUrlKey".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
     * @param keyName The name of the Signed URL Key to delete.
     * @return the request
     */
    public DeleteSignedUrlKey deleteSignedUrlKey(java.lang.String project, java.lang.String backendService, java.lang.String keyName) throws java.io.IOException {
      DeleteSignedUrlKey result = new DeleteSignedUrlKey(project, backendService, keyName);
      initialize(result);
      return result;
    }

    public class DeleteSignedUrlKey extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}/deleteSignedUrlKey";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Deletes a key for validating requests with signed URLs for this backend service.
       *
       * Create a request for the method "backendServices.deleteSignedUrlKey".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link DeleteSignedUrlKey#execute()} method to invoke the remote
       * operation. <p> {@link DeleteSignedUrlKey#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the Signed URL Key should be added. The name should
     *        conform to RFC1035.
       * @param keyName The name of the Signed URL Key to delete.
       * @since 1.13
       */
      protected DeleteSignedUrlKey(java.lang.String project, java.lang.String backendService, java.lang.String keyName) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        this.keyName = com.google.api.client.util.Preconditions.checkNotNull(keyName, "Required parameter keyName must be specified.");
      }

      @Override
      public DeleteSignedUrlKey set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteSignedUrlKey) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteSignedUrlKey setAccessToken(java.lang.String accessToken) {
        return (DeleteSignedUrlKey) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteSignedUrlKey setAlt(java.lang.String alt) {
        return (DeleteSignedUrlKey) super.setAlt(alt);
      }

      @Override
      public DeleteSignedUrlKey setCallback(java.lang.String callback) {
        return (DeleteSignedUrlKey) super.setCallback(callback);
      }

      @Override
      public DeleteSignedUrlKey setFields(java.lang.String fields) {
        return (DeleteSignedUrlKey) super.setFields(fields);
      }

      @Override
      public DeleteSignedUrlKey setKey(java.lang.String key) {
        return (DeleteSignedUrlKey) super.setKey(key);
      }

      @Override
      public DeleteSignedUrlKey setOauthToken(java.lang.String oauthToken) {
        return (DeleteSignedUrlKey) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteSignedUrlKey setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteSignedUrlKey) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteSignedUrlKey setQuotaUser(java.lang.String quotaUser) {
        return (DeleteSignedUrlKey) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteSignedUrlKey setUploadType(java.lang.String uploadType) {
        return (DeleteSignedUrlKey) super.setUploadType(uploadType);
      }

      @Override
      public DeleteSignedUrlKey setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteSignedUrlKey) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public DeleteSignedUrlKey setUserIp(java.lang.String userIp) {
        return (DeleteSignedUrlKey) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public DeleteSignedUrlKey setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the Signed URL Key should be added. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the Signed URL Key should be added. The name
       * should conform to RFC1035.
       */
      public DeleteSignedUrlKey setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /** The name of the Signed URL Key to delete. */
      @com.google.api.client.util.Key
      private java.lang.String keyName;

      /** The name of the Signed URL Key to delete.
       */
      public java.lang.String getKeyName() {
        return keyName;
      }

      /** The name of the Signed URL Key to delete. */
      public DeleteSignedUrlKey setKeyName(java.lang.String keyName) {
        this.keyName = keyName;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public DeleteSignedUrlKey setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public DeleteSignedUrlKey set(String parameterName, Object value) {
        return (DeleteSignedUrlKey) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified BackendService resource. Gets a list of available backend services.
     *
     * Create a request for the method "backendServices.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String backendService) throws java.io.IOException {
      Get result = new Get(project, backendService);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.BackendService> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified BackendService resource. Gets a list of available backend services.
       *
       * Create a request for the method "backendServices.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String backendService) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendService.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to return.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to return. */
      public Get setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the most recent health check results for this BackendService. Example request body: {
     * "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }
     *
     * Create a request for the method "backendServices.getHealth".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation.
     *
     * @param project
     * @param backendService Name of the BackendService resource to which the queried instance belongs.
     * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
     * @return the request
     */
    public GetHealth getHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) throws java.io.IOException {
      GetHealth result = new GetHealth(project, backendService, content);
      initialize(result);
      return result;
    }

    public class GetHealth extends ComputeRequest<com.google.api.services.compute.model.BackendServiceGroupHealth> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}/getHealth";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Gets the most recent health check results for this BackendService. Example request body: {
       * "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }
       *
       * Create a request for the method "backendServices.getHealth".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetHealth#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetHealth#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project
       * @param backendService Name of the BackendService resource to which the queried instance belongs.
       * @param content the {@link com.google.api.services.compute.model.ResourceGroupReference}
       * @since 1.13
       */
      protected GetHealth(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.ResourceGroupReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.BackendServiceGroupHealth.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public GetHealth set$Xgafv(java.lang.String $Xgafv) {
        return (GetHealth) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetHealth setAccessToken(java.lang.String accessToken) {
        return (GetHealth) super.setAccessToken(accessToken);
      }

      @Override
      public GetHealth setAlt(java.lang.String alt) {
        return (GetHealth) super.setAlt(alt);
      }

      @Override
      public GetHealth setCallback(java.lang.String callback) {
        return (GetHealth) super.setCallback(callback);
      }

      @Override
      public GetHealth setFields(java.lang.String fields) {
        return (GetHealth) super.setFields(fields);
      }

      @Override
      public GetHealth setKey(java.lang.String key) {
        return (GetHealth) super.setKey(key);
      }

      @Override
      public GetHealth setOauthToken(java.lang.String oauthToken) {
        return (GetHealth) super.setOauthToken(oauthToken);
      }

      @Override
      public GetHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetHealth) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetHealth setQuotaUser(java.lang.String quotaUser) {
        return (GetHealth) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetHealth setUploadType(java.lang.String uploadType) {
        return (GetHealth) super.setUploadType(uploadType);
      }

      @Override
      public GetHealth setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetHealth) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetHealth setUserIp(java.lang.String userIp) {
        return (GetHealth) super.setUserIp(userIp);
      }

      @com.google.api.client.util.Key
      private java.lang.String project;

      /**

       */
      public java.lang.String getProject() {
        return project;
      }

      public GetHealth setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the queried instance belongs.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to which the queried instance belongs. */
      public GetHealth setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendService = backendService;
        return this;
      }

      @Override
      public GetHealth set(String parameterName, Object value) {
        return (GetHealth) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * Create a request for the method "backendServices.getIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String project, java.lang.String resource) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(project, resource);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{resource}/getIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Gets the access control policy for a resource. May be empty if no such policy or resource
       * exists.
       *
       * Create a request for the method "backendServices.getIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String project, java.lang.String resource) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      /** Requested IAM Policy version. */
      @com.google.api.client.util.Key
      private java.lang.Integer optionsRequestedPolicyVersion;

      /** Requested IAM Policy version.
       */
      public java.lang.Integer getOptionsRequestedPolicyVersion() {
        return optionsRequestedPolicyVersion;
      }

      /** Requested IAM Policy version. */
      public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a BackendService resource in the specified project using the data included in the
     * request. For more information, see Backend services overview .
     *
     * Create a request for the method "backendServices.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a BackendService resource in the specified project using the data included in the
       * request. For more information, see Backend services overview .
       *
       * Create a request for the method "backendServices.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of BackendService resources available to the specified project.
     *
     * Create a request for the method "backendServices.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.BackendServiceList> {

      private static final String REST_PATH = "projects/{project}/global/backendServices";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of BackendService resources available to the specified project.
       *
       * Create a request for the method "backendServices.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.BackendServiceList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patches the specified BackendService resource with the data included in the request. For more
     * information, see Backend services overview. This method supports PATCH semantics and uses the
     * JSON merge patch format and processing rules.
     *
     * Create a request for the method "backendServices.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to patch.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Patch result = new Patch(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Patches the specified BackendService resource with the data included in the request. For more
       * information, see Backend services overview. This method supports PATCH semantics and uses the
       * JSON merge patch format and processing rules.
       *
       * Create a request for the method "backendServices.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to patch.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to patch. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to patch.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to patch. */
      public Patch setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the edge security policy for the specified backend service.
     *
     * Create a request for the method "backendServices.setEdgeSecurityPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetEdgeSecurityPolicy#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the edge security policy should be set. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
     * @return the request
     */
    public SetEdgeSecurityPolicy setEdgeSecurityPolicy(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SecurityPolicyReference content) throws java.io.IOException {
      SetEdgeSecurityPolicy result = new SetEdgeSecurityPolicy(project, backendService, content);
      initialize(result);
      return result;
    }

    public class SetEdgeSecurityPolicy extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}/setEdgeSecurityPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets the edge security policy for the specified backend service.
       *
       * Create a request for the method "backendServices.setEdgeSecurityPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetEdgeSecurityPolicy#execute()} method to invoke the remote
       * operation. <p> {@link SetEdgeSecurityPolicy#initialize(com.google.api.client.googleapis.service
       * s.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the edge security policy should be set. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
       * @since 1.13
       */
      protected SetEdgeSecurityPolicy(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SecurityPolicyReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
      }

      @Override
      public SetEdgeSecurityPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetEdgeSecurityPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetEdgeSecurityPolicy setAccessToken(java.lang.String accessToken) {
        return (SetEdgeSecurityPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetEdgeSecurityPolicy setAlt(java.lang.String alt) {
        return (SetEdgeSecurityPolicy) super.setAlt(alt);
      }

      @Override
      public SetEdgeSecurityPolicy setCallback(java.lang.String callback) {
        return (SetEdgeSecurityPolicy) super.setCallback(callback);
      }

      @Override
      public SetEdgeSecurityPolicy setFields(java.lang.String fields) {
        return (SetEdgeSecurityPolicy) super.setFields(fields);
      }

      @Override
      public SetEdgeSecurityPolicy setKey(java.lang.String key) {
        return (SetEdgeSecurityPolicy) super.setKey(key);
      }

      @Override
      public SetEdgeSecurityPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetEdgeSecurityPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetEdgeSecurityPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetEdgeSecurityPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetEdgeSecurityPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetEdgeSecurityPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetEdgeSecurityPolicy setUploadType(java.lang.String uploadType) {
        return (SetEdgeSecurityPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetEdgeSecurityPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetEdgeSecurityPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetEdgeSecurityPolicy setUserIp(java.lang.String userIp) {
        return (SetEdgeSecurityPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetEdgeSecurityPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the edge security policy should be set. The
       * name should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the edge security policy should be set. The name
     should conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the edge security policy should be set. The
       * name should conform to RFC1035.
       */
      public SetEdgeSecurityPolicy setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public SetEdgeSecurityPolicy setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetEdgeSecurityPolicy set(String parameterName, Object value) {
        return (SetEdgeSecurityPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * Create a request for the method "backendServices.setIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.GlobalSetPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(project, resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{resource}/setIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "backendServices.setIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.GlobalSetPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetPolicyRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Sets the Google Cloud Armor security policy for the specified backend service. For more
     * information, see Google Cloud Armor Overview
     *
     * Create a request for the method "backendServices.setSecurityPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetSecurityPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to which the security policy should be set. The name should
     *        conform to RFC1035.
     * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
     * @return the request
     */
    public SetSecurityPolicy setSecurityPolicy(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SecurityPolicyReference content) throws java.io.IOException {
      SetSecurityPolicy result = new SetSecurityPolicy(project, backendService, content);
      initialize(result);
      return result;
    }

    public class SetSecurityPolicy extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}/setSecurityPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Sets the Google Cloud Armor security policy for the specified backend service. For more
       * information, see Google Cloud Armor Overview
       *
       * Create a request for the method "backendServices.setSecurityPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetSecurityPolicy#execute()} method to invoke the remote operation.
       * <p> {@link SetSecurityPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to which the security policy should be set. The name should
     *        conform to RFC1035.
       * @param content the {@link com.google.api.services.compute.model.SecurityPolicyReference}
       * @since 1.13
       */
      protected SetSecurityPolicy(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.SecurityPolicyReference content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
      }

      @Override
      public SetSecurityPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetSecurityPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetSecurityPolicy setAccessToken(java.lang.String accessToken) {
        return (SetSecurityPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetSecurityPolicy setAlt(java.lang.String alt) {
        return (SetSecurityPolicy) super.setAlt(alt);
      }

      @Override
      public SetSecurityPolicy setCallback(java.lang.String callback) {
        return (SetSecurityPolicy) super.setCallback(callback);
      }

      @Override
      public SetSecurityPolicy setFields(java.lang.String fields) {
        return (SetSecurityPolicy) super.setFields(fields);
      }

      @Override
      public SetSecurityPolicy setKey(java.lang.String key) {
        return (SetSecurityPolicy) super.setKey(key);
      }

      @Override
      public SetSecurityPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetSecurityPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetSecurityPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetSecurityPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetSecurityPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetSecurityPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetSecurityPolicy setUploadType(java.lang.String uploadType) {
        return (SetSecurityPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetSecurityPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetSecurityPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetSecurityPolicy setUserIp(java.lang.String userIp) {
        return (SetSecurityPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetSecurityPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * Name of the BackendService resource to which the security policy should be set. The name
       * should conform to RFC1035.
       */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to which the security policy should be set. The name should
     conform to RFC1035.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /**
       * Name of the BackendService resource to which the security policy should be set. The name
       * should conform to RFC1035.
       */
      public SetSecurityPolicy setBackendService(java.lang.String backendService) {
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public SetSecurityPolicy setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetSecurityPolicy set(String parameterName, Object value) {
        return (SetSecurityPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "backendServices.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "backendServices.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified BackendService resource with the data included in the request. For more
     * information, see Backend services overview.
     *
     * Create a request for the method "backendServices.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param backendService Name of the BackendService resource to update.
     * @param content the {@link com.google.api.services.compute.model.BackendService}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) throws java.io.IOException {
      Update result = new Update(project, backendService, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/backendServices/{backendService}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern BACKEND_SERVICE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified BackendService resource with the data included in the request. For more
       * information, see Backend services overview.
       *
       * Create a request for the method "backendServices.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param backendService Name of the BackendService resource to update.
       * @param content the {@link com.google.api.services.compute.model.BackendService}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String backendService, com.google.api.services.compute.model.BackendService content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.backendService = com.google.api.client.util.Preconditions.checkNotNull(backendService, "Required parameter backendService must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the BackendService resource to update. */
      @com.google.api.client.util.Key
      private java.lang.String backendService;

      /** Name of the BackendService resource to update.
       */
      public java.lang.String getBackendService() {
        return backendService;
      }

      /** Name of the BackendService resource to update. */
      public Update setBackendService(java.lang.String backendService) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(BACKEND_SERVICE_PATTERN.matcher(backendService).matches(),
              "Parameter backendService must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.backendService = backendService;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the DiskTypes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.DiskTypes.List request = compute.diskTypes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public DiskTypes diskTypes() {
    return new DiskTypes();
  }

  /**
   * The "diskTypes" collection of methods.
   */
  public class DiskTypes {

    /**
     * Retrieves an aggregated list of disk types.
     *
     * Create a request for the method "diskTypes.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskTypeAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of disk types.
       *
       * Create a request for the method "diskTypes.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified disk type. Gets a list of available disk types by making a list() request.
     *
     * Create a request for the method "diskTypes.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param diskType Name of the disk type to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String diskType) throws java.io.IOException {
      Get result = new Get(project, zone, diskType);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.DiskType> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/diskTypes/{diskType}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_TYPE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified disk type. Gets a list of available disk types by making a list()
       * request.
       *
       * Create a request for the method "diskTypes.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param diskType Name of the disk type to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String diskType) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskType.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.diskType = com.google.api.client.util.Preconditions.checkNotNull(diskType, "Required parameter diskType must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the disk type to return. */
      @com.google.api.client.util.Key
      private java.lang.String diskType;

      /** Name of the disk type to return.
       */
      public java.lang.String getDiskType() {
        return diskType;
      }

      /** Name of the disk type to return. */
      public Get setDiskType(java.lang.String diskType) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_TYPE_PATTERN.matcher(diskType).matches(),
              "Parameter diskType must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.diskType = diskType;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of disk types available to the specified project.
     *
     * Create a request for the method "diskTypes.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskTypeList> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/diskTypes";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of disk types available to the specified project.
       *
       * Create a request for the method "diskTypes.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskTypeList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Disks collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Disks.List request = compute.disks().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Disks disks() {
    return new Disks();
  }

  /**
   * The "disks" collection of methods.
   */
  public class Disks {

    /**
     * Adds existing resource policies to a disk. You can only add one policy which will be applied to
     * this disk for scheduling snapshot creation.
     *
     * Create a request for the method "disks.addResourcePolicies".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddResourcePolicies#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The disk name for this request.
     * @param content the {@link com.google.api.services.compute.model.DisksAddResourcePoliciesRequest}
     * @return the request
     */
    public AddResourcePolicies addResourcePolicies(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksAddResourcePoliciesRequest content) throws java.io.IOException {
      AddResourcePolicies result = new AddResourcePolicies(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class AddResourcePolicies extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}/addResourcePolicies";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Adds existing resource policies to a disk. You can only add one policy which will be applied to
       * this disk for scheduling snapshot creation.
       *
       * Create a request for the method "disks.addResourcePolicies".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddResourcePolicies#execute()} method to invoke the remote
       * operation. <p> {@link AddResourcePolicies#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The disk name for this request.
       * @param content the {@link com.google.api.services.compute.model.DisksAddResourcePoliciesRequest}
       * @since 1.13
       */
      protected AddResourcePolicies(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksAddResourcePoliciesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public AddResourcePolicies set$Xgafv(java.lang.String $Xgafv) {
        return (AddResourcePolicies) super.set$Xgafv($Xgafv);
      }

      @Override
      public AddResourcePolicies setAccessToken(java.lang.String accessToken) {
        return (AddResourcePolicies) super.setAccessToken(accessToken);
      }

      @Override
      public AddResourcePolicies setAlt(java.lang.String alt) {
        return (AddResourcePolicies) super.setAlt(alt);
      }

      @Override
      public AddResourcePolicies setCallback(java.lang.String callback) {
        return (AddResourcePolicies) super.setCallback(callback);
      }

      @Override
      public AddResourcePolicies setFields(java.lang.String fields) {
        return (AddResourcePolicies) super.setFields(fields);
      }

      @Override
      public AddResourcePolicies setKey(java.lang.String key) {
        return (AddResourcePolicies) super.setKey(key);
      }

      @Override
      public AddResourcePolicies setOauthToken(java.lang.String oauthToken) {
        return (AddResourcePolicies) super.setOauthToken(oauthToken);
      }

      @Override
      public AddResourcePolicies setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddResourcePolicies) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddResourcePolicies setQuotaUser(java.lang.String quotaUser) {
        return (AddResourcePolicies) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddResourcePolicies setUploadType(java.lang.String uploadType) {
        return (AddResourcePolicies) super.setUploadType(uploadType);
      }

      @Override
      public AddResourcePolicies setUploadProtocol(java.lang.String uploadProtocol) {
        return (AddResourcePolicies) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AddResourcePolicies setUserIp(java.lang.String userIp) {
        return (AddResourcePolicies) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AddResourcePolicies setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public AddResourcePolicies setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The disk name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The disk name for this request.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The disk name for this request. */
      public AddResourcePolicies setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public AddResourcePolicies setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddResourcePolicies set(String parameterName, Object value) {
        return (AddResourcePolicies) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves an aggregated list of persistent disks.
     *
     * Create a request for the method "disks.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.DiskAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of persistent disks.
       *
       * Create a request for the method "disks.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using
     * snapshots.insert instead, as that method supports more features, such as creating snapshots in a
     * project different from the source disk project.
     *
     * Create a request for the method "disks.createSnapshot".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to snapshot.
     * @param content the {@link com.google.api.services.compute.model.Snapshot}
     * @return the request
     */
    public CreateSnapshot createSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) throws java.io.IOException {
      CreateSnapshot result = new CreateSnapshot(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class CreateSnapshot extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}/createSnapshot";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider
       * using snapshots.insert instead, as that method supports more features, such as creating
       * snapshots in a project different from the source disk project.
       *
       * Create a request for the method "disks.createSnapshot".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CreateSnapshot#execute()} method to invoke the remote operation.
       * <p> {@link CreateSnapshot#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to snapshot.
       * @param content the {@link com.google.api.services.compute.model.Snapshot}
       * @since 1.13
       */
      protected CreateSnapshot(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Snapshot content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public CreateSnapshot set$Xgafv(java.lang.String $Xgafv) {
        return (CreateSnapshot) super.set$Xgafv($Xgafv);
      }

      @Override
      public CreateSnapshot setAccessToken(java.lang.String accessToken) {
        return (CreateSnapshot) super.setAccessToken(accessToken);
      }

      @Override
      public CreateSnapshot setAlt(java.lang.String alt) {
        return (CreateSnapshot) super.setAlt(alt);
      }

      @Override
      public CreateSnapshot setCallback(java.lang.String callback) {
        return (CreateSnapshot) super.setCallback(callback);
      }

      @Override
      public CreateSnapshot setFields(java.lang.String fields) {
        return (CreateSnapshot) super.setFields(fields);
      }

      @Override
      public CreateSnapshot setKey(java.lang.String key) {
        return (CreateSnapshot) super.setKey(key);
      }

      @Override
      public CreateSnapshot setOauthToken(java.lang.String oauthToken) {
        return (CreateSnapshot) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateSnapshot setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateSnapshot) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateSnapshot setQuotaUser(java.lang.String quotaUser) {
        return (CreateSnapshot) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateSnapshot setUploadType(java.lang.String uploadType) {
        return (CreateSnapshot) super.setUploadType(uploadType);
      }

      @Override
      public CreateSnapshot setUploadProtocol(java.lang.String uploadProtocol) {
        return (CreateSnapshot) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public CreateSnapshot setUserIp(java.lang.String userIp) {
        return (CreateSnapshot) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public CreateSnapshot setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public CreateSnapshot setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to snapshot. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to snapshot.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to snapshot. */
      public CreateSnapshot setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      /**
       * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to
       * prepare for the snapshot process.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean guestFlush;

      /**[ Input Only] Whether to attempt an application consistent snapshot by informing the OS to prepare
    [ for the snapshot process.
    [

       */
      public java.lang.Boolean getGuestFlush() {
        return guestFlush;
      }

      /**
       * [Input Only] Whether to attempt an application consistent snapshot by informing the OS to
       * prepare for the snapshot process.
       */
      public CreateSnapshot setGuestFlush(java.lang.Boolean guestFlush) {
        this.guestFlush = guestFlush;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public CreateSnapshot setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public CreateSnapshot set(String parameterName, Object value) {
        return (CreateSnapshot) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
     * irreversible. However, deleting a disk does not delete any snapshots previously made from the
     * disk. You must separately delete snapshots.
     *
     * Create a request for the method "disks.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Delete result = new Delete(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified persistent disk. Deleting a disk removes its data permanently and is
       * irreversible. However, deleting a disk does not delete any snapshots previously made from the
       * disk. You must separately delete snapshots.
       *
       * Create a request for the method "disks.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Delete setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to delete. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to delete.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to delete. */
      public Delete setDisk(java.lang.String disk) {
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns a specified persistent disk. Gets a list of available persistent disks by making a list()
     * request.
     *
     * Create a request for the method "disks.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk Name of the persistent disk to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String zone, java.lang.String disk) throws java.io.IOException {
      Get result = new Get(project, zone, disk);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Disk> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns a specified persistent disk. Gets a list of available persistent disks by making a
       * list() request.
       *
       * Create a request for the method "disks.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk Name of the persistent disk to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String zone, java.lang.String disk) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Disk.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Get setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name of the persistent disk to return. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** Name of the persistent disk to return.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** Name of the persistent disk to return. */
      public Get setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * Create a request for the method "disks.getIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name or id of the resource for this request.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String project, java.lang.String zone, java.lang.String resource) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(project, zone, resource);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Gets the access control policy for a resource. May be empty if no such policy or resource
       * exists.
       *
       * Create a request for the method "disks.getIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name or id of the resource for this request.
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String project, java.lang.String zone, java.lang.String resource) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public GetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public GetIamPolicy setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      /** Requested IAM Policy version. */
      @com.google.api.client.util.Key
      private java.lang.Integer optionsRequestedPolicyVersion;

      /** Requested IAM Policy version.
       */
      public java.lang.Integer getOptionsRequestedPolicyVersion() {
        return optionsRequestedPolicyVersion;
      }

      /** Requested IAM Policy version. */
      public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a persistent disk in the specified project using the data in the request. You can create
     * a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500 GB data
     * disk by omitting all properties. You can also create a disk that is larger than the default size
     * by specifying the sizeGb property.
     *
     * Create a request for the method "disks.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Insert result = new Insert(project, zone, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a persistent disk in the specified project using the data in the request. You can
       * create a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500
       * GB data disk by omitting all properties. You can also create a disk that is larger than the
       * default size by specifying the sizeGb property.
       *
       * Create a request for the method "disks.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String zone, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Insert setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /** Source image to restore onto a disk. This field is optional. */
      @com.google.api.client.util.Key
      private java.lang.String sourceImage;

      /** Source image to restore onto a disk. This field is optional.
       */
      public java.lang.String getSourceImage() {
        return sourceImage;
      }

      /** Source image to restore onto a disk. This field is optional. */
      public Insert setSourceImage(java.lang.String sourceImage) {
        this.sourceImage = sourceImage;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of persistent disks contained within the specified zone.
     *
     * Create a request for the method "disks.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String zone) throws java.io.IOException {
      List result = new List(project, zone);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.DiskList> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of persistent disks contained within the specified zone.
       *
       * Create a request for the method "disks.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String zone) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.DiskList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public List setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Removes resource policies from a disk.
     *
     * Create a request for the method "disks.removeResourcePolicies".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveResourcePolicies#execute()} method to invoke the remote
     * operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The disk name for this request.
     * @param content the {@link com.google.api.services.compute.model.DisksRemoveResourcePoliciesRequest}
     * @return the request
     */
    public RemoveResourcePolicies removeResourcePolicies(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksRemoveResourcePoliciesRequest content) throws java.io.IOException {
      RemoveResourcePolicies result = new RemoveResourcePolicies(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class RemoveResourcePolicies extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}/removeResourcePolicies";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Removes resource policies from a disk.
       *
       * Create a request for the method "disks.removeResourcePolicies".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveResourcePolicies#execute()} method to invoke the remote
       * operation. <p> {@link RemoveResourcePolicies#initialize(com.google.api.client.googleapis.servic
       * es.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The disk name for this request.
       * @param content the {@link com.google.api.services.compute.model.DisksRemoveResourcePoliciesRequest}
       * @since 1.13
       */
      protected RemoveResourcePolicies(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksRemoveResourcePoliciesRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public RemoveResourcePolicies set$Xgafv(java.lang.String $Xgafv) {
        return (RemoveResourcePolicies) super.set$Xgafv($Xgafv);
      }

      @Override
      public RemoveResourcePolicies setAccessToken(java.lang.String accessToken) {
        return (RemoveResourcePolicies) super.setAccessToken(accessToken);
      }

      @Override
      public RemoveResourcePolicies setAlt(java.lang.String alt) {
        return (RemoveResourcePolicies) super.setAlt(alt);
      }

      @Override
      public RemoveResourcePolicies setCallback(java.lang.String callback) {
        return (RemoveResourcePolicies) super.setCallback(callback);
      }

      @Override
      public RemoveResourcePolicies setFields(java.lang.String fields) {
        return (RemoveResourcePolicies) super.setFields(fields);
      }

      @Override
      public RemoveResourcePolicies setKey(java.lang.String key) {
        return (RemoveResourcePolicies) super.setKey(key);
      }

      @Override
      public RemoveResourcePolicies setOauthToken(java.lang.String oauthToken) {
        return (RemoveResourcePolicies) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveResourcePolicies setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveResourcePolicies) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveResourcePolicies setQuotaUser(java.lang.String quotaUser) {
        return (RemoveResourcePolicies) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveResourcePolicies setUploadType(java.lang.String uploadType) {
        return (RemoveResourcePolicies) super.setUploadType(uploadType);
      }

      @Override
      public RemoveResourcePolicies setUploadProtocol(java.lang.String uploadProtocol) {
        return (RemoveResourcePolicies) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public RemoveResourcePolicies setUserIp(java.lang.String userIp) {
        return (RemoveResourcePolicies) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public RemoveResourcePolicies setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public RemoveResourcePolicies setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The disk name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The disk name for this request.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The disk name for this request. */
      public RemoveResourcePolicies setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public RemoveResourcePolicies setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public RemoveResourcePolicies set(String parameterName, Object value) {
        return (RemoveResourcePolicies) super.set(parameterName, value);
      }
    }
    /**
     * Resizes the specified persistent disk. You can only increase the size of the disk.
     *
     * Create a request for the method "disks.resize".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Resize#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The name of the persistent disk.
     * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
     * @return the request
     */
    public Resize resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) throws java.io.IOException {
      Resize result = new Resize(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class Resize extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}/resize";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Resizes the specified persistent disk. You can only increase the size of the disk.
       *
       * Create a request for the method "disks.resize".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Resize#execute()} method to invoke the remote operation. <p> {@link
       * Resize#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The name of the persistent disk.
       * @param content the {@link com.google.api.services.compute.model.DisksResizeRequest}
       * @since 1.13
       */
      protected Resize(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.DisksResizeRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Resize set$Xgafv(java.lang.String $Xgafv) {
        return (Resize) super.set$Xgafv($Xgafv);
      }

      @Override
      public Resize setAccessToken(java.lang.String accessToken) {
        return (Resize) super.setAccessToken(accessToken);
      }

      @Override
      public Resize setAlt(java.lang.String alt) {
        return (Resize) super.setAlt(alt);
      }

      @Override
      public Resize setCallback(java.lang.String callback) {
        return (Resize) super.setCallback(callback);
      }

      @Override
      public Resize setFields(java.lang.String fields) {
        return (Resize) super.setFields(fields);
      }

      @Override
      public Resize setKey(java.lang.String key) {
        return (Resize) super.setKey(key);
      }

      @Override
      public Resize setOauthToken(java.lang.String oauthToken) {
        return (Resize) super.setOauthToken(oauthToken);
      }

      @Override
      public Resize setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Resize) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Resize setQuotaUser(java.lang.String quotaUser) {
        return (Resize) super.setQuotaUser(quotaUser);
      }

      @Override
      public Resize setUploadType(java.lang.String uploadType) {
        return (Resize) super.setUploadType(uploadType);
      }

      @Override
      public Resize setUploadProtocol(java.lang.String uploadProtocol) {
        return (Resize) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Resize setUserIp(java.lang.String userIp) {
        return (Resize) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Resize setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Resize setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The name of the persistent disk. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The name of the persistent disk.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The name of the persistent disk. */
      public Resize setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Resize setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Resize set(String parameterName, Object value) {
        return (Resize) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * Create a request for the method "disks.setIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.ZoneSetPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(project, zone, resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "disks.setIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.ZoneSetPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetPolicyRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Policy.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetIamPolicy setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetIamPolicy setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.
     *
     * Create a request for the method "disks.setLabels".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.ZoneSetLabelsRequest}
     * @return the request
     */
    public SetLabels setLabels(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetLabelsRequest content) throws java.io.IOException {
      SetLabels result = new SetLabels(project, zone, resource, content);
      initialize(result);
      return result;
    }

    public class SetLabels extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{resource}/setLabels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the labels on a disk. To learn more about labels, read the Labeling Resources
       * documentation.
       *
       * Create a request for the method "disks.setLabels".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.ZoneSetLabelsRequest}
       * @since 1.13
       */
      protected SetLabels(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.ZoneSetLabelsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetLabels set$Xgafv(java.lang.String $Xgafv) {
        return (SetLabels) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetLabels setAccessToken(java.lang.String accessToken) {
        return (SetLabels) super.setAccessToken(accessToken);
      }

      @Override
      public SetLabels setAlt(java.lang.String alt) {
        return (SetLabels) super.setAlt(alt);
      }

      @Override
      public SetLabels setCallback(java.lang.String callback) {
        return (SetLabels) super.setCallback(callback);
      }

      @Override
      public SetLabels setFields(java.lang.String fields) {
        return (SetLabels) super.setFields(fields);
      }

      @Override
      public SetLabels setKey(java.lang.String key) {
        return (SetLabels) super.setKey(key);
      }

      @Override
      public SetLabels setOauthToken(java.lang.String oauthToken) {
        return (SetLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetLabels setQuotaUser(java.lang.String quotaUser) {
        return (SetLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetLabels setUploadType(java.lang.String uploadType) {
        return (SetLabels) super.setUploadType(uploadType);
      }

      @Override
      public SetLabels setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetLabels) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetLabels setUserIp(java.lang.String userIp) {
        return (SetLabels) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetLabels setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public SetLabels setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetLabels setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public SetLabels setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public SetLabels set(String parameterName, Object value) {
        return (SetLabels) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "disks.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, zone, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "disks.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String zone, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public TestIamPermissions setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified disk with the data included in the request. The update is performed only on
     * selected fields included as part of update-mask. Only the following fields can be modified:
     * user_license.
     *
     * Create a request for the method "disks.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param zone The name of the zone for this request.
     * @param disk The disk name for this request.
     * @param content the {@link com.google.api.services.compute.model.Disk}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Disk content) throws java.io.IOException {
      Update result = new Update(project, zone, disk, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/zones/{zone}/disks/{disk}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern ZONE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern DISK_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified disk with the data included in the request. The update is performed only
       * on selected fields included as part of update-mask. Only the following fields can be modified:
       * user_license.
       *
       * Create a request for the method "disks.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param zone The name of the zone for this request.
       * @param disk The disk name for this request.
       * @param content the {@link com.google.api.services.compute.model.Disk}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String zone, java.lang.String disk, com.google.api.services.compute.model.Disk content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.zone = com.google.api.client.util.Preconditions.checkNotNull(zone, "Required parameter zone must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.disk = com.google.api.client.util.Preconditions.checkNotNull(disk, "Required parameter disk must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** The name of the zone for this request. */
      @com.google.api.client.util.Key
      private java.lang.String zone;

      /** The name of the zone for this request.
       */
      public java.lang.String getZone() {
        return zone;
      }

      /** The name of the zone for this request. */
      public Update setZone(java.lang.String zone) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ZONE_PATTERN.matcher(zone).matches(),
              "Parameter zone must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.zone = zone;
        return this;
      }

      /** The disk name for this request. */
      @com.google.api.client.util.Key
      private java.lang.String disk;

      /** The disk name for this request.
       */
      public java.lang.String getDisk() {
        return disk;
      }

      /** The disk name for this request. */
      public Update setDisk(java.lang.String disk) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DISK_PATTERN.matcher(disk).matches(),
              "Parameter disk must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.disk = disk;
        return this;
      }

      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> paths;

      /**

       */
      public java.util.List<java.lang.String> getPaths() {
        return paths;
      }

      public Update setPaths(java.util.List<java.lang.String> paths) {
        this.paths = paths;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /** update_mask indicates fields to be updated as part of this request. */
      @com.google.api.client.util.Key
      private String updateMask;

      /** update_mask indicates fields to be updated as part of this request.
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /** update_mask indicates fields to be updated as part of this request. */
      public Update setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ExternalVpnGateways collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ExternalVpnGateways.List request = compute.externalVpnGateways().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ExternalVpnGateways externalVpnGateways() {
    return new ExternalVpnGateways();
  }

  /**
   * The "externalVpnGateways" collection of methods.
   */
  public class ExternalVpnGateways {

    /**
     * Deletes the specified externalVpnGateway.
     *
     * Create a request for the method "externalVpnGateways.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param externalVpnGateway Name of the externalVpnGateways to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String externalVpnGateway) throws java.io.IOException {
      Delete result = new Delete(project, externalVpnGateway);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways/{externalVpnGateway}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern EXTERNAL_VPN_GATEWAY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Deletes the specified externalVpnGateway.
       *
       * Create a request for the method "externalVpnGateways.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param externalVpnGateway Name of the externalVpnGateways to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String externalVpnGateway) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.externalVpnGateway = com.google.api.client.util.Preconditions.checkNotNull(externalVpnGateway, "Required parameter externalVpnGateway must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(EXTERNAL_VPN_GATEWAY_PATTERN.matcher(externalVpnGateway).matches(),
              "Parameter externalVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the externalVpnGateways to delete. */
      @com.google.api.client.util.Key
      private java.lang.String externalVpnGateway;

      /** Name of the externalVpnGateways to delete.
       */
      public java.lang.String getExternalVpnGateway() {
        return externalVpnGateway;
      }

      /** Name of the externalVpnGateways to delete. */
      public Delete setExternalVpnGateway(java.lang.String externalVpnGateway) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(EXTERNAL_VPN_GATEWAY_PATTERN.matcher(externalVpnGateway).matches(),
              "Parameter externalVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.externalVpnGateway = externalVpnGateway;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a
     * list() request.
     *
     * Create a request for the method "externalVpnGateways.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param externalVpnGateway Name of the externalVpnGateway to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String externalVpnGateway) throws java.io.IOException {
      Get result = new Get(project, externalVpnGateway);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ExternalVpnGateway> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways/{externalVpnGateway}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern EXTERNAL_VPN_GATEWAY_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making
       * a list() request.
       *
       * Create a request for the method "externalVpnGateways.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param externalVpnGateway Name of the externalVpnGateway to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String externalVpnGateway) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ExternalVpnGateway.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.externalVpnGateway = com.google.api.client.util.Preconditions.checkNotNull(externalVpnGateway, "Required parameter externalVpnGateway must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(EXTERNAL_VPN_GATEWAY_PATTERN.matcher(externalVpnGateway).matches(),
              "Parameter externalVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the externalVpnGateway to return. */
      @com.google.api.client.util.Key
      private java.lang.String externalVpnGateway;

      /** Name of the externalVpnGateway to return.
       */
      public java.lang.String getExternalVpnGateway() {
        return externalVpnGateway;
      }

      /** Name of the externalVpnGateway to return. */
      public Get setExternalVpnGateway(java.lang.String externalVpnGateway) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(EXTERNAL_VPN_GATEWAY_PATTERN.matcher(externalVpnGateway).matches(),
              "Parameter externalVpnGateway must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.externalVpnGateway = externalVpnGateway;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ExternalVpnGateway in the specified project using the data included in the request.
     *
     * Create a request for the method "externalVpnGateways.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.ExternalVpnGateway}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.ExternalVpnGateway content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a ExternalVpnGateway in the specified project using the data included in the request.
       *
       * Create a request for the method "externalVpnGateways.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.ExternalVpnGateway}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.ExternalVpnGateway content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of ExternalVpnGateway available to the specified project.
     *
     * Create a request for the method "externalVpnGateways.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ExternalVpnGatewayList> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of ExternalVpnGateway available to the specified project.
       *
       * Create a request for the method "externalVpnGateways.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ExternalVpnGatewayList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources
     * documentation.
     *
     * Create a request for the method "externalVpnGateways.setLabels".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.GlobalSetLabelsRequest}
     * @return the request
     */
    public SetLabels setLabels(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetLabelsRequest content) throws java.io.IOException {
      SetLabels result = new SetLabels(project, resource, content);
      initialize(result);
      return result;
    }

    public class SetLabels extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways/{resource}/setLabels";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling
       * Resources documentation.
       *
       * Create a request for the method "externalVpnGateways.setLabels".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.GlobalSetLabelsRequest}
       * @since 1.13
       */
      protected SetLabels(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.GlobalSetLabelsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public SetLabels set$Xgafv(java.lang.String $Xgafv) {
        return (SetLabels) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetLabels setAccessToken(java.lang.String accessToken) {
        return (SetLabels) super.setAccessToken(accessToken);
      }

      @Override
      public SetLabels setAlt(java.lang.String alt) {
        return (SetLabels) super.setAlt(alt);
      }

      @Override
      public SetLabels setCallback(java.lang.String callback) {
        return (SetLabels) super.setCallback(callback);
      }

      @Override
      public SetLabels setFields(java.lang.String fields) {
        return (SetLabels) super.setFields(fields);
      }

      @Override
      public SetLabels setKey(java.lang.String key) {
        return (SetLabels) super.setKey(key);
      }

      @Override
      public SetLabels setOauthToken(java.lang.String oauthToken) {
        return (SetLabels) super.setOauthToken(oauthToken);
      }

      @Override
      public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetLabels) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetLabels setQuotaUser(java.lang.String quotaUser) {
        return (SetLabels) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetLabels setUploadType(java.lang.String uploadType) {
        return (SetLabels) super.setUploadType(uploadType);
      }

      @Override
      public SetLabels setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetLabels) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetLabels setUserIp(java.lang.String userIp) {
        return (SetLabels) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public SetLabels setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetLabels setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetLabels set(String parameterName, Object value) {
        return (SetLabels) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "externalVpnGateways.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/global/externalVpnGateways/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "externalVpnGateways.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the FirewallPolicies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.FirewallPolicies.List request = compute.firewallPolicies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public FirewallPolicies firewallPolicies() {
    return new FirewallPolicies();
  }

  /**
   * The "firewallPolicies" collection of methods.
   */
  public class FirewallPolicies {

    /**
     * Inserts an association for the specified firewall policy.
     *
     * Create a request for the method "firewallPolicies.addAssociation".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddAssociation#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @param content the {@link com.google.api.services.compute.model.FirewallPolicyAssociation}
     * @return the request
     */
    public AddAssociation addAssociation(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyAssociation content) throws java.io.IOException {
      AddAssociation result = new AddAssociation(firewallPolicy, content);
      initialize(result);
      return result;
    }

    public class AddAssociation extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/addAssociation";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Inserts an association for the specified firewall policy.
       *
       * Create a request for the method "firewallPolicies.addAssociation".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddAssociation#execute()} method to invoke the remote operation.
       * <p> {@link AddAssociation#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @param content the {@link com.google.api.services.compute.model.FirewallPolicyAssociation}
       * @since 1.13
       */
      protected AddAssociation(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyAssociation content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public AddAssociation set$Xgafv(java.lang.String $Xgafv) {
        return (AddAssociation) super.set$Xgafv($Xgafv);
      }

      @Override
      public AddAssociation setAccessToken(java.lang.String accessToken) {
        return (AddAssociation) super.setAccessToken(accessToken);
      }

      @Override
      public AddAssociation setAlt(java.lang.String alt) {
        return (AddAssociation) super.setAlt(alt);
      }

      @Override
      public AddAssociation setCallback(java.lang.String callback) {
        return (AddAssociation) super.setCallback(callback);
      }

      @Override
      public AddAssociation setFields(java.lang.String fields) {
        return (AddAssociation) super.setFields(fields);
      }

      @Override
      public AddAssociation setKey(java.lang.String key) {
        return (AddAssociation) super.setKey(key);
      }

      @Override
      public AddAssociation setOauthToken(java.lang.String oauthToken) {
        return (AddAssociation) super.setOauthToken(oauthToken);
      }

      @Override
      public AddAssociation setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddAssociation) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddAssociation setQuotaUser(java.lang.String quotaUser) {
        return (AddAssociation) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddAssociation setUploadType(java.lang.String uploadType) {
        return (AddAssociation) super.setUploadType(uploadType);
      }

      @Override
      public AddAssociation setUploadProtocol(java.lang.String uploadProtocol) {
        return (AddAssociation) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AddAssociation setUserIp(java.lang.String userIp) {
        return (AddAssociation) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public AddAssociation setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /**
       * Indicates whether or not to replace it if an association of the attachment already exists.
       * This is false by default, in which case an error will be returned if an association already
       * exists.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean replaceExistingAssociation;

      /** Indicates whether or not to replace it if an association of the attachment already exists. This is
     false by default, in which case an error will be returned if an association already exists.
       */
      public java.lang.Boolean getReplaceExistingAssociation() {
        return replaceExistingAssociation;
      }

      /**
       * Indicates whether or not to replace it if an association of the attachment already exists.
       * This is false by default, in which case an error will be returned if an association already
       * exists.
       */
      public AddAssociation setReplaceExistingAssociation(java.lang.Boolean replaceExistingAssociation) {
        this.replaceExistingAssociation = replaceExistingAssociation;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public AddAssociation setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddAssociation set(String parameterName, Object value) {
        return (AddAssociation) super.set(parameterName, value);
      }
    }
    /**
     * Inserts a rule into a firewall policy.
     *
     * Create a request for the method "firewallPolicies.addRule".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AddRule#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @param content the {@link com.google.api.services.compute.model.FirewallPolicyRule}
     * @return the request
     */
    public AddRule addRule(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyRule content) throws java.io.IOException {
      AddRule result = new AddRule(firewallPolicy, content);
      initialize(result);
      return result;
    }

    public class AddRule extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/addRule";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Inserts a rule into a firewall policy.
       *
       * Create a request for the method "firewallPolicies.addRule".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AddRule#execute()} method to invoke the remote operation. <p>
       * {@link
       * AddRule#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @param content the {@link com.google.api.services.compute.model.FirewallPolicyRule}
       * @since 1.13
       */
      protected AddRule(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public AddRule set$Xgafv(java.lang.String $Xgafv) {
        return (AddRule) super.set$Xgafv($Xgafv);
      }

      @Override
      public AddRule setAccessToken(java.lang.String accessToken) {
        return (AddRule) super.setAccessToken(accessToken);
      }

      @Override
      public AddRule setAlt(java.lang.String alt) {
        return (AddRule) super.setAlt(alt);
      }

      @Override
      public AddRule setCallback(java.lang.String callback) {
        return (AddRule) super.setCallback(callback);
      }

      @Override
      public AddRule setFields(java.lang.String fields) {
        return (AddRule) super.setFields(fields);
      }

      @Override
      public AddRule setKey(java.lang.String key) {
        return (AddRule) super.setKey(key);
      }

      @Override
      public AddRule setOauthToken(java.lang.String oauthToken) {
        return (AddRule) super.setOauthToken(oauthToken);
      }

      @Override
      public AddRule setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AddRule) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AddRule setQuotaUser(java.lang.String quotaUser) {
        return (AddRule) super.setQuotaUser(quotaUser);
      }

      @Override
      public AddRule setUploadType(java.lang.String uploadType) {
        return (AddRule) super.setUploadType(uploadType);
      }

      @Override
      public AddRule setUploadProtocol(java.lang.String uploadProtocol) {
        return (AddRule) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AddRule setUserIp(java.lang.String userIp) {
        return (AddRule) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public AddRule setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public AddRule setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public AddRule set(String parameterName, Object value) {
        return (AddRule) super.set(parameterName, value);
      }
    }
    /**
     * Copies rules to the specified firewall policy.
     *
     * Create a request for the method "firewallPolicies.cloneRules".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link CloneRules#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @return the request
     */
    public CloneRules cloneRules(java.lang.String firewallPolicy) throws java.io.IOException {
      CloneRules result = new CloneRules(firewallPolicy);
      initialize(result);
      return result;
    }

    public class CloneRules extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/cloneRules";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Copies rules to the specified firewall policy.
       *
       * Create a request for the method "firewallPolicies.cloneRules".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link CloneRules#execute()} method to invoke the remote operation. <p>
       * {@link
       * CloneRules#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @since 1.13
       */
      protected CloneRules(java.lang.String firewallPolicy) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public CloneRules set$Xgafv(java.lang.String $Xgafv) {
        return (CloneRules) super.set$Xgafv($Xgafv);
      }

      @Override
      public CloneRules setAccessToken(java.lang.String accessToken) {
        return (CloneRules) super.setAccessToken(accessToken);
      }

      @Override
      public CloneRules setAlt(java.lang.String alt) {
        return (CloneRules) super.setAlt(alt);
      }

      @Override
      public CloneRules setCallback(java.lang.String callback) {
        return (CloneRules) super.setCallback(callback);
      }

      @Override
      public CloneRules setFields(java.lang.String fields) {
        return (CloneRules) super.setFields(fields);
      }

      @Override
      public CloneRules setKey(java.lang.String key) {
        return (CloneRules) super.setKey(key);
      }

      @Override
      public CloneRules setOauthToken(java.lang.String oauthToken) {
        return (CloneRules) super.setOauthToken(oauthToken);
      }

      @Override
      public CloneRules setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CloneRules) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CloneRules setQuotaUser(java.lang.String quotaUser) {
        return (CloneRules) super.setQuotaUser(quotaUser);
      }

      @Override
      public CloneRules setUploadType(java.lang.String uploadType) {
        return (CloneRules) super.setUploadType(uploadType);
      }

      @Override
      public CloneRules setUploadProtocol(java.lang.String uploadProtocol) {
        return (CloneRules) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public CloneRules setUserIp(java.lang.String userIp) {
        return (CloneRules) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public CloneRules setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public CloneRules setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      /** The firewall policy from which to copy rules. */
      @com.google.api.client.util.Key
      private java.lang.String sourceFirewallPolicy;

      /** The firewall policy from which to copy rules.
       */
      public java.lang.String getSourceFirewallPolicy() {
        return sourceFirewallPolicy;
      }

      /** The firewall policy from which to copy rules. */
      public CloneRules setSourceFirewallPolicy(java.lang.String sourceFirewallPolicy) {
        this.sourceFirewallPolicy = sourceFirewallPolicy;
        return this;
      }

      @Override
      public CloneRules set(String parameterName, Object value) {
        return (CloneRules) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified policy.
     *
     * Create a request for the method "firewallPolicies.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to delete.
     * @return the request
     */
    public Delete delete(java.lang.String firewallPolicy) throws java.io.IOException {
      Delete result = new Delete(firewallPolicy);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Deletes the specified policy.
       *
       * Create a request for the method "firewallPolicies.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String firewallPolicy) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to delete.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to delete. */
      public Delete setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall policy.
     *
     * Create a request for the method "firewallPolicies.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to get.
     * @return the request
     */
    public Get get(java.lang.String firewallPolicy) throws java.io.IOException {
      Get result = new Get(firewallPolicy);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.FirewallPolicy> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Returns the specified firewall policy.
       *
       * Create a request for the method "firewallPolicies.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to get.
       * @since 1.13
       */
      protected Get(java.lang.String firewallPolicy) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallPolicy.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to get. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to get.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to get. */
      public Get setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets an association with the specified name.
     *
     * Create a request for the method "firewallPolicies.getAssociation".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetAssociation#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to which the queried rule belongs.
     * @return the request
     */
    public GetAssociation getAssociation(java.lang.String firewallPolicy) throws java.io.IOException {
      GetAssociation result = new GetAssociation(firewallPolicy);
      initialize(result);
      return result;
    }

    public class GetAssociation extends ComputeRequest<com.google.api.services.compute.model.FirewallPolicyAssociation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/getAssociation";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Gets an association with the specified name.
       *
       * Create a request for the method "firewallPolicies.getAssociation".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetAssociation#execute()} method to invoke the remote operation.
       * <p> {@link GetAssociation#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to which the queried rule belongs.
       * @since 1.13
       */
      protected GetAssociation(java.lang.String firewallPolicy) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallPolicyAssociation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetAssociation set$Xgafv(java.lang.String $Xgafv) {
        return (GetAssociation) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetAssociation setAccessToken(java.lang.String accessToken) {
        return (GetAssociation) super.setAccessToken(accessToken);
      }

      @Override
      public GetAssociation setAlt(java.lang.String alt) {
        return (GetAssociation) super.setAlt(alt);
      }

      @Override
      public GetAssociation setCallback(java.lang.String callback) {
        return (GetAssociation) super.setCallback(callback);
      }

      @Override
      public GetAssociation setFields(java.lang.String fields) {
        return (GetAssociation) super.setFields(fields);
      }

      @Override
      public GetAssociation setKey(java.lang.String key) {
        return (GetAssociation) super.setKey(key);
      }

      @Override
      public GetAssociation setOauthToken(java.lang.String oauthToken) {
        return (GetAssociation) super.setOauthToken(oauthToken);
      }

      @Override
      public GetAssociation setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetAssociation) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetAssociation setQuotaUser(java.lang.String quotaUser) {
        return (GetAssociation) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetAssociation setUploadType(java.lang.String uploadType) {
        return (GetAssociation) super.setUploadType(uploadType);
      }

      @Override
      public GetAssociation setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetAssociation) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetAssociation setUserIp(java.lang.String userIp) {
        return (GetAssociation) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to which the queried rule belongs. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to which the queried rule belongs.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to which the queried rule belongs. */
      public GetAssociation setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** The name of the association to get from the firewall policy. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the association to get from the firewall policy.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the association to get from the firewall policy. */
      public GetAssociation setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public GetAssociation set(String parameterName, Object value) {
        return (GetAssociation) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. May be empty if no such policy or resource exists.
     *
     * Create a request for the method "firewallPolicies.getIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource Name or id of the resource for this request.
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{resource}/getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Gets the access control policy for a resource. May be empty if no such policy or resource
       * exists.
       *
       * Create a request for the method "firewallPolicies.getIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource Name or id of the resource for this request.
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetIamPolicy setUserIp(java.lang.String userIp) {
        return (GetIamPolicy) super.setUserIp(userIp);
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.resource = resource;
        return this;
      }

      /** Requested IAM Policy version. */
      @com.google.api.client.util.Key
      private java.lang.Integer optionsRequestedPolicyVersion;

      /** Requested IAM Policy version.
       */
      public java.lang.Integer getOptionsRequestedPolicyVersion() {
        return optionsRequestedPolicyVersion;
      }

      /** Requested IAM Policy version. */
      public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Gets a rule of the specified priority.
     *
     * Create a request for the method "firewallPolicies.getRule".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link GetRule#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to which the queried rule belongs.
     * @return the request
     */
    public GetRule getRule(java.lang.String firewallPolicy) throws java.io.IOException {
      GetRule result = new GetRule(firewallPolicy);
      initialize(result);
      return result;
    }

    public class GetRule extends ComputeRequest<com.google.api.services.compute.model.FirewallPolicyRule> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/getRule";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Gets a rule of the specified priority.
       *
       * Create a request for the method "firewallPolicies.getRule".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link GetRule#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetRule#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to which the queried rule belongs.
       * @since 1.13
       */
      protected GetRule(java.lang.String firewallPolicy) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallPolicyRule.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetRule set$Xgafv(java.lang.String $Xgafv) {
        return (GetRule) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetRule setAccessToken(java.lang.String accessToken) {
        return (GetRule) super.setAccessToken(accessToken);
      }

      @Override
      public GetRule setAlt(java.lang.String alt) {
        return (GetRule) super.setAlt(alt);
      }

      @Override
      public GetRule setCallback(java.lang.String callback) {
        return (GetRule) super.setCallback(callback);
      }

      @Override
      public GetRule setFields(java.lang.String fields) {
        return (GetRule) super.setFields(fields);
      }

      @Override
      public GetRule setKey(java.lang.String key) {
        return (GetRule) super.setKey(key);
      }

      @Override
      public GetRule setOauthToken(java.lang.String oauthToken) {
        return (GetRule) super.setOauthToken(oauthToken);
      }

      @Override
      public GetRule setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetRule) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetRule setQuotaUser(java.lang.String quotaUser) {
        return (GetRule) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetRule setUploadType(java.lang.String uploadType) {
        return (GetRule) super.setUploadType(uploadType);
      }

      @Override
      public GetRule setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetRule) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public GetRule setUserIp(java.lang.String userIp) {
        return (GetRule) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to which the queried rule belongs. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to which the queried rule belongs.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to which the queried rule belongs. */
      public GetRule setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** The priority of the rule to get from the firewall policy. */
      @com.google.api.client.util.Key
      private java.lang.Integer priority;

      /** The priority of the rule to get from the firewall policy.
       */
      public java.lang.Integer getPriority() {
        return priority;
      }

      /** The priority of the rule to get from the firewall policy. */
      public GetRule setPriority(java.lang.Integer priority) {
        this.priority = priority;
        return this;
      }

      @Override
      public GetRule set(String parameterName, Object value) {
        return (GetRule) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new policy in the specified project using the data included in the request.
     *
     * Create a request for the method "firewallPolicies.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.compute.model.FirewallPolicy}
     * @return the request
     */
    public Insert insert(com.google.api.services.compute.model.FirewallPolicy content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies";

      /**
       * Creates a new policy in the specified project using the data included in the request.
       *
       * Create a request for the method "firewallPolicies.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.compute.model.FirewallPolicy}
       * @since 1.13
       */
      protected Insert(com.google.api.services.compute.model.FirewallPolicy content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Parent ID for this request. The ID can be either be "folders/[FOLDER_ID]" if the parent is
       * a folder or "organizations/[ORGANIZATION_ID]" if the parent is an organization.
       */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** Parent ID for this request. The ID can be either be "folders/[FOLDER_ID]" if the parent is a folder
     or "organizations/[ORGANIZATION_ID]" if the parent is an organization.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /**
       * Parent ID for this request. The ID can be either be "folders/[FOLDER_ID]" if the parent is
       * a folder or "organizations/[ORGANIZATION_ID]" if the parent is an organization.
       */
      public Insert setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all the policies that have been configured for the specified folder or organization.
     *
     * Create a request for the method "firewallPolicies.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallPolicyList> {

      private static final String REST_PATH = "locations/global/firewallPolicies";

      /**
       * Lists all the policies that have been configured for the specified folder or organization.
       *
       * Create a request for the method "firewallPolicies.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallPolicyList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Parent ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** Parent ID for this request.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /** Parent ID for this request. */
      public List setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Lists associations of a specified target, i.e., organization or folder.
     *
     * Create a request for the method "firewallPolicies.listAssociations".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link ListAssociations#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ListAssociations listAssociations() throws java.io.IOException {
      ListAssociations result = new ListAssociations();
      initialize(result);
      return result;
    }

    public class ListAssociations extends ComputeRequest<com.google.api.services.compute.model.FirewallPoliciesListAssociationsResponse> {

      private static final String REST_PATH = "locations/global/firewallPolicies/listAssociations";

      /**
       * Lists associations of a specified target, i.e., organization or folder.
       *
       * Create a request for the method "firewallPolicies.listAssociations".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link ListAssociations#execute()} method to invoke the remote operation.
       * <p> {@link ListAssociations#initialize(com.google.api.client.googleapis.services.AbstractGoogle
       * ClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @since 1.13
       */
      protected ListAssociations() {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallPoliciesListAssociationsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListAssociations set$Xgafv(java.lang.String $Xgafv) {
        return (ListAssociations) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListAssociations setAccessToken(java.lang.String accessToken) {
        return (ListAssociations) super.setAccessToken(accessToken);
      }

      @Override
      public ListAssociations setAlt(java.lang.String alt) {
        return (ListAssociations) super.setAlt(alt);
      }

      @Override
      public ListAssociations setCallback(java.lang.String callback) {
        return (ListAssociations) super.setCallback(callback);
      }

      @Override
      public ListAssociations setFields(java.lang.String fields) {
        return (ListAssociations) super.setFields(fields);
      }

      @Override
      public ListAssociations setKey(java.lang.String key) {
        return (ListAssociations) super.setKey(key);
      }

      @Override
      public ListAssociations setOauthToken(java.lang.String oauthToken) {
        return (ListAssociations) super.setOauthToken(oauthToken);
      }

      @Override
      public ListAssociations setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListAssociations) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListAssociations setQuotaUser(java.lang.String quotaUser) {
        return (ListAssociations) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListAssociations setUploadType(java.lang.String uploadType) {
        return (ListAssociations) super.setUploadType(uploadType);
      }

      @Override
      public ListAssociations setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListAssociations) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public ListAssociations setUserIp(java.lang.String userIp) {
        return (ListAssociations) super.setUserIp(userIp);
      }

      /** The target resource to list associations. It is an organization, or a folder. */
      @com.google.api.client.util.Key
      private java.lang.String targetResource;

      /** The target resource to list associations. It is an organization, or a folder.
       */
      public java.lang.String getTargetResource() {
        return targetResource;
      }

      /** The target resource to list associations. It is an organization, or a folder. */
      public ListAssociations setTargetResource(java.lang.String targetResource) {
        this.targetResource = targetResource;
        return this;
      }

      @Override
      public ListAssociations set(String parameterName, Object value) {
        return (ListAssociations) super.set(parameterName, value);
      }
    }
    /**
     * Moves the specified firewall policy.
     *
     * Create a request for the method "firewallPolicies.move".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Move#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @return the request
     */
    public Move move(java.lang.String firewallPolicy) throws java.io.IOException {
      Move result = new Move(firewallPolicy);
      initialize(result);
      return result;
    }

    public class Move extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/move";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Moves the specified firewall policy.
       *
       * Create a request for the method "firewallPolicies.move".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Move#execute()} method to invoke the remote operation. <p> {@link
       * Move#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @since 1.13
       */
      protected Move(java.lang.String firewallPolicy) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public Move set$Xgafv(java.lang.String $Xgafv) {
        return (Move) super.set$Xgafv($Xgafv);
      }

      @Override
      public Move setAccessToken(java.lang.String accessToken) {
        return (Move) super.setAccessToken(accessToken);
      }

      @Override
      public Move setAlt(java.lang.String alt) {
        return (Move) super.setAlt(alt);
      }

      @Override
      public Move setCallback(java.lang.String callback) {
        return (Move) super.setCallback(callback);
      }

      @Override
      public Move setFields(java.lang.String fields) {
        return (Move) super.setFields(fields);
      }

      @Override
      public Move setKey(java.lang.String key) {
        return (Move) super.setKey(key);
      }

      @Override
      public Move setOauthToken(java.lang.String oauthToken) {
        return (Move) super.setOauthToken(oauthToken);
      }

      @Override
      public Move setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Move) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Move setQuotaUser(java.lang.String quotaUser) {
        return (Move) super.setQuotaUser(quotaUser);
      }

      @Override
      public Move setUploadType(java.lang.String uploadType) {
        return (Move) super.setUploadType(uploadType);
      }

      @Override
      public Move setUploadProtocol(java.lang.String uploadProtocol) {
        return (Move) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Move setUserIp(java.lang.String userIp) {
        return (Move) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public Move setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** The new parent of the firewall policy. */
      @com.google.api.client.util.Key
      private java.lang.String parentId;

      /** The new parent of the firewall policy.
       */
      public java.lang.String getParentId() {
        return parentId;
      }

      /** The new parent of the firewall policy. */
      public Move setParentId(java.lang.String parentId) {
        this.parentId = parentId;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Move setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Move set(String parameterName, Object value) {
        return (Move) super.set(parameterName, value);
      }
    }
    /**
     * Patches the specified policy with the data included in the request.
     *
     * Create a request for the method "firewallPolicies.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @param content the {@link com.google.api.services.compute.model.FirewallPolicy}
     * @return the request
     */
    public Patch patch(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicy content) throws java.io.IOException {
      Patch result = new Patch(firewallPolicy, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Patches the specified policy with the data included in the request.
       *
       * Create a request for the method "firewallPolicies.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @param content the {@link com.google.api.services.compute.model.FirewallPolicy}
       * @since 1.13
       */
      protected Patch(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicy content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public Patch setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Patches a rule of the specified priority.
     *
     * Create a request for the method "firewallPolicies.patchRule".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link PatchRule#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @param content the {@link com.google.api.services.compute.model.FirewallPolicyRule}
     * @return the request
     */
    public PatchRule patchRule(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyRule content) throws java.io.IOException {
      PatchRule result = new PatchRule(firewallPolicy, content);
      initialize(result);
      return result;
    }

    public class PatchRule extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/patchRule";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Patches a rule of the specified priority.
       *
       * Create a request for the method "firewallPolicies.patchRule".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link PatchRule#execute()} method to invoke the remote operation. <p>
       * {@link
       * PatchRule#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @param content the {@link com.google.api.services.compute.model.FirewallPolicyRule}
       * @since 1.13
       */
      protected PatchRule(java.lang.String firewallPolicy, com.google.api.services.compute.model.FirewallPolicyRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public PatchRule set$Xgafv(java.lang.String $Xgafv) {
        return (PatchRule) super.set$Xgafv($Xgafv);
      }

      @Override
      public PatchRule setAccessToken(java.lang.String accessToken) {
        return (PatchRule) super.setAccessToken(accessToken);
      }

      @Override
      public PatchRule setAlt(java.lang.String alt) {
        return (PatchRule) super.setAlt(alt);
      }

      @Override
      public PatchRule setCallback(java.lang.String callback) {
        return (PatchRule) super.setCallback(callback);
      }

      @Override
      public PatchRule setFields(java.lang.String fields) {
        return (PatchRule) super.setFields(fields);
      }

      @Override
      public PatchRule setKey(java.lang.String key) {
        return (PatchRule) super.setKey(key);
      }

      @Override
      public PatchRule setOauthToken(java.lang.String oauthToken) {
        return (PatchRule) super.setOauthToken(oauthToken);
      }

      @Override
      public PatchRule setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (PatchRule) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public PatchRule setQuotaUser(java.lang.String quotaUser) {
        return (PatchRule) super.setQuotaUser(quotaUser);
      }

      @Override
      public PatchRule setUploadType(java.lang.String uploadType) {
        return (PatchRule) super.setUploadType(uploadType);
      }

      @Override
      public PatchRule setUploadProtocol(java.lang.String uploadProtocol) {
        return (PatchRule) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public PatchRule setUserIp(java.lang.String userIp) {
        return (PatchRule) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public PatchRule setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** The priority of the rule to patch. */
      @com.google.api.client.util.Key
      private java.lang.Integer priority;

      /** The priority of the rule to patch.
       */
      public java.lang.Integer getPriority() {
        return priority;
      }

      /** The priority of the rule to patch. */
      public PatchRule setPriority(java.lang.Integer priority) {
        this.priority = priority;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public PatchRule setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public PatchRule set(String parameterName, Object value) {
        return (PatchRule) super.set(parameterName, value);
      }
    }
    /**
     * Removes an association for the specified firewall policy.
     *
     * Create a request for the method "firewallPolicies.removeAssociation".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveAssociation#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @return the request
     */
    public RemoveAssociation removeAssociation(java.lang.String firewallPolicy) throws java.io.IOException {
      RemoveAssociation result = new RemoveAssociation(firewallPolicy);
      initialize(result);
      return result;
    }

    public class RemoveAssociation extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/removeAssociation";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Removes an association for the specified firewall policy.
       *
       * Create a request for the method "firewallPolicies.removeAssociation".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveAssociation#execute()} method to invoke the remote operation.
       * <p> {@link RemoveAssociation#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @since 1.13
       */
      protected RemoveAssociation(java.lang.String firewallPolicy) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public RemoveAssociation set$Xgafv(java.lang.String $Xgafv) {
        return (RemoveAssociation) super.set$Xgafv($Xgafv);
      }

      @Override
      public RemoveAssociation setAccessToken(java.lang.String accessToken) {
        return (RemoveAssociation) super.setAccessToken(accessToken);
      }

      @Override
      public RemoveAssociation setAlt(java.lang.String alt) {
        return (RemoveAssociation) super.setAlt(alt);
      }

      @Override
      public RemoveAssociation setCallback(java.lang.String callback) {
        return (RemoveAssociation) super.setCallback(callback);
      }

      @Override
      public RemoveAssociation setFields(java.lang.String fields) {
        return (RemoveAssociation) super.setFields(fields);
      }

      @Override
      public RemoveAssociation setKey(java.lang.String key) {
        return (RemoveAssociation) super.setKey(key);
      }

      @Override
      public RemoveAssociation setOauthToken(java.lang.String oauthToken) {
        return (RemoveAssociation) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveAssociation setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveAssociation) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveAssociation setQuotaUser(java.lang.String quotaUser) {
        return (RemoveAssociation) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveAssociation setUploadType(java.lang.String uploadType) {
        return (RemoveAssociation) super.setUploadType(uploadType);
      }

      @Override
      public RemoveAssociation setUploadProtocol(java.lang.String uploadProtocol) {
        return (RemoveAssociation) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public RemoveAssociation setUserIp(java.lang.String userIp) {
        return (RemoveAssociation) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public RemoveAssociation setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** Name for the attachment that will be removed. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name for the attachment that will be removed.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Name for the attachment that will be removed. */
      public RemoveAssociation setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public RemoveAssociation setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public RemoveAssociation set(String parameterName, Object value) {
        return (RemoveAssociation) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a rule of the specified priority.
     *
     * Create a request for the method "firewallPolicies.removeRule".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link RemoveRule#execute()} method to invoke the remote operation.
     *
     * @param firewallPolicy Name of the firewall policy to update.
     * @return the request
     */
    public RemoveRule removeRule(java.lang.String firewallPolicy) throws java.io.IOException {
      RemoveRule result = new RemoveRule(firewallPolicy);
      initialize(result);
      return result;
    }

    public class RemoveRule extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{firewallPolicy}/removeRule";

      private final java.util.regex.Pattern FIREWALL_POLICY_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Deletes a rule of the specified priority.
       *
       * Create a request for the method "firewallPolicies.removeRule".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link RemoveRule#execute()} method to invoke the remote operation. <p>
       * {@link
       * RemoveRule#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param firewallPolicy Name of the firewall policy to update.
       * @since 1.13
       */
      protected RemoveRule(java.lang.String firewallPolicy) {
        super(Compute.this, "POST", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.firewallPolicy = com.google.api.client.util.Preconditions.checkNotNull(firewallPolicy, "Required parameter firewallPolicy must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public RemoveRule set$Xgafv(java.lang.String $Xgafv) {
        return (RemoveRule) super.set$Xgafv($Xgafv);
      }

      @Override
      public RemoveRule setAccessToken(java.lang.String accessToken) {
        return (RemoveRule) super.setAccessToken(accessToken);
      }

      @Override
      public RemoveRule setAlt(java.lang.String alt) {
        return (RemoveRule) super.setAlt(alt);
      }

      @Override
      public RemoveRule setCallback(java.lang.String callback) {
        return (RemoveRule) super.setCallback(callback);
      }

      @Override
      public RemoveRule setFields(java.lang.String fields) {
        return (RemoveRule) super.setFields(fields);
      }

      @Override
      public RemoveRule setKey(java.lang.String key) {
        return (RemoveRule) super.setKey(key);
      }

      @Override
      public RemoveRule setOauthToken(java.lang.String oauthToken) {
        return (RemoveRule) super.setOauthToken(oauthToken);
      }

      @Override
      public RemoveRule setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (RemoveRule) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public RemoveRule setQuotaUser(java.lang.String quotaUser) {
        return (RemoveRule) super.setQuotaUser(quotaUser);
      }

      @Override
      public RemoveRule setUploadType(java.lang.String uploadType) {
        return (RemoveRule) super.setUploadType(uploadType);
      }

      @Override
      public RemoveRule setUploadProtocol(java.lang.String uploadProtocol) {
        return (RemoveRule) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public RemoveRule setUserIp(java.lang.String userIp) {
        return (RemoveRule) super.setUserIp(userIp);
      }

      /** Name of the firewall policy to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewallPolicy;

      /** Name of the firewall policy to update.
       */
      public java.lang.String getFirewallPolicy() {
        return firewallPolicy;
      }

      /** Name of the firewall policy to update. */
      public RemoveRule setFirewallPolicy(java.lang.String firewallPolicy) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_POLICY_PATTERN.matcher(firewallPolicy).matches(),
              "Parameter firewallPolicy must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.firewallPolicy = firewallPolicy;
        return this;
      }

      /** The priority of the rule to remove from the firewall policy. */
      @com.google.api.client.util.Key
      private java.lang.Integer priority;

      /** The priority of the rule to remove from the firewall policy.
       */
      public java.lang.Integer getPriority() {
        return priority;
      }

      /** The priority of the rule to remove from the firewall policy. */
      public RemoveRule setPriority(java.lang.Integer priority) {
        this.priority = priority;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public RemoveRule setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public RemoveRule set(String parameterName, Object value) {
        return (RemoveRule) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy.
     *
     * Create a request for the method "firewallPolicies.setIamPolicy".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.GlobalOrganizationSetPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.compute.model.GlobalOrganizationSetPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends ComputeRequest<com.google.api.services.compute.model.Policy> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{resource}/setIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy.
       *
       * Create a request for the method "firewallPolicies.setIamPolicy".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation. <p>
       * {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.GlobalOrganizationSetPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.compute.model.GlobalOrganizationSetPolicyRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public SetIamPolicy setUserIp(java.lang.String userIp) {
        return (SetIamPolicy) super.setUserIp(userIp);
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "firewallPolicies.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "locations/global/firewallPolicies/{resource}/testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("(firewallPolicies/)?[0-9]{0,20}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "firewallPolicies.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "(firewallPolicies/)?[0-9]{0,20}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Firewalls collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.Firewalls.List request = compute.firewalls().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Firewalls firewalls() {
    return new Firewalls();
  }

  /**
   * The "firewalls" collection of methods.
   */
  public class Firewalls {

    /**
     * Deletes the specified firewall.
     *
     * Create a request for the method "firewalls.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Delete result = new Delete(project, firewall);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified firewall.
       *
       * Create a request for the method "firewalls.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to delete. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to delete.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to delete. */
      public Delete setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified firewall.
     *
     * Create a request for the method "firewalls.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String firewall) throws java.io.IOException {
      Get result = new Get(project, firewall);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.Firewall> {

      private static final String REST_PATH = "projects/{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified firewall.
       *
       * Create a request for the method "firewalls.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String firewall) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.Firewall.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to return. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to return.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to return. */
      public Get setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.firewall = firewall;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a firewall rule in the specified project using the data included in the request.
     *
     * Create a request for the method "firewalls.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Insert insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Insert result = new Insert(project, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Creates a firewall rule in the specified project using the data included in the request.
       *
       * Create a request for the method "firewalls.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Insert(java.lang.String project, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves the list of firewall rules available to the specified project.
     *
     * Create a request for the method "firewalls.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public List list(java.lang.String project) throws java.io.IOException {
      List result = new List(project);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.FirewallList> {

      private static final String REST_PATH = "projects/{project}/global/firewalls";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves the list of firewall rules available to the specified project.
       *
       * Create a request for the method "firewalls.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected List(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.FirewallList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request. This method supports
     * PATCH semantics and uses the JSON merge patch format and processing rules.
     *
     * Create a request for the method "firewalls.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to patch.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Patch result = new Patch(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Patch extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified firewall rule with the data included in the request. This method supports
       * PATCH semantics and uses the JSON merge patch format and processing rules.
       *
       * Create a request for the method "firewalls.patch".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to patch.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Patch(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PATCH", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Patch setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to patch. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to patch.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to patch. */
      public Patch setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Patch setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource.
     *
     * Create a request for the method "firewalls.testIamPermissions".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param resource Name or id of the resource for this request.
     * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(project, resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends ComputeRequest<com.google.api.services.compute.model.TestPermissionsResponse> {

      private static final String REST_PATH = "projects/{project}/global/firewalls/{resource}/testIamPermissions";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns permissions that a caller has on the specified resource.
       *
       * Create a request for the method "firewalls.testIamPermissions".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param resource Name or id of the resource for this request.
       * @param content the {@link com.google.api.services.compute.model.TestPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String project, java.lang.String resource, com.google.api.services.compute.model.TestPermissionsRequest content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.TestPermissionsResponse.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public TestIamPermissions setUserIp(java.lang.String userIp) {
        return (TestIamPermissions) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public TestIamPermissions setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name or id of the resource for this request. */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** Name or id of the resource for this request.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /** Name or id of the resource for this request. */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified firewall rule with the data included in the request. Note that all fields
     * will be updated if using PUT, even fields that are not specified. To update individual fields,
     * please use PATCH instead.
     *
     * Create a request for the method "firewalls.update".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param firewall Name of the firewall rule to update.
     * @param content the {@link com.google.api.services.compute.model.Firewall}
     * @return the request
     */
    public Update update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) throws java.io.IOException {
      Update result = new Update(project, firewall, content);
      initialize(result);
      return result;
    }

    public class Update extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/global/firewalls/{firewall}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern FIREWALL_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Updates the specified firewall rule with the data included in the request. Note that all fields
       * will be updated if using PUT, even fields that are not specified. To update individual fields,
       * please use PATCH instead.
       *
       * Create a request for the method "firewalls.update".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param firewall Name of the firewall rule to update.
       * @param content the {@link com.google.api.services.compute.model.Firewall}
       * @since 1.13
       */
      protected Update(java.lang.String project, java.lang.String firewall, com.google.api.services.compute.model.Firewall content) {
        super(Compute.this, "PUT", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.firewall = com.google.api.client.util.Preconditions.checkNotNull(firewall, "Required parameter firewall must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Update setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the firewall rule to update. */
      @com.google.api.client.util.Key
      private java.lang.String firewall;

      /** Name of the firewall rule to update.
       */
      public java.lang.String getFirewall() {
        return firewall;
      }

      /** Name of the firewall rule to update. */
      public Update setFirewall(java.lang.String firewall) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FIREWALL_PATTERN.matcher(firewall).matches(),
              "Parameter firewall must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.firewall = firewall;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Update setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the ForwardingRules collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Compute compute = new Compute(...);}
   *   {@code Compute.ForwardingRules.List request = compute.forwardingRules().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ForwardingRules forwardingRules() {
    return new ForwardingRules();
  }

  /**
   * The "forwardingRules" collection of methods.
   */
  public class ForwardingRules {

    /**
     * Retrieves an aggregated list of forwarding rules.
     *
     * Create a request for the method "forwardingRules.aggregatedList".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @return the request
     */
    public AggregatedList aggregatedList(java.lang.String project) throws java.io.IOException {
      AggregatedList result = new AggregatedList(project);
      initialize(result);
      return result;
    }

    public class AggregatedList extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleAggregatedList> {

      private static final String REST_PATH = "projects/{project}/aggregated/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      /**
       * Retrieves an aggregated list of forwarding rules.
       *
       * Create a request for the method "forwardingRules.aggregatedList".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link AggregatedList#execute()} method to invoke the remote operation.
       * <p> {@link AggregatedList#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @param project Project ID for this request.
       * @since 1.13
       */
      protected AggregatedList(java.lang.String project) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleAggregatedList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public AggregatedList set$Xgafv(java.lang.String $Xgafv) {
        return (AggregatedList) super.set$Xgafv($Xgafv);
      }

      @Override
      public AggregatedList setAccessToken(java.lang.String accessToken) {
        return (AggregatedList) super.setAccessToken(accessToken);
      }

      @Override
      public AggregatedList setAlt(java.lang.String alt) {
        return (AggregatedList) super.setAlt(alt);
      }

      @Override
      public AggregatedList setCallback(java.lang.String callback) {
        return (AggregatedList) super.setCallback(callback);
      }

      @Override
      public AggregatedList setFields(java.lang.String fields) {
        return (AggregatedList) super.setFields(fields);
      }

      @Override
      public AggregatedList setKey(java.lang.String key) {
        return (AggregatedList) super.setKey(key);
      }

      @Override
      public AggregatedList setOauthToken(java.lang.String oauthToken) {
        return (AggregatedList) super.setOauthToken(oauthToken);
      }

      @Override
      public AggregatedList setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (AggregatedList) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public AggregatedList setQuotaUser(java.lang.String quotaUser) {
        return (AggregatedList) super.setQuotaUser(quotaUser);
      }

      @Override
      public AggregatedList setUploadType(java.lang.String uploadType) {
        return (AggregatedList) super.setUploadType(uploadType);
      }

      @Override
      public AggregatedList setUploadProtocol(java.lang.String uploadProtocol) {
        return (AggregatedList) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public AggregatedList setUserIp(java.lang.String userIp) {
        return (AggregatedList) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public AggregatedList setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public AggregatedList setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeAllScopes;

      /** Indicates whether every visible scope for each scope type (zone, region, global) should be included
     in the response. For new resource types added after this field, the flag has no effect as new
     resource types will always include every visible scope for each scope type in response. For
     resource types which predate this field, if this flag is omitted or false, only scopes of the scope
     types where the resource type is expected to be found will be included.
       */
      public java.lang.Boolean getIncludeAllScopes() {
        return includeAllScopes;
      }

      /**
       * Indicates whether every visible scope for each scope type (zone, region, global) should be
       * included in the response. For new resource types added after this field, the flag has no
       * effect as new resource types will always include every visible scope for each scope type in
       * response. For resource types which predate this field, if this flag is omitted or false,
       * only scopes of the scope types where the resource type is expected to be found will be
       * included.
       */
      public AggregatedList setIncludeAllScopes(java.lang.Boolean includeAllScopes) {
        this.includeAllScopes = includeAllScopes;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public AggregatedList setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public AggregatedList setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public AggregatedList setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public AggregatedList setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public AggregatedList set(String parameterName, Object value) {
        return (AggregatedList) super.set(parameterName, value);
      }
    }
    /**
     * Deletes the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.delete".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to delete.
     * @return the request
     */
    public Delete delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Delete result = new Delete(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Delete extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Deletes the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.delete".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "DELETE", REST_PATH, null, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Delete setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Delete setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to delete. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to delete.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to delete. */
      public Delete setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Delete setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the specified ForwardingRule resource.
     *
     * Create a request for the method "forwardingRules.get".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to return.
     * @return the request
     */
    public Get get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) throws java.io.IOException {
      Get result = new Get(project, region, forwardingRule);
      initialize(result);
      return result;
    }

    public class Get extends ComputeRequest<com.google.api.services.compute.model.ForwardingRule> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/forwardingRules/{forwardingRule}";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      private final java.util.regex.Pattern FORWARDING_RULE_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");

      /**
       * Returns the specified ForwardingRule resource.
       *
       * Create a request for the method "forwardingRules.get".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param forwardingRule Name of the ForwardingRule resource to return.
       * @since 1.13
       */
      protected Get(java.lang.String project, java.lang.String region, java.lang.String forwardingRule) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRule.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.forwardingRule = com.google.api.client.util.Preconditions.checkNotNull(forwardingRule, "Required parameter forwardingRule must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Get setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Get setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /** Name of the ForwardingRule resource to return. */
      @com.google.api.client.util.Key
      private java.lang.String forwardingRule;

      /** Name of the ForwardingRule resource to return.
       */
      public java.lang.String getForwardingRule() {
        return forwardingRule;
      }

      /** Name of the ForwardingRule resource to return. */
      public Get setForwardingRule(java.lang.String forwardingRule) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(FORWARDING_RULE_PATTERN.matcher(forwardingRule).matches(),
              "Parameter forwardingRule must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
        }
        this.forwardingRule = forwardingRule;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a ForwardingRule resource in the specified project and region using the data included in
     * the request.
     *
     * Create a request for the method "forwardingRules.insert".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Insert insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Insert result = new Insert(project, region, content);
      initialize(result);
      return result;
    }

    public class Insert extends ComputeRequest<com.google.api.services.compute.model.Operation> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Creates a ForwardingRule resource in the specified project and region using the data included
       * in the request.
       *
       * Create a request for the method "forwardingRules.insert".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link Insert#execute()} method to invoke the remote operation. <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
       * @since 1.13
       */
      protected Insert(java.lang.String project, java.lang.String region, com.google.api.services.compute.model.ForwardingRule content) {
        super(Compute.this, "POST", REST_PATH, content, com.google.api.services.compute.model.Operation.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public Insert setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public Insert setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An optional request ID to identify requests. Specify a unique request ID so that if you must retry
     your request, the server will know to ignore the request if it has already been completed. For
     example, consider a situation where you make an initial request and the request times out. If you
     make the request again with the same request ID, the server can check if original operation with
     the same request ID was received, and if so, will ignore the second request. This prevents clients
     from accidentally creating duplicate commitments. The request ID must be a valid UUID with the
     exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An optional request ID to identify requests. Specify a unique request ID so that if you
       * must retry your request, the server will know to ignore the request if it has already been
       * completed. For example, consider a situation where you make an initial request and the
       * request times out. If you make the request again with the same request ID, the server can
       * check if original operation with the same request ID was received, and if so, will ignore
       * the second request. This prevents clients from accidentally creating duplicate commitments.
       * The request ID must be a valid UUID with the exception that zero UUID is not supported (
       * 00000000-0000-0000-0000-000000000000).
       */
      public Insert setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Retrieves a list of ForwardingRule resources available to the specified project and region.
     *
     * Create a request for the method "forwardingRules.list".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @return the request
     */
    public List list(java.lang.String project, java.lang.String region) throws java.io.IOException {
      List result = new List(project, region);
      initialize(result);
      return result;
    }

    public class List extends ComputeRequest<com.google.api.services.compute.model.ForwardingRuleList> {

      private static final String REST_PATH = "projects/{project}/regions/{region}/forwardingRules";

      private final java.util.regex.Pattern PROJECT_PATTERN =
          java.util.regex.Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");

      private final java.util.regex.Pattern REGION_PATTERN =
          java.util.regex.Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");

      /**
       * Retrieves a list of ForwardingRule resources available to the specified project and region.
       *
       * Create a request for the method "forwardingRules.list".
       *
       * This request holds the parameters needed by the the compute server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param project Project ID for this request.
       * @param region Name of the region scoping this request.
       * @since 1.13
       */
      protected List(java.lang.String project, java.lang.String region) {
        super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.ForwardingRuleList.class);
        this.project = com.google.api.client.util.Preconditions.checkNotNull(project, "Required parameter project must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.region = com.google.api.client.util.Preconditions.checkNotNull(region, "Required parameter region must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Project ID for this request. */
      @com.google.api.client.util.Key
      private java.lang.String project;

      /** Project ID for this request.
       */
      public java.lang.String getProject() {
        return project;
      }

      /** Project ID for this request. */
      public List setProject(java.lang.String project) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_PATTERN.matcher(project).matches(),
              "Parameter project must conform to the pattern " +
              "(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
        }
        this.project = project;
        return this;
      }

      /** Name of the region scoping this request. */
      @com.google.api.client.util.Key
      private java.lang.String region;

      /** Name of the region scoping this request.
       */
      public java.lang.String getRegion() {
        return region;
      }

      /** Name of the region scoping this request. */
      public List setRegion(java.lang.String region) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(REGION_PATTERN.matcher(region).matches(),
              "Parameter region must conform to the pattern " +
              "[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
        }
        this.region = region;
        return this;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter expression that filters resources listed in the response. The expression must specify the
     field name, an operator, and the value that you want to use for filtering. The value must be a
     string, a number, or a boolean. The operator must be either `=`, `!=`, `>`, `<`, `<=`, `>=` or `:`.
     For example, if you are filtering Compute Engine instances, you can exclude instances named
     `example-instance` by specifying `name != example-instance`. The `:` operator can be used with
     string fields to match substrings. For non-string fields it is equivalent to the `=` operator. The
     `:*` comparison can be used to test whether a key has been defined. For example, to find all
     objects with `owner` label use: ``` labels.owner:* ``` You can also filter nested fields. For
     example, you could specify `scheduling.automaticRestart = false` to include instances only if they
     are not scheduled for automatic restarts. You can use filtering on nested fields to filter based on
     resource labels. To filter on multiple expressions, provide each separate expression within
     parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
     ``` By default, each expression is an `AND` expression. However, you can include `AND` and `OR`
     expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel
     Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter expression that filters resources listed in the response. The expression must
       * specify the field name, an operator, and the value that you want to use for filtering. The
       * value must be a string, a number, or a boolean. The operator must be either `=`, `!=`, `>`,
       * `<`, `<=`, `>=` or `:`. For example, if you are filtering Compute Engine instances, you can
       * exclude instances named `example-instance` by specifying `name != example-instance`. The
       * `:` operator can be used with string fields to match substrings. For non-string fields it
       * is equivalent to the `=` operator. The `:*` comparison can be used to test whether a key
       * has been defined. For example, to find all objects with `owner` label use: ```
       * labels.owner:* ``` You can also filter nested fields. For example, you could specify
       * `scheduling.automaticRestart = false` to include instances only if they are not scheduled
       * for automatic restarts. You can use filtering on nested fields to filter based on resource
       * labels. To filter on multiple expressions, provide each separate expression within
       * parentheses. For example: ``` (scheduling.automaticRestart = true) (cpuPlatform = "Intel
       * Skylake") ``` By default, each expression is an `AND` expression. However, you can include
       * `AND` and `OR` expressions explicitly. For example: ``` (cpuPlatform = "Intel Skylake") OR
       * (cpuPlatform = "Intel Broadwell") AND (scheduling.automaticRestart = true) ```
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results per page that should be returned. If the number of available results
     is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be used to get the
     next page of results in subsequent list requests. Acceptable values are `0` to `500`, inclusive.
     (Default: `500`) [default: 500] [minimum: 0]
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results per page that should be returned. If the number of available
       * results is larger than `maxResults`, Compute Engine returns a `nextPageToken` that can be
       * used to get the next page of results in subsequent list requests. Acceptable values are `0`
       * to `500`, inclusive. (Default: `500`)
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** Sorts list results by a certain order. By default, results are returned in alphanumerical order
     based on the resource name. You can also sort results in descending order based on the creation
     timestamp using `orderBy="creationTimestamp desc"`. This sorts results based on the
     `creationTimestamp` field in reverse chronological order (newest result first). Use this to sort
     resources like operations so that the newest operation is returned first. Currently, only sorting
     by `name` or `creationTimestamp desc` is supported.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * Sorts list results by a certain order. By default, results are returned in alphanumerical
       * order based on the resource name. You can also sort results in descending order based on
       * the creation timestamp using `orderBy="creationTimestamp desc"`. This sorts results based
       * on the `creationTimestamp` field in reverse chronological order (newest result first). Use
       * this to sort resources like operations so that the newest operation is returned first.
       * Currently, only sorting by `name` or `creationTimestamp desc` is supported.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a previous list
     request to get the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Specifies a page token to use. Set `pageToken` to the `nextPageToken` returned by a
       * previous list request to get the next page of results.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean returnPartialSuccess;

      /** Opt-in for partial success behavior which provides partial results in case of failure. The default
     value is false.
       */
      public java.lang.Boolean getReturnPartialSuccess() {
        return returnPartialSuccess;
      }

      /**
       * Opt-in for partial success behavior which provides partial results in case of failure. The
       * default value is false.
       */
      public List setReturnPartialSuccess(java.lang.Boolean returnPartialSuccess) {
        this.returnPartialSuccess = returnPartialSuccess;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified forwarding rule with the data included in the request. This method supports
     * PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can
     * only patch the network_tier field.
     *
     * Create a request for the method "forwardingRules.patch".
     *
     * This request holds the parameters needed by the compute server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param project Project ID for this request.
     * @param region Name of the region scoping this request.
     * @param forwardingRule Name of the ForwardingRule resource to patch.
     * @param content the {@link com.google.api.services.compute.model.ForwardingRule}
     * @return the request
     */
    public Patch patch(java.lang.String project, java.lang.String region, java.lang.String forwardingRule, com.google.api.services.compute.model.ForwardingRule content) throws java.io.IOException {
      Patch result = new Pa