/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * This reservation type allows to pre allocate specific instance configuration. Next ID: 5
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AllocationSpecificSKUReservation extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Indicates how many instances are actually usable currently.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long assuredCount;

  /**
   * Specifies the number of resources that are allocated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * [Output Only] Indicates how many instances are in use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long inUseCount;

  /**
   * The instance properties for the reservation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties;

  /**
   * [Output Only] Indicates how many instances are actually usable currently.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAssuredCount() {
    return assuredCount;
  }

  /**
   * [Output Only] Indicates how many instances are actually usable currently.
   * @param assuredCount assuredCount or {@code null} for none
   */
  public AllocationSpecificSKUReservation setAssuredCount(java.lang.Long assuredCount) {
    this.assuredCount = assuredCount;
    return this;
  }

  /**
   * Specifies the number of resources that are allocated.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * Specifies the number of resources that are allocated.
   * @param count count or {@code null} for none
   */
  public AllocationSpecificSKUReservation setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * [Output Only] Indicates how many instances are in use.
   * @return value or {@code null} for none
   */
  public java.lang.Long getInUseCount() {
    return inUseCount;
  }

  /**
   * [Output Only] Indicates how many instances are in use.
   * @param inUseCount inUseCount or {@code null} for none
   */
  public AllocationSpecificSKUReservation setInUseCount(java.lang.Long inUseCount) {
    this.inUseCount = inUseCount;
    return this;
  }

  /**
   * The instance properties for the reservation.
   * @return value or {@code null} for none
   */
  public AllocationSpecificSKUAllocationReservedInstanceProperties getInstanceProperties() {
    return instanceProperties;
  }

  /**
   * The instance properties for the reservation.
   * @param instanceProperties instanceProperties or {@code null} for none
   */
  public AllocationSpecificSKUReservation setInstanceProperties(AllocationSpecificSKUAllocationReservedInstanceProperties instanceProperties) {
    this.instanceProperties = instanceProperties;
    return this;
  }

  @Override
  public AllocationSpecificSKUReservation set(String fieldName, Object value) {
    return (AllocationSpecificSKUReservation) super.set(fieldName, value);
  }

  @Override
  public AllocationSpecificSKUReservation clone() {
    return (AllocationSpecificSKUReservation) super.clone();
  }

}
