/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for UrlMapsValidateRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UrlMapsValidateRequest extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for
   * HTTP/HTTPS External Global Load Balancer with Advanced Traffic Management. Use EXTERNAL for
   * Classic HTTP/HTTPS External Global Load Balancer. Other load balancer types are not supported.
   * For more information, refer to Choosing a load balancer. If unspecified, the load balancing
   * scheme will be inferred from the backend service resources this URL map references. If that can
   * not be inferred (for example, this URL map only references backend buckets, or this Url map is
   * for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as
   * the default type. If specified, the scheme(s) must not conflict with the load balancing scheme
   * of the backend service resources this Url map references.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> loadBalancingSchemes;

  /**
   * Content of the UrlMap to be validated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UrlMap resource;

  /**
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for
   * HTTP/HTTPS External Global Load Balancer with Advanced Traffic Management. Use EXTERNAL for
   * Classic HTTP/HTTPS External Global Load Balancer. Other load balancer types are not supported.
   * For more information, refer to Choosing a load balancer. If unspecified, the load balancing
   * scheme will be inferred from the backend service resources this URL map references. If that can
   * not be inferred (for example, this URL map only references backend buckets, or this Url map is
   * for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as
   * the default type. If specified, the scheme(s) must not conflict with the load balancing scheme
   * of the backend service resources this Url map references.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLoadBalancingSchemes() {
    return loadBalancingSchemes;
  }

  /**
   * Specifies the load balancer type(s) this validation request is for. Use EXTERNAL_MANAGED for
   * HTTP/HTTPS External Global Load Balancer with Advanced Traffic Management. Use EXTERNAL for
   * Classic HTTP/HTTPS External Global Load Balancer. Other load balancer types are not supported.
   * For more information, refer to Choosing a load balancer. If unspecified, the load balancing
   * scheme will be inferred from the backend service resources this URL map references. If that can
   * not be inferred (for example, this URL map only references backend buckets, or this Url map is
   * for rewrites and redirects only and doesn't reference any backends), EXTERNAL will be used as
   * the default type. If specified, the scheme(s) must not conflict with the load balancing scheme
   * of the backend service resources this Url map references.
   * @param loadBalancingSchemes loadBalancingSchemes or {@code null} for none
   */
  public UrlMapsValidateRequest setLoadBalancingSchemes(java.util.List<java.lang.String> loadBalancingSchemes) {
    this.loadBalancingSchemes = loadBalancingSchemes;
    return this;
  }

  /**
   * Content of the UrlMap to be validated.
   * @return value or {@code null} for none
   */
  public UrlMap getResource() {
    return resource;
  }

  /**
   * Content of the UrlMap to be validated.
   * @param resource resource or {@code null} for none
   */
  public UrlMapsValidateRequest setResource(UrlMap resource) {
    this.resource = resource;
    return this;
  }

  @Override
  public UrlMapsValidateRequest set(String fieldName, Object value) {
    return (UrlMapsValidateRequest) super.set(fieldName, value);
  }

  @Override
  public UrlMapsValidateRequest clone() {
    return (UrlMapsValidateRequest) super.clone();
  }

}
