/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * HttpRouteRuleMatch specifies a set of criteria for matching requests to an HttpRouteRule. All
 * specified criteria must be satisfied for a match to occur.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpRouteRuleMatch extends com.google.api.client.json.GenericJson {

  /**
   * For satisfying the matchRule condition, the path of the request must exactly match the value
   * specified in fullPathMatch after removing any query parameters and anchor that may be part of
   * the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch,
   * fullPathMatch or regexMatch must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullPathMatch;

  /**
   * Specifies a list of header match criteria, all of which must match corresponding headers in the
   * request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpHeaderMatch> headerMatches;

  static {
    // hack to force ProGuard to consider HttpHeaderMatch used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HttpHeaderMatch.class);
  }

  /**
   * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is
   * false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to
   * a target gRPC proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ignoreCase;

  /**
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited
   * set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present
   * node metadata. When there is a match, the relevant routing configuration is made available to
   * those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to
   * MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the
   * metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must
   * match with corresponding labels provided in the metadata. If multiple metadata filters are
   * specified, all of them need to be satisfied in order to be considered a match. metadataFilters
   * specified here is applied after those specified in ForwardingRule that refers to the UrlMap
   * this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a
   * target gRPC proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetadataFilter> metadataFilters;

  /**
   * For satisfying the matchRule condition, the request's path must begin with the specified
   * prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only
   * one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String prefixMatch;

  /**
   * Specifies a list of query parameter match criteria, all of which must match corresponding query
   * parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpQueryParameterMatch> queryParameterMatches;

  static {
    // hack to force ProGuard to consider HttpQueryParameterMatch used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HttpQueryParameterMatch.class);
  }

  /**
   * For satisfying the matchRule condition, the path of the request must satisfy the regular
   * expression specified in regexMatch after removing any query parameters and anchor supplied with
   * the original URL. For more information about regular expression syntax, see Syntax. Only one of
   * prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load
   * balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String regexMatch;

  /**
   * For satisfying the matchRule condition, the path of the request must exactly match the value
   * specified in fullPathMatch after removing any query parameters and anchor that may be part of
   * the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch,
   * fullPathMatch or regexMatch must be specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullPathMatch() {
    return fullPathMatch;
  }

  /**
   * For satisfying the matchRule condition, the path of the request must exactly match the value
   * specified in fullPathMatch after removing any query parameters and anchor that may be part of
   * the original URL. fullPathMatch must be from 1 to 1024 characters. Only one of prefixMatch,
   * fullPathMatch or regexMatch must be specified.
   * @param fullPathMatch fullPathMatch or {@code null} for none
   */
  public HttpRouteRuleMatch setFullPathMatch(java.lang.String fullPathMatch) {
    this.fullPathMatch = fullPathMatch;
    return this;
  }

  /**
   * Specifies a list of header match criteria, all of which must match corresponding headers in the
   * request.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpHeaderMatch> getHeaderMatches() {
    return headerMatches;
  }

  /**
   * Specifies a list of header match criteria, all of which must match corresponding headers in the
   * request.
   * @param headerMatches headerMatches or {@code null} for none
   */
  public HttpRouteRuleMatch setHeaderMatches(java.util.List<HttpHeaderMatch> headerMatches) {
    this.headerMatches = headerMatches;
    return this;
  }

  /**
   * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is
   * false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to
   * a target gRPC proxy.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIgnoreCase() {
    return ignoreCase;
  }

  /**
   * Specifies that prefixMatch and fullPathMatch matches are case sensitive. The default value is
   * false. ignoreCase must not be used with regexMatch. Not supported when the URL map is bound to
   * a target gRPC proxy.
   * @param ignoreCase ignoreCase or {@code null} for none
   */
  public HttpRouteRuleMatch setIgnoreCase(java.lang.Boolean ignoreCase) {
    this.ignoreCase = ignoreCase;
    return this;
  }

  /**
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited
   * set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present
   * node metadata. When there is a match, the relevant routing configuration is made available to
   * those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to
   * MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the
   * metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must
   * match with corresponding labels provided in the metadata. If multiple metadata filters are
   * specified, all of them need to be satisfied in order to be considered a match. metadataFilters
   * specified here is applied after those specified in ForwardingRule that refers to the UrlMap
   * this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a
   * target gRPC proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public java.util.List<MetadataFilter> getMetadataFilters() {
    return metadataFilters;
  }

  /**
   * Opaque filter criteria used by the load balancer to restrict routing configuration to a limited
   * set of xDS compliant clients. In their xDS requests to the load balancer, xDS clients present
   * node metadata. When there is a match, the relevant routing configuration is made available to
   * those proxies. For each metadataFilter in this list, if its filterMatchCriteria is set to
   * MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the
   * metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must
   * match with corresponding labels provided in the metadata. If multiple metadata filters are
   * specified, all of them need to be satisfied in order to be considered a match. metadataFilters
   * specified here is applied after those specified in ForwardingRule that refers to the UrlMap
   * this HttpRouteRuleMatch belongs to. metadataFilters only applies to load balancers that have
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. Not supported when the URL map is bound to a
   * target gRPC proxy that has validateForProxyless field set to true.
   * @param metadataFilters metadataFilters or {@code null} for none
   */
  public HttpRouteRuleMatch setMetadataFilters(java.util.List<MetadataFilter> metadataFilters) {
    this.metadataFilters = metadataFilters;
    return this;
  }

  /**
   * For satisfying the matchRule condition, the request's path must begin with the specified
   * prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only
   * one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrefixMatch() {
    return prefixMatch;
  }

  /**
   * For satisfying the matchRule condition, the request's path must begin with the specified
   * prefixMatch. prefixMatch must begin with a /. The value must be from 1 to 1024 characters. Only
   * one of prefixMatch, fullPathMatch or regexMatch must be specified.
   * @param prefixMatch prefixMatch or {@code null} for none
   */
  public HttpRouteRuleMatch setPrefixMatch(java.lang.String prefixMatch) {
    this.prefixMatch = prefixMatch;
    return this;
  }

  /**
   * Specifies a list of query parameter match criteria, all of which must match corresponding query
   * parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpQueryParameterMatch> getQueryParameterMatches() {
    return queryParameterMatches;
  }

  /**
   * Specifies a list of query parameter match criteria, all of which must match corresponding query
   * parameters in the request. Not supported when the URL map is bound to a target gRPC proxy.
   * @param queryParameterMatches queryParameterMatches or {@code null} for none
   */
  public HttpRouteRuleMatch setQueryParameterMatches(java.util.List<HttpQueryParameterMatch> queryParameterMatches) {
    this.queryParameterMatches = queryParameterMatches;
    return this;
  }

  /**
   * For satisfying the matchRule condition, the path of the request must satisfy the regular
   * expression specified in regexMatch after removing any query parameters and anchor supplied with
   * the original URL. For more information about regular expression syntax, see Syntax. Only one of
   * prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load
   * balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegexMatch() {
    return regexMatch;
  }

  /**
   * For satisfying the matchRule condition, the path of the request must satisfy the regular
   * expression specified in regexMatch after removing any query parameters and anchor supplied with
   * the original URL. For more information about regular expression syntax, see Syntax. Only one of
   * prefixMatch, fullPathMatch or regexMatch must be specified. regexMatch only applies to load
   * balancers that have loadBalancingScheme set to INTERNAL_SELF_MANAGED.
   * @param regexMatch regexMatch or {@code null} for none
   */
  public HttpRouteRuleMatch setRegexMatch(java.lang.String regexMatch) {
    this.regexMatch = regexMatch;
    return this;
  }

  @Override
  public HttpRouteRuleMatch set(String fieldName, Object value) {
    return (HttpRouteRuleMatch) super.set(fieldName, value);
  }

  @Override
  public HttpRouteRuleMatch clone() {
    return (HttpRouteRuleMatch) super.clone();
  }

}
