/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Subsetting configuration for this BackendService. Currently this is applicable only for Internal
 * TCP/UDP load balancing, Internal HTTP(S) load balancing and Traffic Director.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Subsetting extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String policy;

  /**
   * The number of backends per backend group assigned to each proxy instance or each service mesh
   * client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if
   * `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is
   * `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S)
   * load balancing and required for Traffic Director. If you do not provide this value, Cloud Load
   * Balancing will calculate it dynamically to optimize the number of proxies/clients visible to
   * each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number
   * of backends/endpoints, then subsetting is disabled.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer subsetSize;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getPolicy() {
    return policy;
  }

  /**
   * @param policy policy or {@code null} for none
   */
  public Subsetting setPolicy(java.lang.String policy) {
    this.policy = policy;
    return this;
  }

  /**
   * The number of backends per backend group assigned to each proxy instance or each service mesh
   * client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if
   * `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is
   * `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S)
   * load balancing and required for Traffic Director. If you do not provide this value, Cloud Load
   * Balancing will calculate it dynamically to optimize the number of proxies/clients visible to
   * each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number
   * of backends/endpoints, then subsetting is disabled.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSubsetSize() {
    return subsetSize;
  }

  /**
   * The number of backends per backend group assigned to each proxy instance or each service mesh
   * client. An input parameter to the `CONSISTENT_HASH_SUBSETTING` algorithm. Can only be set if
   * `policy` is set to `CONSISTENT_HASH_SUBSETTING`. Can only be set if load balancing scheme is
   * `INTERNAL_MANAGED` or `INTERNAL_SELF_MANAGED`. `subset_size` is optional for Internal HTTP(S)
   * load balancing and required for Traffic Director. If you do not provide this value, Cloud Load
   * Balancing will calculate it dynamically to optimize the number of proxies/clients visible to
   * each backend and vice versa. Must be greater than 0. If `subset_size` is larger than the number
   * of backends/endpoints, then subsetting is disabled.
   * @param subsetSize subsetSize or {@code null} for none
   */
  public Subsetting setSubsetSize(java.lang.Integer subsetSize) {
    this.subsetSize = subsetSize;
    return this;
  }

  @Override
  public Subsetting set(String fieldName, Object value) {
    return (Subsetting) super.set(fieldName, value);
  }

  @Override
  public Subsetting clone() {
    return (Subsetting) super.clone();
  }

}
