/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyAssociation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyAssociation extends com.google.api.client.json.GenericJson {

  /**
   * The resource that the security policy is attached to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attachmentId;

  /**
   * [Output Only] The display name of the security policy of the association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The name for an association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The security policy ID of the association.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String securityPolicyId;

  /**
   * The resource that the security policy is attached to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttachmentId() {
    return attachmentId;
  }

  /**
   * The resource that the security policy is attached to.
   * @param attachmentId attachmentId or {@code null} for none
   */
  public SecurityPolicyAssociation setAttachmentId(java.lang.String attachmentId) {
    this.attachmentId = attachmentId;
    return this;
  }

  /**
   * [Output Only] The display name of the security policy of the association.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * [Output Only] The display name of the security policy of the association.
   * @param displayName displayName or {@code null} for none
   */
  public SecurityPolicyAssociation setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The name for an association.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name for an association.
   * @param name name or {@code null} for none
   */
  public SecurityPolicyAssociation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The security policy ID of the association.
   * @return value or {@code null} for none
   */
  public java.lang.String getSecurityPolicyId() {
    return securityPolicyId;
  }

  /**
   * [Output Only] The security policy ID of the association.
   * @param securityPolicyId securityPolicyId or {@code null} for none
   */
  public SecurityPolicyAssociation setSecurityPolicyId(java.lang.String securityPolicyId) {
    this.securityPolicyId = securityPolicyId;
    return this;
  }

  @Override
  public SecurityPolicyAssociation set(String fieldName, Object value) {
    return (SecurityPolicyAssociation) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyAssociation clone() {
    return (SecurityPolicyAssociation) super.clone();
  }

}
