/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration options for L7 DDoS detection.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig extends com.google.api.client.json.GenericJson {

  /**
   * If set to true, enables CAAP for L7 DDoS detection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enable;

  /**
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM -
   * transparent rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ruleVisibility;

  /**
   * If set to true, enables CAAP for L7 DDoS detection.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnable() {
    return enable;
  }

  /**
   * If set to true, enables CAAP for L7 DDoS detection.
   * @param enable enable or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig setEnable(java.lang.Boolean enable) {
    this.enable = enable;
    return this;
  }

  /**
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM -
   * transparent rules.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuleVisibility() {
    return ruleVisibility;
  }

  /**
   * Rule visibility can be one of the following: STANDARD - opaque rules. (default) PREMIUM -
   * transparent rules.
   * @param ruleVisibility ruleVisibility or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig setRuleVisibility(java.lang.String ruleVisibility) {
    this.ruleVisibility = ruleVisibility;
    return this;
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig set(String fieldName, Object value) {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig clone() {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig) super.clone();
  }

}
