/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The configuration for a built-in load balancing policy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BackendServiceLocalityLoadBalancingPolicyConfigPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The name of a locality load balancer policy to be used. The value should be one of the
   * predefined ones as supported by localityLbPolicy, although at the moment only ROUND_ROBIN is
   * supported. This field should only be populated when the customPolicy field is not used. Note
   * that specifying the same policy more than once for a backend is not a valid configuration and
   * will be rejected.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of a locality load balancer policy to be used. The value should be one of the
   * predefined ones as supported by localityLbPolicy, although at the moment only ROUND_ROBIN is
   * supported. This field should only be populated when the customPolicy field is not used. Note
   * that specifying the same policy more than once for a backend is not a valid configuration and
   * will be rejected.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of a locality load balancer policy to be used. The value should be one of the
   * predefined ones as supported by localityLbPolicy, although at the moment only ROUND_ROBIN is
   * supported. This field should only be populated when the customPolicy field is not used. Note
   * that specifying the same policy more than once for a backend is not a valid configuration and
   * will be rejected.
   * @param name name or {@code null} for none
   */
  public BackendServiceLocalityLoadBalancingPolicyConfigPolicy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public BackendServiceLocalityLoadBalancingPolicyConfigPolicy set(String fieldName, Object value) {
    return (BackendServiceLocalityLoadBalancingPolicyConfigPolicy) super.set(fieldName, value);
  }

  @Override
  public BackendServiceLocalityLoadBalancingPolicyConfigPolicy clone() {
    return (BackendServiceLocalityLoadBalancingPolicyConfigPolicy) super.clone();
  }

}
