/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for DiskAsyncReplication.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiskAsyncReplication extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] URL of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consistencyGroupPolicy;

  /**
   * [Output Only] ID of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String consistencyGroupPolicyId;

  /**
   * The other disk asynchronously replicated to or from the current disk. You can provide this as a
   * partial or full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk -
   * projects/project/zones/zone/disks/disk - zones/zone/disks/disk
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String disk;

  /**
   * [Output Only] The unique ID of the other disk asynchronously replicated to or from the current
   * disk. This value identifies the exact disk that was used to create this replication. For
   * example, if you started replicating the persistent disk from a disk that was later deleted and
   * recreated under the same name, the disk ID would identify the exact version of the disk that
   * was used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskId;

  /**
   * [Output Only] URL of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsistencyGroupPolicy() {
    return consistencyGroupPolicy;
  }

  /**
   * [Output Only] URL of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * @param consistencyGroupPolicy consistencyGroupPolicy or {@code null} for none
   */
  public DiskAsyncReplication setConsistencyGroupPolicy(java.lang.String consistencyGroupPolicy) {
    this.consistencyGroupPolicy = consistencyGroupPolicy;
    return this;
  }

  /**
   * [Output Only] ID of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * @return value or {@code null} for none
   */
  public java.lang.String getConsistencyGroupPolicyId() {
    return consistencyGroupPolicyId;
  }

  /**
   * [Output Only] ID of the DiskConsistencyGroupPolicy if replication was started on the disk as a
   * member of a group.
   * @param consistencyGroupPolicyId consistencyGroupPolicyId or {@code null} for none
   */
  public DiskAsyncReplication setConsistencyGroupPolicyId(java.lang.String consistencyGroupPolicyId) {
    this.consistencyGroupPolicyId = consistencyGroupPolicyId;
    return this;
  }

  /**
   * The other disk asynchronously replicated to or from the current disk. You can provide this as a
   * partial or full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk -
   * projects/project/zones/zone/disks/disk - zones/zone/disks/disk
   * @return value or {@code null} for none
   */
  public java.lang.String getDisk() {
    return disk;
  }

  /**
   * The other disk asynchronously replicated to or from the current disk. You can provide this as a
   * partial or full URL to the resource. For example, the following are valid values: -
   * https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk -
   * projects/project/zones/zone/disks/disk - zones/zone/disks/disk
   * @param disk disk or {@code null} for none
   */
  public DiskAsyncReplication setDisk(java.lang.String disk) {
    this.disk = disk;
    return this;
  }

  /**
   * [Output Only] The unique ID of the other disk asynchronously replicated to or from the current
   * disk. This value identifies the exact disk that was used to create this replication. For
   * example, if you started replicating the persistent disk from a disk that was later deleted and
   * recreated under the same name, the disk ID would identify the exact version of the disk that
   * was used.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskId() {
    return diskId;
  }

  /**
   * [Output Only] The unique ID of the other disk asynchronously replicated to or from the current
   * disk. This value identifies the exact disk that was used to create this replication. For
   * example, if you started replicating the persistent disk from a disk that was later deleted and
   * recreated under the same name, the disk ID would identify the exact version of the disk that
   * was used.
   * @param diskId diskId or {@code null} for none
   */
  public DiskAsyncReplication setDiskId(java.lang.String diskId) {
    this.diskId = diskId;
    return this;
  }

  @Override
  public DiskAsyncReplication set(String fieldName, Object value) {
    return (DiskAsyncReplication) super.set(fieldName, value);
  }

  @Override
  public DiskAsyncReplication clone() {
    return (DiskAsyncReplication) super.clone();
  }

}
