/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.compute;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Data;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.compute.ComputeRequest;
import com.google.api.services.compute.ComputeRequestInitializer;
import com.google.api.services.compute.model.AcceleratorType;
import com.google.api.services.compute.model.AcceleratorTypeAggregatedList;
import com.google.api.services.compute.model.AcceleratorTypeList;
import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AddressAggregatedList;
import com.google.api.services.compute.model.AddressList;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.Autoscaler;
import com.google.api.services.compute.model.AutoscalerAggregatedList;
import com.google.api.services.compute.model.AutoscalerList;
import com.google.api.services.compute.model.BackendBucket;
import com.google.api.services.compute.model.BackendBucketList;
import com.google.api.services.compute.model.BackendService;
import com.google.api.services.compute.model.BackendServiceAggregatedList;
import com.google.api.services.compute.model.BackendServiceGroupHealth;
import com.google.api.services.compute.model.BackendServiceList;
import com.google.api.services.compute.model.BulkInsertDiskResource;
import com.google.api.services.compute.model.BulkInsertInstanceResource;
import com.google.api.services.compute.model.CacheInvalidationRule;
import com.google.api.services.compute.model.Commitment;
import com.google.api.services.compute.model.CommitmentAggregatedList;
import com.google.api.services.compute.model.CommitmentList;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskAggregatedList;
import com.google.api.services.compute.model.DiskList;
import com.google.api.services.compute.model.DiskMoveRequest;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.DiskTypeAggregatedList;
import com.google.api.services.compute.model.DiskTypeList;
import com.google.api.services.compute.model.DisksAddResourcePoliciesRequest;
import com.google.api.services.compute.model.DisksRemoveResourcePoliciesRequest;
import com.google.api.services.compute.model.DisksResizeRequest;
import com.google.api.services.compute.model.DisksStartAsyncReplicationRequest;
import com.google.api.services.compute.model.DisksStopGroupAsyncReplicationResource;
import com.google.api.services.compute.model.DisplayDevice;
import com.google.api.services.compute.model.ExchangedPeeringRoutesList;
import com.google.api.services.compute.model.ExternalVpnGateway;
import com.google.api.services.compute.model.ExternalVpnGatewayList;
import com.google.api.services.compute.model.Firewall;
import com.google.api.services.compute.model.FirewallList;
import com.google.api.services.compute.model.FirewallPoliciesListAssociationsResponse;
import com.google.api.services.compute.model.FirewallPolicy;
import com.google.api.services.compute.model.FirewallPolicyAssociation;
import com.google.api.services.compute.model.FirewallPolicyList;
import com.google.api.services.compute.model.FirewallPolicyRule;
import com.google.api.services.compute.model.ForwardingRule;
import com.google.api.services.compute.model.ForwardingRuleAggregatedList;
import com.google.api.services.compute.model.ForwardingRuleList;
import com.google.api.services.compute.model.GlobalAddressesMoveRequest;
import com.google.api.services.compute.model.GlobalNetworkEndpointGroupsAttachEndpointsRequest;
import com.google.api.services.compute.model.GlobalNetworkEndpointGroupsDetachEndpointsRequest;
import com.google.api.services.compute.model.GlobalOrganizationSetPolicyRequest;
import com.google.api.services.compute.model.GlobalSetLabelsRequest;
import com.google.api.services.compute.model.GlobalSetPolicyRequest;
import com.google.api.services.compute.model.GuestAttributes;
import com.google.api.services.compute.model.HealthCheck;
import com.google.api.services.compute.model.HealthCheckList;
import com.google.api.services.compute.model.HealthCheckService;
import com.google.api.services.compute.model.HealthCheckServicesList;
import com.google.api.services.compute.model.HealthChecksAggregatedList;
import com.google.api.services.compute.model.HttpHealthCheck;
import com.google.api.services.compute.model.HttpHealthCheckList;
import com.google.api.services.compute.model.HttpsHealthCheck;
import com.google.api.services.compute.model.HttpsHealthCheckList;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.ImageFamilyView;
import com.google.api.services.compute.model.ImageList;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceAggregatedList;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.InstanceGroupAggregatedList;
import com.google.api.services.compute.model.InstanceGroupList;
import com.google.api.services.compute.model.InstanceGroupManager;
import com.google.api.services.compute.model.InstanceGroupManagerAggregatedList;
import com.google.api.services.compute.model.InstanceGroupManagerList;
import com.google.api.services.compute.model.InstanceGroupManagerResizeRequest;
import com.google.api.services.compute.model.InstanceGroupManagerResizeRequestsListResponse;
import com.google.api.services.compute.model.InstanceGroupManagersAbandonInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersApplyUpdatesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersCreateInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersDeleteInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersDeletePerInstanceConfigsReq;
import com.google.api.services.compute.model.InstanceGroupManagersListErrorsResponse;
import com.google.api.services.compute.model.InstanceGroupManagersListManagedInstancesResponse;
import com.google.api.services.compute.model.InstanceGroupManagersListPerInstanceConfigsResp;
import com.google.api.services.compute.model.InstanceGroupManagersPatchPerInstanceConfigsReq;
import com.google.api.services.compute.model.InstanceGroupManagersRecreateInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupManagersResizeAdvancedRequest;
import com.google.api.services.compute.model.InstanceGroupManagersSetAutoHealingRequest;
import com.google.api.services.compute.model.InstanceGroupManagersSetInstanceTemplateRequest;
import com.google.api.services.compute.model.InstanceGroupManagersSetTargetPoolsRequest;
import com.google.api.services.compute.model.InstanceGroupManagersUpdatePerInstanceConfigsReq;
import com.google.api.services.compute.model.InstanceGroupsAddInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsListInstances;
import com.google.api.services.compute.model.InstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsRemoveInstancesRequest;
import com.google.api.services.compute.model.InstanceGroupsSetNamedPortsRequest;
import com.google.api.services.compute.model.InstanceList;
import com.google.api.services.compute.model.InstanceListReferrers;
import com.google.api.services.compute.model.InstanceMoveRequest;
import com.google.api.services.compute.model.InstanceReference;
import com.google.api.services.compute.model.InstanceTemplate;
import com.google.api.services.compute.model.InstanceTemplateAggregatedList;
import com.google.api.services.compute.model.InstanceTemplateList;
import com.google.api.services.compute.model.InstancesAddResourcePoliciesRequest;
import com.google.api.services.compute.model.InstancesGetEffectiveFirewallsResponse;
import com.google.api.services.compute.model.InstancesRemoveResourcePoliciesRequest;
import com.google.api.services.compute.model.InstancesResumeRequest;
import com.google.api.services.compute.model.InstancesSetLabelsRequest;
import com.google.api.services.compute.model.InstancesSetMachineResourcesRequest;
import com.google.api.services.compute.model.InstancesSetMachineTypeRequest;
import com.google.api.services.compute.model.InstancesSetMinCpuPlatformRequest;
import com.google.api.services.compute.model.InstancesSetNameRequest;
import com.google.api.services.compute.model.InstancesSetSecurityPolicyRequest;
import com.google.api.services.compute.model.InstancesSetServiceAccountRequest;
import com.google.api.services.compute.model.InstancesStartWithEncryptionKeyRequest;
import com.google.api.services.compute.model.InstantSnapshot;
import com.google.api.services.compute.model.InstantSnapshotAggregatedList;
import com.google.api.services.compute.model.InstantSnapshotList;
import com.google.api.services.compute.model.Interconnect;
import com.google.api.services.compute.model.InterconnectAttachment;
import com.google.api.services.compute.model.InterconnectAttachmentAggregatedList;
import com.google.api.services.compute.model.InterconnectAttachmentList;
import com.google.api.services.compute.model.InterconnectList;
import com.google.api.services.compute.model.InterconnectLocation;
import com.google.api.services.compute.model.InterconnectLocationList;
import com.google.api.services.compute.model.InterconnectRemoteLocation;
import com.google.api.services.compute.model.InterconnectRemoteLocationList;
import com.google.api.services.compute.model.InterconnectsGetDiagnosticsResponse;
import com.google.api.services.compute.model.InterconnectsGetMacsecConfigResponse;
import com.google.api.services.compute.model.License;
import com.google.api.services.compute.model.LicenseCode;
import com.google.api.services.compute.model.LicensesListResponse;
import com.google.api.services.compute.model.MachineImage;
import com.google.api.services.compute.model.MachineImageList;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.MachineTypeAggregatedList;
import com.google.api.services.compute.model.MachineTypeList;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.NatIpInfoResponse;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.NetworkAttachment;
import com.google.api.services.compute.model.NetworkAttachmentAggregatedList;
import com.google.api.services.compute.model.NetworkAttachmentList;
import com.google.api.services.compute.model.NetworkEdgeSecurityService;
import com.google.api.services.compute.model.NetworkEdgeSecurityServiceAggregatedList;
import com.google.api.services.compute.model.NetworkEndpointGroup;
import com.google.api.services.compute.model.NetworkEndpointGroupAggregatedList;
import com.google.api.services.compute.model.NetworkEndpointGroupList;
import com.google.api.services.compute.model.NetworkEndpointGroupsAttachEndpointsRequest;
import com.google.api.services.compute.model.NetworkEndpointGroupsDetachEndpointsRequest;
import com.google.api.services.compute.model.NetworkEndpointGroupsListEndpointsRequest;
import com.google.api.services.compute.model.NetworkEndpointGroupsListNetworkEndpoints;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.NetworkList;
import com.google.api.services.compute.model.NetworksAddPeeringRequest;
import com.google.api.services.compute.model.NetworksGetEffectiveFirewallsResponse;
import com.google.api.services.compute.model.NetworksRemovePeeringRequest;
import com.google.api.services.compute.model.NetworksUpdatePeeringRequest;
import com.google.api.services.compute.model.NodeGroup;
import com.google.api.services.compute.model.NodeGroupAggregatedList;
import com.google.api.services.compute.model.NodeGroupList;
import com.google.api.services.compute.model.NodeGroupsAddNodesRequest;
import com.google.api.services.compute.model.NodeGroupsDeleteNodesRequest;
import com.google.api.services.compute.model.NodeGroupsListNodes;
import com.google.api.services.compute.model.NodeGroupsSetNodeTemplateRequest;
import com.google.api.services.compute.model.NodeGroupsSimulateMaintenanceEventRequest;
import com.google.api.services.compute.model.NodeTemplate;
import com.google.api.services.compute.model.NodeTemplateAggregatedList;
import com.google.api.services.compute.model.NodeTemplateList;
import com.google.api.services.compute.model.NodeType;
import com.google.api.services.compute.model.NodeTypeAggregatedList;
import com.google.api.services.compute.model.NodeTypeList;
import com.google.api.services.compute.model.NotificationEndpoint;
import com.google.api.services.compute.model.NotificationEndpointList;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.OperationAggregatedList;
import com.google.api.services.compute.model.OperationList;
import com.google.api.services.compute.model.OrganizationSecurityPoliciesListAssociationsResponse;
import com.google.api.services.compute.model.PacketMirroring;
import com.google.api.services.compute.model.PacketMirroringAggregatedList;
import com.google.api.services.compute.model.PacketMirroringList;
import com.google.api.services.compute.model.Policy;
import com.google.api.services.compute.model.Project;
import com.google.api.services.compute.model.ProjectsDisableXpnResourceRequest;
import com.google.api.services.compute.model.ProjectsEnableXpnResourceRequest;
import com.google.api.services.compute.model.ProjectsGetXpnResources;
import com.google.api.services.compute.model.ProjectsListXpnHostsRequest;
import com.google.api.services.compute.model.ProjectsSetDefaultNetworkTierRequest;
import com.google.api.services.compute.model.ProjectsSetManagedProtectionTierRequest;
import com.google.api.services.compute.model.PublicAdvertisedPrefix;
import com.google.api.services.compute.model.PublicAdvertisedPrefixList;
import com.google.api.services.compute.model.PublicDelegatedPrefix;
import com.google.api.services.compute.model.PublicDelegatedPrefixAggregatedList;
import com.google.api.services.compute.model.PublicDelegatedPrefixList;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.RegionAddressesMoveRequest;
import com.google.api.services.compute.model.RegionAutoscalerList;
import com.google.api.services.compute.model.RegionCommitmentsUpdateReservationsRequest;
import com.google.api.services.compute.model.RegionDiskTypeList;
import com.google.api.services.compute.model.RegionDisksAddResourcePoliciesRequest;
import com.google.api.services.compute.model.RegionDisksRemoveResourcePoliciesRequest;
import com.google.api.services.compute.model.RegionDisksResizeRequest;
import com.google.api.services.compute.model.RegionDisksStartAsyncReplicationRequest;
import com.google.api.services.compute.model.RegionInstanceGroupList;
import com.google.api.services.compute.model.RegionInstanceGroupManagerDeleteInstanceConfigReq;
import com.google.api.services.compute.model.RegionInstanceGroupManagerList;
import com.google.api.services.compute.model.RegionInstanceGroupManagerPatchInstanceConfigReq;
import com.google.api.services.compute.model.RegionInstanceGroupManagerUpdateInstanceConfigReq;
import com.google.api.services.compute.model.RegionInstanceGroupManagersAbandonInstancesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersApplyUpdatesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersCreateInstancesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersDeleteInstancesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersListErrorsResponse;
import com.google.api.services.compute.model.RegionInstanceGroupManagersListInstanceConfigsResp;
import com.google.api.services.compute.model.RegionInstanceGroupManagersListInstancesResponse;
import com.google.api.services.compute.model.RegionInstanceGroupManagersRecreateRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersResizeAdvancedRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetAutoHealingRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetTargetPoolsRequest;
import com.google.api.services.compute.model.RegionInstanceGroupManagersSetTemplateRequest;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstances;
import com.google.api.services.compute.model.RegionInstanceGroupsListInstancesRequest;
import com.google.api.services.compute.model.RegionInstanceGroupsSetNamedPortsRequest;
import com.google.api.services.compute.model.RegionList;
import com.google.api.services.compute.model.RegionNetworkEndpointGroupsAttachEndpointsRequest;
import com.google.api.services.compute.model.RegionNetworkEndpointGroupsDetachEndpointsRequest;
import com.google.api.services.compute.model.RegionNetworkFirewallPoliciesGetEffectiveFirewallsResponse;
import com.google.api.services.compute.model.RegionSetLabelsRequest;
import com.google.api.services.compute.model.RegionSetPolicyRequest;
import com.google.api.services.compute.model.RegionTargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.RegionUrlMapsValidateRequest;
import com.google.api.services.compute.model.Reservation;
import com.google.api.services.compute.model.ReservationAggregatedList;
import com.google.api.services.compute.model.ReservationList;
import com.google.api.services.compute.model.ReservationsResizeRequest;
import com.google.api.services.compute.model.ResourceGroupReference;
import com.google.api.services.compute.model.ResourcePolicy;
import com.google.api.services.compute.model.ResourcePolicyAggregatedList;
import com.google.api.services.compute.model.ResourcePolicyList;
import com.google.api.services.compute.model.Route;
import com.google.api.services.compute.model.RouteList;
import com.google.api.services.compute.model.Router;
import com.google.api.services.compute.model.RouterAggregatedList;
import com.google.api.services.compute.model.RouterList;
import com.google.api.services.compute.model.RouterStatusResponse;
import com.google.api.services.compute.model.RoutersPreviewResponse;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.Screenshot;
import com.google.api.services.compute.model.SecurityPoliciesAggregatedList;
import com.google.api.services.compute.model.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.api.services.compute.model.SecurityPolicy;
import com.google.api.services.compute.model.SecurityPolicyAssociation;
import com.google.api.services.compute.model.SecurityPolicyList;
import com.google.api.services.compute.model.SecurityPolicyReference;
import com.google.api.services.compute.model.SecurityPolicyRule;
import com.google.api.services.compute.model.SerialPortOutput;
import com.google.api.services.compute.model.ServiceAttachment;
import com.google.api.services.compute.model.ServiceAttachmentAggregatedList;
import com.google.api.services.compute.model.ServiceAttachmentList;
import com.google.api.services.compute.model.ShieldedInstanceConfig;
import com.google.api.services.compute.model.ShieldedInstanceIdentity;
import com.google.api.services.compute.model.ShieldedInstanceIntegrityPolicy;
import com.google.api.services.compute.model.ShieldedVmConfig;
import com.google.api.services.compute.model.ShieldedVmIdentity;
import com.google.api.services.compute.model.ShieldedVmIntegrityPolicy;
import com.google.api.services.compute.model.SignedUrlKey;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.SnapshotList;
import com.google.api.services.compute.model.SslCertificate;
import com.google.api.services.compute.model.SslCertificateAggregatedList;
import com.google.api.services.compute.model.SslCertificateList;
import com.google.api.services.compute.model.SslPoliciesAggregatedList;
import com.google.api.services.compute.model.SslPoliciesList;
import com.google.api.services.compute.model.SslPoliciesListAvailableFeaturesResponse;
import com.google.api.services.compute.model.SslPolicy;
import com.google.api.services.compute.model.SslPolicyReference;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.SubnetworkAggregatedList;
import com.google.api.services.compute.model.SubnetworkList;
import com.google.api.services.compute.model.SubnetworksExpandIpCidrRangeRequest;
import com.google.api.services.compute.model.SubnetworksSetPrivateIpGoogleAccessRequest;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.TargetGrpcProxy;
import com.google.api.services.compute.model.TargetGrpcProxyList;
import com.google.api.services.compute.model.TargetHttpProxy;
import com.google.api.services.compute.model.TargetHttpProxyAggregatedList;
import com.google.api.services.compute.model.TargetHttpProxyList;
import com.google.api.services.compute.model.TargetHttpsProxiesSetCertificateMapRequest;
import com.google.api.services.compute.model.TargetHttpsProxiesSetQuicOverrideRequest;
import com.google.api.services.compute.model.TargetHttpsProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetHttpsProxy;
import com.google.api.services.compute.model.TargetHttpsProxyAggregatedList;
import com.google.api.services.compute.model.TargetHttpsProxyList;
import com.google.api.services.compute.model.TargetInstance;
import com.google.api.services.compute.model.TargetInstanceAggregatedList;
import com.google.api.services.compute.model.TargetInstanceList;
import com.google.api.services.compute.model.TargetPool;
import com.google.api.services.compute.model.TargetPoolAggregatedList;
import com.google.api.services.compute.model.TargetPoolInstanceHealth;
import com.google.api.services.compute.model.TargetPoolList;
import com.google.api.services.compute.model.TargetPoolsAddHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsAddInstanceRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveHealthCheckRequest;
import com.google.api.services.compute.model.TargetPoolsRemoveInstanceRequest;
import com.google.api.services.compute.model.TargetReference;
import com.google.api.services.compute.model.TargetSslProxiesSetBackendServiceRequest;
import com.google.api.services.compute.model.TargetSslProxiesSetCertificateMapRequest;
import com.google.api.services.compute.model.TargetSslProxiesSetProxyHeaderRequest;
import com.google.api.services.compute.model.TargetSslProxiesSetSslCertificatesRequest;
import com.google.api.services.compute.model.TargetSslProxy;
import com.google.api.services.compute.model.TargetSslProxyList;
import com.google.api.services.compute.model.TargetTcpProxiesSetBackendServiceRequest;
import com.google.api.services.compute.model.TargetTcpProxiesSetProxyHeaderRequest;
import com.google.api.services.compute.model.TargetTcpProxy;
import com.google.api.services.compute.model.TargetTcpProxyAggregatedList;
import com.google.api.services.compute.model.TargetTcpProxyList;
import com.google.api.services.compute.model.TargetVpnGateway;
import com.google.api.services.compute.model.TargetVpnGatewayAggregatedList;
import com.google.api.services.compute.model.TargetVpnGatewayList;
import com.google.api.services.compute.model.TestPermissionsRequest;
import com.google.api.services.compute.model.TestPermissionsResponse;
import com.google.api.services.compute.model.UrlMap;
import com.google.api.services.compute.model.UrlMapList;
import com.google.api.services.compute.model.UrlMapReference;
import com.google.api.services.compute.model.UrlMapsAggregatedList;
import com.google.api.services.compute.model.UrlMapsValidateRequest;
import com.google.api.services.compute.model.UrlMapsValidateResponse;
import com.google.api.services.compute.model.UsableSubnetworksAggregatedList;
import com.google.api.services.compute.model.UsageExportLocation;
import com.google.api.services.compute.model.VmEndpointNatMappingsList;
import com.google.api.services.compute.model.VpnGateway;
import com.google.api.services.compute.model.VpnGatewayAggregatedList;
import com.google.api.services.compute.model.VpnGatewayList;
import com.google.api.services.compute.model.VpnGatewaysGetStatusResponse;
import com.google.api.services.compute.model.VpnTunnel;
import com.google.api.services.compute.model.VpnTunnelAggregatedList;
import com.google.api.services.compute.model.VpnTunnelList;
import com.google.api.services.compute.model.XpnHostList;
import com.google.api.services.compute.model.Zone;
import com.google.api.services.compute.model.ZoneList;
import com.google.api.services.compute.model.ZoneSetLabelsRequest;
import com.google.api.services.compute.model.ZoneSetPolicyRequest;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class Compute
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://compute.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://compute.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "compute/beta/";
    public static final String DEFAULT_BATCH_PATH = "batch/compute/beta";
    public static final String DEFAULT_BASE_URL = "https://compute.googleapis.com/compute/beta/";

    public Compute(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Compute(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public AcceleratorTypes acceleratorTypes() {
        return new AcceleratorTypes();
    }

    public Addresses addresses() {
        return new Addresses();
    }

    public Autoscalers autoscalers() {
        return new Autoscalers();
    }

    public BackendBuckets backendBuckets() {
        return new BackendBuckets();
    }

    public BackendServices backendServices() {
        return new BackendServices();
    }

    public DiskTypes diskTypes() {
        return new DiskTypes();
    }

    public Disks disks() {
        return new Disks();
    }

    public ExternalVpnGateways externalVpnGateways() {
        return new ExternalVpnGateways();
    }

    public FirewallPolicies firewallPolicies() {
        return new FirewallPolicies();
    }

    public Firewalls firewalls() {
        return new Firewalls();
    }

    public ForwardingRules forwardingRules() {
        return new ForwardingRules();
    }

    public GlobalAddresses globalAddresses() {
        return new GlobalAddresses();
    }

    public GlobalForwardingRules globalForwardingRules() {
        return new GlobalForwardingRules();
    }

    public GlobalNetworkEndpointGroups globalNetworkEndpointGroups() {
        return new GlobalNetworkEndpointGroups();
    }

    public GlobalOperations globalOperations() {
        return new GlobalOperations();
    }

    public GlobalOrganizationOperations globalOrganizationOperations() {
        return new GlobalOrganizationOperations();
    }

    public GlobalPublicDelegatedPrefixes globalPublicDelegatedPrefixes() {
        return new GlobalPublicDelegatedPrefixes();
    }

    public HealthChecks healthChecks() {
        return new HealthChecks();
    }

    public HttpHealthChecks httpHealthChecks() {
        return new HttpHealthChecks();
    }

    public HttpsHealthChecks httpsHealthChecks() {
        return new HttpsHealthChecks();
    }

    public ImageFamilyViews imageFamilyViews() {
        return new ImageFamilyViews();
    }

    public Images images() {
        return new Images();
    }

    public InstanceGroupManagerResizeRequests instanceGroupManagerResizeRequests() {
        return new InstanceGroupManagerResizeRequests();
    }

    public InstanceGroupManagers instanceGroupManagers() {
        return new InstanceGroupManagers();
    }

    public InstanceGroups instanceGroups() {
        return new InstanceGroups();
    }

    public InstanceTemplates instanceTemplates() {
        return new InstanceTemplates();
    }

    public Instances instances() {
        return new Instances();
    }

    public InstantSnapshots instantSnapshots() {
        return new InstantSnapshots();
    }

    public InterconnectAttachments interconnectAttachments() {
        return new InterconnectAttachments();
    }

    public InterconnectLocations interconnectLocations() {
        return new InterconnectLocations();
    }

    public InterconnectRemoteLocations interconnectRemoteLocations() {
        return new InterconnectRemoteLocations();
    }

    public Interconnects interconnects() {
        return new Interconnects();
    }

    public LicenseCodes licenseCodes() {
        return new LicenseCodes();
    }

    public Licenses licenses() {
        return new Licenses();
    }

    public MachineImages machineImages() {
        return new MachineImages();
    }

    public MachineTypes machineTypes() {
        return new MachineTypes();
    }

    public NetworkAttachments networkAttachments() {
        return new NetworkAttachments();
    }

    public NetworkEdgeSecurityServices networkEdgeSecurityServices() {
        return new NetworkEdgeSecurityServices();
    }

    public NetworkEndpointGroups networkEndpointGroups() {
        return new NetworkEndpointGroups();
    }

    public NetworkFirewallPolicies networkFirewallPolicies() {
        return new NetworkFirewallPolicies();
    }

    public Networks networks() {
        return new Networks();
    }

    public NodeGroups nodeGroups() {
        return new NodeGroups();
    }

    public NodeTemplates nodeTemplates() {
        return new NodeTemplates();
    }

    public NodeTypes nodeTypes() {
        return new NodeTypes();
    }

    public OrganizationSecurityPolicies organizationSecurityPolicies() {
        return new OrganizationSecurityPolicies();
    }

    public PacketMirrorings packetMirrorings() {
        return new PacketMirrorings();
    }

    public Projects projects() {
        return new Projects();
    }

    public PublicAdvertisedPrefixes publicAdvertisedPrefixes() {
        return new PublicAdvertisedPrefixes();
    }

    public PublicDelegatedPrefixes publicDelegatedPrefixes() {
        return new PublicDelegatedPrefixes();
    }

    public RegionAutoscalers regionAutoscalers() {
        return new RegionAutoscalers();
    }

    public RegionBackendServices regionBackendServices() {
        return new RegionBackendServices();
    }

    public RegionCommitments regionCommitments() {
        return new RegionCommitments();
    }

    public RegionDiskTypes regionDiskTypes() {
        return new RegionDiskTypes();
    }

    public RegionDisks regionDisks() {
        return new RegionDisks();
    }

    public RegionHealthCheckServices regionHealthCheckServices() {
        return new RegionHealthCheckServices();
    }

    public RegionHealthChecks regionHealthChecks() {
        return new RegionHealthChecks();
    }

    public RegionInstanceGroupManagers regionInstanceGroupManagers() {
        return new RegionInstanceGroupManagers();
    }

    public RegionInstanceGroups regionInstanceGroups() {
        return new RegionInstanceGroups();
    }

    public RegionInstanceTemplates regionInstanceTemplates() {
        return new RegionInstanceTemplates();
    }

    public RegionInstances regionInstances() {
        return new RegionInstances();
    }

    public RegionInstantSnapshots regionInstantSnapshots() {
        return new RegionInstantSnapshots();
    }

    public RegionNetworkEndpointGroups regionNetworkEndpointGroups() {
        return new RegionNetworkEndpointGroups();
    }

    public RegionNetworkFirewallPolicies regionNetworkFirewallPolicies() {
        return new RegionNetworkFirewallPolicies();
    }

    public RegionNotificationEndpoints regionNotificationEndpoints() {
        return new RegionNotificationEndpoints();
    }

    public RegionOperations regionOperations() {
        return new RegionOperations();
    }

    public RegionSecurityPolicies regionSecurityPolicies() {
        return new RegionSecurityPolicies();
    }

    public RegionSslCertificates regionSslCertificates() {
        return new RegionSslCertificates();
    }

    public RegionSslPolicies regionSslPolicies() {
        return new RegionSslPolicies();
    }

    public RegionTargetHttpProxies regionTargetHttpProxies() {
        return new RegionTargetHttpProxies();
    }

    public RegionTargetHttpsProxies regionTargetHttpsProxies() {
        return new RegionTargetHttpsProxies();
    }

    public RegionTargetTcpProxies regionTargetTcpProxies() {
        return new RegionTargetTcpProxies();
    }

    public RegionUrlMaps regionUrlMaps() {
        return new RegionUrlMaps();
    }

    public RegionZones regionZones() {
        return new RegionZones();
    }

    public Regions regions() {
        return new Regions();
    }

    public Reservations reservations() {
        return new Reservations();
    }

    public ResourcePolicies resourcePolicies() {
        return new ResourcePolicies();
    }

    public Routers routers() {
        return new Routers();
    }

    public Routes routes() {
        return new Routes();
    }

    public SecurityPolicies securityPolicies() {
        return new SecurityPolicies();
    }

    public ServiceAttachments serviceAttachments() {
        return new ServiceAttachments();
    }

    public SnapshotSettings snapshotSettings() {
        return new SnapshotSettings();
    }

    public Snapshots snapshots() {
        return new Snapshots();
    }

    public SslCertificates sslCertificates() {
        return new SslCertificates();
    }

    public SslPolicies sslPolicies() {
        return new SslPolicies();
    }

    public Subnetworks subnetworks() {
        return new Subnetworks();
    }

    public TargetGrpcProxies targetGrpcProxies() {
        return new TargetGrpcProxies();
    }

    public TargetHttpProxies targetHttpProxies() {
        return new TargetHttpProxies();
    }

    public TargetHttpsProxies targetHttpsProxies() {
        return new TargetHttpsProxies();
    }

    public TargetInstances targetInstances() {
        return new TargetInstances();
    }

    public TargetPools targetPools() {
        return new TargetPools();
    }

    public TargetSslProxies targetSslProxies() {
        return new TargetSslProxies();
    }

    public TargetTcpProxies targetTcpProxies() {
        return new TargetTcpProxies();
    }

    public TargetVpnGateways targetVpnGateways() {
        return new TargetVpnGateways();
    }

    public UrlMaps urlMaps() {
        return new UrlMaps();
    }

    public VpnGateways vpnGateways() {
        return new VpnGateways();
    }

    public VpnTunnels vpnTunnels() {
        return new VpnTunnels();
    }

    public ZoneOperations zoneOperations() {
        return new ZoneOperations();
    }

    public Zones zones() {
        return new Zones();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Compute Engine API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Compute.DEFAULT_MTLS_ROOT_URL;
            }
            return Compute.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Compute.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Compute.DEFAULT_BATCH_PATH);
        }

        public Compute build() {
            return new Compute(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setComputeRequestInitializer(ComputeRequestInitializer computeRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)computeRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Zones {
        public Get get(String project, String zone) throws IOException {
            Get result = new Get(project, zone);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends ComputeRequest<ZoneList> {
            private static final String REST_PATH = "projects/{project}/zones";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, ZoneList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<Zone> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;

            protected Get(String project, String zone) {
                super(Compute.this, "GET", REST_PATH, null, Zone.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.zone = zone;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class ZoneOperations {
        public Delete delete(String project, String zone, String operation) throws IOException {
            Delete result = new Delete(project, zone, operation);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String zone, String operation) throws IOException {
            Get result = new Get(project, zone, operation);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String zone) throws IOException {
            List result = new List(project, zone);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Wait wait(String project, String zone, String operation) throws IOException {
            Wait result = new Wait(project, zone, operation);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Wait
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/operations/{operation}/wait";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Wait(String project, String zone, String operation) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Wait set$Xgafv(String $Xgafv) {
                return (Wait)super.set$Xgafv($Xgafv);
            }

            public Wait setAccessToken(String accessToken) {
                return (Wait)super.setAccessToken(accessToken);
            }

            public Wait setAlt(String alt) {
                return (Wait)super.setAlt(alt);
            }

            public Wait setCallback(String callback) {
                return (Wait)super.setCallback(callback);
            }

            public Wait setFields(String fields) {
                return (Wait)super.setFields(fields);
            }

            public Wait setKey(String key) {
                return (Wait)super.setKey(key);
            }

            public Wait setOauthToken(String oauthToken) {
                return (Wait)super.setOauthToken(oauthToken);
            }

            public Wait setPrettyPrint(Boolean prettyPrint) {
                return (Wait)super.setPrettyPrint(prettyPrint);
            }

            public Wait setQuotaUser(String quotaUser) {
                return (Wait)super.setQuotaUser(quotaUser);
            }

            public Wait setUploadType(String uploadType) {
                return (Wait)super.setUploadType(uploadType);
            }

            public Wait setUploadProtocol(String uploadProtocol) {
                return (Wait)super.setUploadProtocol(uploadProtocol);
            }

            public Wait setUserIp(String userIp) {
                return (Wait)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Wait setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Wait setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Wait setOperation(String operation) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.operation = operation;
                return this;
            }

            @Override
            public Wait set(String parameterName, Object value) {
                return (Wait)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<OperationList> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/operations";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String zone) {
                super(Compute.this, "GET", REST_PATH, null, OperationList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Get(String project, String zone, String operation) {
                super(Compute.this, "GET", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Get setOperation(String operation) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.operation = operation;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Void> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/operations/{operation}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern OPERATION_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String operation;

            protected Delete(String project, String zone, String operation) {
                super(Compute.this, "DELETE", REST_PATH, null, Void.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.OPERATION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.operation = (String)Preconditions.checkNotNull((Object)operation, (Object)"Required parameter operation must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getOperation() {
                return this.operation;
            }

            public Delete setOperation(String operation) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.OPERATION_PATTERN.matcher(operation).matches(), (Object)"Parameter operation must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.operation = operation;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class VpnTunnels {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String vpnTunnel) throws IOException {
            Delete result = new Delete(project, region, vpnTunnel);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String vpnTunnel) throws IOException {
            Get result = new Get(project, region, vpnTunnel);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, VpnTunnel content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetLabels setLabels(String project, String region, String resource, RegionSetLabelsRequest content) throws IOException {
            SetLabels result = new SetLabels(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetLabels
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels/{resource}/setLabels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;
            @Key
            private String requestId;

            protected SetLabels(String project, String region, String resource, RegionSetLabelsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetLabels set$Xgafv(String $Xgafv) {
                return (SetLabels)super.set$Xgafv($Xgafv);
            }

            public SetLabels setAccessToken(String accessToken) {
                return (SetLabels)super.setAccessToken(accessToken);
            }

            public SetLabels setAlt(String alt) {
                return (SetLabels)super.setAlt(alt);
            }

            public SetLabels setCallback(String callback) {
                return (SetLabels)super.setCallback(callback);
            }

            public SetLabels setFields(String fields) {
                return (SetLabels)super.setFields(fields);
            }

            public SetLabels setKey(String key) {
                return (SetLabels)super.setKey(key);
            }

            public SetLabels setOauthToken(String oauthToken) {
                return (SetLabels)super.setOauthToken(oauthToken);
            }

            public SetLabels setPrettyPrint(Boolean prettyPrint) {
                return (SetLabels)super.setPrettyPrint(prettyPrint);
            }

            public SetLabels setQuotaUser(String quotaUser) {
                return (SetLabels)super.setQuotaUser(quotaUser);
            }

            public SetLabels setUploadType(String uploadType) {
                return (SetLabels)super.setUploadType(uploadType);
            }

            public SetLabels setUploadProtocol(String uploadProtocol) {
                return (SetLabels)super.setUploadProtocol(uploadProtocol);
            }

            public SetLabels setUserIp(String userIp) {
                return (SetLabels)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetLabels setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetLabels setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetLabels setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetLabels setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetLabels set(String parameterName, Object value) {
                return (SetLabels)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<VpnTunnelList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnelList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, VpnTunnel content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<VpnTunnel> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_TUNNEL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnTunnel;

            protected Get(String project, String region, String vpnTunnel) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnel.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_TUNNEL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = (String)Preconditions.checkNotNull((Object)vpnTunnel, (Object)"Required parameter vpnTunnel must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getVpnTunnel() {
                return this.vpnTunnel;
            }

            public Get setVpnTunnel(String vpnTunnel) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.vpnTunnel = vpnTunnel;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnTunnels/{vpnTunnel}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_TUNNEL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnTunnel;
            @Key
            private String requestId;

            protected Delete(String project, String region, String vpnTunnel) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_TUNNEL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnTunnel = (String)Preconditions.checkNotNull((Object)vpnTunnel, (Object)"Required parameter vpnTunnel must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getVpnTunnel() {
                return this.vpnTunnel;
            }

            public Delete setVpnTunnel(String vpnTunnel) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_TUNNEL_PATTERN.matcher(vpnTunnel).matches(), (Object)"Parameter vpnTunnel must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.vpnTunnel = vpnTunnel;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<VpnTunnelAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/vpnTunnels";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, VpnTunnelAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class VpnGateways {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String vpnGateway) throws IOException {
            Delete result = new Delete(project, region, vpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String vpnGateway) throws IOException {
            Get result = new Get(project, region, vpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetStatus getStatus(String project, String region, String vpnGateway) throws IOException {
            GetStatus result = new GetStatus(project, region, vpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, VpnGateway content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetLabels setLabels(String project, String region, String resource, RegionSetLabelsRequest content) throws IOException {
            SetLabels result = new SetLabels(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetLabels
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways/{resource}/setLabels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;
            @Key
            private String requestId;

            protected SetLabels(String project, String region, String resource, RegionSetLabelsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetLabels set$Xgafv(String $Xgafv) {
                return (SetLabels)super.set$Xgafv($Xgafv);
            }

            public SetLabels setAccessToken(String accessToken) {
                return (SetLabels)super.setAccessToken(accessToken);
            }

            public SetLabels setAlt(String alt) {
                return (SetLabels)super.setAlt(alt);
            }

            public SetLabels setCallback(String callback) {
                return (SetLabels)super.setCallback(callback);
            }

            public SetLabels setFields(String fields) {
                return (SetLabels)super.setFields(fields);
            }

            public SetLabels setKey(String key) {
                return (SetLabels)super.setKey(key);
            }

            public SetLabels setOauthToken(String oauthToken) {
                return (SetLabels)super.setOauthToken(oauthToken);
            }

            public SetLabels setPrettyPrint(Boolean prettyPrint) {
                return (SetLabels)super.setPrettyPrint(prettyPrint);
            }

            public SetLabels setQuotaUser(String quotaUser) {
                return (SetLabels)super.setQuotaUser(quotaUser);
            }

            public SetLabels setUploadType(String uploadType) {
                return (SetLabels)super.setUploadType(uploadType);
            }

            public SetLabels setUploadProtocol(String uploadProtocol) {
                return (SetLabels)super.setUploadProtocol(uploadProtocol);
            }

            public SetLabels setUserIp(String userIp) {
                return (SetLabels)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetLabels setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetLabels setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetLabels setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetLabels setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetLabels set(String parameterName, Object value) {
                return (SetLabels)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<VpnGatewayList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, VpnGatewayList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, VpnGateway content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetStatus
        extends ComputeRequest<VpnGatewaysGetStatusResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways/{vpnGateway}/getStatus";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnGateway;

            protected GetStatus(String project, String region, String vpnGateway) {
                super(Compute.this, "GET", REST_PATH, null, VpnGatewaysGetStatusResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnGateway = (String)Preconditions.checkNotNull((Object)vpnGateway, (Object)"Required parameter vpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetStatus set$Xgafv(String $Xgafv) {
                return (GetStatus)super.set$Xgafv($Xgafv);
            }

            public GetStatus setAccessToken(String accessToken) {
                return (GetStatus)super.setAccessToken(accessToken);
            }

            public GetStatus setAlt(String alt) {
                return (GetStatus)super.setAlt(alt);
            }

            public GetStatus setCallback(String callback) {
                return (GetStatus)super.setCallback(callback);
            }

            public GetStatus setFields(String fields) {
                return (GetStatus)super.setFields(fields);
            }

            public GetStatus setKey(String key) {
                return (GetStatus)super.setKey(key);
            }

            public GetStatus setOauthToken(String oauthToken) {
                return (GetStatus)super.setOauthToken(oauthToken);
            }

            public GetStatus setPrettyPrint(Boolean prettyPrint) {
                return (GetStatus)super.setPrettyPrint(prettyPrint);
            }

            public GetStatus setQuotaUser(String quotaUser) {
                return (GetStatus)super.setQuotaUser(quotaUser);
            }

            public GetStatus setUploadType(String uploadType) {
                return (GetStatus)super.setUploadType(uploadType);
            }

            public GetStatus setUploadProtocol(String uploadProtocol) {
                return (GetStatus)super.setUploadProtocol(uploadProtocol);
            }

            public GetStatus setUserIp(String userIp) {
                return (GetStatus)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetStatus setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetStatus setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getVpnGateway() {
                return this.vpnGateway;
            }

            public GetStatus setVpnGateway(String vpnGateway) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.vpnGateway = vpnGateway;
                return this;
            }

            @Override
            public GetStatus set(String parameterName, Object value) {
                return (GetStatus)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<VpnGateway> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways/{vpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnGateway;

            protected Get(String project, String region, String vpnGateway) {
                super(Compute.this, "GET", REST_PATH, null, VpnGateway.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnGateway = (String)Preconditions.checkNotNull((Object)vpnGateway, (Object)"Required parameter vpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getVpnGateway() {
                return this.vpnGateway;
            }

            public Get setVpnGateway(String vpnGateway) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.vpnGateway = vpnGateway;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/vpnGateways/{vpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String vpnGateway;
            @Key
            private String requestId;

            protected Delete(String project, String region, String vpnGateway) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.vpnGateway = (String)Preconditions.checkNotNull((Object)vpnGateway, (Object)"Required parameter vpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getVpnGateway() {
                return this.vpnGateway;
            }

            public Delete setVpnGateway(String vpnGateway) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.VPN_GATEWAY_PATTERN.matcher(vpnGateway).matches(), (Object)"Parameter vpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.vpnGateway = vpnGateway;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<VpnGatewayAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/vpnGateways";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, VpnGatewayAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class UrlMaps {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String urlMap) throws IOException {
            Delete result = new Delete(project, urlMap);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String urlMap) throws IOException {
            Get result = new Get(project, urlMap);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, UrlMap content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public InvalidateCache invalidateCache(String project, String urlMap, CacheInvalidationRule content) throws IOException {
            InvalidateCache result = new InvalidateCache(project, urlMap, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String urlMap, UrlMap content) throws IOException {
            Patch result = new Patch(project, urlMap, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String urlMap, UrlMap content) throws IOException {
            Update result = new Update(project, urlMap, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Validate validate(String project, String urlMap, UrlMapsValidateRequest content) throws IOException {
            Validate result = new Validate(project, urlMap, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Validate
        extends ComputeRequest<UrlMapsValidateResponse> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}/validate";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Validate(String project, String urlMap, UrlMapsValidateRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, UrlMapsValidateResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Validate set$Xgafv(String $Xgafv) {
                return (Validate)super.set$Xgafv($Xgafv);
            }

            public Validate setAccessToken(String accessToken) {
                return (Validate)super.setAccessToken(accessToken);
            }

            public Validate setAlt(String alt) {
                return (Validate)super.setAlt(alt);
            }

            public Validate setCallback(String callback) {
                return (Validate)super.setCallback(callback);
            }

            public Validate setFields(String fields) {
                return (Validate)super.setFields(fields);
            }

            public Validate setKey(String key) {
                return (Validate)super.setKey(key);
            }

            public Validate setOauthToken(String oauthToken) {
                return (Validate)super.setOauthToken(oauthToken);
            }

            public Validate setPrettyPrint(Boolean prettyPrint) {
                return (Validate)super.setPrettyPrint(prettyPrint);
            }

            public Validate setQuotaUser(String quotaUser) {
                return (Validate)super.setQuotaUser(quotaUser);
            }

            public Validate setUploadType(String uploadType) {
                return (Validate)super.setUploadType(uploadType);
            }

            public Validate setUploadProtocol(String uploadProtocol) {
                return (Validate)super.setUploadProtocol(uploadProtocol);
            }

            public Validate setUserIp(String userIp) {
                return (Validate)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Validate setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Validate setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            @Override
            public Validate set(String parameterName, Object value) {
                return (Validate)super.set(parameterName, value);
            }
        }

        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;
            @Key
            private String requestId;

            protected Update(String project, String urlMap, UrlMap content) {
                super(Compute.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Update setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Update setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;
            @Key
            private String requestId;

            protected Patch(String project, String urlMap, UrlMap content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Patch setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<UrlMapList> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, UrlMapList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class InvalidateCache
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}/invalidateCache";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;
            @Key
            private String requestId;

            protected InvalidateCache(String project, String urlMap, CacheInvalidationRule content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public InvalidateCache set$Xgafv(String $Xgafv) {
                return (InvalidateCache)super.set$Xgafv($Xgafv);
            }

            public InvalidateCache setAccessToken(String accessToken) {
                return (InvalidateCache)super.setAccessToken(accessToken);
            }

            public InvalidateCache setAlt(String alt) {
                return (InvalidateCache)super.setAlt(alt);
            }

            public InvalidateCache setCallback(String callback) {
                return (InvalidateCache)super.setCallback(callback);
            }

            public InvalidateCache setFields(String fields) {
                return (InvalidateCache)super.setFields(fields);
            }

            public InvalidateCache setKey(String key) {
                return (InvalidateCache)super.setKey(key);
            }

            public InvalidateCache setOauthToken(String oauthToken) {
                return (InvalidateCache)super.setOauthToken(oauthToken);
            }

            public InvalidateCache setPrettyPrint(Boolean prettyPrint) {
                return (InvalidateCache)super.setPrettyPrint(prettyPrint);
            }

            public InvalidateCache setQuotaUser(String quotaUser) {
                return (InvalidateCache)super.setQuotaUser(quotaUser);
            }

            public InvalidateCache setUploadType(String uploadType) {
                return (InvalidateCache)super.setUploadType(uploadType);
            }

            public InvalidateCache setUploadProtocol(String uploadProtocol) {
                return (InvalidateCache)super.setUploadProtocol(uploadProtocol);
            }

            public InvalidateCache setUserIp(String userIp) {
                return (InvalidateCache)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public InvalidateCache setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public InvalidateCache setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public InvalidateCache setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public InvalidateCache set(String parameterName, Object value) {
                return (InvalidateCache)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, UrlMap content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<UrlMap> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;

            protected Get(String project, String urlMap) {
                super(Compute.this, "GET", REST_PATH, null, UrlMap.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Get setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/urlMaps/{urlMap}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern URL_MAP_PATTERN;
            @Key
            private String project;
            @Key
            private String urlMap;
            @Key
            private String requestId;

            protected Delete(String project, String urlMap) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.URL_MAP_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.urlMap = (String)Preconditions.checkNotNull((Object)urlMap, (Object)"Required parameter urlMap must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getUrlMap() {
                return this.urlMap;
            }

            public Delete setUrlMap(String urlMap) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.URL_MAP_PATTERN.matcher(urlMap).matches(), (Object)"Parameter urlMap must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.urlMap = urlMap;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<UrlMapsAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/urlMaps";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, UrlMapsAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetVpnGateways {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String targetVpnGateway) throws IOException {
            Delete result = new Delete(project, region, targetVpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String targetVpnGateway) throws IOException {
            Get result = new Get(project, region, targetVpnGateway);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, TargetVpnGateway content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetLabels setLabels(String project, String region, String resource, RegionSetLabelsRequest content) throws IOException {
            SetLabels result = new SetLabels(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetLabels
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways/{resource}/setLabels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;
            @Key
            private String requestId;

            protected SetLabels(String project, String region, String resource, RegionSetLabelsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetLabels set$Xgafv(String $Xgafv) {
                return (SetLabels)super.set$Xgafv($Xgafv);
            }

            public SetLabels setAccessToken(String accessToken) {
                return (SetLabels)super.setAccessToken(accessToken);
            }

            public SetLabels setAlt(String alt) {
                return (SetLabels)super.setAlt(alt);
            }

            public SetLabels setCallback(String callback) {
                return (SetLabels)super.setCallback(callback);
            }

            public SetLabels setFields(String fields) {
                return (SetLabels)super.setFields(fields);
            }

            public SetLabels setKey(String key) {
                return (SetLabels)super.setKey(key);
            }

            public SetLabels setOauthToken(String oauthToken) {
                return (SetLabels)super.setOauthToken(oauthToken);
            }

            public SetLabels setPrettyPrint(Boolean prettyPrint) {
                return (SetLabels)super.setPrettyPrint(prettyPrint);
            }

            public SetLabels setQuotaUser(String quotaUser) {
                return (SetLabels)super.setQuotaUser(quotaUser);
            }

            public SetLabels setUploadType(String uploadType) {
                return (SetLabels)super.setUploadType(uploadType);
            }

            public SetLabels setUploadProtocol(String uploadProtocol) {
                return (SetLabels)super.setUploadProtocol(uploadProtocol);
            }

            public SetLabels setUserIp(String userIp) {
                return (SetLabels)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetLabels setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetLabels setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetLabels setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetLabels setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetLabels set(String parameterName, Object value) {
                return (SetLabels)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetVpnGatewayList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGatewayList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, TargetVpnGateway content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetVpnGateway> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetVpnGateway;

            protected Get(String project, String region, String targetVpnGateway) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGateway.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = (String)Preconditions.checkNotNull((Object)targetVpnGateway, (Object)"Required parameter targetVpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetVpnGateway() {
                return this.targetVpnGateway;
            }

            public Get setTargetVpnGateway(String targetVpnGateway) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetVpnGateway = targetVpnGateway;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetVpnGateways/{targetVpnGateway}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_VPN_GATEWAY_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetVpnGateway;
            @Key
            private String requestId;

            protected Delete(String project, String region, String targetVpnGateway) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_VPN_GATEWAY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetVpnGateway = (String)Preconditions.checkNotNull((Object)targetVpnGateway, (Object)"Required parameter targetVpnGateway must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetVpnGateway() {
                return this.targetVpnGateway;
            }

            public Delete setTargetVpnGateway(String targetVpnGateway) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_VPN_GATEWAY_PATTERN.matcher(targetVpnGateway).matches(), (Object)"Parameter targetVpnGateway must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetVpnGateway = targetVpnGateway;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetVpnGatewayAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetVpnGateways";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetVpnGatewayAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetTcpProxies {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String targetTcpProxy) throws IOException {
            Delete result = new Delete(project, targetTcpProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String targetTcpProxy) throws IOException {
            Get result = new Get(project, targetTcpProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, TargetTcpProxy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetBackendService setBackendService(String project, String targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest content) throws IOException {
            SetBackendService result = new SetBackendService(project, targetTcpProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetProxyHeader setProxyHeader(String project, String targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest content) throws IOException {
            SetProxyHeader result = new SetProxyHeader(project, targetTcpProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetProxyHeader
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setProxyHeader";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_TCP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetTcpProxy;
            @Key
            private String requestId;

            protected SetProxyHeader(String project, String targetTcpProxy, TargetTcpProxiesSetProxyHeaderRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_TCP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetTcpProxy = (String)Preconditions.checkNotNull((Object)targetTcpProxy, (Object)"Required parameter targetTcpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetProxyHeader set$Xgafv(String $Xgafv) {
                return (SetProxyHeader)super.set$Xgafv($Xgafv);
            }

            public SetProxyHeader setAccessToken(String accessToken) {
                return (SetProxyHeader)super.setAccessToken(accessToken);
            }

            public SetProxyHeader setAlt(String alt) {
                return (SetProxyHeader)super.setAlt(alt);
            }

            public SetProxyHeader setCallback(String callback) {
                return (SetProxyHeader)super.setCallback(callback);
            }

            public SetProxyHeader setFields(String fields) {
                return (SetProxyHeader)super.setFields(fields);
            }

            public SetProxyHeader setKey(String key) {
                return (SetProxyHeader)super.setKey(key);
            }

            public SetProxyHeader setOauthToken(String oauthToken) {
                return (SetProxyHeader)super.setOauthToken(oauthToken);
            }

            public SetProxyHeader setPrettyPrint(Boolean prettyPrint) {
                return (SetProxyHeader)super.setPrettyPrint(prettyPrint);
            }

            public SetProxyHeader setQuotaUser(String quotaUser) {
                return (SetProxyHeader)super.setQuotaUser(quotaUser);
            }

            public SetProxyHeader setUploadType(String uploadType) {
                return (SetProxyHeader)super.setUploadType(uploadType);
            }

            public SetProxyHeader setUploadProtocol(String uploadProtocol) {
                return (SetProxyHeader)super.setUploadProtocol(uploadProtocol);
            }

            public SetProxyHeader setUserIp(String userIp) {
                return (SetProxyHeader)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetProxyHeader setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetTcpProxy() {
                return this.targetTcpProxy;
            }

            public SetProxyHeader setTargetTcpProxy(String targetTcpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetTcpProxy = targetTcpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetProxyHeader setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetProxyHeader set(String parameterName, Object value) {
                return (SetProxyHeader)super.set(parameterName, value);
            }
        }

        public class SetBackendService
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies/{targetTcpProxy}/setBackendService";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_TCP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetTcpProxy;
            @Key
            private String requestId;

            protected SetBackendService(String project, String targetTcpProxy, TargetTcpProxiesSetBackendServiceRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_TCP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetTcpProxy = (String)Preconditions.checkNotNull((Object)targetTcpProxy, (Object)"Required parameter targetTcpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetBackendService set$Xgafv(String $Xgafv) {
                return (SetBackendService)super.set$Xgafv($Xgafv);
            }

            public SetBackendService setAccessToken(String accessToken) {
                return (SetBackendService)super.setAccessToken(accessToken);
            }

            public SetBackendService setAlt(String alt) {
                return (SetBackendService)super.setAlt(alt);
            }

            public SetBackendService setCallback(String callback) {
                return (SetBackendService)super.setCallback(callback);
            }

            public SetBackendService setFields(String fields) {
                return (SetBackendService)super.setFields(fields);
            }

            public SetBackendService setKey(String key) {
                return (SetBackendService)super.setKey(key);
            }

            public SetBackendService setOauthToken(String oauthToken) {
                return (SetBackendService)super.setOauthToken(oauthToken);
            }

            public SetBackendService setPrettyPrint(Boolean prettyPrint) {
                return (SetBackendService)super.setPrettyPrint(prettyPrint);
            }

            public SetBackendService setQuotaUser(String quotaUser) {
                return (SetBackendService)super.setQuotaUser(quotaUser);
            }

            public SetBackendService setUploadType(String uploadType) {
                return (SetBackendService)super.setUploadType(uploadType);
            }

            public SetBackendService setUploadProtocol(String uploadProtocol) {
                return (SetBackendService)super.setUploadProtocol(uploadProtocol);
            }

            public SetBackendService setUserIp(String userIp) {
                return (SetBackendService)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetBackendService setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetTcpProxy() {
                return this.targetTcpProxy;
            }

            public SetBackendService setTargetTcpProxy(String targetTcpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetTcpProxy = targetTcpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetBackendService setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetBackendService set(String parameterName, Object value) {
                return (SetBackendService)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetTcpProxyList> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetTcpProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, TargetTcpProxy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetTcpProxy> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies/{targetTcpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_TCP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetTcpProxy;

            protected Get(String project, String targetTcpProxy) {
                super(Compute.this, "GET", REST_PATH, null, TargetTcpProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_TCP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetTcpProxy = (String)Preconditions.checkNotNull((Object)targetTcpProxy, (Object)"Required parameter targetTcpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetTcpProxy() {
                return this.targetTcpProxy;
            }

            public Get setTargetTcpProxy(String targetTcpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetTcpProxy = targetTcpProxy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetTcpProxies/{targetTcpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_TCP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetTcpProxy;
            @Key
            private String requestId;

            protected Delete(String project, String targetTcpProxy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_TCP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetTcpProxy = (String)Preconditions.checkNotNull((Object)targetTcpProxy, (Object)"Required parameter targetTcpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetTcpProxy() {
                return this.targetTcpProxy;
            }

            public Delete setTargetTcpProxy(String targetTcpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_TCP_PROXY_PATTERN.matcher(targetTcpProxy).matches(), (Object)"Parameter targetTcpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetTcpProxy = targetTcpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetTcpProxyAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetTcpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetTcpProxyAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetSslProxies {
        public Delete delete(String project, String targetSslProxy) throws IOException {
            Delete result = new Delete(project, targetSslProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String targetSslProxy) throws IOException {
            Get result = new Get(project, targetSslProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, TargetSslProxy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetBackendService setBackendService(String project, String targetSslProxy, TargetSslProxiesSetBackendServiceRequest content) throws IOException {
            SetBackendService result = new SetBackendService(project, targetSslProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetCertificateMap setCertificateMap(String project, String targetSslProxy, TargetSslProxiesSetCertificateMapRequest content) throws IOException {
            SetCertificateMap result = new SetCertificateMap(project, targetSslProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetProxyHeader setProxyHeader(String project, String targetSslProxy, TargetSslProxiesSetProxyHeaderRequest content) throws IOException {
            SetProxyHeader result = new SetProxyHeader(project, targetSslProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSslCertificates setSslCertificates(String project, String targetSslProxy, TargetSslProxiesSetSslCertificatesRequest content) throws IOException {
            SetSslCertificates result = new SetSslCertificates(project, targetSslProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSslPolicy setSslPolicy(String project, String targetSslProxy, SslPolicyReference content) throws IOException {
            SetSslPolicy result = new SetSslPolicy(project, targetSslProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetSslPolicy
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslPolicy";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected SetSslPolicy(String project, String targetSslProxy, SslPolicyReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
            }

            public SetSslPolicy set$Xgafv(String $Xgafv) {
                return (SetSslPolicy)super.set$Xgafv($Xgafv);
            }

            public SetSslPolicy setAccessToken(String accessToken) {
                return (SetSslPolicy)super.setAccessToken(accessToken);
            }

            public SetSslPolicy setAlt(String alt) {
                return (SetSslPolicy)super.setAlt(alt);
            }

            public SetSslPolicy setCallback(String callback) {
                return (SetSslPolicy)super.setCallback(callback);
            }

            public SetSslPolicy setFields(String fields) {
                return (SetSslPolicy)super.setFields(fields);
            }

            public SetSslPolicy setKey(String key) {
                return (SetSslPolicy)super.setKey(key);
            }

            public SetSslPolicy setOauthToken(String oauthToken) {
                return (SetSslPolicy)super.setOauthToken(oauthToken);
            }

            public SetSslPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetSslPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetSslPolicy setQuotaUser(String quotaUser) {
                return (SetSslPolicy)super.setQuotaUser(quotaUser);
            }

            public SetSslPolicy setUploadType(String uploadType) {
                return (SetSslPolicy)super.setUploadType(uploadType);
            }

            public SetSslPolicy setUploadProtocol(String uploadProtocol) {
                return (SetSslPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetSslPolicy setUserIp(String userIp) {
                return (SetSslPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSslPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public SetSslPolicy setTargetSslProxy(String targetSslProxy) {
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSslPolicy setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSslPolicy set(String parameterName, Object value) {
                return (SetSslPolicy)super.set(parameterName, value);
            }
        }

        public class SetSslCertificates
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}/setSslCertificates";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_SSL_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected SetSslCertificates(String project, String targetSslProxy, TargetSslProxiesSetSslCertificatesRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_SSL_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetSslCertificates set$Xgafv(String $Xgafv) {
                return (SetSslCertificates)super.set$Xgafv($Xgafv);
            }

            public SetSslCertificates setAccessToken(String accessToken) {
                return (SetSslCertificates)super.setAccessToken(accessToken);
            }

            public SetSslCertificates setAlt(String alt) {
                return (SetSslCertificates)super.setAlt(alt);
            }

            public SetSslCertificates setCallback(String callback) {
                return (SetSslCertificates)super.setCallback(callback);
            }

            public SetSslCertificates setFields(String fields) {
                return (SetSslCertificates)super.setFields(fields);
            }

            public SetSslCertificates setKey(String key) {
                return (SetSslCertificates)super.setKey(key);
            }

            public SetSslCertificates setOauthToken(String oauthToken) {
                return (SetSslCertificates)super.setOauthToken(oauthToken);
            }

            public SetSslCertificates setPrettyPrint(Boolean prettyPrint) {
                return (SetSslCertificates)super.setPrettyPrint(prettyPrint);
            }

            public SetSslCertificates setQuotaUser(String quotaUser) {
                return (SetSslCertificates)super.setQuotaUser(quotaUser);
            }

            public SetSslCertificates setUploadType(String uploadType) {
                return (SetSslCertificates)super.setUploadType(uploadType);
            }

            public SetSslCertificates setUploadProtocol(String uploadProtocol) {
                return (SetSslCertificates)super.setUploadProtocol(uploadProtocol);
            }

            public SetSslCertificates setUserIp(String userIp) {
                return (SetSslCertificates)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSslCertificates setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public SetSslCertificates setTargetSslProxy(String targetSslProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSslCertificates setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSslCertificates set(String parameterName, Object value) {
                return (SetSslCertificates)super.set(parameterName, value);
            }
        }

        public class SetProxyHeader
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}/setProxyHeader";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_SSL_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected SetProxyHeader(String project, String targetSslProxy, TargetSslProxiesSetProxyHeaderRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_SSL_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetProxyHeader set$Xgafv(String $Xgafv) {
                return (SetProxyHeader)super.set$Xgafv($Xgafv);
            }

            public SetProxyHeader setAccessToken(String accessToken) {
                return (SetProxyHeader)super.setAccessToken(accessToken);
            }

            public SetProxyHeader setAlt(String alt) {
                return (SetProxyHeader)super.setAlt(alt);
            }

            public SetProxyHeader setCallback(String callback) {
                return (SetProxyHeader)super.setCallback(callback);
            }

            public SetProxyHeader setFields(String fields) {
                return (SetProxyHeader)super.setFields(fields);
            }

            public SetProxyHeader setKey(String key) {
                return (SetProxyHeader)super.setKey(key);
            }

            public SetProxyHeader setOauthToken(String oauthToken) {
                return (SetProxyHeader)super.setOauthToken(oauthToken);
            }

            public SetProxyHeader setPrettyPrint(Boolean prettyPrint) {
                return (SetProxyHeader)super.setPrettyPrint(prettyPrint);
            }

            public SetProxyHeader setQuotaUser(String quotaUser) {
                return (SetProxyHeader)super.setQuotaUser(quotaUser);
            }

            public SetProxyHeader setUploadType(String uploadType) {
                return (SetProxyHeader)super.setUploadType(uploadType);
            }

            public SetProxyHeader setUploadProtocol(String uploadProtocol) {
                return (SetProxyHeader)super.setUploadProtocol(uploadProtocol);
            }

            public SetProxyHeader setUserIp(String userIp) {
                return (SetProxyHeader)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetProxyHeader setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public SetProxyHeader setTargetSslProxy(String targetSslProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetProxyHeader setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetProxyHeader set(String parameterName, Object value) {
                return (SetProxyHeader)super.set(parameterName, value);
            }
        }

        public class SetCertificateMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}/setCertificateMap";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected SetCertificateMap(String project, String targetSslProxy, TargetSslProxiesSetCertificateMapRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
            }

            public SetCertificateMap set$Xgafv(String $Xgafv) {
                return (SetCertificateMap)super.set$Xgafv($Xgafv);
            }

            public SetCertificateMap setAccessToken(String accessToken) {
                return (SetCertificateMap)super.setAccessToken(accessToken);
            }

            public SetCertificateMap setAlt(String alt) {
                return (SetCertificateMap)super.setAlt(alt);
            }

            public SetCertificateMap setCallback(String callback) {
                return (SetCertificateMap)super.setCallback(callback);
            }

            public SetCertificateMap setFields(String fields) {
                return (SetCertificateMap)super.setFields(fields);
            }

            public SetCertificateMap setKey(String key) {
                return (SetCertificateMap)super.setKey(key);
            }

            public SetCertificateMap setOauthToken(String oauthToken) {
                return (SetCertificateMap)super.setOauthToken(oauthToken);
            }

            public SetCertificateMap setPrettyPrint(Boolean prettyPrint) {
                return (SetCertificateMap)super.setPrettyPrint(prettyPrint);
            }

            public SetCertificateMap setQuotaUser(String quotaUser) {
                return (SetCertificateMap)super.setQuotaUser(quotaUser);
            }

            public SetCertificateMap setUploadType(String uploadType) {
                return (SetCertificateMap)super.setUploadType(uploadType);
            }

            public SetCertificateMap setUploadProtocol(String uploadProtocol) {
                return (SetCertificateMap)super.setUploadProtocol(uploadProtocol);
            }

            public SetCertificateMap setUserIp(String userIp) {
                return (SetCertificateMap)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetCertificateMap setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public SetCertificateMap setTargetSslProxy(String targetSslProxy) {
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetCertificateMap setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetCertificateMap set(String parameterName, Object value) {
                return (SetCertificateMap)super.set(parameterName, value);
            }
        }

        public class SetBackendService
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}/setBackendService";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_SSL_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected SetBackendService(String project, String targetSslProxy, TargetSslProxiesSetBackendServiceRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_SSL_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetBackendService set$Xgafv(String $Xgafv) {
                return (SetBackendService)super.set$Xgafv($Xgafv);
            }

            public SetBackendService setAccessToken(String accessToken) {
                return (SetBackendService)super.setAccessToken(accessToken);
            }

            public SetBackendService setAlt(String alt) {
                return (SetBackendService)super.setAlt(alt);
            }

            public SetBackendService setCallback(String callback) {
                return (SetBackendService)super.setCallback(callback);
            }

            public SetBackendService setFields(String fields) {
                return (SetBackendService)super.setFields(fields);
            }

            public SetBackendService setKey(String key) {
                return (SetBackendService)super.setKey(key);
            }

            public SetBackendService setOauthToken(String oauthToken) {
                return (SetBackendService)super.setOauthToken(oauthToken);
            }

            public SetBackendService setPrettyPrint(Boolean prettyPrint) {
                return (SetBackendService)super.setPrettyPrint(prettyPrint);
            }

            public SetBackendService setQuotaUser(String quotaUser) {
                return (SetBackendService)super.setQuotaUser(quotaUser);
            }

            public SetBackendService setUploadType(String uploadType) {
                return (SetBackendService)super.setUploadType(uploadType);
            }

            public SetBackendService setUploadProtocol(String uploadProtocol) {
                return (SetBackendService)super.setUploadProtocol(uploadProtocol);
            }

            public SetBackendService setUserIp(String userIp) {
                return (SetBackendService)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetBackendService setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public SetBackendService setTargetSslProxy(String targetSslProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetBackendService setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetBackendService set(String parameterName, Object value) {
                return (SetBackendService)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetSslProxyList> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetSslProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, TargetSslProxy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetSslProxy> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_SSL_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;

            protected Get(String project, String targetSslProxy) {
                super(Compute.this, "GET", REST_PATH, null, TargetSslProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_SSL_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public Get setTargetSslProxy(String targetSslProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetSslProxies/{targetSslProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_SSL_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetSslProxy;
            @Key
            private String requestId;

            protected Delete(String project, String targetSslProxy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_SSL_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetSslProxy = (String)Preconditions.checkNotNull((Object)targetSslProxy, (Object)"Required parameter targetSslProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetSslProxy() {
                return this.targetSslProxy;
            }

            public Delete setTargetSslProxy(String targetSslProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_SSL_PROXY_PATTERN.matcher(targetSslProxy).matches(), (Object)"Parameter targetSslProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetSslProxy = targetSslProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class TargetPools {
        public AddHealthCheck addHealthCheck(String project, String region, String targetPool, TargetPoolsAddHealthCheckRequest content) throws IOException {
            AddHealthCheck result = new AddHealthCheck(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AddInstance addInstance(String project, String region, String targetPool, TargetPoolsAddInstanceRequest content) throws IOException {
            AddInstance result = new AddInstance(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String targetPool) throws IOException {
            Delete result = new Delete(project, region, targetPool);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String targetPool) throws IOException {
            Get result = new Get(project, region, targetPool);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetHealth getHealth(String project, String region, String targetPool, InstanceReference content) throws IOException {
            GetHealth result = new GetHealth(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, TargetPool content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RemoveHealthCheck removeHealthCheck(String project, String region, String targetPool, TargetPoolsRemoveHealthCheckRequest content) throws IOException {
            RemoveHealthCheck result = new RemoveHealthCheck(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RemoveInstance removeInstance(String project, String region, String targetPool, TargetPoolsRemoveInstanceRequest content) throws IOException {
            RemoveInstance result = new RemoveInstance(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetBackup setBackup(String project, String region, String targetPool, TargetReference content) throws IOException {
            SetBackup result = new SetBackup(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSecurityPolicy setSecurityPolicy(String project, String region, String targetPool, SecurityPolicyReference content) throws IOException {
            SetSecurityPolicy result = new SetSecurityPolicy(project, region, targetPool, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetSecurityPolicy
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/setSecurityPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected SetSecurityPolicy(String project, String region, String targetPool, SecurityPolicyReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
            }

            public SetSecurityPolicy set$Xgafv(String $Xgafv) {
                return (SetSecurityPolicy)super.set$Xgafv($Xgafv);
            }

            public SetSecurityPolicy setAccessToken(String accessToken) {
                return (SetSecurityPolicy)super.setAccessToken(accessToken);
            }

            public SetSecurityPolicy setAlt(String alt) {
                return (SetSecurityPolicy)super.setAlt(alt);
            }

            public SetSecurityPolicy setCallback(String callback) {
                return (SetSecurityPolicy)super.setCallback(callback);
            }

            public SetSecurityPolicy setFields(String fields) {
                return (SetSecurityPolicy)super.setFields(fields);
            }

            public SetSecurityPolicy setKey(String key) {
                return (SetSecurityPolicy)super.setKey(key);
            }

            public SetSecurityPolicy setOauthToken(String oauthToken) {
                return (SetSecurityPolicy)super.setOauthToken(oauthToken);
            }

            public SetSecurityPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetSecurityPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetSecurityPolicy setQuotaUser(String quotaUser) {
                return (SetSecurityPolicy)super.setQuotaUser(quotaUser);
            }

            public SetSecurityPolicy setUploadType(String uploadType) {
                return (SetSecurityPolicy)super.setUploadType(uploadType);
            }

            public SetSecurityPolicy setUploadProtocol(String uploadProtocol) {
                return (SetSecurityPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetSecurityPolicy setUserIp(String userIp) {
                return (SetSecurityPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSecurityPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetSecurityPolicy setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public SetSecurityPolicy setTargetPool(String targetPool) {
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSecurityPolicy setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSecurityPolicy set(String parameterName, Object value) {
                return (SetSecurityPolicy)super.set(parameterName, value);
            }
        }

        public class SetBackup
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/setBackup";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private Float failoverRatio;
            @Key
            private String requestId;

            protected SetBackup(String project, String region, String targetPool, TargetReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetBackup set$Xgafv(String $Xgafv) {
                return (SetBackup)super.set$Xgafv($Xgafv);
            }

            public SetBackup setAccessToken(String accessToken) {
                return (SetBackup)super.setAccessToken(accessToken);
            }

            public SetBackup setAlt(String alt) {
                return (SetBackup)super.setAlt(alt);
            }

            public SetBackup setCallback(String callback) {
                return (SetBackup)super.setCallback(callback);
            }

            public SetBackup setFields(String fields) {
                return (SetBackup)super.setFields(fields);
            }

            public SetBackup setKey(String key) {
                return (SetBackup)super.setKey(key);
            }

            public SetBackup setOauthToken(String oauthToken) {
                return (SetBackup)super.setOauthToken(oauthToken);
            }

            public SetBackup setPrettyPrint(Boolean prettyPrint) {
                return (SetBackup)super.setPrettyPrint(prettyPrint);
            }

            public SetBackup setQuotaUser(String quotaUser) {
                return (SetBackup)super.setQuotaUser(quotaUser);
            }

            public SetBackup setUploadType(String uploadType) {
                return (SetBackup)super.setUploadType(uploadType);
            }

            public SetBackup setUploadProtocol(String uploadProtocol) {
                return (SetBackup)super.setUploadProtocol(uploadProtocol);
            }

            public SetBackup setUserIp(String userIp) {
                return (SetBackup)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetBackup setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetBackup setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public SetBackup setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public Float getFailoverRatio() {
                return this.failoverRatio;
            }

            public SetBackup setFailoverRatio(Float failoverRatio) {
                this.failoverRatio = failoverRatio;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetBackup setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetBackup set(String parameterName, Object value) {
                return (SetBackup)super.set(parameterName, value);
            }
        }

        public class RemoveInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/removeInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected RemoveInstance(String project, String region, String targetPool, TargetPoolsRemoveInstanceRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public RemoveInstance set$Xgafv(String $Xgafv) {
                return (RemoveInstance)super.set$Xgafv($Xgafv);
            }

            public RemoveInstance setAccessToken(String accessToken) {
                return (RemoveInstance)super.setAccessToken(accessToken);
            }

            public RemoveInstance setAlt(String alt) {
                return (RemoveInstance)super.setAlt(alt);
            }

            public RemoveInstance setCallback(String callback) {
                return (RemoveInstance)super.setCallback(callback);
            }

            public RemoveInstance setFields(String fields) {
                return (RemoveInstance)super.setFields(fields);
            }

            public RemoveInstance setKey(String key) {
                return (RemoveInstance)super.setKey(key);
            }

            public RemoveInstance setOauthToken(String oauthToken) {
                return (RemoveInstance)super.setOauthToken(oauthToken);
            }

            public RemoveInstance setPrettyPrint(Boolean prettyPrint) {
                return (RemoveInstance)super.setPrettyPrint(prettyPrint);
            }

            public RemoveInstance setQuotaUser(String quotaUser) {
                return (RemoveInstance)super.setQuotaUser(quotaUser);
            }

            public RemoveInstance setUploadType(String uploadType) {
                return (RemoveInstance)super.setUploadType(uploadType);
            }

            public RemoveInstance setUploadProtocol(String uploadProtocol) {
                return (RemoveInstance)super.setUploadProtocol(uploadProtocol);
            }

            public RemoveInstance setUserIp(String userIp) {
                return (RemoveInstance)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveInstance setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveInstance setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveInstance setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public RemoveInstance setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public RemoveInstance set(String parameterName, Object value) {
                return (RemoveInstance)super.set(parameterName, value);
            }
        }

        public class RemoveHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/removeHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected RemoveHealthCheck(String project, String region, String targetPool, TargetPoolsRemoveHealthCheckRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public RemoveHealthCheck set$Xgafv(String $Xgafv) {
                return (RemoveHealthCheck)super.set$Xgafv($Xgafv);
            }

            public RemoveHealthCheck setAccessToken(String accessToken) {
                return (RemoveHealthCheck)super.setAccessToken(accessToken);
            }

            public RemoveHealthCheck setAlt(String alt) {
                return (RemoveHealthCheck)super.setAlt(alt);
            }

            public RemoveHealthCheck setCallback(String callback) {
                return (RemoveHealthCheck)super.setCallback(callback);
            }

            public RemoveHealthCheck setFields(String fields) {
                return (RemoveHealthCheck)super.setFields(fields);
            }

            public RemoveHealthCheck setKey(String key) {
                return (RemoveHealthCheck)super.setKey(key);
            }

            public RemoveHealthCheck setOauthToken(String oauthToken) {
                return (RemoveHealthCheck)super.setOauthToken(oauthToken);
            }

            public RemoveHealthCheck setPrettyPrint(Boolean prettyPrint) {
                return (RemoveHealthCheck)super.setPrettyPrint(prettyPrint);
            }

            public RemoveHealthCheck setQuotaUser(String quotaUser) {
                return (RemoveHealthCheck)super.setQuotaUser(quotaUser);
            }

            public RemoveHealthCheck setUploadType(String uploadType) {
                return (RemoveHealthCheck)super.setUploadType(uploadType);
            }

            public RemoveHealthCheck setUploadProtocol(String uploadProtocol) {
                return (RemoveHealthCheck)super.setUploadProtocol(uploadProtocol);
            }

            public RemoveHealthCheck setUserIp(String userIp) {
                return (RemoveHealthCheck)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveHealthCheck setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public RemoveHealthCheck setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public RemoveHealthCheck setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public RemoveHealthCheck setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public RemoveHealthCheck set(String parameterName, Object value) {
                return (RemoveHealthCheck)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetPoolList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, TargetPool content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetHealth
        extends ComputeRequest<TargetPoolInstanceHealth> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/getHealth";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected GetHealth(String project, String region, String targetPool, InstanceReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TargetPoolInstanceHealth.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public GetHealth set$Xgafv(String $Xgafv) {
                return (GetHealth)super.set$Xgafv($Xgafv);
            }

            public GetHealth setAccessToken(String accessToken) {
                return (GetHealth)super.setAccessToken(accessToken);
            }

            public GetHealth setAlt(String alt) {
                return (GetHealth)super.setAlt(alt);
            }

            public GetHealth setCallback(String callback) {
                return (GetHealth)super.setCallback(callback);
            }

            public GetHealth setFields(String fields) {
                return (GetHealth)super.setFields(fields);
            }

            public GetHealth setKey(String key) {
                return (GetHealth)super.setKey(key);
            }

            public GetHealth setOauthToken(String oauthToken) {
                return (GetHealth)super.setOauthToken(oauthToken);
            }

            public GetHealth setPrettyPrint(Boolean prettyPrint) {
                return (GetHealth)super.setPrettyPrint(prettyPrint);
            }

            public GetHealth setQuotaUser(String quotaUser) {
                return (GetHealth)super.setQuotaUser(quotaUser);
            }

            public GetHealth setUploadType(String uploadType) {
                return (GetHealth)super.setUploadType(uploadType);
            }

            public GetHealth setUploadProtocol(String uploadProtocol) {
                return (GetHealth)super.setUploadProtocol(uploadProtocol);
            }

            public GetHealth setUserIp(String userIp) {
                return (GetHealth)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetHealth setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetHealth setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public GetHealth setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            @Override
            public GetHealth set(String parameterName, Object value) {
                return (GetHealth)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetPool> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;

            protected Get(String project, String region, String targetPool) {
                super(Compute.this, "GET", REST_PATH, null, TargetPool.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Get setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected Delete(String project, String region, String targetPool) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public Delete setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetPoolAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetPools";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetPoolAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }

        public class AddInstance
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/addInstance";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected AddInstance(String project, String region, String targetPool, TargetPoolsAddInstanceRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public AddInstance set$Xgafv(String $Xgafv) {
                return (AddInstance)super.set$Xgafv($Xgafv);
            }

            public AddInstance setAccessToken(String accessToken) {
                return (AddInstance)super.setAccessToken(accessToken);
            }

            public AddInstance setAlt(String alt) {
                return (AddInstance)super.setAlt(alt);
            }

            public AddInstance setCallback(String callback) {
                return (AddInstance)super.setCallback(callback);
            }

            public AddInstance setFields(String fields) {
                return (AddInstance)super.setFields(fields);
            }

            public AddInstance setKey(String key) {
                return (AddInstance)super.setKey(key);
            }

            public AddInstance setOauthToken(String oauthToken) {
                return (AddInstance)super.setOauthToken(oauthToken);
            }

            public AddInstance setPrettyPrint(Boolean prettyPrint) {
                return (AddInstance)super.setPrettyPrint(prettyPrint);
            }

            public AddInstance setQuotaUser(String quotaUser) {
                return (AddInstance)super.setQuotaUser(quotaUser);
            }

            public AddInstance setUploadType(String uploadType) {
                return (AddInstance)super.setUploadType(uploadType);
            }

            public AddInstance setUploadProtocol(String uploadProtocol) {
                return (AddInstance)super.setUploadProtocol(uploadProtocol);
            }

            public AddInstance setUserIp(String userIp) {
                return (AddInstance)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AddInstance setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddInstance setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddInstance setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public AddInstance setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public AddInstance set(String parameterName, Object value) {
                return (AddInstance)super.set(parameterName, value);
            }
        }

        public class AddHealthCheck
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/targetPools/{targetPool}/addHealthCheck";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern TARGET_POOL_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String targetPool;
            @Key
            private String requestId;

            protected AddHealthCheck(String project, String region, String targetPool, TargetPoolsAddHealthCheckRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_POOL_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetPool = (String)Preconditions.checkNotNull((Object)targetPool, (Object)"Required parameter targetPool must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public AddHealthCheck set$Xgafv(String $Xgafv) {
                return (AddHealthCheck)super.set$Xgafv($Xgafv);
            }

            public AddHealthCheck setAccessToken(String accessToken) {
                return (AddHealthCheck)super.setAccessToken(accessToken);
            }

            public AddHealthCheck setAlt(String alt) {
                return (AddHealthCheck)super.setAlt(alt);
            }

            public AddHealthCheck setCallback(String callback) {
                return (AddHealthCheck)super.setCallback(callback);
            }

            public AddHealthCheck setFields(String fields) {
                return (AddHealthCheck)super.setFields(fields);
            }

            public AddHealthCheck setKey(String key) {
                return (AddHealthCheck)super.setKey(key);
            }

            public AddHealthCheck setOauthToken(String oauthToken) {
                return (AddHealthCheck)super.setOauthToken(oauthToken);
            }

            public AddHealthCheck setPrettyPrint(Boolean prettyPrint) {
                return (AddHealthCheck)super.setPrettyPrint(prettyPrint);
            }

            public AddHealthCheck setQuotaUser(String quotaUser) {
                return (AddHealthCheck)super.setQuotaUser(quotaUser);
            }

            public AddHealthCheck setUploadType(String uploadType) {
                return (AddHealthCheck)super.setUploadType(uploadType);
            }

            public AddHealthCheck setUploadProtocol(String uploadProtocol) {
                return (AddHealthCheck)super.setUploadProtocol(uploadProtocol);
            }

            public AddHealthCheck setUserIp(String userIp) {
                return (AddHealthCheck)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AddHealthCheck setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public AddHealthCheck setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getTargetPool() {
                return this.targetPool;
            }

            public AddHealthCheck setTargetPool(String targetPool) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_POOL_PATTERN.matcher(targetPool).matches(), (Object)"Parameter targetPool must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetPool = targetPool;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public AddHealthCheck setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public AddHealthCheck set(String parameterName, Object value) {
                return (AddHealthCheck)super.set(parameterName, value);
            }
        }
    }

    public class TargetInstances {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String zone, String targetInstance) throws IOException {
            Delete result = new Delete(project, zone, targetInstance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String zone, String targetInstance) throws IOException {
            Get result = new Get(project, zone, targetInstance);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String zone, TargetInstance content) throws IOException {
            Insert result = new Insert(project, zone, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String zone) throws IOException {
            List result = new List(project, zone);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSecurityPolicy setSecurityPolicy(String project, String zone, String targetInstance, SecurityPolicyReference content) throws IOException {
            SetSecurityPolicy result = new SetSecurityPolicy(project, zone, targetInstance, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String zone, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, zone, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String zone, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public TestIamPermissions setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetSecurityPolicy
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances/{targetInstance}/setSecurityPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;
            @Key
            private String requestId;

            protected SetSecurityPolicy(String project, String zone, String targetInstance, SecurityPolicyReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)targetInstance, (Object)"Required parameter targetInstance must be specified.");
            }

            public SetSecurityPolicy set$Xgafv(String $Xgafv) {
                return (SetSecurityPolicy)super.set$Xgafv($Xgafv);
            }

            public SetSecurityPolicy setAccessToken(String accessToken) {
                return (SetSecurityPolicy)super.setAccessToken(accessToken);
            }

            public SetSecurityPolicy setAlt(String alt) {
                return (SetSecurityPolicy)super.setAlt(alt);
            }

            public SetSecurityPolicy setCallback(String callback) {
                return (SetSecurityPolicy)super.setCallback(callback);
            }

            public SetSecurityPolicy setFields(String fields) {
                return (SetSecurityPolicy)super.setFields(fields);
            }

            public SetSecurityPolicy setKey(String key) {
                return (SetSecurityPolicy)super.setKey(key);
            }

            public SetSecurityPolicy setOauthToken(String oauthToken) {
                return (SetSecurityPolicy)super.setOauthToken(oauthToken);
            }

            public SetSecurityPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetSecurityPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetSecurityPolicy setQuotaUser(String quotaUser) {
                return (SetSecurityPolicy)super.setQuotaUser(quotaUser);
            }

            public SetSecurityPolicy setUploadType(String uploadType) {
                return (SetSecurityPolicy)super.setUploadType(uploadType);
            }

            public SetSecurityPolicy setUploadProtocol(String uploadProtocol) {
                return (SetSecurityPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetSecurityPolicy setUserIp(String userIp) {
                return (SetSecurityPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSecurityPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public SetSecurityPolicy setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public SetSecurityPolicy setTargetInstance(String targetInstance) {
                this.targetInstance = targetInstance;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSecurityPolicy setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSecurityPolicy set(String parameterName, Object value) {
                return (SetSecurityPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetInstanceList> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String zone) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public List setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String requestId;

            protected Insert(String project, String zone, TargetInstance content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Insert setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetInstance> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGET_INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;

            protected Get(String project, String zone, String targetInstance) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstance.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)targetInstance, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Get setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Get setTargetInstance(String targetInstance) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetInstance = targetInstance;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/zones/{zone}/targetInstances/{targetInstance}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ZONE_PATTERN;
            private final Pattern TARGET_INSTANCE_PATTERN;
            @Key
            private String project;
            @Key
            private String zone;
            @Key
            private String targetInstance;
            @Key
            private String requestId;

            protected Delete(String project, String zone, String targetInstance) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ZONE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.TARGET_INSTANCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.zone = (String)Preconditions.checkNotNull((Object)zone, (Object)"Required parameter zone must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.targetInstance = (String)Preconditions.checkNotNull((Object)targetInstance, (Object)"Required parameter targetInstance must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getZone() {
                return this.zone;
            }

            public Delete setZone(String zone) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ZONE_PATTERN.matcher(zone).matches(), (Object)"Parameter zone must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.zone = zone;
                return this;
            }

            public String getTargetInstance() {
                return this.targetInstance;
            }

            public Delete setTargetInstance(String targetInstance) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_INSTANCE_PATTERN.matcher(targetInstance).matches(), (Object)"Parameter targetInstance must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetInstance = targetInstance;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetInstanceAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetInstances";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetInstanceAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetHttpsProxies {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String targetHttpsProxy) throws IOException {
            Delete result = new Delete(project, targetHttpsProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String targetHttpsProxy) throws IOException {
            Get result = new Get(project, targetHttpsProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, TargetHttpsProxy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String targetHttpsProxy, TargetHttpsProxy content) throws IOException {
            Patch result = new Patch(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetCertificateMap setCertificateMap(String project, String targetHttpsProxy, TargetHttpsProxiesSetCertificateMapRequest content) throws IOException {
            SetCertificateMap result = new SetCertificateMap(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetQuicOverride setQuicOverride(String project, String targetHttpsProxy, TargetHttpsProxiesSetQuicOverrideRequest content) throws IOException {
            SetQuicOverride result = new SetQuicOverride(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSslCertificates setSslCertificates(String project, String targetHttpsProxy, TargetHttpsProxiesSetSslCertificatesRequest content) throws IOException {
            SetSslCertificates result = new SetSslCertificates(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetSslPolicy setSslPolicy(String project, String targetHttpsProxy, SslPolicyReference content) throws IOException {
            SetSslPolicy result = new SetSslPolicy(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetUrlMap setUrlMap(String project, String targetHttpsProxy, UrlMapReference content) throws IOException {
            SetUrlMap result = new SetUrlMap(project, targetHttpsProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetUrlMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setUrlMap";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected SetUrlMap(String project, String targetHttpsProxy, UrlMapReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetUrlMap set$Xgafv(String $Xgafv) {
                return (SetUrlMap)super.set$Xgafv($Xgafv);
            }

            public SetUrlMap setAccessToken(String accessToken) {
                return (SetUrlMap)super.setAccessToken(accessToken);
            }

            public SetUrlMap setAlt(String alt) {
                return (SetUrlMap)super.setAlt(alt);
            }

            public SetUrlMap setCallback(String callback) {
                return (SetUrlMap)super.setCallback(callback);
            }

            public SetUrlMap setFields(String fields) {
                return (SetUrlMap)super.setFields(fields);
            }

            public SetUrlMap setKey(String key) {
                return (SetUrlMap)super.setKey(key);
            }

            public SetUrlMap setOauthToken(String oauthToken) {
                return (SetUrlMap)super.setOauthToken(oauthToken);
            }

            public SetUrlMap setPrettyPrint(Boolean prettyPrint) {
                return (SetUrlMap)super.setPrettyPrint(prettyPrint);
            }

            public SetUrlMap setQuotaUser(String quotaUser) {
                return (SetUrlMap)super.setQuotaUser(quotaUser);
            }

            public SetUrlMap setUploadType(String uploadType) {
                return (SetUrlMap)super.setUploadType(uploadType);
            }

            public SetUrlMap setUploadProtocol(String uploadProtocol) {
                return (SetUrlMap)super.setUploadProtocol(uploadProtocol);
            }

            public SetUrlMap setUserIp(String userIp) {
                return (SetUrlMap)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetUrlMap setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetUrlMap setTargetHttpsProxy(String targetHttpsProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetUrlMap setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetUrlMap set(String parameterName, Object value) {
                return (SetUrlMap)super.set(parameterName, value);
            }
        }

        public class SetSslPolicy
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setSslPolicy";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected SetSslPolicy(String project, String targetHttpsProxy, SslPolicyReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
            }

            public SetSslPolicy set$Xgafv(String $Xgafv) {
                return (SetSslPolicy)super.set$Xgafv($Xgafv);
            }

            public SetSslPolicy setAccessToken(String accessToken) {
                return (SetSslPolicy)super.setAccessToken(accessToken);
            }

            public SetSslPolicy setAlt(String alt) {
                return (SetSslPolicy)super.setAlt(alt);
            }

            public SetSslPolicy setCallback(String callback) {
                return (SetSslPolicy)super.setCallback(callback);
            }

            public SetSslPolicy setFields(String fields) {
                return (SetSslPolicy)super.setFields(fields);
            }

            public SetSslPolicy setKey(String key) {
                return (SetSslPolicy)super.setKey(key);
            }

            public SetSslPolicy setOauthToken(String oauthToken) {
                return (SetSslPolicy)super.setOauthToken(oauthToken);
            }

            public SetSslPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetSslPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetSslPolicy setQuotaUser(String quotaUser) {
                return (SetSslPolicy)super.setQuotaUser(quotaUser);
            }

            public SetSslPolicy setUploadType(String uploadType) {
                return (SetSslPolicy)super.setUploadType(uploadType);
            }

            public SetSslPolicy setUploadProtocol(String uploadProtocol) {
                return (SetSslPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetSslPolicy setUserIp(String userIp) {
                return (SetSslPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSslPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetSslPolicy setTargetHttpsProxy(String targetHttpsProxy) {
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSslPolicy setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSslPolicy set(String parameterName, Object value) {
                return (SetSslPolicy)super.set(parameterName, value);
            }
        }

        public class SetSslCertificates
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/targetHttpsProxies/{targetHttpsProxy}/setSslCertificates";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected SetSslCertificates(String project, String targetHttpsProxy, TargetHttpsProxiesSetSslCertificatesRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetSslCertificates set$Xgafv(String $Xgafv) {
                return (SetSslCertificates)super.set$Xgafv($Xgafv);
            }

            public SetSslCertificates setAccessToken(String accessToken) {
                return (SetSslCertificates)super.setAccessToken(accessToken);
            }

            public SetSslCertificates setAlt(String alt) {
                return (SetSslCertificates)super.setAlt(alt);
            }

            public SetSslCertificates setCallback(String callback) {
                return (SetSslCertificates)super.setCallback(callback);
            }

            public SetSslCertificates setFields(String fields) {
                return (SetSslCertificates)super.setFields(fields);
            }

            public SetSslCertificates setKey(String key) {
                return (SetSslCertificates)super.setKey(key);
            }

            public SetSslCertificates setOauthToken(String oauthToken) {
                return (SetSslCertificates)super.setOauthToken(oauthToken);
            }

            public SetSslCertificates setPrettyPrint(Boolean prettyPrint) {
                return (SetSslCertificates)super.setPrettyPrint(prettyPrint);
            }

            public SetSslCertificates setQuotaUser(String quotaUser) {
                return (SetSslCertificates)super.setQuotaUser(quotaUser);
            }

            public SetSslCertificates setUploadType(String uploadType) {
                return (SetSslCertificates)super.setUploadType(uploadType);
            }

            public SetSslCertificates setUploadProtocol(String uploadProtocol) {
                return (SetSslCertificates)super.setUploadProtocol(uploadProtocol);
            }

            public SetSslCertificates setUserIp(String userIp) {
                return (SetSslCertificates)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetSslCertificates setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetSslCertificates setTargetHttpsProxy(String targetHttpsProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetSslCertificates setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetSslCertificates set(String parameterName, Object value) {
                return (SetSslCertificates)super.set(parameterName, value);
            }
        }

        public class SetQuicOverride
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setQuicOverride";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected SetQuicOverride(String project, String targetHttpsProxy, TargetHttpsProxiesSetQuicOverrideRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
            }

            public SetQuicOverride set$Xgafv(String $Xgafv) {
                return (SetQuicOverride)super.set$Xgafv($Xgafv);
            }

            public SetQuicOverride setAccessToken(String accessToken) {
                return (SetQuicOverride)super.setAccessToken(accessToken);
            }

            public SetQuicOverride setAlt(String alt) {
                return (SetQuicOverride)super.setAlt(alt);
            }

            public SetQuicOverride setCallback(String callback) {
                return (SetQuicOverride)super.setCallback(callback);
            }

            public SetQuicOverride setFields(String fields) {
                return (SetQuicOverride)super.setFields(fields);
            }

            public SetQuicOverride setKey(String key) {
                return (SetQuicOverride)super.setKey(key);
            }

            public SetQuicOverride setOauthToken(String oauthToken) {
                return (SetQuicOverride)super.setOauthToken(oauthToken);
            }

            public SetQuicOverride setPrettyPrint(Boolean prettyPrint) {
                return (SetQuicOverride)super.setPrettyPrint(prettyPrint);
            }

            public SetQuicOverride setQuotaUser(String quotaUser) {
                return (SetQuicOverride)super.setQuotaUser(quotaUser);
            }

            public SetQuicOverride setUploadType(String uploadType) {
                return (SetQuicOverride)super.setUploadType(uploadType);
            }

            public SetQuicOverride setUploadProtocol(String uploadProtocol) {
                return (SetQuicOverride)super.setUploadProtocol(uploadProtocol);
            }

            public SetQuicOverride setUserIp(String userIp) {
                return (SetQuicOverride)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetQuicOverride setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetQuicOverride setTargetHttpsProxy(String targetHttpsProxy) {
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetQuicOverride setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetQuicOverride set(String parameterName, Object value) {
                return (SetQuicOverride)super.set(parameterName, value);
            }
        }

        public class SetCertificateMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}/setCertificateMap";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected SetCertificateMap(String project, String targetHttpsProxy, TargetHttpsProxiesSetCertificateMapRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
            }

            public SetCertificateMap set$Xgafv(String $Xgafv) {
                return (SetCertificateMap)super.set$Xgafv($Xgafv);
            }

            public SetCertificateMap setAccessToken(String accessToken) {
                return (SetCertificateMap)super.setAccessToken(accessToken);
            }

            public SetCertificateMap setAlt(String alt) {
                return (SetCertificateMap)super.setAlt(alt);
            }

            public SetCertificateMap setCallback(String callback) {
                return (SetCertificateMap)super.setCallback(callback);
            }

            public SetCertificateMap setFields(String fields) {
                return (SetCertificateMap)super.setFields(fields);
            }

            public SetCertificateMap setKey(String key) {
                return (SetCertificateMap)super.setKey(key);
            }

            public SetCertificateMap setOauthToken(String oauthToken) {
                return (SetCertificateMap)super.setOauthToken(oauthToken);
            }

            public SetCertificateMap setPrettyPrint(Boolean prettyPrint) {
                return (SetCertificateMap)super.setPrettyPrint(prettyPrint);
            }

            public SetCertificateMap setQuotaUser(String quotaUser) {
                return (SetCertificateMap)super.setQuotaUser(quotaUser);
            }

            public SetCertificateMap setUploadType(String uploadType) {
                return (SetCertificateMap)super.setUploadType(uploadType);
            }

            public SetCertificateMap setUploadProtocol(String uploadProtocol) {
                return (SetCertificateMap)super.setUploadProtocol(uploadProtocol);
            }

            public SetCertificateMap setUserIp(String userIp) {
                return (SetCertificateMap)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetCertificateMap setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public SetCertificateMap setTargetHttpsProxy(String targetHttpsProxy) {
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetCertificateMap setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetCertificateMap set(String parameterName, Object value) {
                return (SetCertificateMap)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected Patch(String project, String targetHttpsProxy, TargetHttpsProxy content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public Patch setTargetHttpsProxy(String targetHttpsProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetHttpsProxyList> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpsProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, TargetHttpsProxy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetHttpsProxy> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;

            protected Get(String project, String targetHttpsProxy) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpsProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public Get setTargetHttpsProxy(String targetHttpsProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpsProxies/{targetHttpsProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTPS_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpsProxy;
            @Key
            private String requestId;

            protected Delete(String project, String targetHttpsProxy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTPS_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpsProxy = (String)Preconditions.checkNotNull((Object)targetHttpsProxy, (Object)"Required parameter targetHttpsProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpsProxy() {
                return this.targetHttpsProxy;
            }

            public Delete setTargetHttpsProxy(String targetHttpsProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTPS_PROXY_PATTERN.matcher(targetHttpsProxy).matches(), (Object)"Parameter targetHttpsProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpsProxy = targetHttpsProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetHttpsProxyAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetHttpsProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpsProxyAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetHttpProxies {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String targetHttpProxy) throws IOException {
            Delete result = new Delete(project, targetHttpProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String targetHttpProxy) throws IOException {
            Get result = new Get(project, targetHttpProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, TargetHttpProxy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String targetHttpProxy, TargetHttpProxy content) throws IOException {
            Patch result = new Patch(project, targetHttpProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetUrlMap setUrlMap(String project, String targetHttpProxy, UrlMapReference content) throws IOException {
            SetUrlMap result = new SetUrlMap(project, targetHttpProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetUrlMap
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/targetHttpProxies/{targetHttpProxy}/setUrlMap";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;
            @Key
            private String requestId;

            protected SetUrlMap(String project, String targetHttpProxy, UrlMapReference content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)targetHttpProxy, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetUrlMap set$Xgafv(String $Xgafv) {
                return (SetUrlMap)super.set$Xgafv($Xgafv);
            }

            public SetUrlMap setAccessToken(String accessToken) {
                return (SetUrlMap)super.setAccessToken(accessToken);
            }

            public SetUrlMap setAlt(String alt) {
                return (SetUrlMap)super.setAlt(alt);
            }

            public SetUrlMap setCallback(String callback) {
                return (SetUrlMap)super.setCallback(callback);
            }

            public SetUrlMap setFields(String fields) {
                return (SetUrlMap)super.setFields(fields);
            }

            public SetUrlMap setKey(String key) {
                return (SetUrlMap)super.setKey(key);
            }

            public SetUrlMap setOauthToken(String oauthToken) {
                return (SetUrlMap)super.setOauthToken(oauthToken);
            }

            public SetUrlMap setPrettyPrint(Boolean prettyPrint) {
                return (SetUrlMap)super.setPrettyPrint(prettyPrint);
            }

            public SetUrlMap setQuotaUser(String quotaUser) {
                return (SetUrlMap)super.setQuotaUser(quotaUser);
            }

            public SetUrlMap setUploadType(String uploadType) {
                return (SetUrlMap)super.setUploadType(uploadType);
            }

            public SetUrlMap setUploadProtocol(String uploadProtocol) {
                return (SetUrlMap)super.setUploadProtocol(uploadProtocol);
            }

            public SetUrlMap setUserIp(String userIp) {
                return (SetUrlMap)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetUrlMap setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public SetUrlMap setTargetHttpProxy(String targetHttpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpProxy = targetHttpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetUrlMap setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetUrlMap set(String parameterName, Object value) {
                return (SetUrlMap)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies/{targetHttpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;
            @Key
            private String requestId;

            protected Patch(String project, String targetHttpProxy, TargetHttpProxy content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)targetHttpProxy, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public Patch setTargetHttpProxy(String targetHttpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpProxy = targetHttpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetHttpProxyList> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, TargetHttpProxy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetHttpProxy> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies/{targetHttpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;

            protected Get(String project, String targetHttpProxy) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)targetHttpProxy, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public Get setTargetHttpProxy(String targetHttpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpProxy = targetHttpProxy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetHttpProxies/{targetHttpProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_HTTP_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetHttpProxy;
            @Key
            private String requestId;

            protected Delete(String project, String targetHttpProxy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_HTTP_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetHttpProxy = (String)Preconditions.checkNotNull((Object)targetHttpProxy, (Object)"Required parameter targetHttpProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetHttpProxy() {
                return this.targetHttpProxy;
            }

            public Delete setTargetHttpProxy(String targetHttpProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_HTTP_PROXY_PATTERN.matcher(targetHttpProxy).matches(), (Object)"Parameter targetHttpProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetHttpProxy = targetHttpProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<TargetHttpProxyAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/targetHttpProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetHttpProxyAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class TargetGrpcProxies {
        public Delete delete(String project, String targetGrpcProxy) throws IOException {
            Delete result = new Delete(project, targetGrpcProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String targetGrpcProxy) throws IOException {
            Get result = new Get(project, targetGrpcProxy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, TargetGrpcProxy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String targetGrpcProxy, TargetGrpcProxy content) throws IOException {
            Patch result = new Patch(project, targetGrpcProxy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_GRPC_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetGrpcProxy;
            @Key
            private String requestId;

            protected Patch(String project, String targetGrpcProxy, TargetGrpcProxy content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_GRPC_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetGrpcProxy = (String)Preconditions.checkNotNull((Object)targetGrpcProxy, (Object)"Required parameter targetGrpcProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetGrpcProxy() {
                return this.targetGrpcProxy;
            }

            public Patch setTargetGrpcProxy(String targetGrpcProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetGrpcProxy = targetGrpcProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<TargetGrpcProxyList> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, TargetGrpcProxyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, TargetGrpcProxy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<TargetGrpcProxy> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_GRPC_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetGrpcProxy;

            protected Get(String project, String targetGrpcProxy) {
                super(Compute.this, "GET", REST_PATH, null, TargetGrpcProxy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_GRPC_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetGrpcProxy = (String)Preconditions.checkNotNull((Object)targetGrpcProxy, (Object)"Required parameter targetGrpcProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetGrpcProxy() {
                return this.targetGrpcProxy;
            }

            public Get setTargetGrpcProxy(String targetGrpcProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetGrpcProxy = targetGrpcProxy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/targetGrpcProxies/{targetGrpcProxy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern TARGET_GRPC_PROXY_PATTERN;
            @Key
            private String project;
            @Key
            private String targetGrpcProxy;
            @Key
            private String requestId;

            protected Delete(String project, String targetGrpcProxy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.TARGET_GRPC_PROXY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.targetGrpcProxy = (String)Preconditions.checkNotNull((Object)targetGrpcProxy, (Object)"Required parameter targetGrpcProxy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getTargetGrpcProxy() {
                return this.targetGrpcProxy;
            }

            public Delete setTargetGrpcProxy(String targetGrpcProxy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.TARGET_GRPC_PROXY_PATTERN.matcher(targetGrpcProxy).matches(), (Object)"Parameter targetGrpcProxy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.targetGrpcProxy = targetGrpcProxy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Subnetworks {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String subnetwork) throws IOException {
            Delete result = new Delete(project, region, subnetwork);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ExpandIpCidrRange expandIpCidrRange(String project, String region, String subnetwork, SubnetworksExpandIpCidrRangeRequest content) throws IOException {
            ExpandIpCidrRange result = new ExpandIpCidrRange(project, region, subnetwork, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String subnetwork) throws IOException {
            Get result = new Get(project, region, subnetwork);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String project, String region, String resource) throws IOException {
            GetIamPolicy result = new GetIamPolicy(project, region, resource);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, Subnetwork content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListUsable listUsable(String project) throws IOException {
            ListUsable result = new ListUsable(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String region, String subnetwork, Subnetwork content) throws IOException {
            Patch result = new Patch(project, region, subnetwork, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetPrivateIpGoogleAccess setPrivateIpGoogleAccess(String project, String region, String subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest content) throws IOException {
            SetPrivateIpGoogleAccess result = new SetPrivateIpGoogleAccess(project, region, subnetwork, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetPrivateIpGoogleAccess
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{subnetwork}/setPrivateIpGoogleAccess";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;
            @Key
            private String requestId;

            protected SetPrivateIpGoogleAccess(String project, String region, String subnetwork, SubnetworksSetPrivateIpGoogleAccessRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetPrivateIpGoogleAccess set$Xgafv(String $Xgafv) {
                return (SetPrivateIpGoogleAccess)super.set$Xgafv($Xgafv);
            }

            public SetPrivateIpGoogleAccess setAccessToken(String accessToken) {
                return (SetPrivateIpGoogleAccess)super.setAccessToken(accessToken);
            }

            public SetPrivateIpGoogleAccess setAlt(String alt) {
                return (SetPrivateIpGoogleAccess)super.setAlt(alt);
            }

            public SetPrivateIpGoogleAccess setCallback(String callback) {
                return (SetPrivateIpGoogleAccess)super.setCallback(callback);
            }

            public SetPrivateIpGoogleAccess setFields(String fields) {
                return (SetPrivateIpGoogleAccess)super.setFields(fields);
            }

            public SetPrivateIpGoogleAccess setKey(String key) {
                return (SetPrivateIpGoogleAccess)super.setKey(key);
            }

            public SetPrivateIpGoogleAccess setOauthToken(String oauthToken) {
                return (SetPrivateIpGoogleAccess)super.setOauthToken(oauthToken);
            }

            public SetPrivateIpGoogleAccess setPrettyPrint(Boolean prettyPrint) {
                return (SetPrivateIpGoogleAccess)super.setPrettyPrint(prettyPrint);
            }

            public SetPrivateIpGoogleAccess setQuotaUser(String quotaUser) {
                return (SetPrivateIpGoogleAccess)super.setQuotaUser(quotaUser);
            }

            public SetPrivateIpGoogleAccess setUploadType(String uploadType) {
                return (SetPrivateIpGoogleAccess)super.setUploadType(uploadType);
            }

            public SetPrivateIpGoogleAccess setUploadProtocol(String uploadProtocol) {
                return (SetPrivateIpGoogleAccess)super.setUploadProtocol(uploadProtocol);
            }

            public SetPrivateIpGoogleAccess setUserIp(String userIp) {
                return (SetPrivateIpGoogleAccess)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetPrivateIpGoogleAccess setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetPrivateIpGoogleAccess setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public SetPrivateIpGoogleAccess setSubnetwork(String subnetwork) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.subnetwork = subnetwork;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public SetPrivateIpGoogleAccess setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public SetPrivateIpGoogleAccess set(String parameterName, Object value) {
                return (SetPrivateIpGoogleAccess)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected SetIamPolicy(String project, String region, String resource, RegionSetPolicyRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetIamPolicy setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{subnetwork}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;
            @Key
            private Integer drainTimeoutSeconds;
            @Key
            private String requestId;

            protected Patch(String project, String region, String subnetwork, Subnetwork content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Patch setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public Patch setSubnetwork(String subnetwork) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.subnetwork = subnetwork;
                return this;
            }

            public Integer getDrainTimeoutSeconds() {
                return this.drainTimeoutSeconds;
            }

            public Patch setDrainTimeoutSeconds(Integer drainTimeoutSeconds) {
                this.drainTimeoutSeconds = drainTimeoutSeconds;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class ListUsable
        extends ComputeRequest<UsableSubnetworksAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/subnetworks/listUsable";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;
            @Key
            private String serviceProject;

            protected ListUsable(String project) {
                super(Compute.this, "GET", REST_PATH, null, UsableSubnetworksAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListUsable set$Xgafv(String $Xgafv) {
                return (ListUsable)super.set$Xgafv($Xgafv);
            }

            public ListUsable setAccessToken(String accessToken) {
                return (ListUsable)super.setAccessToken(accessToken);
            }

            public ListUsable setAlt(String alt) {
                return (ListUsable)super.setAlt(alt);
            }

            public ListUsable setCallback(String callback) {
                return (ListUsable)super.setCallback(callback);
            }

            public ListUsable setFields(String fields) {
                return (ListUsable)super.setFields(fields);
            }

            public ListUsable setKey(String key) {
                return (ListUsable)super.setKey(key);
            }

            public ListUsable setOauthToken(String oauthToken) {
                return (ListUsable)super.setOauthToken(oauthToken);
            }

            public ListUsable setPrettyPrint(Boolean prettyPrint) {
                return (ListUsable)super.setPrettyPrint(prettyPrint);
            }

            public ListUsable setQuotaUser(String quotaUser) {
                return (ListUsable)super.setQuotaUser(quotaUser);
            }

            public ListUsable setUploadType(String uploadType) {
                return (ListUsable)super.setUploadType(uploadType);
            }

            public ListUsable setUploadProtocol(String uploadProtocol) {
                return (ListUsable)super.setUploadProtocol(uploadProtocol);
            }

            public ListUsable setUserIp(String userIp) {
                return (ListUsable)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public ListUsable setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListUsable setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListUsable setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public ListUsable setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListUsable setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public ListUsable setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            public String getServiceProject() {
                return this.serviceProject;
            }

            public ListUsable setServiceProject(String serviceProject) {
                this.serviceProject = serviceProject;
                return this;
            }

            @Override
            public ListUsable set(String parameterName, Object value) {
                return (ListUsable)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<SubnetworkList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, SubnetworkList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, Subnetwork content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;
            @Key
            private Integer optionsRequestedPolicyVersion;

            protected GetIamPolicy(String project, String region, String resource) {
                super(Compute.this, "GET", REST_PATH, null, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetIamPolicy setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<Subnetwork> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{subnetwork}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;

            protected Get(String project, String region, String subnetwork) {
                super(Compute.this, "GET", REST_PATH, null, Subnetwork.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public Get setSubnetwork(String subnetwork) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.subnetwork = subnetwork;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class ExpandIpCidrRange
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{subnetwork}/expandIpCidrRange";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;
            @Key
            private String requestId;

            protected ExpandIpCidrRange(String project, String region, String subnetwork, SubnetworksExpandIpCidrRangeRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public ExpandIpCidrRange set$Xgafv(String $Xgafv) {
                return (ExpandIpCidrRange)super.set$Xgafv($Xgafv);
            }

            public ExpandIpCidrRange setAccessToken(String accessToken) {
                return (ExpandIpCidrRange)super.setAccessToken(accessToken);
            }

            public ExpandIpCidrRange setAlt(String alt) {
                return (ExpandIpCidrRange)super.setAlt(alt);
            }

            public ExpandIpCidrRange setCallback(String callback) {
                return (ExpandIpCidrRange)super.setCallback(callback);
            }

            public ExpandIpCidrRange setFields(String fields) {
                return (ExpandIpCidrRange)super.setFields(fields);
            }

            public ExpandIpCidrRange setKey(String key) {
                return (ExpandIpCidrRange)super.setKey(key);
            }

            public ExpandIpCidrRange setOauthToken(String oauthToken) {
                return (ExpandIpCidrRange)super.setOauthToken(oauthToken);
            }

            public ExpandIpCidrRange setPrettyPrint(Boolean prettyPrint) {
                return (ExpandIpCidrRange)super.setPrettyPrint(prettyPrint);
            }

            public ExpandIpCidrRange setQuotaUser(String quotaUser) {
                return (ExpandIpCidrRange)super.setQuotaUser(quotaUser);
            }

            public ExpandIpCidrRange setUploadType(String uploadType) {
                return (ExpandIpCidrRange)super.setUploadType(uploadType);
            }

            public ExpandIpCidrRange setUploadProtocol(String uploadProtocol) {
                return (ExpandIpCidrRange)super.setUploadProtocol(uploadProtocol);
            }

            public ExpandIpCidrRange setUserIp(String userIp) {
                return (ExpandIpCidrRange)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public ExpandIpCidrRange setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public ExpandIpCidrRange setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public ExpandIpCidrRange setSubnetwork(String subnetwork) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.subnetwork = subnetwork;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public ExpandIpCidrRange setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public ExpandIpCidrRange set(String parameterName, Object value) {
                return (ExpandIpCidrRange)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/subnetworks/{subnetwork}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SUBNETWORK_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String subnetwork;
            @Key
            private String requestId;

            protected Delete(String project, String region, String subnetwork) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SUBNETWORK_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.subnetwork = (String)Preconditions.checkNotNull((Object)subnetwork, (Object)"Required parameter subnetwork must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getSubnetwork() {
                return this.subnetwork;
            }

            public Delete setSubnetwork(String subnetwork) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SUBNETWORK_PATTERN.matcher(subnetwork).matches(), (Object)"Parameter subnetwork must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.subnetwork = subnetwork;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<SubnetworkAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/subnetworks";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, SubnetworkAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class SslPolicies {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String sslPolicy) throws IOException {
            Delete result = new Delete(project, sslPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String sslPolicy) throws IOException {
            Get result = new Get(project, sslPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, SslPolicy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListAvailableFeatures listAvailableFeatures(String project) throws IOException {
            ListAvailableFeatures result = new ListAvailableFeatures(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String sslPolicy, SslPolicy content) throws IOException {
            Patch result = new Patch(project, sslPolicy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies/{sslPolicy}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String sslPolicy;
            @Key
            private String requestId;

            protected Patch(String project, String sslPolicy, SslPolicy content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslPolicy = (String)Preconditions.checkNotNull((Object)sslPolicy, (Object)"Required parameter sslPolicy must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSslPolicy() {
                return this.sslPolicy;
            }

            public Patch setSslPolicy(String sslPolicy) {
                this.sslPolicy = sslPolicy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class ListAvailableFeatures
        extends ComputeRequest<SslPoliciesListAvailableFeaturesResponse> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies/listAvailableFeatures";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected ListAvailableFeatures(String project) {
                super(Compute.this, "GET", REST_PATH, null, SslPoliciesListAvailableFeaturesResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListAvailableFeatures set$Xgafv(String $Xgafv) {
                return (ListAvailableFeatures)super.set$Xgafv($Xgafv);
            }

            public ListAvailableFeatures setAccessToken(String accessToken) {
                return (ListAvailableFeatures)super.setAccessToken(accessToken);
            }

            public ListAvailableFeatures setAlt(String alt) {
                return (ListAvailableFeatures)super.setAlt(alt);
            }

            public ListAvailableFeatures setCallback(String callback) {
                return (ListAvailableFeatures)super.setCallback(callback);
            }

            public ListAvailableFeatures setFields(String fields) {
                return (ListAvailableFeatures)super.setFields(fields);
            }

            public ListAvailableFeatures setKey(String key) {
                return (ListAvailableFeatures)super.setKey(key);
            }

            public ListAvailableFeatures setOauthToken(String oauthToken) {
                return (ListAvailableFeatures)super.setOauthToken(oauthToken);
            }

            public ListAvailableFeatures setPrettyPrint(Boolean prettyPrint) {
                return (ListAvailableFeatures)super.setPrettyPrint(prettyPrint);
            }

            public ListAvailableFeatures setQuotaUser(String quotaUser) {
                return (ListAvailableFeatures)super.setQuotaUser(quotaUser);
            }

            public ListAvailableFeatures setUploadType(String uploadType) {
                return (ListAvailableFeatures)super.setUploadType(uploadType);
            }

            public ListAvailableFeatures setUploadProtocol(String uploadProtocol) {
                return (ListAvailableFeatures)super.setUploadProtocol(uploadProtocol);
            }

            public ListAvailableFeatures setUserIp(String userIp) {
                return (ListAvailableFeatures)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public ListAvailableFeatures setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListAvailableFeatures setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListAvailableFeatures setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public ListAvailableFeatures setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListAvailableFeatures setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public ListAvailableFeatures setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public ListAvailableFeatures set(String parameterName, Object value) {
                return (ListAvailableFeatures)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<SslPoliciesList> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, SslPoliciesList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, SslPolicy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<SslPolicy> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies/{sslPolicy}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String sslPolicy;

            protected Get(String project, String sslPolicy) {
                super(Compute.this, "GET", REST_PATH, null, SslPolicy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslPolicy = (String)Preconditions.checkNotNull((Object)sslPolicy, (Object)"Required parameter sslPolicy must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSslPolicy() {
                return this.sslPolicy;
            }

            public Get setSslPolicy(String sslPolicy) {
                this.sslPolicy = sslPolicy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/sslPolicies/{sslPolicy}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String sslPolicy;
            @Key
            private String requestId;

            protected Delete(String project, String sslPolicy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslPolicy = (String)Preconditions.checkNotNull((Object)sslPolicy, (Object)"Required parameter sslPolicy must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSslPolicy() {
                return this.sslPolicy;
            }

            public Delete setSslPolicy(String sslPolicy) {
                this.sslPolicy = sslPolicy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<SslPoliciesAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/sslPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, SslPoliciesAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class SslCertificates {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String sslCertificate) throws IOException {
            Delete result = new Delete(project, sslCertificate);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String sslCertificate) throws IOException {
            Get result = new Get(project, sslCertificate);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, SslCertificate content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/sslCertificates/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<SslCertificateList> {
            private static final String REST_PATH = "projects/{project}/global/sslCertificates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, SslCertificateList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/sslCertificates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, SslCertificate content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<SslCertificate> {
            private static final String REST_PATH = "projects/{project}/global/sslCertificates/{sslCertificate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SSL_CERTIFICATE_PATTERN;
            @Key
            private String project;
            @Key
            private String sslCertificate;

            protected Get(String project, String sslCertificate) {
                super(Compute.this, "GET", REST_PATH, null, SslCertificate.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SSL_CERTIFICATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslCertificate = (String)Preconditions.checkNotNull((Object)sslCertificate, (Object)"Required parameter sslCertificate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(sslCertificate).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSslCertificate() {
                return this.sslCertificate;
            }

            public Get setSslCertificate(String sslCertificate) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(sslCertificate).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.sslCertificate = sslCertificate;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/sslCertificates/{sslCertificate}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SSL_CERTIFICATE_PATTERN;
            @Key
            private String project;
            @Key
            private String sslCertificate;
            @Key
            private String requestId;

            protected Delete(String project, String sslCertificate) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SSL_CERTIFICATE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.sslCertificate = (String)Preconditions.checkNotNull((Object)sslCertificate, (Object)"Required parameter sslCertificate must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(sslCertificate).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSslCertificate() {
                return this.sslCertificate;
            }

            public Delete setSslCertificate(String sslCertificate) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SSL_CERTIFICATE_PATTERN.matcher(sslCertificate).matches(), (Object)"Parameter sslCertificate must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.sslCertificate = sslCertificate;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<SslCertificateAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/sslCertificates";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, SslCertificateAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class Snapshots {
        public Delete delete(String project, String snapshot) throws IOException {
            Delete result = new Delete(project, snapshot);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String snapshot) throws IOException {
            Get result = new Get(project, snapshot);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String project, String resource) throws IOException {
            GetIamPolicy result = new GetIamPolicy(project, resource);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, Snapshot content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String project, String resource, GlobalSetPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetLabels setLabels(String project, String resource, GlobalSetLabelsRequest content) throws IOException {
            SetLabels result = new SetLabels(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetLabels
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{resource}/setLabels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected SetLabels(String project, String resource, GlobalSetLabelsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetLabels set$Xgafv(String $Xgafv) {
                return (SetLabels)super.set$Xgafv($Xgafv);
            }

            public SetLabels setAccessToken(String accessToken) {
                return (SetLabels)super.setAccessToken(accessToken);
            }

            public SetLabels setAlt(String alt) {
                return (SetLabels)super.setAlt(alt);
            }

            public SetLabels setCallback(String callback) {
                return (SetLabels)super.setCallback(callback);
            }

            public SetLabels setFields(String fields) {
                return (SetLabels)super.setFields(fields);
            }

            public SetLabels setKey(String key) {
                return (SetLabels)super.setKey(key);
            }

            public SetLabels setOauthToken(String oauthToken) {
                return (SetLabels)super.setOauthToken(oauthToken);
            }

            public SetLabels setPrettyPrint(Boolean prettyPrint) {
                return (SetLabels)super.setPrettyPrint(prettyPrint);
            }

            public SetLabels setQuotaUser(String quotaUser) {
                return (SetLabels)super.setQuotaUser(quotaUser);
            }

            public SetLabels setUploadType(String uploadType) {
                return (SetLabels)super.setUploadType(uploadType);
            }

            public SetLabels setUploadProtocol(String uploadProtocol) {
                return (SetLabels)super.setUploadProtocol(uploadProtocol);
            }

            public SetLabels setUserIp(String userIp) {
                return (SetLabels)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetLabels setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetLabels setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetLabels set(String parameterName, Object value) {
                return (SetLabels)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{resource}/setIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected SetIamPolicy(String project, String resource, GlobalSetPolicyRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<SnapshotList> {
            private static final String REST_PATH = "projects/{project}/global/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, SnapshotList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/snapshots";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, Snapshot content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{resource}/getIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;
            @Key
            private Integer optionsRequestedPolicyVersion;

            protected GetIamPolicy(String project, String resource) {
                super(Compute.this, "GET", REST_PATH, null, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<Snapshot> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;

            protected Get(String project, String snapshot) {
                super(Compute.this, "GET", REST_PATH, null, Snapshot.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)snapshot, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Get setSnapshot(String snapshot) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.snapshot = snapshot;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/snapshots/{snapshot}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SNAPSHOT_PATTERN;
            @Key
            private String project;
            @Key
            private String snapshot;
            @Key
            private String requestId;

            protected Delete(String project, String snapshot) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SNAPSHOT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.snapshot = (String)Preconditions.checkNotNull((Object)snapshot, (Object)"Required parameter snapshot must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSnapshot() {
                return this.snapshot;
            }

            public Delete setSnapshot(String snapshot) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SNAPSHOT_PATTERN.matcher(snapshot).matches(), (Object)"Parameter snapshot must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.snapshot = snapshot;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class SnapshotSettings {
        public Get get(String project) throws IOException {
            Get result = new Get(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, com.google.api.services.compute.model.SnapshotSettings content) throws IOException {
            Patch result = new Patch(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/snapshotSettings";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;
            @Key
            private String updateMask;

            protected Patch(String project, com.google.api.services.compute.model.SnapshotSettings content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<com.google.api.services.compute.model.SnapshotSettings> {
            private static final String REST_PATH = "projects/{project}/global/snapshotSettings";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;

            protected Get(String project) {
                super(Compute.this, "GET", REST_PATH, null, com.google.api.services.compute.model.SnapshotSettings.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class ServiceAttachments {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String serviceAttachment) throws IOException {
            Delete result = new Delete(project, region, serviceAttachment);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String serviceAttachment) throws IOException {
            Get result = new Get(project, region, serviceAttachment);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String project, String region, String resource) throws IOException {
            GetIamPolicy result = new GetIamPolicy(project, region, resource);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, ServiceAttachment content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String region, String serviceAttachment, ServiceAttachment content) throws IOException {
            Patch result = new Patch(project, region, serviceAttachment, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public TestIamPermissions setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected SetIamPolicy(String project, String region, String resource, RegionSetPolicyRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public SetIamPolicy setUserIp(String userIp) {
                return (SetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public SetIamPolicy setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String serviceAttachment;
            @Key
            private String requestId;

            protected Patch(String project, String region, String serviceAttachment, ServiceAttachment content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                this.serviceAttachment = (String)Preconditions.checkNotNull((Object)serviceAttachment, (Object)"Required parameter serviceAttachment must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Patch setRegion(String region) {
                this.region = region;
                return this;
            }

            public String getServiceAttachment() {
                return this.serviceAttachment;
            }

            public Patch setServiceAttachment(String serviceAttachment) {
                this.serviceAttachment = serviceAttachment;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<ServiceAttachmentList> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project, String region) {
                super(Compute.this, "GET", REST_PATH, null, ServiceAttachmentList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public List setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String requestId;

            protected Insert(String project, String region, ServiceAttachment content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Insert setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends ComputeRequest<Policy> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;
            @Key
            private Integer optionsRequestedPolicyVersion;

            protected GetIamPolicy(String project, String region, String resource) {
                super(Compute.this, "GET", REST_PATH, null, Policy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public GetIamPolicy setUserIp(String userIp) {
                return (GetIamPolicy)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetIamPolicy setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public GetIamPolicy setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            public Integer getOptionsRequestedPolicyVersion() {
                return this.optionsRequestedPolicyVersion;
            }

            public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<ServiceAttachment> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SERVICE_ATTACHMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String serviceAttachment;

            protected Get(String project, String region, String serviceAttachment) {
                super(Compute.this, "GET", REST_PATH, null, ServiceAttachment.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SERVICE_ATTACHMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.serviceAttachment = (String)Preconditions.checkNotNull((Object)serviceAttachment, (Object)"Required parameter serviceAttachment must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SERVICE_ATTACHMENT_PATTERN.matcher(serviceAttachment).matches(), (Object)"Parameter serviceAttachment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Get setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getServiceAttachment() {
                return this.serviceAttachment;
            }

            public Get setServiceAttachment(String serviceAttachment) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SERVICE_ATTACHMENT_PATTERN.matcher(serviceAttachment).matches(), (Object)"Parameter serviceAttachment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.serviceAttachment = serviceAttachment;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/serviceAttachments/{serviceAttachment}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern SERVICE_ATTACHMENT_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String serviceAttachment;
            @Key
            private String requestId;

            protected Delete(String project, String region, String serviceAttachment) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.SERVICE_ATTACHMENT_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.serviceAttachment = (String)Preconditions.checkNotNull((Object)serviceAttachment, (Object)"Required parameter serviceAttachment must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SERVICE_ATTACHMENT_PATTERN.matcher(serviceAttachment).matches(), (Object)"Parameter serviceAttachment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Delete setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getServiceAttachment() {
                return this.serviceAttachment;
            }

            public Delete setServiceAttachment(String serviceAttachment) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SERVICE_ATTACHMENT_PATTERN.matcher(serviceAttachment).matches(), (Object)"Parameter serviceAttachment must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.serviceAttachment = serviceAttachment;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<ServiceAttachmentAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/serviceAttachments";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, ServiceAttachmentAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }
    }

    public class SecurityPolicies {
        public AddRule addRule(String project, String securityPolicy, SecurityPolicyRule content) throws IOException {
            AddRule result = new AddRule(project, securityPolicy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String securityPolicy) throws IOException {
            Delete result = new Delete(project, securityPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String securityPolicy) throws IOException {
            Get result = new Get(project, securityPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetRule getRule(String project, String securityPolicy) throws IOException {
            GetRule result = new GetRule(project, securityPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, SecurityPolicy content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListPreconfiguredExpressionSets listPreconfiguredExpressionSets(String project) throws IOException {
            ListPreconfiguredExpressionSets result = new ListPreconfiguredExpressionSets(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String securityPolicy, SecurityPolicy content) throws IOException {
            Patch result = new Patch(project, securityPolicy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public PatchRule patchRule(String project, String securityPolicy, SecurityPolicyRule content) throws IOException {
            PatchRule result = new PatchRule(project, securityPolicy, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public RemoveRule removeRule(String project, String securityPolicy) throws IOException {
            RemoveRule result = new RemoveRule(project, securityPolicy);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetLabels setLabels(String project, String resource, GlobalSetLabelsRequest content) throws IOException {
            SetLabels result = new SetLabels(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetLabels
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{resource}/setLabels";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected SetLabels(String project, String resource, GlobalSetLabelsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public SetLabels set$Xgafv(String $Xgafv) {
                return (SetLabels)super.set$Xgafv($Xgafv);
            }

            public SetLabels setAccessToken(String accessToken) {
                return (SetLabels)super.setAccessToken(accessToken);
            }

            public SetLabels setAlt(String alt) {
                return (SetLabels)super.setAlt(alt);
            }

            public SetLabels setCallback(String callback) {
                return (SetLabels)super.setCallback(callback);
            }

            public SetLabels setFields(String fields) {
                return (SetLabels)super.setFields(fields);
            }

            public SetLabels setKey(String key) {
                return (SetLabels)super.setKey(key);
            }

            public SetLabels setOauthToken(String oauthToken) {
                return (SetLabels)super.setOauthToken(oauthToken);
            }

            public SetLabels setPrettyPrint(Boolean prettyPrint) {
                return (SetLabels)super.setPrettyPrint(prettyPrint);
            }

            public SetLabels setQuotaUser(String quotaUser) {
                return (SetLabels)super.setQuotaUser(quotaUser);
            }

            public SetLabels setUploadType(String uploadType) {
                return (SetLabels)super.setUploadType(uploadType);
            }

            public SetLabels setUploadProtocol(String uploadProtocol) {
                return (SetLabels)super.setUploadProtocol(uploadProtocol);
            }

            public SetLabels setUserIp(String userIp) {
                return (SetLabels)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public SetLabels setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public SetLabels setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetLabels set(String parameterName, Object value) {
                return (SetLabels)super.set(parameterName, value);
            }
        }

        public class RemoveRule
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}/removeRule";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private Integer priority;

            protected RemoveRule(String project, String securityPolicy) {
                super(Compute.this, "POST", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public RemoveRule set$Xgafv(String $Xgafv) {
                return (RemoveRule)super.set$Xgafv($Xgafv);
            }

            public RemoveRule setAccessToken(String accessToken) {
                return (RemoveRule)super.setAccessToken(accessToken);
            }

            public RemoveRule setAlt(String alt) {
                return (RemoveRule)super.setAlt(alt);
            }

            public RemoveRule setCallback(String callback) {
                return (RemoveRule)super.setCallback(callback);
            }

            public RemoveRule setFields(String fields) {
                return (RemoveRule)super.setFields(fields);
            }

            public RemoveRule setKey(String key) {
                return (RemoveRule)super.setKey(key);
            }

            public RemoveRule setOauthToken(String oauthToken) {
                return (RemoveRule)super.setOauthToken(oauthToken);
            }

            public RemoveRule setPrettyPrint(Boolean prettyPrint) {
                return (RemoveRule)super.setPrettyPrint(prettyPrint);
            }

            public RemoveRule setQuotaUser(String quotaUser) {
                return (RemoveRule)super.setQuotaUser(quotaUser);
            }

            public RemoveRule setUploadType(String uploadType) {
                return (RemoveRule)super.setUploadType(uploadType);
            }

            public RemoveRule setUploadProtocol(String uploadProtocol) {
                return (RemoveRule)super.setUploadProtocol(uploadProtocol);
            }

            public RemoveRule setUserIp(String userIp) {
                return (RemoveRule)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public RemoveRule setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public RemoveRule setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public Integer getPriority() {
                return this.priority;
            }

            public RemoveRule setPriority(Integer priority) {
                this.priority = priority;
                return this;
            }

            @Override
            public RemoveRule set(String parameterName, Object value) {
                return (RemoveRule)super.set(parameterName, value);
            }
        }

        public class PatchRule
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}/patchRule";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private Integer priority;
            @Key
            private String updateMask;
            @Key
            private Boolean validateOnly;

            protected PatchRule(String project, String securityPolicy, SecurityPolicyRule content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public PatchRule set$Xgafv(String $Xgafv) {
                return (PatchRule)super.set$Xgafv($Xgafv);
            }

            public PatchRule setAccessToken(String accessToken) {
                return (PatchRule)super.setAccessToken(accessToken);
            }

            public PatchRule setAlt(String alt) {
                return (PatchRule)super.setAlt(alt);
            }

            public PatchRule setCallback(String callback) {
                return (PatchRule)super.setCallback(callback);
            }

            public PatchRule setFields(String fields) {
                return (PatchRule)super.setFields(fields);
            }

            public PatchRule setKey(String key) {
                return (PatchRule)super.setKey(key);
            }

            public PatchRule setOauthToken(String oauthToken) {
                return (PatchRule)super.setOauthToken(oauthToken);
            }

            public PatchRule setPrettyPrint(Boolean prettyPrint) {
                return (PatchRule)super.setPrettyPrint(prettyPrint);
            }

            public PatchRule setQuotaUser(String quotaUser) {
                return (PatchRule)super.setQuotaUser(quotaUser);
            }

            public PatchRule setUploadType(String uploadType) {
                return (PatchRule)super.setUploadType(uploadType);
            }

            public PatchRule setUploadProtocol(String uploadProtocol) {
                return (PatchRule)super.setUploadProtocol(uploadProtocol);
            }

            public PatchRule setUserIp(String userIp) {
                return (PatchRule)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public PatchRule setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public PatchRule setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public Integer getPriority() {
                return this.priority;
            }

            public PatchRule setPriority(Integer priority) {
                this.priority = priority;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public PatchRule setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            public Boolean getValidateOnly() {
                return this.validateOnly;
            }

            public PatchRule setValidateOnly(Boolean validateOnly) {
                this.validateOnly = validateOnly;
                return this;
            }

            @Override
            public PatchRule set(String parameterName, Object value) {
                return (PatchRule)super.set(parameterName, value);
            }
        }

        public class Patch
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private String requestId;
            @Key
            private String updateMask;

            protected Patch(String project, String securityPolicy, SecurityPolicy content) {
                super(Compute.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public Patch setUserIp(String userIp) {
                return (Patch)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Patch setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public Patch setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Patch setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public String getUpdateMask() {
                return this.updateMask;
            }

            public Patch setUpdateMask(String updateMask) {
                this.updateMask = updateMask;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class ListPreconfiguredExpressionSets
        extends ComputeRequest<SecurityPoliciesListPreconfiguredExpressionSetsResponse> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/listPreconfiguredExpressionSets";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected ListPreconfiguredExpressionSets(String project) {
                super(Compute.this, "GET", REST_PATH, null, SecurityPoliciesListPreconfiguredExpressionSetsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListPreconfiguredExpressionSets set$Xgafv(String $Xgafv) {
                return (ListPreconfiguredExpressionSets)super.set$Xgafv($Xgafv);
            }

            public ListPreconfiguredExpressionSets setAccessToken(String accessToken) {
                return (ListPreconfiguredExpressionSets)super.setAccessToken(accessToken);
            }

            public ListPreconfiguredExpressionSets setAlt(String alt) {
                return (ListPreconfiguredExpressionSets)super.setAlt(alt);
            }

            public ListPreconfiguredExpressionSets setCallback(String callback) {
                return (ListPreconfiguredExpressionSets)super.setCallback(callback);
            }

            public ListPreconfiguredExpressionSets setFields(String fields) {
                return (ListPreconfiguredExpressionSets)super.setFields(fields);
            }

            public ListPreconfiguredExpressionSets setKey(String key) {
                return (ListPreconfiguredExpressionSets)super.setKey(key);
            }

            public ListPreconfiguredExpressionSets setOauthToken(String oauthToken) {
                return (ListPreconfiguredExpressionSets)super.setOauthToken(oauthToken);
            }

            public ListPreconfiguredExpressionSets setPrettyPrint(Boolean prettyPrint) {
                return (ListPreconfiguredExpressionSets)super.setPrettyPrint(prettyPrint);
            }

            public ListPreconfiguredExpressionSets setQuotaUser(String quotaUser) {
                return (ListPreconfiguredExpressionSets)super.setQuotaUser(quotaUser);
            }

            public ListPreconfiguredExpressionSets setUploadType(String uploadType) {
                return (ListPreconfiguredExpressionSets)super.setUploadType(uploadType);
            }

            public ListPreconfiguredExpressionSets setUploadProtocol(String uploadProtocol) {
                return (ListPreconfiguredExpressionSets)super.setUploadProtocol(uploadProtocol);
            }

            public ListPreconfiguredExpressionSets setUserIp(String userIp) {
                return (ListPreconfiguredExpressionSets)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public ListPreconfiguredExpressionSets setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public ListPreconfiguredExpressionSets setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public ListPreconfiguredExpressionSets setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public ListPreconfiguredExpressionSets setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListPreconfiguredExpressionSets setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public ListPreconfiguredExpressionSets setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public ListPreconfiguredExpressionSets set(String parameterName, Object value) {
                return (ListPreconfiguredExpressionSets)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<SecurityPolicyList> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, SecurityPolicyList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;
            @Key
            private Boolean validateOnly;

            protected Insert(String project, SecurityPolicy content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            public Boolean getValidateOnly() {
                return this.validateOnly;
            }

            public Insert setValidateOnly(Boolean validateOnly) {
                this.validateOnly = validateOnly;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class GetRule
        extends ComputeRequest<SecurityPolicyRule> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}/getRule";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private Integer priority;

            protected GetRule(String project, String securityPolicy) {
                super(Compute.this, "GET", REST_PATH, null, SecurityPolicyRule.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetRule set$Xgafv(String $Xgafv) {
                return (GetRule)super.set$Xgafv($Xgafv);
            }

            public GetRule setAccessToken(String accessToken) {
                return (GetRule)super.setAccessToken(accessToken);
            }

            public GetRule setAlt(String alt) {
                return (GetRule)super.setAlt(alt);
            }

            public GetRule setCallback(String callback) {
                return (GetRule)super.setCallback(callback);
            }

            public GetRule setFields(String fields) {
                return (GetRule)super.setFields(fields);
            }

            public GetRule setKey(String key) {
                return (GetRule)super.setKey(key);
            }

            public GetRule setOauthToken(String oauthToken) {
                return (GetRule)super.setOauthToken(oauthToken);
            }

            public GetRule setPrettyPrint(Boolean prettyPrint) {
                return (GetRule)super.setPrettyPrint(prettyPrint);
            }

            public GetRule setQuotaUser(String quotaUser) {
                return (GetRule)super.setQuotaUser(quotaUser);
            }

            public GetRule setUploadType(String uploadType) {
                return (GetRule)super.setUploadType(uploadType);
            }

            public GetRule setUploadProtocol(String uploadProtocol) {
                return (GetRule)super.setUploadProtocol(uploadProtocol);
            }

            public GetRule setUserIp(String userIp) {
                return (GetRule)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public GetRule setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public GetRule setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public Integer getPriority() {
                return this.priority;
            }

            public GetRule setPriority(Integer priority) {
                this.priority = priority;
                return this;
            }

            @Override
            public GetRule set(String parameterName, Object value) {
                return (GetRule)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<SecurityPolicy> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;

            protected Get(String project, String securityPolicy) {
                super(Compute.this, "GET", REST_PATH, null, SecurityPolicy.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public Get setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private String requestId;

            protected Delete(String project, String securityPolicy) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public Delete setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class AggregatedList
        extends ComputeRequest<SecurityPoliciesAggregatedList> {
            private static final String REST_PATH = "projects/{project}/aggregated/securityPolicies";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Boolean includeAllScopes;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected AggregatedList(String project) {
                super(Compute.this, "GET", REST_PATH, null, SecurityPoliciesAggregatedList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public AggregatedList set$Xgafv(String $Xgafv) {
                return (AggregatedList)super.set$Xgafv($Xgafv);
            }

            public AggregatedList setAccessToken(String accessToken) {
                return (AggregatedList)super.setAccessToken(accessToken);
            }

            public AggregatedList setAlt(String alt) {
                return (AggregatedList)super.setAlt(alt);
            }

            public AggregatedList setCallback(String callback) {
                return (AggregatedList)super.setCallback(callback);
            }

            public AggregatedList setFields(String fields) {
                return (AggregatedList)super.setFields(fields);
            }

            public AggregatedList setKey(String key) {
                return (AggregatedList)super.setKey(key);
            }

            public AggregatedList setOauthToken(String oauthToken) {
                return (AggregatedList)super.setOauthToken(oauthToken);
            }

            public AggregatedList setPrettyPrint(Boolean prettyPrint) {
                return (AggregatedList)super.setPrettyPrint(prettyPrint);
            }

            public AggregatedList setQuotaUser(String quotaUser) {
                return (AggregatedList)super.setQuotaUser(quotaUser);
            }

            public AggregatedList setUploadType(String uploadType) {
                return (AggregatedList)super.setUploadType(uploadType);
            }

            public AggregatedList setUploadProtocol(String uploadProtocol) {
                return (AggregatedList)super.setUploadProtocol(uploadProtocol);
            }

            public AggregatedList setUserIp(String userIp) {
                return (AggregatedList)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AggregatedList setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public AggregatedList setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Boolean getIncludeAllScopes() {
                return this.includeAllScopes;
            }

            public AggregatedList setIncludeAllScopes(Boolean includeAllScopes) {
                this.includeAllScopes = includeAllScopes;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public AggregatedList setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public AggregatedList setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public AggregatedList setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public AggregatedList setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public AggregatedList set(String parameterName, Object value) {
                return (AggregatedList)super.set(parameterName, value);
            }
        }

        public class AddRule
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/securityPolicies/{securityPolicy}/addRule";
            private final Pattern PROJECT_PATTERN;
            private final Pattern SECURITY_POLICY_PATTERN;
            @Key
            private String project;
            @Key
            private String securityPolicy;
            @Key
            private Boolean validateOnly;

            protected AddRule(String project, String securityPolicy, SecurityPolicyRule content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.SECURITY_POLICY_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.securityPolicy = (String)Preconditions.checkNotNull((Object)securityPolicy, (Object)"Required parameter securityPolicy must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public AddRule set$Xgafv(String $Xgafv) {
                return (AddRule)super.set$Xgafv($Xgafv);
            }

            public AddRule setAccessToken(String accessToken) {
                return (AddRule)super.setAccessToken(accessToken);
            }

            public AddRule setAlt(String alt) {
                return (AddRule)super.setAlt(alt);
            }

            public AddRule setCallback(String callback) {
                return (AddRule)super.setCallback(callback);
            }

            public AddRule setFields(String fields) {
                return (AddRule)super.setFields(fields);
            }

            public AddRule setKey(String key) {
                return (AddRule)super.setKey(key);
            }

            public AddRule setOauthToken(String oauthToken) {
                return (AddRule)super.setOauthToken(oauthToken);
            }

            public AddRule setPrettyPrint(Boolean prettyPrint) {
                return (AddRule)super.setPrettyPrint(prettyPrint);
            }

            public AddRule setQuotaUser(String quotaUser) {
                return (AddRule)super.setQuotaUser(quotaUser);
            }

            public AddRule setUploadType(String uploadType) {
                return (AddRule)super.setUploadType(uploadType);
            }

            public AddRule setUploadProtocol(String uploadProtocol) {
                return (AddRule)super.setUploadProtocol(uploadProtocol);
            }

            public AddRule setUserIp(String userIp) {
                return (AddRule)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public AddRule setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getSecurityPolicy() {
                return this.securityPolicy;
            }

            public AddRule setSecurityPolicy(String securityPolicy) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.SECURITY_POLICY_PATTERN.matcher(securityPolicy).matches(), (Object)"Parameter securityPolicy must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.securityPolicy = securityPolicy;
                return this;
            }

            public Boolean getValidateOnly() {
                return this.validateOnly;
            }

            public AddRule setValidateOnly(Boolean validateOnly) {
                this.validateOnly = validateOnly;
                return this;
            }

            @Override
            public AddRule set(String parameterName, Object value) {
                return (AddRule)super.set(parameterName, value);
            }
        }
    }

    public class Routes {
        public Delete delete(String project, String route) throws IOException {
            Delete result = new Delete(project, route);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String route) throws IOException {
            Get result = new Get(project, route);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, Route content) throws IOException {
            Insert result = new Insert(project, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project) throws IOException {
            List result = new List(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/global/routes/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public TestIamPermissions setUserIp(String userIp) {
                return (TestIamPermissions)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public TestIamPermissions setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9_]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class List
        extends ComputeRequest<RouteList> {
            private static final String REST_PATH = "projects/{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String filter;
            @Key
            private Long maxResults;
            @Key
            private String orderBy;
            @Key
            private String pageToken;
            @Key
            private Boolean returnPartialSuccess;

            protected List(String project) {
                super(Compute.this, "GET", REST_PATH, null, RouteList.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public List setUserIp(String userIp) {
                return (List)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public List setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Long maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getReturnPartialSuccess() {
                return this.returnPartialSuccess;
            }

            public List setReturnPartialSuccess(Boolean returnPartialSuccess) {
                this.returnPartialSuccess = returnPartialSuccess;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/routes";
            private final Pattern PROJECT_PATTERN;
            @Key
            private String project;
            @Key
            private String requestId;

            protected Insert(String project, Route content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public Insert setUserIp(String userIp) {
                return (Insert)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Insert setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Insert setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends ComputeRequest<Route> {
            private static final String REST_PATH = "projects/{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;

            protected Get(String project, String route) {
                super(Compute.this, "GET", REST_PATH, null, Route.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)route, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(route).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Get setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Get setRoute(String route) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(route).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.route = route;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/global/routes/{route}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern ROUTE_PATTERN;
            @Key
            private String project;
            @Key
            private String route;
            @Key
            private String requestId;

            protected Delete(String project, String route) {
                super(Compute.this, "DELETE", REST_PATH, null, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.ROUTE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.route = (String)Preconditions.checkNotNull((Object)route, (Object)"Required parameter route must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(route).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public Delete setUserIp(String userIp) {
                return (Delete)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Delete setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRoute() {
                return this.route;
            }

            public Delete setRoute(String route) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTE_PATTERN.matcher(route).matches(), (Object)"Parameter route must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.route = route;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Delete setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }

    public class Routers {
        public AggregatedList aggregatedList(String project) throws IOException {
            AggregatedList result = new AggregatedList(project);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String project, String region, String router) throws IOException {
            Delete result = new Delete(project, region, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String project, String region, String router) throws IOException {
            Get result = new Get(project, region, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetNatIpInfo getNatIpInfo(String project, String region, String router) throws IOException {
            GetNatIpInfo result = new GetNatIpInfo(project, region, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetNatMappingInfo getNatMappingInfo(String project, String region, String router) throws IOException {
            GetNatMappingInfo result = new GetNatMappingInfo(project, region, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetRouterStatus getRouterStatus(String project, String region, String router) throws IOException {
            GetRouterStatus result = new GetRouterStatus(project, region, router);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String project, String region, Router content) throws IOException {
            Insert result = new Insert(project, region, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String project, String region) throws IOException {
            List result = new List(project, region);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String project, String region, String router, Router content) throws IOException {
            Patch result = new Patch(project, region, router, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Preview preview(String project, String region, String router, Router content) throws IOException {
            Preview result = new Preview(project, region, router, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String project, String region, String resource, TestPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(project, region, resource, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String project, String region, String router, Router content) throws IOException {
            Update result = new Update(project, region, router, content);
            Compute.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends ComputeRequest<Operation> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/routers/{router}";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern ROUTER_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String router;
            @Key
            private String requestId;

            protected Update(String project, String region, String router, Router content) {
                super(Compute.this, "PUT", REST_PATH, (Object)content, Operation.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.ROUTER_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.router = (String)Preconditions.checkNotNull((Object)router, (Object)"Required parameter router must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(router).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public Update setUserIp(String userIp) {
                return (Update)super.setUserIp(userIp);
            }

            public String getProject() {
                return this.project;
            }

            public Update setProject(String project) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.project = project;
                return this;
            }

            public String getRegion() {
                return this.region;
            }

            public Update setRegion(String region) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.region = region;
                return this;
            }

            public String getRouter() {
                return this.router;
            }

            public Update setRouter(String router) {
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ROUTER_PATTERN.matcher(router).matches(), (Object)"Parameter router must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
                this.router = router;
                return this;
            }

            public String getRequestId() {
                return this.requestId;
            }

            public Update setRequestId(String requestId) {
                this.requestId = requestId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends ComputeRequest<TestPermissionsResponse> {
            private static final String REST_PATH = "projects/{project}/regions/{region}/routers/{resource}/testIamPermissions";
            private final Pattern PROJECT_PATTERN;
            private final Pattern REGION_PATTERN;
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String project;
            @Key
            private String region;
            @Key
            private String resource;

            protected TestIamPermissions(String project, String region, String resource, TestPermissionsRequest content) {
                super(Compute.this, "POST", REST_PATH, (Object)content, TestPermissionsResponse.class);
                this.PROJECT_PATTERN = Pattern.compile("(?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                this.REGION_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                this.RESOURCE_PATTERN = Pattern.compile("[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                this.project = (String)Preconditions.checkNotNull((Object)project, (Object)"Required parameter project must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PROJECT_PATTERN.matcher(project).matches(), (Object)"Parameter project must conform to the pattern (?:(?:[-a-z0-9]{1,63}\\.)*(?:[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?):)?(?:[0-9]{1,19}|(?:[a-z0-9](?:[-a-z0-9]{0,61}[a-z0-9])?))");
                }
                this.region = (String)Preconditions.checkNotNull((Object)region, (Object)"Required parameter region must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.REGION_PATTERN.matcher(region).matches(), (Object)"Parameter region must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?");
                }
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!Compute.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern [a-z](?:[-a-z0-9]{0,61}[a-z0-9])?|[1-9][0-9]{0,19}");
                }
            }

 