/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Represents a Target HTTP Proxy resource. Google Compute Engine has two Target HTTP Proxy
 * resources: * [Global](/compute/docs/reference/rest/beta/targetHttpProxies) *
 * [Regional](/compute/docs/reference/rest/beta/regionTargetHttpProxies) A target HTTP proxy is a
 * component of GCP HTTP load balancers. * targetHttpProxies are used by global external Application
 * Load Balancers, classic Application Load Balancers, cross-region internal Application Load
 * Balancers, and Traffic Director. * regionTargetHttpProxies are used by regional internal
 * Application Load Balancers and regional external Application Load Balancers. Forwarding rules
 * reference a target HTTP proxy, and the target proxy then references a URL map. For more
 * information, read Using Target Proxies and Forwarding rule concepts.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetHttpProxy extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-
   * date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpProxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * URLs to networkservices.HttpFilter resources enabled for xDS clients using this configuration.
   * For example, https://networkservices.googleapis.com/v1alpha1/projects/project/locations/
   * locationhttpFilters/httpFilter Only filters that handle outbound connection and stream events
   * may be specified. These filters work in conjunction with a default set of HTTP filters that may
   * already be configured by Traffic Director. Traffic Director will determine the final location
   * of these filters within xDS configuration based on the name of the HTTP filter. If Traffic
   * Director positions multiple filters at the same location, those filters will be in the same
   * order as specified in this list. httpFilters only applies for loadbalancers with
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> httpFilters;

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer httpKeepAliveTimeoutSec;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean proxyBind;

  /**
   * [Output Only] URL of the region where the regional Target HTTP Proxy resides. This field is not
   * applicable to global Target HTTP Proxies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * URL to the UrlMap resource that defines the mapping from URL to the BackendService.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlMap;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public TargetHttpProxy setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public TargetHttpProxy setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-
   * date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpProxy.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-
   * date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpProxy.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-
   * date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpProxy.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public TargetHttpProxy setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used
   * in optimistic locking. This field will be ignored when inserting a TargetHttpProxy. An up-to-
   * date fingerprint must be provided in order to patch/update the TargetHttpProxy; otherwise, the
   * request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get()
   * request to retrieve the TargetHttpProxy.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public TargetHttpProxy encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * URLs to networkservices.HttpFilter resources enabled for xDS clients using this configuration.
   * For example, https://networkservices.googleapis.com/v1alpha1/projects/project/locations/
   * locationhttpFilters/httpFilter Only filters that handle outbound connection and stream events
   * may be specified. These filters work in conjunction with a default set of HTTP filters that may
   * already be configured by Traffic Director. Traffic Director will determine the final location
   * of these filters within xDS configuration based on the name of the HTTP filter. If Traffic
   * Director positions multiple filters at the same location, those filters will be in the same
   * order as specified in this list. httpFilters only applies for loadbalancers with
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getHttpFilters() {
    return httpFilters;
  }

  /**
   * URLs to networkservices.HttpFilter resources enabled for xDS clients using this configuration.
   * For example, https://networkservices.googleapis.com/v1alpha1/projects/project/locations/
   * locationhttpFilters/httpFilter Only filters that handle outbound connection and stream events
   * may be specified. These filters work in conjunction with a default set of HTTP filters that may
   * already be configured by Traffic Director. Traffic Director will determine the final location
   * of these filters within xDS configuration based on the name of the HTTP filter. If Traffic
   * Director positions multiple filters at the same location, those filters will be in the same
   * order as specified in this list. httpFilters only applies for loadbalancers with
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. See ForwardingRule for more details.
   * @param httpFilters httpFilters or {@code null} for none
   */
  public TargetHttpProxy setHttpFilters(java.util.List<java.lang.String> httpFilters) {
    this.httpFilters = httpFilters;
    return this;
  }

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHttpKeepAliveTimeoutSec() {
    return httpKeepAliveTimeoutSec;
  }

  /**
   * Specifies how long to keep a connection open, after completing a response, while there is no
   * matching traffic (in seconds). If an HTTP keep-alive is not specified, a default value (610
   * seconds) will be used. For global external Application Load Balancers, the minimum allowed
   * value is 5 seconds and the maximum allowed value is 1200 seconds. For classic Application Load
   * Balancers, this option is not supported.
   * @param httpKeepAliveTimeoutSec httpKeepAliveTimeoutSec or {@code null} for none
   */
  public TargetHttpProxy setHttpKeepAliveTimeoutSec(java.lang.Integer httpKeepAliveTimeoutSec) {
    this.httpKeepAliveTimeoutSec = httpKeepAliveTimeoutSec;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public TargetHttpProxy setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#targetHttpProxy for target HTTP proxies.
   * @param kind kind or {@code null} for none
   */
  public TargetHttpProxy setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource. Provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public TargetHttpProxy setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getProxyBind() {
    return proxyBind;
  }

  /**
   * This field only applies when the forwarding rule that references this target proxy has a
   * loadBalancingScheme set to INTERNAL_SELF_MANAGED. When this field is set to true, Envoy proxies
   * set up inbound traffic interception and bind to the IP address and port specified in the
   * forwarding rule. This is generally useful when using Traffic Director to configure Envoy as a
   * gateway or middle proxy (in other words, not a sidecar proxy). The Envoy proxy listens for
   * inbound requests and handles requests when it receives them. The default is false.
   * @param proxyBind proxyBind or {@code null} for none
   */
  public TargetHttpProxy setProxyBind(java.lang.Boolean proxyBind) {
    this.proxyBind = proxyBind;
    return this;
  }

  /**
   * [Output Only] URL of the region where the regional Target HTTP Proxy resides. This field is not
   * applicable to global Target HTTP Proxies.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the regional Target HTTP Proxy resides. This field is not
   * applicable to global Target HTTP Proxies.
   * @param region region or {@code null} for none
   */
  public TargetHttpProxy setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public TargetHttpProxy setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * URL to the UrlMap resource that defines the mapping from URL to the BackendService.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlMap() {
    return urlMap;
  }

  /**
   * URL to the UrlMap resource that defines the mapping from URL to the BackendService.
   * @param urlMap urlMap or {@code null} for none
   */
  public TargetHttpProxy setUrlMap(java.lang.String urlMap) {
    this.urlMap = urlMap;
    return this;
  }

  @Override
  public TargetHttpProxy set(String fieldName, Object value) {
    return (TargetHttpProxy) super.set(fieldName, value);
  }

  @Override
  public TargetHttpProxy clone() {
    return (TargetHttpProxy) super.clone();
  }

}
