/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstantSnapshotExportParams.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstantSnapshotExportParams extends com.google.api.client.json.GenericJson {

  /**
   * An optional base instant snapshot that this resource is compared against. If not specified, all
   * blocks of this resource are exported. The base instant snapshot and this resource must be
   * created from the same disk. The base instant snapshot must be created earlier in time than this
   * resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String baseInstantSnapshot;

  /**
   * The name of an existing bucket in Cloud Storage where the changed blocks will be stored. The
   * Google Service Account must have read and write access to this bucket. The bucket has to be in
   * the same region as this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bucketName;

  /**
   * Encryption key used to encrypt the instant snapshot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomerEncryptionKey encryptionKey;

  /**
   * Name of the output Bigstore object storing the changed blocks. Object name must be less than
   * 1024 bytes in length.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectName;

  /**
   * The format of the output file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outputType;

  /**
   * An optional base instant snapshot that this resource is compared against. If not specified, all
   * blocks of this resource are exported. The base instant snapshot and this resource must be
   * created from the same disk. The base instant snapshot must be created earlier in time than this
   * resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getBaseInstantSnapshot() {
    return baseInstantSnapshot;
  }

  /**
   * An optional base instant snapshot that this resource is compared against. If not specified, all
   * blocks of this resource are exported. The base instant snapshot and this resource must be
   * created from the same disk. The base instant snapshot must be created earlier in time than this
   * resource.
   * @param baseInstantSnapshot baseInstantSnapshot or {@code null} for none
   */
  public InstantSnapshotExportParams setBaseInstantSnapshot(java.lang.String baseInstantSnapshot) {
    this.baseInstantSnapshot = baseInstantSnapshot;
    return this;
  }

  /**
   * The name of an existing bucket in Cloud Storage where the changed blocks will be stored. The
   * Google Service Account must have read and write access to this bucket. The bucket has to be in
   * the same region as this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getBucketName() {
    return bucketName;
  }

  /**
   * The name of an existing bucket in Cloud Storage where the changed blocks will be stored. The
   * Google Service Account must have read and write access to this bucket. The bucket has to be in
   * the same region as this resource.
   * @param bucketName bucketName or {@code null} for none
   */
  public InstantSnapshotExportParams setBucketName(java.lang.String bucketName) {
    this.bucketName = bucketName;
    return this;
  }

  /**
   * Encryption key used to encrypt the instant snapshot.
   * @return value or {@code null} for none
   */
  public CustomerEncryptionKey getEncryptionKey() {
    return encryptionKey;
  }

  /**
   * Encryption key used to encrypt the instant snapshot.
   * @param encryptionKey encryptionKey or {@code null} for none
   */
  public InstantSnapshotExportParams setEncryptionKey(CustomerEncryptionKey encryptionKey) {
    this.encryptionKey = encryptionKey;
    return this;
  }

  /**
   * Name of the output Bigstore object storing the changed blocks. Object name must be less than
   * 1024 bytes in length.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectName() {
    return objectName;
  }

  /**
   * Name of the output Bigstore object storing the changed blocks. Object name must be less than
   * 1024 bytes in length.
   * @param objectName objectName or {@code null} for none
   */
  public InstantSnapshotExportParams setObjectName(java.lang.String objectName) {
    this.objectName = objectName;
    return this;
  }

  /**
   * The format of the output file.
   * @return value or {@code null} for none
   */
  public java.lang.String getOutputType() {
    return outputType;
  }

  /**
   * The format of the output file.
   * @param outputType outputType or {@code null} for none
   */
  public InstantSnapshotExportParams setOutputType(java.lang.String outputType) {
    this.outputType = outputType;
    return this;
  }

  @Override
  public InstantSnapshotExportParams set(String fieldName, Object value) {
    return (InstantSnapshotExportParams) super.set(fieldName, value);
  }

  @Override
  public InstantSnapshotExportParams clone() {
    return (InstantSnapshotExportParams) super.clone();
  }

}
