/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for BfdPacket.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BfdPacket extends com.google.api.client.json.GenericJson {

  /**
   * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean authenticationPresent;

  /**
   * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean controlPlaneIndependent;

  /**
   * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean demand;

  /**
   * The diagnostic code specifies the local system's reason for the last change in session state.
   * This allows remote systems to determine the reason that the previous session failed, for
   * example. These diagnostic codes are specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diagnostic;

  /**
   * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("final")
  private java.lang.Boolean final__;

  /**
   * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long length;

  /**
   * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long minEchoRxIntervalMs;

  /**
   * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long minRxIntervalMs;

  /**
   * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long minTxIntervalMs;

  /**
   * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long multiplier;

  /**
   * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean multipoint;

  /**
   * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long myDiscriminator;

  /**
   * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean poll;

  /**
   * The current BFD session state as seen by the transmitting system. These states are specified in
   * section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long version;

  /**
   * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Long yourDiscriminator;

  /**
   * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAuthenticationPresent() {
    return authenticationPresent;
  }

  /**
   * The Authentication Present bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param authenticationPresent authenticationPresent or {@code null} for none
   */
  public BfdPacket setAuthenticationPresent(java.lang.Boolean authenticationPresent) {
    this.authenticationPresent = authenticationPresent;
    return this;
  }

  /**
   * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getControlPlaneIndependent() {
    return controlPlaneIndependent;
  }

  /**
   * The Control Plane Independent bit of the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @param controlPlaneIndependent controlPlaneIndependent or {@code null} for none
   */
  public BfdPacket setControlPlaneIndependent(java.lang.Boolean controlPlaneIndependent) {
    this.controlPlaneIndependent = controlPlaneIndependent;
    return this;
  }

  /**
   * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDemand() {
    return demand;
  }

  /**
   * The demand bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param demand demand or {@code null} for none
   */
  public BfdPacket setDemand(java.lang.Boolean demand) {
    this.demand = demand;
    return this;
  }

  /**
   * The diagnostic code specifies the local system's reason for the last change in session state.
   * This allows remote systems to determine the reason that the previous session failed, for
   * example. These diagnostic codes are specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.String getDiagnostic() {
    return diagnostic;
  }

  /**
   * The diagnostic code specifies the local system's reason for the last change in session state.
   * This allows remote systems to determine the reason that the previous session failed, for
   * example. These diagnostic codes are specified in section 4.1 of RFC5880
   * @param diagnostic diagnostic or {@code null} for none
   */
  public BfdPacket setDiagnostic(java.lang.String diagnostic) {
    this.diagnostic = diagnostic;
    return this;
  }

  /**
   * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFinal() {
    return final__;
  }

  /**
   * The Final bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param final__ final__ or {@code null} for none
   */
  public BfdPacket setFinal(java.lang.Boolean final__) {
    this.final__ = final__;
    return this;
  }

  /**
   * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getLength() {
    return length;
  }

  /**
   * The length of the BFD Control packet in bytes. This is specified in section 4.1 of RFC5880
   * @param length length or {@code null} for none
   */
  public BfdPacket setLength(java.lang.Long length) {
    this.length = length;
    return this;
  }

  /**
   * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinEchoRxIntervalMs() {
    return minEchoRxIntervalMs;
  }

  /**
   * The Required Min Echo RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @param minEchoRxIntervalMs minEchoRxIntervalMs or {@code null} for none
   */
  public BfdPacket setMinEchoRxIntervalMs(java.lang.Long minEchoRxIntervalMs) {
    this.minEchoRxIntervalMs = minEchoRxIntervalMs;
    return this;
  }

  /**
   * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinRxIntervalMs() {
    return minRxIntervalMs;
  }

  /**
   * The Required Min RX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @param minRxIntervalMs minRxIntervalMs or {@code null} for none
   */
  public BfdPacket setMinRxIntervalMs(java.lang.Long minRxIntervalMs) {
    this.minRxIntervalMs = minRxIntervalMs;
    return this;
  }

  /**
   * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getMinTxIntervalMs() {
    return minTxIntervalMs;
  }

  /**
   * The Desired Min TX Interval value in the BFD packet. This is specified in section 4.1 of
   * RFC5880
   * @param minTxIntervalMs minTxIntervalMs or {@code null} for none
   */
  public BfdPacket setMinTxIntervalMs(java.lang.Long minTxIntervalMs) {
    this.minTxIntervalMs = minTxIntervalMs;
    return this;
  }

  /**
   * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getMultiplier() {
    return multiplier;
  }

  /**
   * The detection time multiplier of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param multiplier multiplier or {@code null} for none
   */
  public BfdPacket setMultiplier(java.lang.Long multiplier) {
    this.multiplier = multiplier;
    return this;
  }

  /**
   * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMultipoint() {
    return multipoint;
  }

  /**
   * The multipoint bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param multipoint multipoint or {@code null} for none
   */
  public BfdPacket setMultipoint(java.lang.Boolean multipoint) {
    this.multipoint = multipoint;
    return this;
  }

  /**
   * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getMyDiscriminator() {
    return myDiscriminator;
  }

  /**
   * The My Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * @param myDiscriminator myDiscriminator or {@code null} for none
   */
  public BfdPacket setMyDiscriminator(java.lang.Long myDiscriminator) {
    this.myDiscriminator = myDiscriminator;
    return this;
  }

  /**
   * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPoll() {
    return poll;
  }

  /**
   * The Poll bit of the BFD packet. This is specified in section 4.1 of RFC5880
   * @param poll poll or {@code null} for none
   */
  public BfdPacket setPoll(java.lang.Boolean poll) {
    this.poll = poll;
    return this;
  }

  /**
   * The current BFD session state as seen by the transmitting system. These states are specified in
   * section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The current BFD session state as seen by the transmitting system. These states are specified in
   * section 4.1 of RFC5880
   * @param state state or {@code null} for none
   */
  public BfdPacket setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * The version number of the BFD protocol, as specified in section 4.1 of RFC5880.
   * @param version version or {@code null} for none
   */
  public BfdPacket setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * @return value or {@code null} for none
   */
  public java.lang.Long getYourDiscriminator() {
    return yourDiscriminator;
  }

  /**
   * The Your Discriminator value in the BFD packet. This is specified in section 4.1 of RFC5880
   * @param yourDiscriminator yourDiscriminator or {@code null} for none
   */
  public BfdPacket setYourDiscriminator(java.lang.Long yourDiscriminator) {
    this.yourDiscriminator = yourDiscriminator;
    return this;
  }

  @Override
  public BfdPacket set(String fieldName, Object value) {
    return (BfdPacket) super.set(fieldName, value);
  }

  @Override
  public BfdPacket clone() {
    return (BfdPacket) super.clone();
  }

}
