/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains information of a NAT IP.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NatIpInfoNatIpInfoMapping extends com.google.api.client.json.GenericJson {

  /**
   * Specifies whether NAT IP is auto or manual.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * NAT IP address. For example: 203.0.113.11.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String natIp;

  /**
   * Specifies whether NAT IP is currently serving at least one endpoint or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String usage;

  /**
   * Specifies whether NAT IP is auto or manual.
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * Specifies whether NAT IP is auto or manual.
   * @param mode mode or {@code null} for none
   */
  public NatIpInfoNatIpInfoMapping setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * NAT IP address. For example: 203.0.113.11.
   * @return value or {@code null} for none
   */
  public java.lang.String getNatIp() {
    return natIp;
  }

  /**
   * NAT IP address. For example: 203.0.113.11.
   * @param natIp natIp or {@code null} for none
   */
  public NatIpInfoNatIpInfoMapping setNatIp(java.lang.String natIp) {
    this.natIp = natIp;
    return this;
  }

  /**
   * Specifies whether NAT IP is currently serving at least one endpoint or not.
   * @return value or {@code null} for none
   */
  public java.lang.String getUsage() {
    return usage;
  }

  /**
   * Specifies whether NAT IP is currently serving at least one endpoint or not.
   * @param usage usage or {@code null} for none
   */
  public NatIpInfoNatIpInfoMapping setUsage(java.lang.String usage) {
    this.usage = usage;
    return this;
  }

  @Override
  public NatIpInfoNatIpInfoMapping set(String fieldName, Object value) {
    return (NatIpInfoNatIpInfoMapping) super.set(fieldName, value);
  }

  @Override
  public NatIpInfoNatIpInfoMapping clone() {
    return (NatIpInfoNatIpInfoMapping) super.clone();
  }

}
