/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for
 * SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig extends com.google.api.client.json.GenericJson {

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float autoDeployConfidenceThreshold;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer autoDeployExpirationSec;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float autoDeployImpactedBaselineThreshold;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float autoDeployLoadThreshold;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float detectionAbsoluteQps;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float detectionLoadThreshold;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float detectionRelativeToBaselineQps;

  /**
   * The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within
   * the security policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Configuration options for enabling Adaptive Protection to operate on specified granular traffic
   * units.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig> trafficGranularityConfigs;

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getAutoDeployConfidenceThreshold() {
    return autoDeployConfidenceThreshold;
  }

  /**
   * @param autoDeployConfidenceThreshold autoDeployConfidenceThreshold or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setAutoDeployConfidenceThreshold(java.lang.Float autoDeployConfidenceThreshold) {
    this.autoDeployConfidenceThreshold = autoDeployConfidenceThreshold;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Integer getAutoDeployExpirationSec() {
    return autoDeployExpirationSec;
  }

  /**
   * @param autoDeployExpirationSec autoDeployExpirationSec or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setAutoDeployExpirationSec(java.lang.Integer autoDeployExpirationSec) {
    this.autoDeployExpirationSec = autoDeployExpirationSec;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getAutoDeployImpactedBaselineThreshold() {
    return autoDeployImpactedBaselineThreshold;
  }

  /**
   * @param autoDeployImpactedBaselineThreshold autoDeployImpactedBaselineThreshold or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setAutoDeployImpactedBaselineThreshold(java.lang.Float autoDeployImpactedBaselineThreshold) {
    this.autoDeployImpactedBaselineThreshold = autoDeployImpactedBaselineThreshold;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getAutoDeployLoadThreshold() {
    return autoDeployLoadThreshold;
  }

  /**
   * @param autoDeployLoadThreshold autoDeployLoadThreshold or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setAutoDeployLoadThreshold(java.lang.Float autoDeployLoadThreshold) {
    this.autoDeployLoadThreshold = autoDeployLoadThreshold;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getDetectionAbsoluteQps() {
    return detectionAbsoluteQps;
  }

  /**
   * @param detectionAbsoluteQps detectionAbsoluteQps or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setDetectionAbsoluteQps(java.lang.Float detectionAbsoluteQps) {
    this.detectionAbsoluteQps = detectionAbsoluteQps;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getDetectionLoadThreshold() {
    return detectionLoadThreshold;
  }

  /**
   * @param detectionLoadThreshold detectionLoadThreshold or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setDetectionLoadThreshold(java.lang.Float detectionLoadThreshold) {
    this.detectionLoadThreshold = detectionLoadThreshold;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.Float getDetectionRelativeToBaselineQps() {
    return detectionRelativeToBaselineQps;
  }

  /**
   * @param detectionRelativeToBaselineQps detectionRelativeToBaselineQps or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setDetectionRelativeToBaselineQps(java.lang.Float detectionRelativeToBaselineQps) {
    this.detectionRelativeToBaselineQps = detectionRelativeToBaselineQps;
    return this;
  }

  /**
   * The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within
   * the security policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name must be 1-63 characters long, and comply with RFC1035. The name must be unique within
   * the security policy.
   * @param name name or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Configuration options for enabling Adaptive Protection to operate on specified granular traffic
   * units.
   * @return value or {@code null} for none
   */
  public java.util.List<SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig> getTrafficGranularityConfigs() {
    return trafficGranularityConfigs;
  }

  /**
   * Configuration options for enabling Adaptive Protection to operate on specified granular traffic
   * units.
   * @param trafficGranularityConfigs trafficGranularityConfigs or {@code null} for none
   */
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig setTrafficGranularityConfigs(java.util.List<SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfigTrafficGranularityConfig> trafficGranularityConfigs) {
    this.trafficGranularityConfigs = trafficGranularityConfigs;
    return this;
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig set(String fieldName, Object value) {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig clone() {
    return (SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfigThresholdConfig) super.clone();
  }

}
