/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Configuration for a Cloud Run network endpoint group (NEG). The service must be provided
 * explicitly or in the URL mask. The tag is optional, may be provided explicitly or in the URL
 * mask. Note: Cloud Run service must be in the same project and located in the same region as the
 * Serverless NEG.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkEndpointGroupCloudRun extends com.google.api.client.json.GenericJson {

  /**
   * Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long,
   * and comply with RFC1035. Example value: "run-service".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String service;

  /**
   * Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained
   * traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035.
   * Example value: "revision-0010".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * An URL mask is one of the main components of the Cloud Function. A template to parse  and
   * fields from a request URL. URL mask allows for routing to multiple Run services without having
   * to create multiple network endpoint groups and backend services. For example, request URLs
   * foo1.domain.com/bar1 and foo1.domain.com/bar2 can be backed by the same Serverless Network
   * Endpoint Group (NEG) with URL mask .domain.com/. The URL mask will parse them to {
   * service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String urlMask;

  /**
   * Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long,
   * and comply with RFC1035. Example value: "run-service".
   * @return value or {@code null} for none
   */
  public java.lang.String getService() {
    return service;
  }

  /**
   * Cloud Run service is the main resource of Cloud Run. The service must be 1-63 characters long,
   * and comply with RFC1035. Example value: "run-service".
   * @param service service or {@code null} for none
   */
  public NetworkEndpointGroupCloudRun setService(java.lang.String service) {
    this.service = service;
    return this;
  }

  /**
   * Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained
   * traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035.
   * Example value: "revision-0010".
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * Optional Cloud Run tag represents the "named-revision" to provide additional fine-grained
   * traffic routing information. The tag must be 1-63 characters long, and comply with RFC1035.
   * Example value: "revision-0010".
   * @param tag tag or {@code null} for none
   */
  public NetworkEndpointGroupCloudRun setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  /**
   * An URL mask is one of the main components of the Cloud Function. A template to parse  and
   * fields from a request URL. URL mask allows for routing to multiple Run services without having
   * to create multiple network endpoint groups and backend services. For example, request URLs
   * foo1.domain.com/bar1 and foo1.domain.com/bar2 can be backed by the same Serverless Network
   * Endpoint Group (NEG) with URL mask .domain.com/. The URL mask will parse them to {
   * service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
   * @return value or {@code null} for none
   */
  public java.lang.String getUrlMask() {
    return urlMask;
  }

  /**
   * An URL mask is one of the main components of the Cloud Function. A template to parse  and
   * fields from a request URL. URL mask allows for routing to multiple Run services without having
   * to create multiple network endpoint groups and backend services. For example, request URLs
   * foo1.domain.com/bar1 and foo1.domain.com/bar2 can be backed by the same Serverless Network
   * Endpoint Group (NEG) with URL mask .domain.com/. The URL mask will parse them to {
   * service="bar1", tag="foo1" } and { service="bar2", tag="foo2" } respectively.
   * @param urlMask urlMask or {@code null} for none
   */
  public NetworkEndpointGroupCloudRun setUrlMask(java.lang.String urlMask) {
    this.urlMask = urlMask;
    return this;
  }

  @Override
  public NetworkEndpointGroupCloudRun set(String fieldName, Object value) {
    return (NetworkEndpointGroupCloudRun) super.set(fieldName, value);
  }

  @Override
  public NetworkEndpointGroupCloudRun clone() {
    return (NetworkEndpointGroupCloudRun) super.clone();
  }

}
