/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A matcher for the path portion of the URL. The BackendService from the longest-matched rule will
 * serve the URL. If no rule was matched, the default service is used.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PathMatcher extends com.google.api.client.json.GenericJson {

  /**
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. This policy takes effect at the
   * PathMatcher level and applies only when no policy has been defined for the error code at lower
   * levels like RouteRule and PathRule within this PathMatcher. If an error code does not have a
   * policy defined in defaultCustomErrorResponsePolicy, then a policy defined for the error code in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy is configured with policies
   * for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * RouteRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * When used in conjunction with pathMatcher.defaultRouteAction.retryPolicy, retries take
   * precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is
   * applied. While attempting a retry, if load balancer is successful in reaching the service, the
   * defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to
   * the client. defaultCustomErrorResponsePolicy is supported only for global external Application
   * Load Balancers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CustomErrorResponsePolicy defaultCustomErrorResponsePolicy;

  /**
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load
   * balancer performs advanced routing actions, such as URL rewrites and header transformations,
   * before forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. URL maps for classic Application Load Balancers only support
   * the urlRewrite action within a path matcher's defaultRouteAction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRouteAction defaultRouteAction;

  /**
   * The full or partial URL to the BackendService resource. This URL is used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService -
   * compute/v1/projects/project/global/backendServices/backendService -
   * global/backendServices/backendService If defaultRouteAction is also specified, advanced routing
   * actions, such as URL rewrites, take effect before sending the request to the backend. However,
   * if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices.
   * Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must
   * not be specified. Only one of defaultService, defaultUrlRedirect , or
   * defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of
   * the following Google IAM permissions on the specified resource default_service: -
   * compute.backendBuckets.use - compute.backendServices.use
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultService;

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC
   * proxy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpRedirectAction defaultUrlRedirect;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backend service. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load
   * balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map
   * is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HttpHeaderAction headerAction;

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PathRule> pathRules;

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HttpRouteRule> routeRules;

  static {
    // hack to force ProGuard to consider HttpRouteRule used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HttpRouteRule.class);
  }

  /**
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. This policy takes effect at the
   * PathMatcher level and applies only when no policy has been defined for the error code at lower
   * levels like RouteRule and PathRule within this PathMatcher. If an error code does not have a
   * policy defined in defaultCustomErrorResponsePolicy, then a policy defined for the error code in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy is configured with policies
   * for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * RouteRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * When used in conjunction with pathMatcher.defaultRouteAction.retryPolicy, retries take
   * precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is
   * applied. While attempting a retry, if load balancer is successful in reaching the service, the
   * defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to
   * the client. defaultCustomErrorResponsePolicy is supported only for global external Application
   * Load Balancers.
   * @return value or {@code null} for none
   */
  public CustomErrorResponsePolicy getDefaultCustomErrorResponsePolicy() {
    return defaultCustomErrorResponsePolicy;
  }

  /**
   * defaultCustomErrorResponsePolicy specifies how the Load Balancer returns error responses when
   * BackendServiceor BackendBucket responds with an error. This policy takes effect at the
   * PathMatcher level and applies only when no policy has been defined for the error code at lower
   * levels like RouteRule and PathRule within this PathMatcher. If an error code does not have a
   * policy defined in defaultCustomErrorResponsePolicy, then a policy defined for the error code in
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. For example, consider a UrlMap with the
   * following configuration: - UrlMap.defaultCustomErrorResponsePolicy is configured with policies
   * for 5xx and 4xx errors - A RouteRule for /coming_soon/ is configured for the error code 404. If
   * the request is for www.myotherdomain.com and a 404 is encountered, the policy under
   * UrlMap.defaultCustomErrorResponsePolicy takes effect. If a 404 response is encountered for the
   * request www.example.com/current_events/, the pathMatcher's policy takes effect. If however, the
   * request for www.example.com/coming_soon/ encounters a 404, the policy in
   * RouteRule.customErrorResponsePolicy takes effect. If any of the requests in this example
   * encounter a 500 error code, the policy at UrlMap.defaultCustomErrorResponsePolicy takes effect.
   * When used in conjunction with pathMatcher.defaultRouteAction.retryPolicy, retries take
   * precedence. Only once all retries are exhausted, the defaultCustomErrorResponsePolicy is
   * applied. While attempting a retry, if load balancer is successful in reaching the service, the
   * defaultCustomErrorResponsePolicy is ignored and the response from the service is returned to
   * the client. defaultCustomErrorResponsePolicy is supported only for global external Application
   * Load Balancers.
   * @param defaultCustomErrorResponsePolicy defaultCustomErrorResponsePolicy or {@code null} for none
   */
  public PathMatcher setDefaultCustomErrorResponsePolicy(CustomErrorResponsePolicy defaultCustomErrorResponsePolicy) {
    this.defaultCustomErrorResponsePolicy = defaultCustomErrorResponsePolicy;
    return this;
  }

  /**
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load
   * balancer performs advanced routing actions, such as URL rewrites and header transformations,
   * before forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. URL maps for classic Application Load Balancers only support
   * the urlRewrite action within a path matcher's defaultRouteAction.
   * @return value or {@code null} for none
   */
  public HttpRouteAction getDefaultRouteAction() {
    return defaultRouteAction;
  }

  /**
   * defaultRouteAction takes effect when none of the pathRules or routeRules match. The load
   * balancer performs advanced routing actions, such as URL rewrites and header transformations,
   * before forwarding the request to the selected backend. If defaultRouteAction specifies any
   * weightedBackendServices, defaultService must not be set. Conversely if defaultService is set,
   * defaultRouteAction cannot contain any weightedBackendServices. Only one of defaultRouteAction
   * or defaultUrlRedirect must be set. URL maps for classic Application Load Balancers only support
   * the urlRewrite action within a path matcher's defaultRouteAction.
   * @param defaultRouteAction defaultRouteAction or {@code null} for none
   */
  public PathMatcher setDefaultRouteAction(HttpRouteAction defaultRouteAction) {
    this.defaultRouteAction = defaultRouteAction;
    return this;
  }

  /**
   * The full or partial URL to the BackendService resource. This URL is used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService -
   * compute/v1/projects/project/global/backendServices/backendService -
   * global/backendServices/backendService If defaultRouteAction is also specified, advanced routing
   * actions, such as URL rewrites, take effect before sending the request to the backend. However,
   * if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices.
   * Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must
   * not be specified. Only one of defaultService, defaultUrlRedirect , or
   * defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of
   * the following Google IAM permissions on the specified resource default_service: -
   * compute.backendBuckets.use - compute.backendServices.use
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultService() {
    return defaultService;
  }

  /**
   * The full or partial URL to the BackendService resource. This URL is used if none of the
   * pathRules or routeRules defined by this PathMatcher are matched. For example, the following are
   * all valid URLs to a BackendService resource: -
   * https://www.googleapis.com/compute/v1/projects/project /global/backendServices/backendService -
   * compute/v1/projects/project/global/backendServices/backendService -
   * global/backendServices/backendService If defaultRouteAction is also specified, advanced routing
   * actions, such as URL rewrites, take effect before sending the request to the backend. However,
   * if defaultService is specified, defaultRouteAction cannot contain any weightedBackendServices.
   * Conversely, if defaultRouteAction specifies any weightedBackendServices, defaultService must
   * not be specified. Only one of defaultService, defaultUrlRedirect , or
   * defaultRouteAction.weightedBackendService must be set. Authorization requires one or more of
   * the following Google IAM permissions on the specified resource default_service: -
   * compute.backendBuckets.use - compute.backendServices.use
   * @param defaultService defaultService or {@code null} for none
   */
  public PathMatcher setDefaultService(java.lang.String defaultService) {
    this.defaultService = defaultService;
    return this;
  }

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC
   * proxy.
   * @return value or {@code null} for none
   */
  public HttpRedirectAction getDefaultUrlRedirect() {
    return defaultUrlRedirect;
  }

  /**
   * When none of the specified pathRules or routeRules match, the request is redirected to a URL
   * specified by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
   * defaultRouteAction must not be set. Not supported when the URL map is bound to a target gRPC
   * proxy.
   * @param defaultUrlRedirect defaultUrlRedirect or {@code null} for none
   */
  public PathMatcher setDefaultUrlRedirect(HttpRedirectAction defaultUrlRedirect) {
    this.defaultUrlRedirect = defaultUrlRedirect;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public PathMatcher setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backend service. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load
   * balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map
   * is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * @return value or {@code null} for none
   */
  public HttpHeaderAction getHeaderAction() {
    return headerAction;
  }

  /**
   * Specifies changes to request and response headers that need to take effect for the selected
   * backend service. HeaderAction specified here are applied after the matching HttpRouteRule
   * HeaderAction and before the HeaderAction in the UrlMap HeaderAction is not supported for load
   * balancers that have their loadBalancingScheme set to EXTERNAL. Not supported when the URL map
   * is bound to a target gRPC proxy that has validateForProxyless field set to true.
   * @param headerAction headerAction or {@code null} for none
   */
  public PathMatcher setHeaderAction(HttpHeaderAction headerAction) {
    this.headerAction = headerAction;
    return this;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name to which this PathMatcher is referred by the HostRule.
   * @param name name or {@code null} for none
   */
  public PathMatcher setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * @return value or {@code null} for none
   */
  public java.util.List<PathRule> getPathRules() {
    return pathRules;
  }

  /**
   * The list of path rules. Use this list instead of routeRules when routing based on simple path
   * matching is all that's required. The order by which path rules are specified does not matter.
   * Matches are always done on the longest-path-first basis. For example: a pathRule with a path
   * /a/b/c will match before /a/b irrespective of the order in which those paths appear in this
   * list. Within a given pathMatcher, only one of pathRules or routeRules must be set.
   * @param pathRules pathRules or {@code null} for none
   */
  public PathMatcher setPathRules(java.util.List<PathRule> pathRules) {
    this.pathRules = pathRules;
    return this;
  }

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * @return value or {@code null} for none
   */
  public java.util.List<HttpRouteRule> getRouteRules() {
    return routeRules;
  }

  /**
   * The list of HTTP route rules. Use this list instead of pathRules when advanced route matching
   * and routing actions are desired. routeRules are evaluated in order of priority, from the lowest
   * to highest number. Within a given pathMatcher, you can set only one of pathRules or routeRules.
   * @param routeRules routeRules or {@code null} for none
   */
  public PathMatcher setRouteRules(java.util.List<HttpRouteRule> routeRules) {
    this.routeRules = routeRules;
    return this;
  }

  @Override
  public PathMatcher set(String fieldName, Object value) {
    return (PathMatcher) super.set(fieldName, value);
  }

  @Override
  public PathMatcher clone() {
    return (PathMatcher) super.clone();
  }

}
