/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The network endpoint.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NetworkEndpoint extends com.google.api.client.json.GenericJson {

  /**
   * Metadata defined as annotations on the network endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> annotations;

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with GCE_VM_IP_PORTMAP endpoint type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer clientDestinationPort;

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with CLIENT_PORT_PER_ENDPOINT mapping mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer clientPort;

  /**
   * Optional fully qualified domain name of network endpoint. This can only be specified when
   * NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fqdn;

  /**
   * The name or a URL of VM instance of this network endpoint. This field is required for network
   * endpoints of type GCE_VM_IP and GCE_VM_IP_PORT. The instance must be in the same zone of
   * network endpoint group (for zonal NEGs) or in the zone within the region of the NEG (for
   * regional NEGs). If the ipAddress is specified, it must belongs to the VM instance. The name
   * must be 1-63 characters long, and comply with RFC1035 or be a valid URL pointing to an existing
   * instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instance;

  /**
   * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine
   * (either the primary IP or as part of an aliased IP range). If the IP address is not specified,
   * then the primary IP address for the VM instance in the network that the network endpoint group
   * belongs to will be used. This field is redundant and need not be set for network endpoints of
   * type GCE_VM_IP. If set, it must be set to the primary internal IP address of the attached VM
   * instance that matches the subnetwork of the NEG. The primary internal IP address from any NIC
   * of a multi-NIC VM instance can be added to a NEG as long as it matches the NEG subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * Optional IPv6 address of network endpoint.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6Address;

  /**
   * Optional port number of network endpoint. If not specified, the defaultPort for the network
   * endpoint group will be used. This field can not be set for network endpoints of type GCE_VM_IP.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * Metadata defined as annotations on the network endpoint.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getAnnotations() {
    return annotations;
  }

  /**
   * Metadata defined as annotations on the network endpoint.
   * @param annotations annotations or {@code null} for none
   */
  public NetworkEndpoint setAnnotations(java.util.Map<String, java.lang.String> annotations) {
    this.annotations = annotations;
    return this;
  }

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with GCE_VM_IP_PORTMAP endpoint type.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getClientDestinationPort() {
    return clientDestinationPort;
  }

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with GCE_VM_IP_PORTMAP endpoint type.
   * @param clientDestinationPort clientDestinationPort or {@code null} for none
   */
  public NetworkEndpoint setClientDestinationPort(java.lang.Integer clientDestinationPort) {
    this.clientDestinationPort = clientDestinationPort;
    return this;
  }

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with CLIENT_PORT_PER_ENDPOINT mapping mode.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getClientPort() {
    return clientPort;
  }

  /**
   * Represents the port number to which PSC consumer sends packets. Only valid for network endpoint
   * groups created with CLIENT_PORT_PER_ENDPOINT mapping mode.
   * @param clientPort clientPort or {@code null} for none
   */
  public NetworkEndpoint setClientPort(java.lang.Integer clientPort) {
    this.clientPort = clientPort;
    return this;
  }

  /**
   * Optional fully qualified domain name of network endpoint. This can only be specified when
   * NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
   * @return value or {@code null} for none
   */
  public java.lang.String getFqdn() {
    return fqdn;
  }

  /**
   * Optional fully qualified domain name of network endpoint. This can only be specified when
   * NetworkEndpointGroup.network_endpoint_type is NON_GCP_FQDN_PORT.
   * @param fqdn fqdn or {@code null} for none
   */
  public NetworkEndpoint setFqdn(java.lang.String fqdn) {
    this.fqdn = fqdn;
    return this;
  }

  /**
   * The name or a URL of VM instance of this network endpoint. This field is required for network
   * endpoints of type GCE_VM_IP and GCE_VM_IP_PORT. The instance must be in the same zone of
   * network endpoint group (for zonal NEGs) or in the zone within the region of the NEG (for
   * regional NEGs). If the ipAddress is specified, it must belongs to the VM instance. The name
   * must be 1-63 characters long, and comply with RFC1035 or be a valid URL pointing to an existing
   * instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstance() {
    return instance;
  }

  /**
   * The name or a URL of VM instance of this network endpoint. This field is required for network
   * endpoints of type GCE_VM_IP and GCE_VM_IP_PORT. The instance must be in the same zone of
   * network endpoint group (for zonal NEGs) or in the zone within the region of the NEG (for
   * regional NEGs). If the ipAddress is specified, it must belongs to the VM instance. The name
   * must be 1-63 characters long, and comply with RFC1035 or be a valid URL pointing to an existing
   * instance.
   * @param instance instance or {@code null} for none
   */
  public NetworkEndpoint setInstance(java.lang.String instance) {
    this.instance = instance;
    return this;
  }

  /**
   * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine
   * (either the primary IP or as part of an aliased IP range). If the IP address is not specified,
   * then the primary IP address for the VM instance in the network that the network endpoint group
   * belongs to will be used. This field is redundant and need not be set for network endpoints of
   * type GCE_VM_IP. If set, it must be set to the primary internal IP address of the attached VM
   * instance that matches the subnetwork of the NEG. The primary internal IP address from any NIC
   * of a multi-NIC VM instance can be added to a NEG as long as it matches the NEG subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * Optional IPv4 address of network endpoint. The IP address must belong to a VM in Compute Engine
   * (either the primary IP or as part of an aliased IP range). If the IP address is not specified,
   * then the primary IP address for the VM instance in the network that the network endpoint group
   * belongs to will be used. This field is redundant and need not be set for network endpoints of
   * type GCE_VM_IP. If set, it must be set to the primary internal IP address of the attached VM
   * instance that matches the subnetwork of the NEG. The primary internal IP address from any NIC
   * of a multi-NIC VM instance can be added to a NEG as long as it matches the NEG subnetwork.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public NetworkEndpoint setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * Optional IPv6 address of network endpoint.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6Address() {
    return ipv6Address;
  }

  /**
   * Optional IPv6 address of network endpoint.
   * @param ipv6Address ipv6Address or {@code null} for none
   */
  public NetworkEndpoint setIpv6Address(java.lang.String ipv6Address) {
    this.ipv6Address = ipv6Address;
    return this;
  }

  /**
   * Optional port number of network endpoint. If not specified, the defaultPort for the network
   * endpoint group will be used. This field can not be set for network endpoints of type GCE_VM_IP.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * Optional port number of network endpoint. If not specified, the defaultPort for the network
   * endpoint group will be used. This field can not be set for network endpoints of type GCE_VM_IP.
   * @param port port or {@code null} for none
   */
  public NetworkEndpoint setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  @Override
  public NetworkEndpoint set(String fieldName, Object value) {
    return (NetworkEndpoint) super.set(fieldName, value);
  }

  @Override
  public NetworkEndpoint clone() {
    return (NetworkEndpoint) super.clone();
  }

}
