/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceSettingsMetadata.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceSettingsMetadata extends com.google.api.client.json.GenericJson {

  /**
   * A metadata key/value items map. The total size of all keys and values must be less than 512KB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> items;

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A metadata key/value items map. The total size of all keys and values must be less than 512KB.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getItems() {
    return items;
  }

  /**
   * A metadata key/value items map. The total size of all keys and values must be less than 512KB.
   * @param items items or {@code null} for none
   */
  public InstanceSettingsMetadata setItems(java.util.Map<String, java.lang.String> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * @param kind kind or {@code null} for none
   */
  public InstanceSettingsMetadata setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public InstanceSettingsMetadata set(String fieldName, Object value) {
    return (InstanceSettingsMetadata) super.set(fieldName, value);
  }

  @Override
  public InstanceSettingsMetadata clone() {
    return (InstanceSettingsMetadata) super.clone();
  }

}
