/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition of partner_metadata field. To be used in dedicated Partner Metadata methods and
 * to be inlined in the Instance and InstanceTemplate resources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PartnerMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Instance-level hash to be used for optimistic locking.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * Partner Metadata assigned to the instance. A map from a subdomain to entries map. Subdomain
   * name must be compliant with RFC1035 definition. The total size of all keys and values must be
   * less than 2MB. Subdomain 'metadata.compute.googleapis.com' is reserverd for instance's
   * metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, StructuredEntries> partnerMetadata;

  /**
   * Instance-level hash to be used for optimistic locking.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Instance-level hash to be used for optimistic locking.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Instance-level hash to be used for optimistic locking.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public PartnerMetadata setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Instance-level hash to be used for optimistic locking.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public PartnerMetadata encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * Partner Metadata assigned to the instance. A map from a subdomain to entries map. Subdomain
   * name must be compliant with RFC1035 definition. The total size of all keys and values must be
   * less than 2MB. Subdomain 'metadata.compute.googleapis.com' is reserverd for instance's
   * metadata.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, StructuredEntries> getPartnerMetadata() {
    return partnerMetadata;
  }

  /**
   * Partner Metadata assigned to the instance. A map from a subdomain to entries map. Subdomain
   * name must be compliant with RFC1035 definition. The total size of all keys and values must be
   * less than 2MB. Subdomain 'metadata.compute.googleapis.com' is reserverd for instance's
   * metadata.
   * @param partnerMetadata partnerMetadata or {@code null} for none
   */
  public PartnerMetadata setPartnerMetadata(java.util.Map<String, StructuredEntries> partnerMetadata) {
    this.partnerMetadata = partnerMetadata;
    return this;
  }

  @Override
  public PartnerMetadata set(String fieldName, Object value) {
    return (PartnerMetadata) super.set(fieldName, value);
  }

  @Override
  public PartnerMetadata clone() {
    return (PartnerMetadata) super.clone();
  }

}
