/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A policy that specifies how requests intended for the route's backends are shadowed to a separate
 * mirrored backend service. The load balancer doesn't wait for responses from the shadow service.
 * Before sending traffic to the shadow service, the host or authority header is suffixed with
 * -shadow.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RequestMirrorPolicy extends com.google.api.client.json.GenericJson {

  /**
   * The full or partial URL to the BackendService resource being mirrored to. The backend service
   * configured for a mirroring policy must reference backends that are of the same type as the
   * original backend service matched in the URL map. Serverless NEG backends are not currently
   * supported as a mirrored backend service.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backendService;

  /**
   * The percentage of requests to be mirrored to `backend_service`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double mirrorPercent;

  /**
   * The full or partial URL to the BackendService resource being mirrored to. The backend service
   * configured for a mirroring policy must reference backends that are of the same type as the
   * original backend service matched in the URL map. Serverless NEG backends are not currently
   * supported as a mirrored backend service.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackendService() {
    return backendService;
  }

  /**
   * The full or partial URL to the BackendService resource being mirrored to. The backend service
   * configured for a mirroring policy must reference backends that are of the same type as the
   * original backend service matched in the URL map. Serverless NEG backends are not currently
   * supported as a mirrored backend service.
   * @param backendService backendService or {@code null} for none
   */
  public RequestMirrorPolicy setBackendService(java.lang.String backendService) {
    this.backendService = backendService;
    return this;
  }

  /**
   * The percentage of requests to be mirrored to `backend_service`.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMirrorPercent() {
    return mirrorPercent;
  }

  /**
   * The percentage of requests to be mirrored to `backend_service`.
   * @param mirrorPercent mirrorPercent or {@code null} for none
   */
  public RequestMirrorPolicy setMirrorPercent(java.lang.Double mirrorPercent) {
    this.mirrorPercent = mirrorPercent;
    return this;
  }

  @Override
  public RequestMirrorPolicy set(String fieldName, Object value) {
    return (RequestMirrorPolicy) super.set(fieldName, value);
  }

  @Override
  public RequestMirrorPolicy clone() {
    return (RequestMirrorPolicy) super.clone();
  }

}
