/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Information about recommendation status for locations that were allowed but not used by the
 * response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FutureResourcesRecommendationOtherLocation extends com.google.api.client.json.GenericJson {

  /**
   * Details (human readable) describing the situation. For example, if status is CONDITION_NOT_MET,
   * then details contain information about the parameters of the time window that did not meet the
   * required conditions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String details;

  /**
   * Status of recommendation in this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Details (human readable) describing the situation. For example, if status is CONDITION_NOT_MET,
   * then details contain information about the parameters of the time window that did not meet the
   * required conditions.
   * @return value or {@code null} for none
   */
  public java.lang.String getDetails() {
    return details;
  }

  /**
   * Details (human readable) describing the situation. For example, if status is CONDITION_NOT_MET,
   * then details contain information about the parameters of the time window that did not meet the
   * required conditions.
   * @param details details or {@code null} for none
   */
  public FutureResourcesRecommendationOtherLocation setDetails(java.lang.String details) {
    this.details = details;
    return this;
  }

  /**
   * Status of recommendation in this location.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of recommendation in this location.
   * @param status status or {@code null} for none
   */
  public FutureResourcesRecommendationOtherLocation setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public FutureResourcesRecommendationOtherLocation set(String fieldName, Object value) {
    return (FutureResourcesRecommendationOtherLocation) super.set(fieldName, value);
  }

  @Override
  public FutureResourcesRecommendationOtherLocation clone() {
    return (FutureResourcesRecommendationOtherLocation) super.clone();
  }

}
