/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Describes the cause of the error with structured details. Example of an error when contacting the
 * "pubsub.googleapis.com" API when it is not enabled: { "reason": "API_DISABLED" "domain":
 * "googleapis.com" "metadata": { "resource": "projects/123", "service": "pubsub.googleapis.com" } }
 * This response indicates that the pubsub.googleapis.com API is not enabled. Example of an error
 * that is returned when attempting to create a Spanner instance in a region that is out of stock: {
 * "reason": "STOCKOUT" "domain": "spanner.googleapis.com", "metadata": { "availableRegions": "us-
 * central1,us-east2" } }
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ErrorInfo extends com.google.api.client.json.GenericJson {

  /**
   * The logical grouping to which the "reason" belongs. The error domain is typically the
   * registered service name of the tool or product that generates the error. Example:
   * "pubsub.googleapis.com". If the error is generated by some common infrastructure, the error
   * domain must be a globally unique value that identifies the infrastructure. For Google API
   * infrastructure, the error domain is "googleapis.com".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domain;

  /**
   * Additional structured details about this error. Keys must match a regular expression of `a-z+`
   * but should ideally be lowerCamelCase. Also, they must be limited to 64 characters in length.
   * When identifying the current value of an exceeded limit, the units should be contained in the
   * key, not the value. For example, rather than `{"instanceLimit": "100/request"}`, should be
   * returned as, `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
   * instances that can be created in a single (batch) request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> metadatas;

  /**
   * The reason of the error. This is a constant value that identifies the proximate cause of the
   * error. Error reasons are unique within a particular domain of errors. This should be at most 63
   * characters and match a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The logical grouping to which the "reason" belongs. The error domain is typically the
   * registered service name of the tool or product that generates the error. Example:
   * "pubsub.googleapis.com". If the error is generated by some common infrastructure, the error
   * domain must be a globally unique value that identifies the infrastructure. For Google API
   * infrastructure, the error domain is "googleapis.com".
   * @return value or {@code null} for none
   */
  public java.lang.String getDomain() {
    return domain;
  }

  /**
   * The logical grouping to which the "reason" belongs. The error domain is typically the
   * registered service name of the tool or product that generates the error. Example:
   * "pubsub.googleapis.com". If the error is generated by some common infrastructure, the error
   * domain must be a globally unique value that identifies the infrastructure. For Google API
   * infrastructure, the error domain is "googleapis.com".
   * @param domain domain or {@code null} for none
   */
  public ErrorInfo setDomain(java.lang.String domain) {
    this.domain = domain;
    return this;
  }

  /**
   * Additional structured details about this error. Keys must match a regular expression of `a-z+`
   * but should ideally be lowerCamelCase. Also, they must be limited to 64 characters in length.
   * When identifying the current value of an exceeded limit, the units should be contained in the
   * key, not the value. For example, rather than `{"instanceLimit": "100/request"}`, should be
   * returned as, `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
   * instances that can be created in a single (batch) request.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getMetadatas() {
    return metadatas;
  }

  /**
   * Additional structured details about this error. Keys must match a regular expression of `a-z+`
   * but should ideally be lowerCamelCase. Also, they must be limited to 64 characters in length.
   * When identifying the current value of an exceeded limit, the units should be contained in the
   * key, not the value. For example, rather than `{"instanceLimit": "100/request"}`, should be
   * returned as, `{"instanceLimitPerRequest": "100"}`, if the client exceeds the number of
   * instances that can be created in a single (batch) request.
   * @param metadatas metadatas or {@code null} for none
   */
  public ErrorInfo setMetadatas(java.util.Map<String, java.lang.String> metadatas) {
    this.metadatas = metadatas;
    return this;
  }

  /**
   * The reason of the error. This is a constant value that identifies the proximate cause of the
   * error. Error reasons are unique within a particular domain of errors. This should be at most 63
   * characters and match a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * The reason of the error. This is a constant value that identifies the proximate cause of the
   * error. Error reasons are unique within a particular domain of errors. This should be at most 63
   * characters and match a regular expression of `A-Z+[A-Z0-9]`, which represents UPPER_SNAKE_CASE.
   * @param reason reason or {@code null} for none
   */
  public ErrorInfo setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  @Override
  public ErrorInfo set(String fieldName, Object value) {
    return (ErrorInfo) super.set(fieldName, value);
  }

  @Override
  public ErrorInfo clone() {
    return (ErrorInfo) super.clone();
  }

}
