/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for InstanceGroupManagerInstanceLifecyclePolicy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerInstanceLifecyclePolicy extends com.google.api.client.json.GenericJson {

  /**
   * The action that a MIG performs on a failed VM. If the value of the onFailedHealthCheck field is
   * `DEFAULT_ACTION`, then the same action also applies to the VMs on which your application fails
   * a health check. Valid values are - REPAIR (default): MIG automatically repairs a failed VM by
   * recreating it. For more information, see About repairing VMs in a MIG. - DO_NOTHING: MIG does
   * not repair a failed VM.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultActionOnFailure;

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. Instead, configuration updates are applied according to the
   * group's update policy. - YES: If configuration updates are available, they are applied during
   * repair.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String forceUpdateOnRepair;

  /**
   * The action that a MIG performs on an unhealthy VM. A VM is marked as unhealthy when the
   * application running on that VM fails a health check. Valid values are: - DEFAULT_ACTION
   * (default): MIG uses the same action configured for
   * instanceLifecyclePolicy.defaultActionOnFailure field. - REPAIR: MIG automatically repairs an
   * unhealthy VM by recreating it. - DO_NOTHING: MIG doesn't repair an unhealthy VM. For more
   * information, see About repairing VMs in a MIG.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String onFailedHealthCheck;

  /**
   * The action that a MIG performs on a failed VM. If the value of the onFailedHealthCheck field is
   * `DEFAULT_ACTION`, then the same action also applies to the VMs on which your application fails
   * a health check. Valid values are - REPAIR (default): MIG automatically repairs a failed VM by
   * recreating it. For more information, see About repairing VMs in a MIG. - DO_NOTHING: MIG does
   * not repair a failed VM.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultActionOnFailure() {
    return defaultActionOnFailure;
  }

  /**
   * The action that a MIG performs on a failed VM. If the value of the onFailedHealthCheck field is
   * `DEFAULT_ACTION`, then the same action also applies to the VMs on which your application fails
   * a health check. Valid values are - REPAIR (default): MIG automatically repairs a failed VM by
   * recreating it. For more information, see About repairing VMs in a MIG. - DO_NOTHING: MIG does
   * not repair a failed VM.
   * @param defaultActionOnFailure defaultActionOnFailure or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicy setDefaultActionOnFailure(java.lang.String defaultActionOnFailure) {
    this.defaultActionOnFailure = defaultActionOnFailure;
    return this;
  }

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. Instead, configuration updates are applied according to the
   * group's update policy. - YES: If configuration updates are available, they are applied during
   * repair.
   * @return value or {@code null} for none
   */
  public java.lang.String getForceUpdateOnRepair() {
    return forceUpdateOnRepair;
  }

  /**
   * A bit indicating whether to forcefully apply the group's latest configuration when repairing a
   * VM. Valid options are: - NO (default): If configuration updates are available, they are not
   * forcefully applied during repair. Instead, configuration updates are applied according to the
   * group's update policy. - YES: If configuration updates are available, they are applied during
   * repair.
   * @param forceUpdateOnRepair forceUpdateOnRepair or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicy setForceUpdateOnRepair(java.lang.String forceUpdateOnRepair) {
    this.forceUpdateOnRepair = forceUpdateOnRepair;
    return this;
  }

  /**
   * The action that a MIG performs on an unhealthy VM. A VM is marked as unhealthy when the
   * application running on that VM fails a health check. Valid values are: - DEFAULT_ACTION
   * (default): MIG uses the same action configured for
   * instanceLifecyclePolicy.defaultActionOnFailure field. - REPAIR: MIG automatically repairs an
   * unhealthy VM by recreating it. - DO_NOTHING: MIG doesn't repair an unhealthy VM. For more
   * information, see About repairing VMs in a MIG.
   * @return value or {@code null} for none
   */
  public java.lang.String getOnFailedHealthCheck() {
    return onFailedHealthCheck;
  }

  /**
   * The action that a MIG performs on an unhealthy VM. A VM is marked as unhealthy when the
   * application running on that VM fails a health check. Valid values are: - DEFAULT_ACTION
   * (default): MIG uses the same action configured for
   * instanceLifecyclePolicy.defaultActionOnFailure field. - REPAIR: MIG automatically repairs an
   * unhealthy VM by recreating it. - DO_NOTHING: MIG doesn't repair an unhealthy VM. For more
   * information, see About repairing VMs in a MIG.
   * @param onFailedHealthCheck onFailedHealthCheck or {@code null} for none
   */
  public InstanceGroupManagerInstanceLifecyclePolicy setOnFailedHealthCheck(java.lang.String onFailedHealthCheck) {
    this.onFailedHealthCheck = onFailedHealthCheck;
    return this;
  }

  @Override
  public InstanceGroupManagerInstanceLifecyclePolicy set(String fieldName, Object value) {
    return (InstanceGroupManagerInstanceLifecyclePolicy) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerInstanceLifecyclePolicy clone() {
    return (InstanceGroupManagerInstanceLifecyclePolicy) super.clone();
  }

}
