/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * InstanceGroupManagerResizeRequest represents a request to create a number of VMs: either
 * immediately or by queuing the request for the specified time. This resize request is nested under
 * InstanceGroupManager and the VMs created by this request are added to the owning
 * InstanceGroupManager.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceGroupManagerResizeRequest extends com.google.api.client.json.GenericJson {

  /**
   * This field is deprecated, please use resize_by instead. The count of instances to create as
   * part of this resize request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * [Output Only] The creation timestamp for this resize request in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * The names of instances to be created by this resize request. The number of names specified
   * determines the number of instances to create. The group's target size will be increased by this
   * number. This field cannot be used together with 'resize_by'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<PerInstanceConfig> instances;

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerResizeRequest for
   * resize requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of this resize request. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] The URL of a region where the resize request is located. Populated only for
   * regional resize requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Requested run duration for instances that will be created by this request. At the end of the
   * run duration instance will be deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Duration requestedRunDuration;

  /**
   * The number of instances to be created by this resize request. The group's target size will be
   * increased by this number. This field cannot be used together with 'instances'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer resizeBy;

  /**
   * [Output Only] The URL for this resize request. The server defines this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLinkWithId;

  /**
   * [Output only] Current state of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * [Output only] Status of the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private InstanceGroupManagerResizeRequestStatus status;

  /**
   * [Output Only] The URL of a zone where the resize request is located. Populated only for zonal
   * resize requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * This field is deprecated, please use resize_by instead. The count of instances to create as
   * part of this resize request.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * This field is deprecated, please use resize_by instead. The count of instances to create as
   * part of this resize request.
   * @param count count or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * [Output Only] The creation timestamp for this resize request in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] The creation timestamp for this resize request in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] A unique identifier for this resource type. The server generates this identifier.
   * @param id id or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * The names of instances to be created by this resize request. The number of names specified
   * determines the number of instances to create. The group's target size will be increased by this
   * number. This field cannot be used together with 'resize_by'.
   * @return value or {@code null} for none
   */
  public java.util.List<PerInstanceConfig> getInstances() {
    return instances;
  }

  /**
   * The names of instances to be created by this resize request. The number of names specified
   * determines the number of instances to create. The group's target size will be increased by this
   * number. This field cannot be used together with 'resize_by'.
   * @param instances instances or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setInstances(java.util.List<PerInstanceConfig> instances) {
    this.instances = instances;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerResizeRequest for
   * resize requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerResizeRequest for
   * resize requests.
   * @param kind kind or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of this resize request. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this resize request. The name must be 1-63 characters long, and comply with
   * RFC1035.
   * @param name name or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] The URL of a region where the resize request is located. Populated only for
   * regional resize requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] The URL of a region where the resize request is located. Populated only for
   * regional resize requests.
   * @param region region or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Requested run duration for instances that will be created by this request. At the end of the
   * run duration instance will be deleted.
   * @return value or {@code null} for none
   */
  public Duration getRequestedRunDuration() {
    return requestedRunDuration;
  }

  /**
   * Requested run duration for instances that will be created by this request. At the end of the
   * run duration instance will be deleted.
   * @param requestedRunDuration requestedRunDuration or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setRequestedRunDuration(Duration requestedRunDuration) {
    this.requestedRunDuration = requestedRunDuration;
    return this;
  }

  /**
   * The number of instances to be created by this resize request. The group's target size will be
   * increased by this number. This field cannot be used together with 'instances'.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getResizeBy() {
    return resizeBy;
  }

  /**
   * The number of instances to be created by this resize request. The group's target size will be
   * increased by this number. This field cannot be used together with 'instances'.
   * @param resizeBy resizeBy or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setResizeBy(java.lang.Integer resizeBy) {
    this.resizeBy = resizeBy;
    return this;
  }

  /**
   * [Output Only] The URL for this resize request. The server defines this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] The URL for this resize request. The server defines this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLinkWithId() {
    return selfLinkWithId;
  }

  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   * @param selfLinkWithId selfLinkWithId or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setSelfLinkWithId(java.lang.String selfLinkWithId) {
    this.selfLinkWithId = selfLinkWithId;
    return this;
  }

  /**
   * [Output only] Current state of the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * [Output only] Current state of the request.
   * @param state state or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * [Output only] Status of the request.
   * @return value or {@code null} for none
   */
  public InstanceGroupManagerResizeRequestStatus getStatus() {
    return status;
  }

  /**
   * [Output only] Status of the request.
   * @param status status or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setStatus(InstanceGroupManagerResizeRequestStatus status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] The URL of a zone where the resize request is located. Populated only for zonal
   * resize requests.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] The URL of a zone where the resize request is located. Populated only for zonal
   * resize requests.
   * @param zone zone or {@code null} for none
   */
  public InstanceGroupManagerResizeRequest setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public InstanceGroupManagerResizeRequest set(String fieldName, Object value) {
    return (InstanceGroupManagerResizeRequest) super.set(fieldName, value);
  }

  @Override
  public InstanceGroupManagerResizeRequest clone() {
    return (InstanceGroupManagerResizeRequest) super.clone();
  }

}
