/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Multi-MIG represents a group of managed instance groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MultiMig extends com.google.api.client.json.GenericJson {

  /**
   * [Output only] The creation timestamp of this multi-MIG in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output only] Type of the resource. Always compute#multiMig for multi-MIGs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of the multi-MIG. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output only] The URL of the region where the resource resides. You must specify this field as
   * part of the HTTP request URL. You cannot set the region as a field in the request body.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * Resource policies for this multi-MIG.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MultiMigResourcePolicies resourcePolicies;

  /**
   * [Output only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output only] The creation timestamp of this multi-MIG in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output only] The creation timestamp of this multi-MIG in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public MultiMig setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource.
   * @param description description or {@code null} for none
   */
  public MultiMig setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output only] The unique identifier for this resource type. The server generates this
   * identifier.
   * @param id id or {@code null} for none
   */
  public MultiMig setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output only] Type of the resource. Always compute#multiMig for multi-MIGs.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output only] Type of the resource. Always compute#multiMig for multi-MIGs.
   * @param kind kind or {@code null} for none
   */
  public MultiMig setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of the multi-MIG. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of the multi-MIG. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular expression
   * `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and
   * all following characters must be a dash, lowercase letter, or digit, except the last character,
   * which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public MultiMig setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output only] The URL of the region where the resource resides. You must specify this field as
   * part of the HTTP request URL. You cannot set the region as a field in the request body.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output only] The URL of the region where the resource resides. You must specify this field as
   * part of the HTTP request URL. You cannot set the region as a field in the request body.
   * @param region region or {@code null} for none
   */
  public MultiMig setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * Resource policies for this multi-MIG.
   * @return value or {@code null} for none
   */
  public MultiMigResourcePolicies getResourcePolicies() {
    return resourcePolicies;
  }

  /**
   * Resource policies for this multi-MIG.
   * @param resourcePolicies resourcePolicies or {@code null} for none
   */
  public MultiMig setResourcePolicies(MultiMigResourcePolicies resourcePolicies) {
    this.resourcePolicies = resourcePolicies;
    return this;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public MultiMig setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public MultiMig set(String fieldName, Object value) {
    return (MultiMig) super.set(fieldName, value);
  }

  @Override
  public MultiMig clone() {
    return (MultiMig) super.clone();
  }

}
