/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for ResourcePolicyResourceStatusInstanceSchedulePolicyStatus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ResourcePolicyResourceStatusInstanceSchedulePolicyStatus extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The last time the schedule successfully ran. The timestamp is an RFC3339 string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastRunStartTime;

  /**
   * [Output Only] The next time the schedule is planned to run. The actual time might be slightly
   * different. The timestamp is an RFC3339 string.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextRunStartTime;

  /**
   * [Output Only] The last time the schedule successfully ran. The timestamp is an RFC3339 string.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastRunStartTime() {
    return lastRunStartTime;
  }

  /**
   * [Output Only] The last time the schedule successfully ran. The timestamp is an RFC3339 string.
   * @param lastRunStartTime lastRunStartTime or {@code null} for none
   */
  public ResourcePolicyResourceStatusInstanceSchedulePolicyStatus setLastRunStartTime(java.lang.String lastRunStartTime) {
    this.lastRunStartTime = lastRunStartTime;
    return this;
  }

  /**
   * [Output Only] The next time the schedule is planned to run. The actual time might be slightly
   * different. The timestamp is an RFC3339 string.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextRunStartTime() {
    return nextRunStartTime;
  }

  /**
   * [Output Only] The next time the schedule is planned to run. The actual time might be slightly
   * different. The timestamp is an RFC3339 string.
   * @param nextRunStartTime nextRunStartTime or {@code null} for none
   */
  public ResourcePolicyResourceStatusInstanceSchedulePolicyStatus setNextRunStartTime(java.lang.String nextRunStartTime) {
    this.nextRunStartTime = nextRunStartTime;
    return this;
  }

  @Override
  public ResourcePolicyResourceStatusInstanceSchedulePolicyStatus set(String fieldName, Object value) {
    return (ResourcePolicyResourceStatusInstanceSchedulePolicyStatus) super.set(fieldName, value);
  }

  @Override
  public ResourcePolicyResourceStatusInstanceSchedulePolicyStatus clone() {
    return (ResourcePolicyResourceStatusInstanceSchedulePolicyStatus) super.clone();
  }

}
