/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SecurityPolicyAdvancedOptionsConfig.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SecurityPolicyAdvancedOptionsConfig extends com.google.api.client.json.GenericJson {

  /**
   * Custom configuration to apply the JSON parsing. Only applicable when json_parsing is set to
   * STANDARD.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SecurityPolicyAdvancedOptionsConfigJsonCustomConfig jsonCustomConfig;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jsonParsing;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String logLevel;

  /**
   * The maximum request size chosen by the customer with Waf enabled. Currently only "8KB" and
   * "128KB" are supported. Values are case insensitive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestBodyInspectionSize;

  /**
   * An optional list of case-insensitive request header names to use for resolving the callers
   * client IP address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> userIpRequestHeaders;

  /**
   * Custom configuration to apply the JSON parsing. Only applicable when json_parsing is set to
   * STANDARD.
   * @return value or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfigJsonCustomConfig getJsonCustomConfig() {
    return jsonCustomConfig;
  }

  /**
   * Custom configuration to apply the JSON parsing. Only applicable when json_parsing is set to
   * STANDARD.
   * @param jsonCustomConfig jsonCustomConfig or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfig setJsonCustomConfig(SecurityPolicyAdvancedOptionsConfigJsonCustomConfig jsonCustomConfig) {
    this.jsonCustomConfig = jsonCustomConfig;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getJsonParsing() {
    return jsonParsing;
  }

  /**
   * @param jsonParsing jsonParsing or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfig setJsonParsing(java.lang.String jsonParsing) {
    this.jsonParsing = jsonParsing;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getLogLevel() {
    return logLevel;
  }

  /**
   * @param logLevel logLevel or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfig setLogLevel(java.lang.String logLevel) {
    this.logLevel = logLevel;
    return this;
  }

  /**
   * The maximum request size chosen by the customer with Waf enabled. Currently only "8KB" and
   * "128KB" are supported. Values are case insensitive.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestBodyInspectionSize() {
    return requestBodyInspectionSize;
  }

  /**
   * The maximum request size chosen by the customer with Waf enabled. Currently only "8KB" and
   * "128KB" are supported. Values are case insensitive.
   * @param requestBodyInspectionSize requestBodyInspectionSize or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfig setRequestBodyInspectionSize(java.lang.String requestBodyInspectionSize) {
    this.requestBodyInspectionSize = requestBodyInspectionSize;
    return this;
  }

  /**
   * An optional list of case-insensitive request header names to use for resolving the callers
   * client IP address.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUserIpRequestHeaders() {
    return userIpRequestHeaders;
  }

  /**
   * An optional list of case-insensitive request header names to use for resolving the callers
   * client IP address.
   * @param userIpRequestHeaders userIpRequestHeaders or {@code null} for none
   */
  public SecurityPolicyAdvancedOptionsConfig setUserIpRequestHeaders(java.util.List<java.lang.String> userIpRequestHeaders) {
    this.userIpRequestHeaders = userIpRequestHeaders;
    return this;
  }

  @Override
  public SecurityPolicyAdvancedOptionsConfig set(String fieldName, Object value) {
    return (SecurityPolicyAdvancedOptionsConfig) super.set(fieldName, value);
  }

  @Override
  public SecurityPolicyAdvancedOptionsConfig clone() {
    return (SecurityPolicyAdvancedOptionsConfig) super.clone();
  }

}
