/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for SnapshotSettingsStorageLocationSettings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SnapshotSettingsStorageLocationSettings extends com.google.api.client.json.GenericJson {

  /**
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this
   * field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, SnapshotSettingsStorageLocationSettingsStorageLocationPreference> locations;

  /**
   * The chosen location policy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String policy;

  /**
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this
   * field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, SnapshotSettingsStorageLocationSettingsStorageLocationPreference> getLocations() {
    return locations;
  }

  /**
   * When the policy is SPECIFIC_LOCATIONS, snapshots will be stored in the locations listed in this
   * field. Keys are Cloud Storage bucket locations. Only one location can be specified.
   * @param locations locations or {@code null} for none
   */
  public SnapshotSettingsStorageLocationSettings setLocations(java.util.Map<String, SnapshotSettingsStorageLocationSettingsStorageLocationPreference> locations) {
    this.locations = locations;
    return this;
  }

  /**
   * The chosen location policy.
   * @return value or {@code null} for none
   */
  public java.lang.String getPolicy() {
    return policy;
  }

  /**
   * The chosen location policy.
   * @param policy policy or {@code null} for none
   */
  public SnapshotSettingsStorageLocationSettings setPolicy(java.lang.String policy) {
    this.policy = policy;
    return this;
  }

  @Override
  public SnapshotSettingsStorageLocationSettings set(String fieldName, Object value) {
    return (SnapshotSettingsStorageLocationSettings) super.set(fieldName, value);
  }

  @Override
  public SnapshotSettingsStorageLocationSettings clone() {
    return (SnapshotSettingsStorageLocationSettings) super.clone();
  }

}
