/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Subnetwork which the current user has compute.subnetworks.use permission on.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UsableSubnetwork extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The external IPv6 address range that is assigned to this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String externalIpv6Prefix;

  /**
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String internalIpv6Prefix;

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipCidrRange;

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipv6AccessType;

  /**
   * Network URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String purpose;

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Secondary IP ranges.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UsableSubnetworkSecondaryRange> secondaryIpRanges;

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stackType;

  /**
   * Subnetwork URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnetwork;

  /**
   * [Output Only] The external IPv6 address range that is assigned to this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getExternalIpv6Prefix() {
    return externalIpv6Prefix;
  }

  /**
   * [Output Only] The external IPv6 address range that is assigned to this subnetwork.
   * @param externalIpv6Prefix externalIpv6Prefix or {@code null} for none
   */
  public UsableSubnetwork setExternalIpv6Prefix(java.lang.String externalIpv6Prefix) {
    this.externalIpv6Prefix = externalIpv6Prefix;
    return this;
  }

  /**
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getInternalIpv6Prefix() {
    return internalIpv6Prefix;
  }

  /**
   * [Output Only] The internal IPv6 address range that is assigned to this subnetwork.
   * @param internalIpv6Prefix internalIpv6Prefix or {@code null} for none
   */
  public UsableSubnetwork setInternalIpv6Prefix(java.lang.String internalIpv6Prefix) {
    this.internalIpv6Prefix = internalIpv6Prefix;
    return this;
  }

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpCidrRange() {
    return ipCidrRange;
  }

  /**
   * The range of internal addresses that are owned by this subnetwork.
   * @param ipCidrRange ipCidrRange or {@code null} for none
   */
  public UsableSubnetwork setIpCidrRange(java.lang.String ipCidrRange) {
    this.ipCidrRange = ipCidrRange;
    return this;
  }

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpv6AccessType() {
    return ipv6AccessType;
  }

  /**
   * The access type of IPv6 address this subnet holds. It's immutable and can only be specified
   * during creation or the first time the subnet is updated into IPV4_IPV6 dual stack.
   * @param ipv6AccessType ipv6AccessType or {@code null} for none
   */
  public UsableSubnetwork setIpv6AccessType(java.lang.String ipv6AccessType) {
    this.ipv6AccessType = ipv6AccessType;
    return this;
  }

  /**
   * Network URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * Network URL.
   * @param network network or {@code null} for none
   */
  public UsableSubnetwork setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getPurpose() {
    return purpose;
  }

  /**
   * @param purpose purpose or {@code null} for none
   */
  public UsableSubnetwork setPurpose(java.lang.String purpose) {
    this.purpose = purpose;
    return this;
  }

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role of subnetwork. Currently, this field is only used when purpose is set to
   * GLOBAL_MANAGED_PROXY or REGIONAL_MANAGED_PROXY. The value can be set to ACTIVE or BACKUP. An
   * ACTIVE subnetwork is one that is currently being used for Envoy-based load balancers in a
   * region. A BACKUP subnetwork is one that is ready to be promoted to ACTIVE or is currently
   * draining. This field can be updated with a patch request.
   * @param role role or {@code null} for none
   */
  public UsableSubnetwork setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Secondary IP ranges.
   * @return value or {@code null} for none
   */
  public java.util.List<UsableSubnetworkSecondaryRange> getSecondaryIpRanges() {
    return secondaryIpRanges;
  }

  /**
   * Secondary IP ranges.
   * @param secondaryIpRanges secondaryIpRanges or {@code null} for none
   */
  public UsableSubnetwork setSecondaryIpRanges(java.util.List<UsableSubnetworkSecondaryRange> secondaryIpRanges) {
    this.secondaryIpRanges = secondaryIpRanges;
    return this;
  }

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * @return value or {@code null} for none
   */
  public java.lang.String getStackType() {
    return stackType;
  }

  /**
   * The stack type for the subnet. If set to IPV4_ONLY, new VMs in the subnet are assigned IPv4
   * addresses only. If set to IPV4_IPV6, new VMs in the subnet can be assigned both IPv4 and IPv6
   * addresses. If not specified, IPV4_ONLY is used. This field can be both set at resource creation
   * time and updated using patch.
   * @param stackType stackType or {@code null} for none
   */
  public UsableSubnetwork setStackType(java.lang.String stackType) {
    this.stackType = stackType;
    return this;
  }

  /**
   * Subnetwork URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnetwork() {
    return subnetwork;
  }

  /**
   * Subnetwork URL.
   * @param subnetwork subnetwork or {@code null} for none
   */
  public UsableSubnetwork setSubnetwork(java.lang.String subnetwork) {
    this.subnetwork = subnetwork;
    return this;
  }

  @Override
  public UsableSubnetwork set(String fieldName, Object value) {
    return (UsableSubnetwork) super.set(fieldName, value);
  }

  @Override
  public UsableSubnetwork clone() {
    return (UsableSubnetwork) super.clone();
  }

}
