/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * The properties of a wire.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WireProperties extends com.google.api.client.json.GenericJson {

  /**
   * The unmetered bandwidth in Gigabits per second, using decimal units. `10` is 10 Gbps, `100` is
   * 100 Gbps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long bandwidthUnmetered;

  /**
   * Response when a fault is detected in a pseudowire: - NONE: default. - DISABLE_PORT: set the
   * port line protocol down when inline probes detect a fault. This setting is only permitted on
   * port mode pseudowires.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String faultResponse;

  /**
   * The unmetered bandwidth in Gigabits per second, using decimal units. `10` is 10 Gbps, `100` is
   * 100 Gbps.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBandwidthUnmetered() {
    return bandwidthUnmetered;
  }

  /**
   * The unmetered bandwidth in Gigabits per second, using decimal units. `10` is 10 Gbps, `100` is
   * 100 Gbps.
   * @param bandwidthUnmetered bandwidthUnmetered or {@code null} for none
   */
  public WireProperties setBandwidthUnmetered(java.lang.Long bandwidthUnmetered) {
    this.bandwidthUnmetered = bandwidthUnmetered;
    return this;
  }

  /**
   * Response when a fault is detected in a pseudowire: - NONE: default. - DISABLE_PORT: set the
   * port line protocol down when inline probes detect a fault. This setting is only permitted on
   * port mode pseudowires.
   * @return value or {@code null} for none
   */
  public java.lang.String getFaultResponse() {
    return faultResponse;
  }

  /**
   * Response when a fault is detected in a pseudowire: - NONE: default. - DISABLE_PORT: set the
   * port line protocol down when inline probes detect a fault. This setting is only permitted on
   * port mode pseudowires.
   * @param faultResponse faultResponse or {@code null} for none
   */
  public WireProperties setFaultResponse(java.lang.String faultResponse) {
    this.faultResponse = faultResponse;
    return this;
  }

  @Override
  public WireProperties set(String fieldName, Object value) {
    return (WireProperties) super.set(fieldName, value);
  }

  @Override
  public WireProperties clone() {
    return (WireProperties) super.clone();
  }

}
