/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-13 at 02:05:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * An Instance resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Instance extends com.google.api.client.json.GenericJson {

  /**
   * Allows this instance to send and receive packets with non-matching destination or source IPs.
   * This is required if you plan to use this instance to forward routes. For more information, see
   * Enabling IP Forwarding.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canIpForward;

  /**
   * [Output Only] The CPU platform used by this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cpuPlatform;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttachedDisk> disks;

  static {
    // hack to force ProGuard to consider AttachedDisk used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(AttachedDisk.class);
  }

  /**
   * [Output Only] Unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String labelFingerprint;

  /**
   * Labels to apply to this instance. These can be later modified by the setLabels method. Each
   * label key/value pair must comply with RFC1035. Label values may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Full or partial URL of the machine type resource to use for this instance, in the format:
   * zones/zone/machineTypes/ machine-type. This is provided by the client when the instance is
   * created. For example, the following is a valid partial url to a predefined machine type:
   *
   * zones/us-central1-f/machineTypes/n1-standard-1
   *
   * To create a custom machine type, provide a URL to a machine type in the following format, where
   * CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for
   * this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of
   * memory is 5120 MB):
   *
   * zones/zone/machineTypes/custom-CPUS-MEMORY
   *
   * For example: zones/us-central1-f/machineTypes/custom-4-5120
   *
   * For a full list of restrictions, read the Specifications for custom machine types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String machineType;

  /**
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and
   * predefined keys.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Metadata metadata;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services, such as connecting to the internet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NetworkInterface> networkInterfaces;

  /**
   * Scheduling options for this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scheduling scheduling;

  /**
   * [Output Only] Server defined URL for this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * A list of service accounts, with their specified scopes, authorized for this instance. Service
   * accounts generate access tokens that can be accessed through the metadata server and used to
   * authenticate applications on the instance. See Authenticating from Google Compute Engine for
   * more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceAccount> serviceAccounts;

  /**
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING,
   * RUNNING, STOPPING, and TERMINATED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String statusMessage;

  /**
   * A list of tags to appy to this instance. Tags are used to identify valid sources or targets for
   * network firewalls and are specified by the client during instance creation. The tags can be
   * later modified by the setTags method. Each tag within the list must comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Tags tags;

  /**
   * [Output Only] URL of the zone where the instance resides.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String zone;

  /**
   * Allows this instance to send and receive packets with non-matching destination or source IPs.
   * This is required if you plan to use this instance to forward routes. For more information, see
   * Enabling IP Forwarding.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanIpForward() {
    return canIpForward;
  }

  /**
   * Allows this instance to send and receive packets with non-matching destination or source IPs.
   * This is required if you plan to use this instance to forward routes. For more information, see
   * Enabling IP Forwarding.
   * @param canIpForward canIpForward or {@code null} for none
   */
  public Instance setCanIpForward(java.lang.Boolean canIpForward) {
    this.canIpForward = canIpForward;
    return this;
  }

  /**
   * [Output Only] The CPU platform used by this instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getCpuPlatform() {
    return cpuPlatform;
  }

  /**
   * [Output Only] The CPU platform used by this instance.
   * @param cpuPlatform cpuPlatform or {@code null} for none
   */
  public Instance setCpuPlatform(java.lang.String cpuPlatform) {
    this.cpuPlatform = cpuPlatform;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public Instance setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional textual description of the resource; provided by the client when the resource is
   * created.
   * @param description description or {@code null} for none
   */
  public Instance setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * @return value or {@code null} for none
   */
  public java.util.List<AttachedDisk> getDisks() {
    return disks;
  }

  /**
   * Array of disks associated with this instance. Persistent disks must be created before you can
   * assign them.
   * @param disks disks or {@code null} for none
   */
  public Instance setDisks(java.util.List<AttachedDisk> disks) {
    this.disks = disks;
    return this;
  }

  /**
   * [Output Only] Unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] Unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public Instance setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#instance for instances.
   * @param kind kind or {@code null} for none
   */
  public Instance setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the instance.
   * @see #decodeLabelFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getLabelFingerprint() {
    return labelFingerprint;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the instance.
   * @see #getLabelFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeLabelFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(labelFingerprint);
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the instance.
   * @see #encodeLabelFingerprint()
   * @param labelFingerprint labelFingerprint or {@code null} for none
   */
  public Instance setLabelFingerprint(java.lang.String labelFingerprint) {
    this.labelFingerprint = labelFingerprint;
    return this;
  }

  /**
   * A fingerprint for this request, which is essentially a hash of the metadata's contents and used
   * for optimistic locking. The fingerprint is initially generated by Compute Engine and changes
   * after every request to modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata.
   *
   * To see the latest fingerprint, make get() request to the instance.
   * @see #setLabelFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Instance encodeLabelFingerprint(byte[] labelFingerprint) {
    this.labelFingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(labelFingerprint);
    return this;
  }

  /**
   * Labels to apply to this instance. These can be later modified by the setLabels method. Each
   * label key/value pair must comply with RFC1035. Label values may be empty.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels to apply to this instance. These can be later modified by the setLabels method. Each
   * label key/value pair must comply with RFC1035. Label values may be empty.
   * @param labels labels or {@code null} for none
   */
  public Instance setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Full or partial URL of the machine type resource to use for this instance, in the format:
   * zones/zone/machineTypes/ machine-type. This is provided by the client when the instance is
   * created. For example, the following is a valid partial url to a predefined machine type:
   *
   * zones/us-central1-f/machineTypes/n1-standard-1
   *
   * To create a custom machine type, provide a URL to a machine type in the following format, where
   * CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for
   * this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of
   * memory is 5120 MB):
   *
   * zones/zone/machineTypes/custom-CPUS-MEMORY
   *
   * For example: zones/us-central1-f/machineTypes/custom-4-5120
   *
   * For a full list of restrictions, read the Specifications for custom machine types.
   * @return value or {@code null} for none
   */
  public java.lang.String getMachineType() {
    return machineType;
  }

  /**
   * Full or partial URL of the machine type resource to use for this instance, in the format:
   * zones/zone/machineTypes/ machine-type. This is provided by the client when the instance is
   * created. For example, the following is a valid partial url to a predefined machine type:
   *
   * zones/us-central1-f/machineTypes/n1-standard-1
   *
   * To create a custom machine type, provide a URL to a machine type in the following format, where
   * CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for
   * this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of
   * memory is 5120 MB):
   *
   * zones/zone/machineTypes/custom-CPUS-MEMORY
   *
   * For example: zones/us-central1-f/machineTypes/custom-4-5120
   *
   * For a full list of restrictions, read the Specifications for custom machine types.
   * @param machineType machineType or {@code null} for none
   */
  public Instance setMachineType(java.lang.String machineType) {
    this.machineType = machineType;
    return this;
  }

  /**
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and
   * predefined keys.
   * @return value or {@code null} for none
   */
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * The metadata key/value pairs assigned to this instance. This includes custom metadata and
   * predefined keys.
   * @param metadata metadata or {@code null} for none
   */
  public Instance setMetadata(Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public Instance setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services, such as connecting to the internet.
   * @return value or {@code null} for none
   */
  public java.util.List<NetworkInterface> getNetworkInterfaces() {
    return networkInterfaces;
  }

  /**
   * An array of configurations for this interface. This specifies how this interface is configured
   * to interact with other network services, such as connecting to the internet.
   * @param networkInterfaces networkInterfaces or {@code null} for none
   */
  public Instance setNetworkInterfaces(java.util.List<NetworkInterface> networkInterfaces) {
    this.networkInterfaces = networkInterfaces;
    return this;
  }

  /**
   * Scheduling options for this instance.
   * @return value or {@code null} for none
   */
  public Scheduling getScheduling() {
    return scheduling;
  }

  /**
   * Scheduling options for this instance.
   * @param scheduling scheduling or {@code null} for none
   */
  public Instance setScheduling(Scheduling scheduling) {
    this.scheduling = scheduling;
    return this;
  }

  /**
   * [Output Only] Server defined URL for this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server defined URL for this resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Instance setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * A list of service accounts, with their specified scopes, authorized for this instance. Service
   * accounts generate access tokens that can be accessed through the metadata server and used to
   * authenticate applications on the instance. See Authenticating from Google Compute Engine for
   * more information.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceAccount> getServiceAccounts() {
    return serviceAccounts;
  }

  /**
   * A list of service accounts, with their specified scopes, authorized for this instance. Service
   * accounts generate access tokens that can be accessed through the metadata server and used to
   * authenticate applications on the instance. See Authenticating from Google Compute Engine for
   * more information.
   * @param serviceAccounts serviceAccounts or {@code null} for none
   */
  public Instance setServiceAccounts(java.util.List<ServiceAccount> serviceAccounts) {
    this.serviceAccounts = serviceAccounts;
    return this;
  }

  /**
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING,
   * RUNNING, STOPPING, and TERMINATED.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING,
   * RUNNING, STOPPING, and TERMINATED.
   * @param status status or {@code null} for none
   */
  public Instance setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatusMessage() {
    return statusMessage;
  }

  /**
   * [Output Only] An optional, human-readable explanation of the status.
   * @param statusMessage statusMessage or {@code null} for none
   */
  public Instance setStatusMessage(java.lang.String statusMessage) {
    this.statusMessage = statusMessage;
    return this;
  }

  /**
   * A list of tags to appy to this instance. Tags are used to identify valid sources or targets for
   * network firewalls and are specified by the client during instance creation. The tags can be
   * later modified by the setTags method. Each tag within the list must comply with RFC1035.
   * @return value or {@code null} for none
   */
  public Tags getTags() {
    return tags;
  }

  /**
   * A list of tags to appy to this instance. Tags are used to identify valid sources or targets for
   * network firewalls and are specified by the client during instance creation. The tags can be
   * later modified by the setTags method. Each tag within the list must comply with RFC1035.
   * @param tags tags or {@code null} for none
   */
  public Instance setTags(Tags tags) {
    this.tags = tags;
    return this;
  }

  /**
   * [Output Only] URL of the zone where the instance resides.
   * @return value or {@code null} for none
   */
  public java.lang.String getZone() {
    return zone;
  }

  /**
   * [Output Only] URL of the zone where the instance resides.
   * @param zone zone or {@code null} for none
   */
  public Instance setZone(java.lang.String zone) {
    this.zone = zone;
    return this;
  }

  @Override
  public Instance set(String fieldName, Object value) {
    return (Instance) super.set(fieldName, value);
  }

  @Override
  public Instance clone() {
    return (Instance) super.clone();
  }

}
