/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-03 at 23:11:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A ForwardingRule resource. A ForwardingRule resource specifies which pool of target virtual
 * machines to forward a packet to if it matches the given [IPAddress, IPProtocol, portRange] tuple.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ForwardingRule extends com.google.api.client.json.GenericJson {

  /**
   * The IP address that this forwarding rule is serving on behalf of.
   *
   * For global forwarding rules, the address must be a global IP; for regional forwarding rules,
   * the address must live in the same region as the forwarding rule. By default, this field is
   * empty and an ephemeral IP from the same scope (global or regional) will be assigned.
   *
   * When the load balancing scheme is INTERNAL, this can only be an RFC 1918 IP address belonging
   * to the network/subnetwork configured for the forwarding rule. A reserved address cannot be
   * used. If the field is empty, the IP address will be automatically allocated from the internal
   * IP range of the subnetwork or network configured for this forwarding rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPAddress")
  private java.lang.String iPAddress;

  /**
   * The IP protocol to which this rule applies. Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.
   *
   * When the load balancing scheme is INTERNAL
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("IPProtocol")
  private java.lang.String iPProtocol;

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String creationTimestamp;

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.math.BigInteger id;

  /**
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule
   * resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets addressed to ports in the
   * specified range will be forwarded to target. Forwarding rules with the same [IPAddress,
   * IPProtocol] pair must have disjoint port ranges.
   *
   * This field is not used for internal load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String portRange;

  /**
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not
   * applicable to global forwarding rules.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy or TargetHttpsProxy resource. The forwarded
   * traffic must be of a type appropriate to the target object. For example, TargetHttpProxy
   * requires HTTP traffic, and TargetHttpsProxy requires HTTPS traffic.
   *
   * This field is not used for internal load balancing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String target;

  /**
   * The IP address that this forwarding rule is serving on behalf of.
   *
   * For global forwarding rules, the address must be a global IP; for regional forwarding rules,
   * the address must live in the same region as the forwarding rule. By default, this field is
   * empty and an ephemeral IP from the same scope (global or regional) will be assigned.
   *
   * When the load balancing scheme is INTERNAL, this can only be an RFC 1918 IP address belonging
   * to the network/subnetwork configured for the forwarding rule. A reserved address cannot be
   * used. If the field is empty, the IP address will be automatically allocated from the internal
   * IP range of the subnetwork or network configured for this forwarding rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getIPAddress() {
    return iPAddress;
  }

  /**
   * The IP address that this forwarding rule is serving on behalf of.
   *
   * For global forwarding rules, the address must be a global IP; for regional forwarding rules,
   * the address must live in the same region as the forwarding rule. By default, this field is
   * empty and an ephemeral IP from the same scope (global or regional) will be assigned.
   *
   * When the load balancing scheme is INTERNAL, this can only be an RFC 1918 IP address belonging
   * to the network/subnetwork configured for the forwarding rule. A reserved address cannot be
   * used. If the field is empty, the IP address will be automatically allocated from the internal
   * IP range of the subnetwork or network configured for this forwarding rule.
   * @param iPAddress iPAddress or {@code null} for none
   */
  public ForwardingRule setIPAddress(java.lang.String iPAddress) {
    this.iPAddress = iPAddress;
    return this;
  }

  /**
   * The IP protocol to which this rule applies. Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.
   *
   * When the load balancing scheme is INTERNAL
   * @return value or {@code null} for none
   */
  public java.lang.String getIPProtocol() {
    return iPProtocol;
  }

  /**
   * The IP protocol to which this rule applies. Valid options are TCP, UDP, ESP, AH, SCTP or ICMP.
   *
   * When the load balancing scheme is INTERNAL
   * @param iPProtocol iPProtocol or {@code null} for none
   */
  public ForwardingRule setIPProtocol(java.lang.String iPProtocol) {
    this.iPProtocol = iPProtocol;
    return this;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @return value or {@code null} for none
   */
  public java.lang.String getCreationTimestamp() {
    return creationTimestamp;
  }

  /**
   * [Output Only] Creation timestamp in RFC3339 text format.
   * @param creationTimestamp creationTimestamp or {@code null} for none
   */
  public ForwardingRule setCreationTimestamp(java.lang.String creationTimestamp) {
    this.creationTimestamp = creationTimestamp;
    return this;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * An optional description of this resource. Provide this property when you create the resource.
   * @param description description or {@code null} for none
   */
  public ForwardingRule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.math.BigInteger getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public ForwardingRule setId(java.math.BigInteger id) {
    this.id = id;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule
   * resources.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule
   * resources.
   * @param kind kind or {@code null} for none
   */
  public ForwardingRule setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of the resource; provided by the client when the resource is created. The name must be
   * 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression [a-z]([-a-z0-9]*[a-z0-9])? which means the first
   * character must be a lowercase letter, and all following characters must be a dash, lowercase
   * letter, or digit, except the last character, which cannot be a dash.
   * @param name name or {@code null} for none
   */
  public ForwardingRule setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets addressed to ports in the
   * specified range will be forwarded to target. Forwarding rules with the same [IPAddress,
   * IPProtocol] pair must have disjoint port ranges.
   *
   * This field is not used for internal load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.String getPortRange() {
    return portRange;
  }

  /**
   * Applicable only when IPProtocol is TCP, UDP, or SCTP, only packets addressed to ports in the
   * specified range will be forwarded to target. Forwarding rules with the same [IPAddress,
   * IPProtocol] pair must have disjoint port ranges.
   *
   * This field is not used for internal load balancing.
   * @param portRange portRange or {@code null} for none
   */
  public ForwardingRule setPortRange(java.lang.String portRange) {
    this.portRange = portRange;
    return this;
  }

  /**
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not
   * applicable to global forwarding rules.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * [Output Only] URL of the region where the regional forwarding rule resides. This field is not
   * applicable to global forwarding rules.
   * @param region region or {@code null} for none
   */
  public ForwardingRule setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public ForwardingRule setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy or TargetHttpsProxy resource. The forwarded
   * traffic must be of a type appropriate to the target object. For example, TargetHttpProxy
   * requires HTTP traffic, and TargetHttpsProxy requires HTTPS traffic.
   *
   * This field is not used for internal load balancing.
   * @return value or {@code null} for none
   */
  public java.lang.String getTarget() {
    return target;
  }

  /**
   * The URL of the target resource to receive the matched traffic. For regional forwarding rules,
   * this target must live in the same region as the forwarding rule. For global forwarding rules,
   * this target must be a global TargetHttpProxy or TargetHttpsProxy resource. The forwarded
   * traffic must be of a type appropriate to the target object. For example, TargetHttpProxy
   * requires HTTP traffic, and TargetHttpsProxy requires HTTPS traffic.
   *
   * This field is not used for internal load balancing.
   * @param target target or {@code null} for none
   */
  public ForwardingRule setTarget(java.lang.String target) {
    this.target = target;
    return this;
  }

  @Override
  public ForwardingRule set(String fieldName, Object value) {
    return (ForwardingRule) super.set(fieldName, value);
  }

  @Override
  public ForwardingRule clone() {
    return (ForwardingRule) super.clone();
  }

}
