/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-08-03 at 23:11:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A metadata key/value entry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metadata extends com.google.api.client.json.GenericJson {

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Items> items;

  static {
    // hack to force ProGuard to consider Items used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Items.class);
  }

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public Metadata setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of the metadata's
   * contents and used for optimistic locking. The fingerprint is initially generated by Compute
   * Engine and changes after every request to modify or update metadata. You must always provide an
   * up-to-date fingerprint hash in order to update or change metadata.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public Metadata encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * @return value or {@code null} for none
   */
  public java.util.List<Items> getItems() {
    return items;
  }

  /**
   * Array of key/value pairs. The total size of all keys and values must be less than 512 KB.
   * @param items items or {@code null} for none
   */
  public Metadata setItems(java.util.List<Items> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of the resource. Always compute#metadata for metadata.
   * @param kind kind or {@code null} for none
   */
  public Metadata setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public Metadata set(String fieldName, Object value) {
    return (Metadata) super.set(fieldName, value);
  }

  @Override
  public Metadata clone() {
    return (Metadata) super.clone();
  }

  /**
   * Model definition for MetadataItems.
   */
  public static final class Items extends com.google.api.client.json.GenericJson {

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String key;

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * @return value or {@code null} for none
     */
    public java.lang.String getKey() {
      return key;
    }

    /**
     * Key for the metadata entry. Keys must conform to the following regexp: [a-zA-Z0-9-_]+, and be
     * less than 128 bytes in length. This is reflected as part of a URL in the metadata server.
     * Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the
     * project.
     * @param key key or {@code null} for none
     */
    public Items setKey(java.lang.String key) {
      this.key = key;
      return this;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * Value for the metadata entry. These are free-form strings, and only have meaning as interpreted
     * by the image running in the instance. The only restriction placed on values is that their size
     * must be less than or equal to 32768 bytes.
     * @param value value or {@code null} for none
     */
    public Items setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public Items set(String fieldName, Object value) {
      return (Items) super.set(fieldName, value);
    }

    @Override
    public Items clone() {
      return (Items) super.clone();
    }

  }

}
