/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-10 at 04:08:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * A license resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class License extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] If true, the customer will be charged license fee for running software that
   * contains this license on an instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean chargesUseFee;

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * [Output Only] Server-defined URL for the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] If true, the customer will be charged license fee for running software that
   * contains this license on an instance.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getChargesUseFee() {
    return chargesUseFee;
  }

  /**
   * [Output Only] If true, the customer will be charged license fee for running software that
   * contains this license on an instance.
   * @param chargesUseFee chargesUseFee or {@code null} for none
   */
  public License setChargesUseFee(java.lang.Boolean chargesUseFee) {
    this.chargesUseFee = chargesUseFee;
    return this;
  }

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] Type of resource. Always compute#license for licenses.
   * @param kind kind or {@code null} for none
   */
  public License setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * [Output Only] Name of the resource. The name is 1-63 characters long and complies with RFC1035.
   * @param name name or {@code null} for none
   */
  public License setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output Only] Server-defined URL for the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public License setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public License set(String fieldName, Object value) {
    return (License) super.set(fieldName, value);
  }

  @Override
  public License clone() {
    return (License) super.clone();
  }

}
