/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-09-29 at 00:42:21 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Contains a list of managed instance groups.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstanceGroupManagerList extends com.google.api.client.json.GenericJson {

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A list of managed instance groups.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<InstanceGroupManager> items;

  static {
    // hack to force ProGuard to consider InstanceGroupManager used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(InstanceGroupManager.class);
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * [Output only] A token used to continue a truncated list request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * [Output only] The URL for this resource type. The server generates this URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * @param id id or {@code null} for none
   */
  public RegionInstanceGroupManagerList setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A list of managed instance groups.
   * @return value or {@code null} for none
   */
  public java.util.List<InstanceGroupManager> getItems() {
    return items;
  }

  /**
   * A list of managed instance groups.
   * @param items items or {@code null} for none
   */
  public RegionInstanceGroupManagerList setItems(java.util.List<InstanceGroupManager> items) {
    this.items = items;
    return this;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * [Output Only] The resource type, which is always compute#instanceGroupManagerList for a list of
   * managed instance groups that exist in th regional scope.
   * @param kind kind or {@code null} for none
   */
  public RegionInstanceGroupManagerList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * [Output only] A token used to continue a truncated list request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * [Output only] A token used to continue a truncated list request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public RegionInstanceGroupManagerList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * [Output only] The URL for this resource type. The server generates this URL.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * [Output only] The URL for this resource type. The server generates this URL.
   * @param selfLink selfLink or {@code null} for none
   */
  public RegionInstanceGroupManagerList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public RegionInstanceGroupManagerList set(String fieldName, Object value) {
    return (RegionInstanceGroupManagerList) super.set(fieldName, value);
  }

  @Override
  public RegionInstanceGroupManagerList clone() {
    return (RegionInstanceGroupManagerList) super.clone();
  }

}
