/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-07-08 17:28:43 UTC)
 * on 2016-10-06 at 19:26:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for TargetPoolsAddHealthCheckRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TargetPoolsAddHealthCheckRequest extends com.google.api.client.json.GenericJson {

  /**
   * A list of HttpHealthCheck resources to add to the target pool.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HealthCheckReference> healthChecks;

  static {
    // hack to force ProGuard to consider HealthCheckReference used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HealthCheckReference.class);
  }

  /**
   * A list of HttpHealthCheck resources to add to the target pool.
   * @return value or {@code null} for none
   */
  public java.util.List<HealthCheckReference> getHealthChecks() {
    return healthChecks;
  }

  /**
   * A list of HttpHealthCheck resources to add to the target pool.
   * @param healthChecks healthChecks or {@code null} for none
   */
  public TargetPoolsAddHealthCheckRequest setHealthChecks(java.util.List<HealthCheckReference> healthChecks) {
    this.healthChecks = healthChecks;
    return this;
  }

  @Override
  public TargetPoolsAddHealthCheckRequest set(String fieldName, Object value) {
    return (TargetPoolsAddHealthCheckRequest) super.set(fieldName, value);
  }

  @Override
  public TargetPoolsAddHealthCheckRequest clone() {
    return (TargetPoolsAddHealthCheckRequest) super.clone();
  }

}
