/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-11 at 14:19:11 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RegionInstanceGroupsSetNamedPortsRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegionInstanceGroupsSetNamedPortsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The fingerprint of the named ports information for this instance group. Use this optional
   * property to prevent conflicts when multiple users change the named ports settings concurrently.
   * Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in
   * your request to ensure that you do not overwrite changes that were applied from another
   * concurrent request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fingerprint;

  /**
   * The list of named ports to set for this instance group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NamedPort> namedPorts;

  static {
    // hack to force ProGuard to consider NamedPort used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(NamedPort.class);
  }

  /**
   * The fingerprint of the named ports information for this instance group. Use this optional
   * property to prevent conflicts when multiple users change the named ports settings concurrently.
   * Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in
   * your request to ensure that you do not overwrite changes that were applied from another
   * concurrent request.
   * @see #decodeFingerprint()
   * @return value or {@code null} for none
   */
  public java.lang.String getFingerprint() {
    return fingerprint;
  }

  /**
   * The fingerprint of the named ports information for this instance group. Use this optional
   * property to prevent conflicts when multiple users change the named ports settings concurrently.
   * Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in
   * your request to ensure that you do not overwrite changes that were applied from another
   * concurrent request.
   * @see #getFingerprint()
   * @return Base64 decoded value or {@code null} for none
   *
   * @since 1.14
   */
  public byte[] decodeFingerprint() {
    return com.google.api.client.util.Base64.decodeBase64(fingerprint);
  }

  /**
   * The fingerprint of the named ports information for this instance group. Use this optional
   * property to prevent conflicts when multiple users change the named ports settings concurrently.
   * Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in
   * your request to ensure that you do not overwrite changes that were applied from another
   * concurrent request.
   * @see #encodeFingerprint()
   * @param fingerprint fingerprint or {@code null} for none
   */
  public RegionInstanceGroupsSetNamedPortsRequest setFingerprint(java.lang.String fingerprint) {
    this.fingerprint = fingerprint;
    return this;
  }

  /**
   * The fingerprint of the named ports information for this instance group. Use this optional
   * property to prevent conflicts when multiple users change the named ports settings concurrently.
   * Obtain the fingerprint with the instanceGroups.get method. Then, include the fingerprint in
   * your request to ensure that you do not overwrite changes that were applied from another
   * concurrent request.
   * @see #setFingerprint()
   *
   * <p>
   * The value is encoded Base64 or {@code null} for none.
   * </p>
   *
   * @since 1.14
   */
  public RegionInstanceGroupsSetNamedPortsRequest encodeFingerprint(byte[] fingerprint) {
    this.fingerprint = com.google.api.client.util.Base64.encodeBase64URLSafeString(fingerprint);
    return this;
  }

  /**
   * The list of named ports to set for this instance group.
   * @return value or {@code null} for none
   */
  public java.util.List<NamedPort> getNamedPorts() {
    return namedPorts;
  }

  /**
   * The list of named ports to set for this instance group.
   * @param namedPorts namedPorts or {@code null} for none
   */
  public RegionInstanceGroupsSetNamedPortsRequest setNamedPorts(java.util.List<NamedPort> namedPorts) {
    this.namedPorts = namedPorts;
    return this;
  }

  @Override
  public RegionInstanceGroupsSetNamedPortsRequest set(String fieldName, Object value) {
    return (RegionInstanceGroupsSetNamedPortsRequest) super.set(fieldName, value);
  }

  @Override
  public RegionInstanceGroupsSetNamedPortsRequest clone() {
    return (RegionInstanceGroupsSetNamedPortsRequest) super.clone();
  }

}
