/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-05-24 at 22:18:32 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.compute.model;

/**
 * Model definition for RouterInterface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Compute Engine API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RouterInterface extends com.google.api.client.json.GenericJson {

  /**
   * IP address and range of the interface. The IP range must be in the RFC3927 link-local IP space.
   * The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate
   * the address as it represents the IP address of the interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipRange;

  /**
   * URI of the linked VPN tunnel. It must be in the same region as the router. Each interface can
   * have at most one linked resource and it could either be a VPN Tunnel or an interconnect
   * attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkedVpnTunnel;

  /**
   * Name of this interface entry. The name must be 1-63 characters long and comply with RFC1035.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * IP address and range of the interface. The IP range must be in the RFC3927 link-local IP space.
   * The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate
   * the address as it represents the IP address of the interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpRange() {
    return ipRange;
  }

  /**
   * IP address and range of the interface. The IP range must be in the RFC3927 link-local IP space.
   * The value must be a CIDR-formatted string, for example: 169.254.0.1/30. NOTE: Do not truncate
   * the address as it represents the IP address of the interface.
   * @param ipRange ipRange or {@code null} for none
   */
  public RouterInterface setIpRange(java.lang.String ipRange) {
    this.ipRange = ipRange;
    return this;
  }

  /**
   * URI of the linked VPN tunnel. It must be in the same region as the router. Each interface can
   * have at most one linked resource and it could either be a VPN Tunnel or an interconnect
   * attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkedVpnTunnel() {
    return linkedVpnTunnel;
  }

  /**
   * URI of the linked VPN tunnel. It must be in the same region as the router. Each interface can
   * have at most one linked resource and it could either be a VPN Tunnel or an interconnect
   * attachment.
   * @param linkedVpnTunnel linkedVpnTunnel or {@code null} for none
   */
  public RouterInterface setLinkedVpnTunnel(java.lang.String linkedVpnTunnel) {
    this.linkedVpnTunnel = linkedVpnTunnel;
    return this;
  }

  /**
   * Name of this interface entry. The name must be 1-63 characters long and comply with RFC1035.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Name of this interface entry. The name must be 1-63 characters long and comply with RFC1035.
   * @param name name or {@code null} for none
   */
  public RouterInterface setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public RouterInterface set(String fieldName, Object value) {
    return (RouterInterface) super.set(fieldName, value);
  }

  @Override
  public RouterInterface clone() {
    return (RouterInterface) super.clone();
  }

}
